#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#ifdef LINUX
#include <netinet/in.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#endif

static struct speed_struct {
	speed_t term_speed;
	int speed;
} speed_table[] = {
	{B300,   300},
	{B600,   600},
	{B1200,  1200},
	{B2400,  2400},
	{B4800,  4800},
	{B9600,  9600},
	{B19200, 19200},
	{B0,     0}
};

struct termios kbd_termios;
struct termios save_termios;

void kbdopen(void)
{
	struct termios termios;

	tcgetattr(STDIN_FILENO, &termios);
	kbd_termios = termios;

	termios.c_lflag &= ~(ECHO | ICANON | IEXTEN | ISIG);
	termios.c_iflag &= ~(BRKINT | ICRNL | INPCK | ISTRIP | IXON);
	termios.c_cflag &= ~(CSIZE | PARENB);
	termios.c_oflag &= ~(OPOST);
	termios.c_cflag |= CS8;

	termios.c_cc[VMIN]  = 1;
	termios.c_cc[VTIME] = 0;
	
	tcsetattr(STDIN_FILENO, TCSANOW, &termios);
}

void kbddone(void)
{
	tcsetattr(STDIN_FILENO, TCSANOW, &kbd_termios);
}

#ifdef LINUX
int sockopen(void)
{
	int s;

	if ((s = socket(AF_INET, SOCK_PACKET, htons(ETH_P_AX25))) < 0) {
		perror("socket");
		exit(1);
	}

	return s;
}
#endif

int serlopen(char *port, int speed)
{
	struct speed_struct *ss;
	struct termios termios;
	int s;

	if ((s = open(port, O_RDONLY)) < 0)
		return -1;

	for (ss = speed_table; ss->speed != 0; ss++)
		if (ss->speed == speed)
			break;
			
	if (ss->speed == 0)
		return -1;
	
	tcgetattr(s, &termios);
	save_termios = termios;
	
	termios.c_lflag = 0;
	termios.c_iflag = 0;
#ifndef CBAUD
	/* sh: ignore modem control lines */
	termios.c_cflag = termios.c_cflag | CREAD | CS8 | CLOCAL;	
#else
	termios.c_cflag = (termios.c_cflag & CBAUD) | CREAD | CS8;
#endif
	termios.c_oflag = 0;

	termios.c_cc[VMIN]  = 1;
	termios.c_cc[VTIME] = 0;
	
	cfsetispeed(&termios, ss->term_speed);
	cfsetospeed(&termios, ss->term_speed);

	tcsetattr(s, TCSANOW, &termios);

	return s;
}

#ifdef LINUX
void sockdone(int s) {
	if (s != -1) {
		close(s);
	}
}
#endif

void serldone(int s) {
	if (s != -1) {
		tcsetattr(s, TCSANOW, &save_termios);
		close(s);
	}
}
