// endhost.cpp

#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include "com.h"

#define FALSE 0
#define TRUE 1
#define PORTNAME_SIZE 20

void configure_endhost(int&, char*);

int main(void) {

    char port[PORTNAME_SIZE + 1];
    int speed;

    configure_endhost(speed, port);
    Com com_obj(speed, port);

    unsigned char message[4] = {192, 'Q', 192, 0};
    com_obj.send(message);
    return 0;
}

void configure_endhost(int& speed, char* port) {
    char* home = getenv("HOME");
    ifstream filein;
    int found_rcfile = FALSE;
    if (home) {
        char* home_rcfile = new char[strlen(home) + strlen(RC_FILE) + 2];
	if (!home_rcfile) {
	    cerr << "Memory allocation error in configure_host()" << endl;
	    exit(1);
	}
	strcpy(home_rcfile, home);
	strcat(home_rcfile, "/");
	strcat(home_rcfile, RC_FILE);

	filein.open(home_rcfile, ios::in | ios::nocreate);
	if (filein) found_rcfile = TRUE;
	else filein.clear();
	delete[] home_rcfile;
    }
    if (found_rcfile == FALSE) {
        char* system_rcfile = new char[strlen(RC_FILE) + 6];
	if (!system_rcfile) {
	    cerr << "Memory allocation error in configure_host()" << endl;
	    exit(1);
	}
	strcpy(system_rcfile, "/etc/");
	strcat(system_rcfile, RC_FILE);
	filein.open(system_rcfile, ios::in | ios::nocreate);
	if (filein) found_rcfile = TRUE;
	else filein.clear();
	delete[] system_rcfile;
    }
    if (found_rcfile == FALSE) {
        cerr << "Can't find or open file /etc/" RC_FILE << endl;
	cerr << "or file $HOME/." RC_FILE << endl;
        exit(2);
    }

// now extract settings from file

    char buffer[257];
    char* buffer_ptr;
    int count;
    int port_found_flag = FALSE;
    int speed_found_flag = FALSE;
    while(filein.getline(buffer, 256)) {
	if ((count = filein.gcount()) > 1 && *buffer != '#') {  // # at start of line is a comment
	    buffer[--count] = 0;  // null terminate the string

	    if ((buffer_ptr = strstr(buffer, "SERIALPORT:")) != 0) { // found SERIALPORT:
	        buffer_ptr += 11;        // advance buffer_ptr to the letter after SERIALPORT:

		while (*buffer_ptr == ' ') buffer_ptr++;  // get rid of leading white space

		char* temp_ptr = buffer_ptr; // get rid of any trailing white space or comment
		while(*temp_ptr != 0 && *temp_ptr != ' ' && *temp_ptr != '#') temp_ptr++;
		if (*temp_ptr == ' ' || *temp_ptr == '#') *temp_ptr = 0;

		int length;
		if ((length = strlen(buffer_ptr)) != 0) {
		    if (length > PORTNAME_SIZE) {
		        cerr << "Serial port device name exceeds size of PORTNAME_SIZE defined in main.cpp\n"
			        "Increase the size and recompile" << endl;
			exit(CONFIG_ERROR);
		    }
		    strcpy(port, buffer_ptr);
		    port_found_flag = TRUE;
		}
	    }

	    else if ((buffer_ptr = strstr(buffer, "SPEED:")) != 0) { // found SPEED:
	        buffer_ptr += 6;        // advance buffer_ptr to the letter after SPEED:

		while (*buffer_ptr == ' ') buffer_ptr++;  // get rid of leading white space

		char* temp_ptr = buffer_ptr; // get rid of any trailing white space or comment
		while(*temp_ptr != 0 && *temp_ptr != ' ' && *temp_ptr != '#') temp_ptr++;
		if (*temp_ptr == ' ' || *temp_ptr == '#') *temp_ptr = 0;

		speed = atoi(buffer_ptr);
		if (speed == 300 || speed == 600 || speed == 1200 ||
		    speed == 2400 || speed == 4800 || speed == 9600) {
		    speed_found_flag = TRUE;
		}
	    }
	}
    }
    if (!port_found_flag) {
        filein.close();
        cerr << "Serial port device (eg. ttyS0) must be specified in kamdir" << endl;
	cerr << "Include a 'SERIALPORT: xxxx' statement in that file, where xxxx\n"
	        "is the serial port used with the TNC" << endl;
	exit(3);
    }
    if (!speed_found_flag) speed = 9600;
    filein.close();
}
