/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include "filesend.h"
#include "dlist.cpp"   // contains template definitions

static int cq_alarm_flag = FALSE;

int FilesendBuffer::open_file(const char* filename, int convert_codes) {
  // Thefilename supplied will be opened, and convert_codes may be set to TRUE.
  // If if is set TRUE, then $a will be translated to your call, and $b will be 
  // translated to your selcall, and $c will be translated to the call in the callsign
  // store buffer for the currently active screen

  // we only send a file in packet mode when connected
    if ((!get_port() || tnc_ptr->tnc_func.hfmode == Tnc_func::packet)
	&& tnc_ptr->tnc_func.stream_status[get_stream()][get_port()] == Tnc_func::disconnected) {
        PopupWin* popupwin_ptr = new PopupWin;
	if (!popupwin_ptr) {
	    cerr << "Memory allocation error in FilesendBuffer::open_file()" << endl;
	    exit(MEM_ERROR);
	}
	popupwin_ptr->show();
	popupwin_ptr->write("Cannot send a file in packet mode", 1, 3);
	popupwin_ptr->write("unless connected", 2, 3);
	popupwin_ptr->winrefresh();
	sleep(3);
	popupwin_ptr->unshow();
	delete popupwin_ptr;
	refresh_winlist(*screenform_ptr);
        return FALSE;
    }

    int return_val = FALSE;
    if (file_flag == not_sending) {
        filein.open(filename, ios::in | ios::nocreate);
	if (!filein) {
	    PopupWin* popupwin_ptr = new PopupWin;
	    if (!popupwin_ptr) {
	        cerr << "Memory allocation error in FilesendBuffer::open_file()" << endl;
		exit(MEM_ERROR);
	    }
	    popupwin_ptr->show();
	    popupwin_ptr->write(filename, 1, 5);
	    popupwin_ptr->write("cannot be found or opened", 3, 5);
	    popupwin_ptr->winrefresh();
	    sleep(3);
	    popupwin_ptr->unshow();
	    delete popupwin_ptr;
	    refresh_winlist(*screenform_ptr);
	}
	else {
	    file_flag = loading_buffer;
	    return_val = TRUE;
	    if (get_buffer_mode() == FileBuffer::text) convert_codes_flag = convert_codes;
	    else {
	        convert_codes_flag = FALSE;
		char* temp_ptr = "\nSending file ...\n";
		for (; *temp_ptr; temp_ptr++) {
		    receivewin_ptr->write(*temp_ptr);
		    receivewin_ptr->store_letter(*temp_ptr, get_stream(), get_port());
		}
		receivewin_ptr->winrefresh();
	    }
	}
    }
    return return_val;
}

int FilesendBuffer::load_buffer(void) {

  // if we were sending a file and now it has all gone to the Kam, signal this
  // (when this method has finished loading the file into tr_buffer, we set
  // FilesendBuffer::file_flag to FilesendBuffer::loading_complete, not
  // FilesendBuffer::not_sending, so that the program will know that there is material
  // in tr_buffer which should be flushed even if the return key, etc., has not been pressed)

  // this method should accordingly be called by the program loop whenever
  // FilesendBuffer::file_flag != FilesendBuffer::not_sending

  // the program returns FALSE when FilesendBuffer::file_flag == FilesendBuffer::not_sending,
  // otherwise it returns TRUE

    if (file_flag == not_sending) return FALSE;
    if (file_flag == loading_complete) {
        if (Qqueue<char>::is_empty()) {
	    if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus) {
		char* temp_ptr = "\nSending completed.\n";
		for (; *temp_ptr; temp_ptr++) {
		    if (get_stream() == tnc_ptr->tnc_func.active_stream()
			&& get_port() == tnc_ptr->tnc_func.active_port) {
		        receivewin_ptr->write(*temp_ptr);
		    }
		    receivewin_ptr->store_letter(*temp_ptr, get_stream(), get_port());
		}
		receivewin_ptr->winrefresh();
	    }
	    file_flag = not_sending;
	    filein.close();
	    return FALSE;
	}
    }

    char letter;
    int result = 0;
    int count;
    int write_to_sendwin_flag = FALSE;

    if (get_stream() == tnc_ptr->tnc_func.active_stream()
	&& get_port() == tnc_ptr->tnc_func.active_port
	&& get_buffer_mode() == FileBuffer::text) {
        write_to_sendwin_flag = TRUE;
    }

    for (count = 0; result != -1 && count < TR_BUFFER_SIZE/2 && filein.get(letter); count++) {
        if (get_buffer_mode() == FileBuffer::text
	    && tnc_ptr->tnc_func.active_port
	    && (uchar)letter > 31) {
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty
		|| tnc_ptr->tnc_func.hfmode == Tnc_func::fec
		|| tnc_ptr->tnc_func.hfmode == Tnc_func::amtor
		|| (tnc_ptr->tnc_func.hfmode == Tnc_func::gtor
		    && tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected)
		|| (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		    && (tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected
			|| tnc_ptr->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor))) {
	        if (!is_baudot(letter)) letter = 0;
		else if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty) letter = toupper(letter);
	    }
	    else if (tnc_ptr->tnc_func.hfmode == Tnc_func::cw) {
	        if (!is_morse(letter) 
		     && !(letter == '$' && convert_codes_flag)) letter = 0; // allow the $ token through
		else letter = toupper(letter);
	    }
	}

#if CHAR_SET==LATIN_1
        if (get_buffer_mode() == FileBuffer::binary  || get_buffer_mode() == FileBuffer::s_plus
	      || (uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
        if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus
	      || ((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
	if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus
	      || (letter < 127 && letter > 31) || letter == '\n') {
#endif
	    if (letter == '$' && convert_codes_flag) {
	        int second_letter = filein.peek();
		if (second_letter == 'a') {
		    if ((unsigned int)is_free() >= strlen(prog_func.myCall)) {
		        for (char* letter_ptr = prog_func.myCall; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'a' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'b') {
		    if ((unsigned int)is_free() >= strlen(prog_func.mySelCall)) {
		        for (char* letter_ptr = prog_func.mySelCall; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'b' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'c') {
		    if ((unsigned int)is_free() >= 
			   strlen(tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port])) {
		        for (char* letter_ptr = tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port]; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'c' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'd') {
		    if ((unsigned int)is_free() >= 5) {
		        time_t time_val;
			time(&time_val);
			tm* time_ptr = gmtime(&time_val);
			ostrstream s1;
			s1 << setfill('0') << setw(2) << time_ptr->tm_hour
			   << ":" << setw(2) << time_ptr->tm_min << ends;
			char* time_string = s1.str();
			for (char* letter_ptr = time_string; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'd' code
			delete[] time_string;
		    }
		    else {           // not sufficient room in buffer for time
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'e') {
		    if ((unsigned int)is_free() >= 9) {
		        time_t time_val;
			time(&time_val);
			tm* time_ptr = gmtime(&time_val);
			ostrstream s1;
			char month[4];
			get_month(month, time_ptr->tm_mon);
			s1 << time_ptr->tm_mday << "-" << month << "-"
			   << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
			char* date_string = s1.str();
			for (char* letter_ptr = date_string; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'e' code
			delete[] date_string;
		    }
		    else {           // not sufficient room in buffer for date
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'f') {
		    if ((unsigned int)is_free() >=  3) {
		        for (char* letter_ptr = prog_func.rst; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			    if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			}
			second_letter = filein.get(); // get rid of the 'f' code
		    }
		    else {           // not sufficient room in buffer for rst report
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == EOF) {  // last letter of file is a '$'
		    result = add_item('$');
		    if (result == -1) filein.putback('$');
		    else if (write_to_sendwin_flag) {
		        sendwin_ptr->write('$');
			sendwin_ptr->winrefresh();
		    }
		}
	    }
	    else {
	        result = add_item(letter);
		if (result == -1) filein.putback(letter);
		else if (write_to_sendwin_flag) {
		    sendwin_ptr->write(letter);
		    if (letter == '\n' || letter == ' ') sendwin_ptr->winrefresh();
		}
	    }
	}
    }

    // if we are in packet mode and are now disconnected, stop sending file
    if ((!get_port() || tnc_ptr->tnc_func.hfmode == Tnc_func::packet)
	&& tnc_ptr->tnc_func.stream_status[get_stream()][get_port()] == Tnc_func::disconnected) {
        end_loading();
    }

    else if (file_flag == loading_buffer && !filein) {
        file_flag = loading_complete;
    }
    if (write_to_sendwin_flag) sendwin_ptr->winrefresh();
    return TRUE;
}

int CqsendBuffer::load_buffer(void) {
  // this method should accordingly be called by the program loop whenever
  // an object of this class is in existence
  // so that the buffer is properly flushed and the timer properly set

  // the program returns FALSE when this is the last call the CqsendBuffer::load_buffer(void),
  // or if the cq file cannot be opened
  // otherwise it returns TRUE

  // only this method is intended to write to prog_func.sending_autocq, although
  // prog_func.sending_autocq is intended to be generally readable by other
  // functions and classes used in this program


    if (autocq_flag == off) {
        char* filename = new char[strlen(prog_func.filedir) + 4];
	if (!filename) {
	    cerr << "Memory allocation error in CqsendBuffer::load_buffer()" << endl;
	    exit(MEM_ERROR);
	}
	strcpy(filename, prog_func.filedir);
	strcat(filename, "/cq");
    
	filein.open(filename, ios::in | ios::nocreate);
	if (!filein) {
	    PopupWin* popupwin_p = new PopupWin;
	    if (!popupwin_p) {
	        cerr << "Memory allocation error in CqsendBuffer::load_buffer()" << endl;
		exit(MEM_ERROR);
	    }
	    popupwin_p->show();
	    popupwin_p->write("File ", 1, 2);
	    popupwin_p->write(filename);
	    popupwin_p->write("cannot be found/opened", 2, 2);
	    popupwin_p->write("Check that FILEDIR: in kamrc is correct", 3, 2);
	    sleep(3);
	    popupwin_p->unshow();
	    delete popupwin_p;
	    refresh_winlist(*screenform_ptr);
	    prog_func.sending_autocq = FALSE;
	    return FALSE;
	}
	else {
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(200000);
		tnc_ptr->send_kamcommand(pactorCMD, '2', '0');
		usleep(200000);
	    }
	    autocq_flag = loading_cq_buffer;
	    prog_func.sending_autocq = TRUE;
	    mainscreen_ptr->display_connected_status();
	    tnc_ptr->send_specialcommand(txCMD);
	}
	delete[] filename;
    }

    int return_val = TRUE;
    char letter;
    int result = 0;
    int count;
    int write_to_sendwin_flag = FALSE;

    if (tnc_ptr->tnc_func.active_port) write_to_sendwin_flag = TRUE;

    if (autocq_flag == loading_cq_buffer && tnc_ptr->tnc_func.tx_status == Tnc_func::tx) {
        for (count = 0; result != -1 && count < CQ_BUFFER_SIZE/2 && filein.get(letter); count++) {
	    if ((uchar)letter > 31
		&& tnc_ptr->tnc_func.hfmode != Tnc_func::pactor
		&& !is_baudot(letter)) {
	        letter = 0;
	    }

#if CHAR_SET==LATIN_1
	    if ((uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
	    if (((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
	    if ((letter < 127 && letter > 31) || letter == '\n') {
#endif
	        if (letter == '$') {
		    int second_letter = filein.peek();
		    if (second_letter == 'a') {
		        if ((unsigned int)is_free() >= strlen(prog_func.myCall)) {
			    for (char* letter_ptr = prog_func.myCall; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'a' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'b') {
		        if ((unsigned int)is_free() >= strlen(prog_func.mySelCall)) {
			    for (char* letter_ptr = prog_func.mySelCall; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'b' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'c') {
		        if ((unsigned int)is_free() >= 
			      strlen(tnc_ptr->tnc_func.hisCall[0][1])) {
			    for (char* letter_ptr = tnc_ptr->tnc_func.hisCall[0][1]; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'c' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'd') {
		        if ((unsigned int)is_free() >= 5) {
			    time_t time_val;
			    time(&time_val);
			    tm* time_ptr = gmtime(&time_val);
			    ostrstream s1;
			    s1 << setfill('0') << setw(2) << time_ptr->tm_hour
			       << ":" << setw(2) << time_ptr->tm_min << ends;
			    char* time_string = s1.str();
			    for (char* letter_ptr = time_string; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'd' code
			    delete[] time_string;
			}
			else {           // not sufficient room in buffer for time
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'e') {
		        if ((unsigned int)is_free() >= 9) {
			    time_t time_val;
			    time(&time_val);
			    tm* time_ptr = gmtime(&time_val);
			    ostrstream s1;
			    char month[4];
			    get_month(month, time_ptr->tm_mon);
			    s1 << time_ptr->tm_mday << "-" << month << "-"
			       << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
			    char* date_string = s1.str();
			    for (char* letter_ptr = date_string; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'd' code
			    delete[] date_string;
			}
			else {           // not sufficient room in buffer for time
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'f') {
		        if ((unsigned int)is_free() >= 3) {
			    for (char* letter_ptr = prog_func.rst; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
				if (write_to_sendwin_flag) sendwin_ptr->write(*letter_ptr);
			    }
			    second_letter = filein.get(); // get rid of the 'f' code
			}
			else {           // not sufficient room in buffer for rst report
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == EOF) {  // last letter of file is a '$'
		        result = add_item('$');
			if (result == -1) filein.putback('$');
			else if (write_to_sendwin_flag) {
			    sendwin_ptr->write('$');
			    sendwin_ptr->winrefresh();
			}
		    }
		}
		else {
		    result = add_item(letter);
		    if (result == -1) filein.putback(letter);
		    else if (write_to_sendwin_flag) {
		        sendwin_ptr->write(letter);
			if (letter == '\n' || letter == ' ') sendwin_ptr->winrefresh();
		    }
		}
	    }
	}
	if (!filein) {
	    autocq_flag = loading_cq_buffer_complete;
	    add_item('\n');
	    add_item(CMDinbuffer);
	    add_item('E');
	    add_item(CMDinbuffer);
	    if (write_to_sendwin_flag) sendwin_ptr->write('\n');
	}
    }   
    else if (autocq_flag == loading_cq_buffer_complete) {
        if (tnc_ptr->tnc_func.tx_status == Tnc_func::rx) rx_count++;// stop one stray rx status info
                                                                    // triggering a premature send
	if (rx_count > 2) {
	    filein.clear();               // go back to begining of file ready for next pass through
	    filein.seekg(0, ios::beg);    // after the timer alarm goes off
	    autocq_flag = waiting;
	    cq_alarm_flag = FALSE;
	    signal(SIGALRM, cq_alarm_handler);
	    int alarm_val = prog_func.autocq_delay;
	    if (!alarm_val) alarm_val = 90;
	    alarm(alarm_val);
	    rx_count = 0;
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
// we need to go back to Tor Standby mode if we having been sending FEC in Pactor
// Note: if we cancel a cq message half way through by means of Autocq_query::action(),
// Autocq_query::action() will set prog_func.sending_autocq to FALSE, with the result
// that Tnc::read_state_message() will automatically do the same, so there is no
// to cater here for that possibility
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(300000);
		tnc_ptr->send_kamcommand(torCMD, '2', '0');
		usleep(100000);
	    }
	}
    }
    else if (autocq_flag == waiting) {
        if (tnc_ptr->tnc_func.stream_status[0][1] ==  Tnc_func::connected) {
	    filein.close();
	    prog_func.sending_autocq = FALSE;
	    mainscreen_ptr->display_connected_status();
	    return_val = FALSE;
	}
	else if (cq_alarm_flag) {
	    beep();
	    doupdate();
	    autocq_flag = loading_cq_buffer;
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(200000);
		tnc_ptr->send_kamcommand(pactorCMD, '2', '0');
		usleep(100000);
	    }
	    tnc_ptr->send_specialcommand(txCMD);  // go back to transmit
	    cq_alarm_flag = FALSE;
	}
    }
    else if (autocq_flag == close_down) {
        filein.close();
	prog_func.sending_autocq = FALSE;
	mainscreen_ptr->display_connected_status();
	return_val = FALSE;
    }
    if (write_to_sendwin_flag) sendwin_ptr->winrefresh();
    return return_val;
}


void cq_alarm_handler(int) {
    cq_alarm_flag = TRUE;
}

BufferList::BufferList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    upload_status[stream][port] = BufferList::keyboard;
	}
    }
}
