/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef PROG_DEFS_H
#define PROG_DEFS_H

// define number of streams on each port
// the program will set the MAXUSERS parameter of the Kam to this value whenever the program starts
#define MAXUSERS 8

// MAX_FRAMESIZE must not be greater than 256 and should not sensibly be less than 80
#define MAX_FRAMESIZE 128

// TR_BUFFER_SIZE should not be less than MESSAGE_SIZE - the max message size in ./messages
#define TR_BUFFER_SIZE 1024
#define MESSAGE_SIZE 276

#define FILE_BUFFER_SIZE 1024

#define CQ_BUFFER_SIZE MAX_FRAMESIZE*2

// this defines where the keyboard will wordwrap (it is also used in tnc.cpp to
// define KEYBOARD_PRIORITY to ensure that there is space for one line from the keyboard
// in the kam memory
#define WORDWRAP 77

// GUARD_QUEUE defines the number of characters to be left in tr_buffer when 
// send_mode (indicating the treatment of hf sending) is set to guard
#define GUARD_QUEUE 10

#define hisCall_SIZE 13
#define selCall_SIZE 9 
// selCall_SIZE must be at least 7

const int CALLBUFFER_SIZE = 20;

#define RC_FILE "kamrc"

// define some common exit codes

#define MEM_ERROR 10
#define CONFIG_ERROR 11
#define COM_ERROR 12
#define FILEOPEN_ERROR 13
#define PIPE_ERROR 14
#define TERM_ERROR 15
#define ARG_ERROR 16

// define the codes in Makefile to choose the correct character set

#define ASCII 0
#define CP437 1
#define LATIN_1 2

#define CMDinbuffer 3
// the program uses CMDinbuffer as a token when placing commands in tr_buffer, so that
// the command can be recognised when characters are extracted from the buffer to be
// placed in send_pipe.  This is used with Kam Tor command E (change-over to receive),
// and is preferable to placing command E directly in send_pipe in case there are
// still things in tr_buffer to be sent before change-over.

// CMDinbuffer should never be defined as a normal ASCII or LATIN-1 letter (in other
// words it must be less than 32), nor must it be 7 (beep), 8 (backspace), 10 ('\n')
// or 13 ('\r').

struct Prog_func{
    enum smode {word, guard, line} send_mode;
    enum {normal, setup} prog_mode;
    int exitflag;
    char* filedir;
    char* homedir;
    char* myCall;
    char mySelCall[selCall_SIZE +1];
    char* print_cmd;
    int GPL_flag;
    int noprompt_flag;
    int autocq_delay;
    int sending_autocq;
    char rst[4];
    enum {amtor, pactor} tor_autocq_mode;
};

// function declarations for three functions in main.cpp

int is_baudot(char);
int is_morse(char);
int get_month(char[4], int);

#endif
