/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef QQUEUE_H
#define QQUEUE_H

#include "prog_defs.h"

#ifndef MEM_ERROR
#define MEM_ERROR 10
#endif

class Qqueue_enum {
public:
    enum extract_mode{remove, view};  // because of template rules in early compilers
				      // such as gcc 2.7.2.x, any enumerated type
};                                    // declaration must be included in a wrapper class


template <class Type>
class Qqueue: public Qqueue_enum {
protected:
    Type* itembuffer;
    Type* itembuffer_baseptr;  // points to the current item at front of buffer (oldest item available)
    Type* itembuffer_backptr;  // points to the address in which the next item will be placed
    Type* max_itemptr;
    int itembuffer_length;
    int discard_flag;     // if discard_flag = 0, no item is added to the
                          // buffer if it is full; if != 0, then the item at
			  // the front of the buffer is discarded when a
			  // item is added to the full buffer
    int itemcount;
public:
    int add_item(const Type&);   // returns -1 if buffer full and discard_flag = 0, else returns 0
    Type front(extract_mode);    // if remove_flag != 0, then the letter being
    Type back(extract_mode);     // extracted will be removed from the buffer
    int is_empty(void) const {return itemcount == 0;}  // indicates if the above two methods will work
    int is_free(void) const {return itembuffer_length - itemcount;} // returns the number of free storage items
    int is_used(void) const {return itemcount;} // returns the number of items stored in the buffer
    operator void*(void) const {if (itemcount == itembuffer_length) return 0; else return (void*)this;} // returns 0 if queue is full
    int operator!(void) const {return is_empty();}
    void reset(void);
    Qqueue(int itembuffer_length, int discard_flag);
    ~Qqueue(void) {delete[] itembuffer;}
};

#endif
