/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef WIDGETS_H
#define WIDGETS_H

#include <qapplication.h>
#include <qmainwindow.h>
#include <qmultilinedit.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qevent.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qmessagebox.h>
#include <qclipboard.h>

#include "dialogs.h"
#include "prog_defs.h"
#include "tnc.h"

#define MAXLINES  300
#define SCROLL_STORE_SIZE 10000
#define RECEIVE_BUFFER_SIZE 9
#define END_OF_WINDOW 1000000      // this needs to be an arbitrary value greater than MAXLINES representing
                                   // the place the cursor is to be placed to reach the end of the window

class MainScreen;

class StatusLine: public QStatusBar {
    int with_tor_fleximinsize;
    int no_tor_fleximinsize;
    Tnc* tnc_p;
    Tnc_base* tnc_base_p;
    QLabel* connected_status_label_p;
    QLabel* lock_label_p;
    QLabel* tx_label_p;
    QLabel* idle_label_p;
    QLabel* err_label_p;
    QLabel* irs_label_p;
    QLabel* speed_label_p;
    QLabel* huff_label_p;
    QLabel* freebytes_label_p;
    QLabel* flexi_label_p;
    int torline_flag;
public:
    void write_connected_status(char* text) {connected_status_label_p->setText(text);}
    void write_lock_status(char* text) {lock_label_p->setText(text);}
    void write_tx_status(char* text) {tx_label_p->setText(text);}
    void write_idle_status(char* text) {idle_label_p->setText(text);}
    void write_err_status(char* text) {err_label_p->setText(text);}
    void write_irs_status(char* text) {irs_label_p->setText(text);}
    void write_speed_status(char* text) {speed_label_p->setText(text);}
    void write_huff_status(char* text) {huff_label_p->setText(text);}
    void write_freebytes(char* text) {freebytes_label_p->setText(text);}
    void make_torline(void);
    StatusLine(QWidget*, Tnc*, int, int);
};

class SendWin;
class ReceiveWin;
class DisplayLine;
class BufferList;
class EventSlots;

class MainScreen: public QMainWindow {

    Q_OBJECT
private:
    int letters_to_send_flag;
    int flush_chars;
    int count;
    int standard_size;
    unsigned char info_byte;
    unsigned char tx_byte;
    int buffer_count;
    int beep_count;
    int interval_count;
    int menu_copy_item;
    int menu_print_selection_item;
    int mouse_copy_item;
    int mouse_print_selection_item;
    int menu_set_print_mark_item;
    int menu_print_from_mark_item;
    int mouse_set_print_mark_item;
    int mouse_print_from_mark_item;
    QSplitter* splitter_p;
    DisplayLine* display_line_p;
    StatusLine* status_line_p;
    QPopupMenu* filemenu_p;
    QPopupMenu* streammenu_p;
    QPopupMenu* hfpacket_p;
    QPopupMenu* hftor_p;
    QPopupMenu* mouse_popup_p;
    QPopupMenu* mouse_streammenu_p;
    QPopupMenu* mouse_hfpacket_p;
    QPopupMenu* mouse_hftor_p;
    QToolButton* connect_button_p;
    QToolButton* disconnect_button_p;
    QToolButton* call_lock_button_p;
    QToolButton* capture_button_p;
    QToolButton* auto_cq_button_p;
    QToolButton* speed_lock_button_p;
    QToolButton* ident_button_p;
    QToolButton* sync_button_p;
    QToolButton* abort_button_p;
    QToolButton* rx_button_p;
    QToolButton* tx_button_p;
    QToolButton* cw_speed_button_p;
    EventSlots* event_slots_p;
    Tnc* tnc_p;
    Tnc_base* tnc_base_p;
    Pipe_fifo& receive_pipe;
    Transmit_buffer& tr_buffer;
    BufferList& buffer_list;
    int header_height;
    enum {rx, tx} tx_status;
private slots:
    void process_receive_pipe(int);
    void mouse_popup(void) {mouse_popup_p->exec(QCursor::pos());}
    void activate_textselected_items(void);
    void disactivate_textselected_items(void);
    void about_kamplus(void){QMessageBox::information(this, "About kamplus-qt",
			     "kamplus-qt-0.97\n\n"
			     "Copyright (C) 1999, 2000 Chris Vine, G3XXF\n"
			     "chris@cvine.freeserve.co.uk\n"
			     "G3XXF@GB7MSW.#33.GBR.EU\n\n"
			     "This program is released under the\n"
			     "GNU General Public License, version 2\n");}
    void about_qt(void) {QMessageBox::aboutQt(this, "About Qt");}
protected:
    virtual void resizeEvent(QResizeEvent*);
    virtual void timerEvent(QTimerEvent*);
public:
    SendWin* sendwin_p;
    ReceiveWin* receivewin_p;
    void update_print_mark_items(void);
    void show_packetmenu_streams(void) {streammenu_p->removeItem(1);
                                        mouse_streammenu_p->removeItem(1);
                                        streammenu_p->insertItem("&Hf", hfpacket_p, 1);
                                        mouse_streammenu_p->insertItem("Hf", mouse_hfpacket_p, 1);}
    void show_tormenu_streams(void) {streammenu_p->removeItem(1);
                                     mouse_streammenu_p->removeItem(1);
                                     streammenu_p->insertItem("&Hf", hftor_p, 1);
                                     mouse_streammenu_p->insertItem("Hf", mouse_hftor_p, 1);}
    void display_capture_status(void);
    void display_current_stream(void);
    void display_connected_status(void);
    void display_mode(void);
    void display_send_mode_status(void);
    void display_callsign(void);
    void display_freebytes(void);
    void set_connect_button(void);
    void set_disconnect_button(void);
    void set_capture_button(void) {if (tnc_p->tnc_func.capturefile_flag) capture_button_p->setOn(true);
                                     else capture_button_p->setOn(false);}
    void set_call_lock_button(void);
    void set_auto_cq_button(void);
    void set_speed_lock_button(void);
    void set_ident_button(void);
    void set_sync_button(void);
    void set_abort_button(void);
    void set_rx_button(void) {if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) rx_button_p->setEnabled(true);
                              else rx_button_p->setEnabled(false);}
    void set_tx_button(void) {if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) tx_button_p->setEnabled(true);
                             else tx_button_p->setEnabled(false);}
    void set_cw_speed_button(void) {if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode == Tnc_func::cw) cw_speed_button_p->setEnabled(true);
                                    else cw_speed_button_p->setEnabled(false);}
    void make_torline(void) {status_line_p->make_torline();}
    void update_lockinfo(void);
    void update_torinfo(unsigned char info = 255); // if info = 255, the tor info line will be updated from info_byte
    void update_txinfo(unsigned char tx = 255); // if tx = 255, the tx indication will be updated from tx_byte
    void beep(int count) {beep_count = count;}
    MainScreen(Tnc*, Tnc_base*, Pipe_fifo&, Transmit_buffer&, BufferList&);
    ~MainScreen(void) {}
};

class SendWin: public QMultiLineEdit {

    Q_OBJECT

signals:
    void CtrlA_pressed(void);
    void CtrlD_pressed(void);
    void CtrlT_pressed(void);
    void CtrlZ_pressed(void);
    void f1_pressed(void);
    void f2_pressed(void);
    void f3_pressed(int);
    void f4_pressed(void);
    void f5_pressed(void);
    void f7_pressed(void);
    void f8_pressed(void);
    void f9_pressed(void);
    void f10_pressed(void);
    void f11_pressed(void);
    void f12_pressed(void);
    void altB_pressed(void);
    void altI_pressed(void);
    void altL_pressed(void);
    void altP_pressed(void);
    void altR_pressed(void);
    void altS_pressed(void);
    void altX_pressed(void);
    void pageup_pressed(void);
    void pagedown_pressed(void);
    void sig_auto_cq(int, int);
    void sig_change_hfmode(int, int);
    void sig_upload(int);
    void sig_download(int);
    void sig_send_message(int, int);

    void keyup(void);
    void keydown(void);
    void keyright(int);

    void letter_to_send(uchar);

    void mouse_right_clicked(void);
protected:
    virtual void keyPressEvent(QKeyEvent*);
    virtual void mousePressEvent(QMouseEvent* event) {if (event->button() == RightButton) emit mouse_right_clicked();}
    virtual void mouseMoveEvent(QMouseEvent*) {}         // ignore other mouse events in this window
    virtual void mouseReleaseEvent(QMouseEvent*) {}      // ignore other mouse events in this window
    virtual void mouseDoubleClickEvent(QMouseEvent*) {}  // ignore other mouse events in this window
public:
    void write(const char*);
    void new_line(void) {newLine();}
    void backspace(void) {QMultiLineEdit::backspace();}
    void del_line(void) {QMultiLineEdit::killLine();}
    void font_change(int);
    SendWin(QWidget*);
    ~SendWin(void) {}
};


// we inherit from QMulitLineEdit, and we can make Receivewin a friend and
// access some of the protected methods

class ReceiveWinNode: public QMultiLineEdit {

    Q_OBJECT

signals:
    void mouse_right_clicked(void);
    void mouse_released(void);
private:
    int line_letters;
protected:
    virtual void mousePressEvent(QMouseEvent*);
    virtual void mouseReleaseEvent(QMouseEvent*);
public:
    friend ReceiveWin;
    ReceiveWinNode(QWidget*);
    ~ReceiveWinNode(void) {}
};

class ScrollStore {
    char store[SCROLL_STORE_SIZE + 1];
    int index;
public:
    void add_letter(char letter) {store[index++] = letter;}
    void remove_letter(void) {if (index) index--;}
    const char* extract_store(void) {store[index] = 0; return store;}
    void clear_store(void) {*store = 0; index = 0;}
    int is_free(void) const {if (index < SCROLL_STORE_SIZE) return SCROLL_STORE_SIZE - index;
                             return false;}
    int is_empty(void) const {return !index;}
    ScrollStore(void): index(0) {*store = 0;}
};

class ReceiveWin: public QWidgetStack {

    Q_OBJECT

signals:
    void mouse_right_clicked(void);
    void activate_textselected_items(void);
    void disactivate_textselected_items(void);
private:
    ReceiveWinNode* node_ptr[MAXUSERS][2];  // have a pointer for each stream/port;
    Tnc* tnc_p;
    int standard_size;
    int scroll_flag;
    char receive_buffer[RECEIVE_BUFFER_SIZE + 1];
    int receive_index;
public slots:
    void scrollup(void);
    void scrolldown(void);
    void scrollout(int silent);
    void copy(void);
    void print_selection(void);
    void print_scroll_buffer(void);
    void set_textselected_items(void);
public:
    ScrollStore scroll_store;
    int is_scrolling(void) const {return scroll_flag;};
    void check_scroll_condition(void);
    void write(const char* text) {write(text, tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
    void write(const char* text, int stream, int port);
    void newline(void) {newline(tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
    void newline(int stream, int port);
    void del_letter(void) {del_letter(tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
    void del_letter(int stream, int port);
    void buffer_add(char letter) {receive_buffer[receive_index++] = letter; receive_buffer[receive_index] = 0;
                                  if (receive_index >= RECEIVE_BUFFER_SIZE) buffer_flush();}
    int buffer_del(void) {if (receive_index) {receive_buffer[--receive_index] = 0; return 0;}
                          return -1;}
    void buffer_flush(void) {if (receive_index) {write(receive_buffer, 0, 1); *receive_buffer = 0; receive_index = 0;}}
    int buffer_letters(void) const {return receive_index;}
    void font_change(int);

    ReceiveWin(QWidget*, Tnc*, int);
    ~ReceiveWin(void) {}
};


class DisplayLine: public QWidget {
    MainScreen* mainscreen_p;
    int standard_size;
    QLabel* hiscall_label_p;
    QLabel* hfmode_label_p;
    QLabel* capture_stream_label_p;
    QLabel* hfsend_label_p;
    QLabel* current_stream_label_p;
    QLabel* current_stream_marker_p;
    int horiz_placement;
    int streamlabel_size;
    int streammarker_size;
protected:
    virtual void resizeEvent(QResizeEvent*);
public:
    void write_call(char* text) {hiscall_label_p->setText(text);}
    void write_hfmode(char* text) {hfmode_label_p->setText(text);}
    void write_capture(char* text) {capture_stream_label_p->setText(text);}
    void write_hfsend(char* text) {hfsend_label_p->setText(text);}
    void write_stream(char* text) {current_stream_label_p->setText(text);}
    int get_minsize(void) const {return horiz_placement + streamlabel_size + streammarker_size;}
    DisplayLine(MainScreen*, int);
};


#endif
