/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

char usrvia[2*L2VLEN+L2IDLEN+1];

#define CP_L2CON   2
#define CP_L4CON   4
#define CP_HOSTCON 7

#define CP_PARERR  10
#define CP_NODIG   11
#define CP_BADQUAL 12
#define CP_INTERN  13
#define CP_UNKNOWN 14

/************************************************************************/
/* Pruefen, ob die Autobinaer-Uebertragung abgebrochen werden soll      */
/*----------------------------------------------------------------------*/
static BOOLEAN abort_sbin(MBHEAD *mbp)
{
  if ((mbp->mbpc - mbp->mbgc) >= 4)
    return (get32(mbp) != 0x234f4b23L); /* BC ist zu bloede fuer '#OK#' */
  return (FALSE);
}

/************************************************************************/
/* Schaun, ob wir ein Call in der MH-Liste haben und dest fuellen.      */
/*----------------------------------------------------------------------*/
BOOLEAN isheard(char *id, DEST *dest) {
  MHEARD *mhp;
  BOOLEAN found = FALSE;

  for (mhp = (MHEARD *)l2heard.heardl.head;
       mhp != (MHEARD *)&l2heard.heardl;
       mhp  = mhp->next)
    if (cmpcal(id, mhp->id)) {                  /* Call in MH-Liste     */
      dest->port = mhp->port;                   /* Port aus MH          */
      dest->typ = 'U';
      *dest->via = 0;
      found = TRUE;
      if (cmpid(id, mhp->id))         /* wenn SSID auch passt, fertig!  */
        return (MHEARD_AVAILABLE);
    }
  return (found ? MHEARD_AVAILABLE : MHEARD_UNKNOWN);
}

/*
 * Connectwunsch bewerten und analysieren.
 */
WORD conprm2(DEST *user, DEST *dest) {

  dest->port = 0;                  /* DG8BR's Bug umgehen?              */

  if (user->call[0] == 0)
    return (CP_PARERR);             /* Parameter-Fehler                 */

  if (cmpid(user->call, hostid))
    return (CP_HOSTCON);

  switch (l3_find_route(user->call, dest)) {
/*
 * Als erstes wird geprueft, ob das Ziel eventuell unereichbar ist. Dann
 * brauchen wir gar nicht fortzufahren.
 */
    case NODE_DOWN :
      if (user->port == NOPORT) {
        cpyid(dest->call, user->call);
        return (CP_BADQUAL);
      }
      /* Wenn der Node ausgefallen ist, duerfen auch User einen Umweg
       * probieren.
       */
      break;
    case NODE_UNKNOWN :
/*
 * Kennen wir das Ziel nicht direkt, schauen wir ins Addressfeld, vielleicht
 * kennen wir ja den ersten via-Digi. Ist dieser down, dann ist das Ziel
 * nicht erreichbar. Ist es ein NET/ROM, koennen wir so nicht routen. Als
 * letztes hilft nur der Blick in die MH-Liste.
 */
      switch (l3_find_route(user->via, dest)) {
        case NODE_DOWN :
          cpyid(dest->call, user->call);
          return (CP_BADQUAL);
        case NODE_AVAILABLE :
          if (dest->typ <= NETROM)
            return (CP_NODIG);
          addid(dest->via, user->via);
          user->via[0] = 0;
          break;
        case NODE_UNKNOWN :
          if (isheard(user->call, dest) == MHEARD_UNKNOWN) {
            cpyid(dest->call, user->call);
            if (user->port != NOPORT)
             {
              dest->port = user->port;
              dest->via[0] = 0;
              dest->typ = 'U';
              return(CP_L2CON);
             }
            return(CP_UNKNOWN);
          }
      }
  }
/*
 * Der User darf den Connect beeinflussen, der Typ wird von NET/ROM auf
 * L2 Connect aber nur beim Sysop geaendert.
 */
  if (issyso() || (user->typ > NETROM))
   {
    if (user->port != NOPORT)
     {
      dest->port = user->port;
      dest->via[0] = '\0';
      dest->typ = 'U';
     }
    if (user->via[0])
     {
      cpyidl(dest->via, user->via);
      dest->typ = 'U';
     }
   }
  cpyid(dest->call, user->call);

  return (dest->typ <= NETROM ? CP_L4CON : CP_L2CON);
}

/*
 * Parameter fuer den Connect-Befehl auswerten und in dest speichern.
 * conprm() erhaelt eine Kopie von clipoi/clicnt und arbeitet damit.
 */
WORD conprm(
WORD       *n,                        /* Restlaenge der Parameterzeile */
char       **p,                       /* Parameter des Connectbefehls  */
DEST       *dest) {
  int     index;
  char    ident[L2CALEN];
  DEST    user;

  user.typ     = 'U';
  user.call[0] = 0;
  user.port    = NOPORT;            /* Port setzen                      */
  user.via[0]  = 0;

  if (!*n) return (CP_HOSTCON);

  if (getcal(n, p, VCpar, user.call) != TRUE)
    if (getide(n, p, ident) != ERRORS)
      if ((index = find_alias(ident)) != -1)
        cpyid(user.call, netp->nodetab[index].id);
  getport(n, p, &user.port);
  getdig(n, p, VCpar, user.via);
  getport(n, p, &user.port);

#ifdef PACSAT
  if (cmpid(user.call, pacsatid)) {
    ccpbox();
    return (CP_INTERN);
  }
  else
#endif
    return (conprm2(&user, dest));
}

#define CE_HTFULL  0
#define CE_CTFULL  1
#define CE_LTFULL  2
#define CE_BADQUAL 3
#define CE_SUSPEND 4
#define CE_BUSY    5
#define CE_PORTOFF 6
#define CE_INVCAL  7
#define CE_UNKNOWN 8

/*
 * (xxx table full) Fehler ausgeben und Fernconnects ablehnen.
 */
void conerr(int error, DEST *dest) {
  static char *fullerr[] = {"Host", "Circuit", "Link"};
  static char *failerr[] = {" (not available)\r", " (you are restricted)\r"};
  static char *busyerr[] = {" (already connected)\r"};
  MBHEAD *mbp;
  int    port;
  char   dstcal[10];

  if (ptctab[userpo->uid].local == PTC_LOCAL) {
    switch (error) {
      case CE_HTFULL :
      case CE_CTFULL :
      case CE_LTFULL :
      case CE_SUSPEND:
      case CE_BUSY   :
      case CE_INVCAL :
      case CE_UNKNOWN:
        if (g_utyp(userpo->uid) == L2_USER)
          rejlnk(g_ulink(userpo->uid)); /* durchfallen */
      default        :
        disusr(userpo->uid);
    }
  } else {
    switch (error) {
      case CE_HTFULL :
      case CE_CTFULL :
      case CE_LTFULL :
        puttfu(fullerr[error]);
        return;
      case CE_BADQUAL :
      case CE_SUSPEND :
        mbp = putals("Failure with ");
        putid(dest->call, mbp);
        putstr(failerr[error-CE_BADQUAL], mbp);
        break;
      case CE_BUSY :
        mbp = putals("Busy from ");
        putid(dest->call, mbp);
        putstr(busyerr[error-CE_BUSY], mbp);
        break;
      case CE_PORTOFF :
        mbp = putals("Port not in use\r");
        break;
      case CE_INVCAL :
        mbp = putals("Invalid call\r");
        break;
      case CE_UNKNOWN:
        call2str(dstcal, dest->call);
        mbp = getmbp();
        putprintf(mbp, "\rNode / User %s unknown! Please specify port, "
                       "if %s is a User:\r", dstcal, dstcal);
        for (port = 0; port < L2PNUM; port++)
         {
          if (portenabled(port) && updmheard(port))
            putprintf(mbp, "CONNECT %s %s\r", dstcal, portpar[port].name);
         }
        break;
    }
    prompt(mbp);
    seteom(mbp);
  }
}

/*
 * Nachricht ueber den Linkaufbau ausgeben.
 */
void setupmsg(DEST *dest) {
  MBHEAD *mbp;

  if (ptctab[userpo->uid].local == PTC_NORMAL) {
    switch (dest->typ) {
      case NETROM :
      case TNN :
      case INP :
      case THENET :
        mbp = putals("Interlink setup (");
        putstr(portpar[dest->port].name, mbp);
        putstr(") ...\r", mbp);
        break;
      case FLEXNET :
        mbp = putals("Interlink setup (via ");
        putid(dest->nbrcal, mbp);
        putstr(") ...\r", mbp);
        break;
      case LOCAL_M :
        mbp = putals("Link setup (");
        putstr(portpar[dest->port].name, mbp);
        putstr(") ...\r", mbp);
        break;
      default :
        mbp = putals("Downlink setup (");
        putstr(portpar[dest->port].name, mbp);
        putstr(") ...\r", mbp);
        /*
         * Bei einem Downlink soll keine LOOP-Warnung angezeigt werden.
         */
        seteom(mbp);
        return;
    }
    if (userport(userpo) == dest->port)
      putstr("WARNING: Loop detected (HELP LOOP)\r", mbp);
    seteom(mbp);
  }
}

/*
 * Connect-Partner in der Patchcord-Liste eintragen
 */
void setptc(void *link, UBYTE typ) {
  PTCENT *ptcp;
  PTCENT *p_ptcp;
  UID     uid = userpo->uid;

  ptcp = ptctab + uid;
  ptcp->p_uid = g_uid(link, typ);
  p_ptcp = ptctab + ptcp->p_uid;
  p_ptcp->p_uid = uid;
}

/*
 * Connect an die Host-Console herstellen
 */
void conhst(DEST *dest) {
  int     i;

  for (i = 1, hstusr = hstubl+1; i < MAXHST; ++i, ++hstusr)
    if ((!hstusr->conflg) && (cmpid(hstusr->call, hostid))) break;

  if (i != MAXHST) {
    cpyid(hstusr->call, usrcal);
    if (hstreq()) {
      setptc(hstusr, HOST_USER);
      userpo->status = US_CREQ;
      return;
    }
  }

  conerr(CE_HTFULL, dest);
}

/*
 * Level 4 Connect (Circuit) herstellen.
 */
void conl4(DEST *dest) {
  CIRBLK *cirp;
  LNKBLK *frelnk;
  int     i;

  for (i = 0, cirpoi = cirtab; i < NUMCIR; ++i, ++cirpoi)
    if (cirpoi->state == L4SDSCED)
      break;

  if (i != NUMCIR) {
    cpyid(cirpoi->downca, dest->np->id);
    cpyid(cirpoi->upcall, usrcal);
    switch (g_utyp(userpo->uid)) {
      case L4_USER:  /* User ist Circuit    */
        cirp = (CIRBLK *) g_ulink(userpo->uid);
        cpyid (cirpoi->upnod,cirp->upnod);
        /* Uplinkknoten setzen */
        cpyidl(cirpoi->upnodv,cirp->upnodv);
        /* Digikette auch      */
        break;

      case L2_USER:  /* User ist L2-Link    */
            frelnk = (LNKBLK *) g_ulink(userpo->uid);
        cpyid (cirpoi->upnod,myid);
        /* Uplink hier         */
        cpyidl(cirpoi->upnodv,frelnk->viaidl);
        /* und Digikette       */
        break;

      default:    /* User vom Host       */
        cpyid(cirpoi->upnod,hostid);
        /* Uplink hier         */
        *cirpoi->upnodv = '\0';
        /* kein Digi           */
        break;
    }
    cirpoi->l3node  = dest->np;
    userpo->status = US_CREQ;
    setptc(cirpoi, L4_USER);
    setupmsg(dest);                 /* "Interlink setup ..."            */
    newcir();
  } else                            /* Circuit aufbauen                 */
    conerr(CE_CTFULL, dest);        /* Circuit Table full               */
}

/*
 * Level 2 Connect herstellen.
 */
void conl2(DEST *dest) {

  if (dest->typ == 'U')
    if (is_down_suspended(dest->call, dest->port)) {
      conerr(CE_SUSPEND, dest);
      return;
    }

  if (portenabled(dest->port)) {

    if (dest->typ != FLEXNET) {     /* nur bei FLEXNET Pfadweitergabe   */
      cpyid(usrvia, myid);
      usrvia[L2IDLEN - 1] |= L2CH;
      usrvia[L2IDLEN] = 0;
    }

    addidl(usrvia, dest->via);      /* gefundenen Pfad noch drankleben  */

    if (strlen(usrvia) > L2VLEN) {  /* Headerfeld ist zu gross          */
      conerr(CE_INVCAL, dest);
      return;
    }

    /* wenn wir diesen Link schon aktiv haben, melden wir BUSY          */

    lnkpoi = getlnk(dest->port, usrcal, dest->call, usrvia);

    if (lnkpoi) {
      if (lnkpoi->state == L2SDSCED) {
        userpo->status = US_CREQ;
        setptc(lnkpoi, L2_USER);
        setupmsg(dest);             /* "Downlink setup" ...             */
        newlnk();                   /* Neuen Link aufbauen              */
      } else
        conerr(CE_BUSY, dest);      /* Busy (Already connected)         */
    } else
      conerr(CE_LTFULL, dest);      /* Link table full                  */
  } else
    conerr(CE_PORTOFF, dest);       /* Port ist abgeschaltet            */
}

void conusr(int type, DEST *dest) {
  switch (type) {
    case CP_HOSTCON:                /* Connect an die Console           */
      conhst(dest);                 /* nicht an Kanal 0 connecten       */
      break;
    case CP_L4CON:                  /* Layer4 (NET/ROM) Connect?        */
      conl4(dest);                  /* Level 4 Connect                  */
      break;
    case CP_L2CON:                  /* Level2 connect?                  */
      conl2(dest);
      break;
    case CP_BADQUAL:
      conerr(CE_BADQUAL, dest);
      break;
    case CP_INTERN:
      break;
    case CP_UNKNOWN:
      conerr(CE_UNKNOWN, dest);
      break;
    default :                       /* Fehler aufgetreten?              */
      conerr(CE_INVCAL, dest);
      break;
  }
}

/************************************************************************/
/* Einleiten einer Weiterverbindung bei Gateway-Connects.               */
/* Hierzu wird aus dem L2-via-Feld gelesen, wohin der Link gehen        */
/* soll. Bei L4-Links wird entsprechend das Zielcall gelesen.           */
/*----------------------------------------------------------------------*/
void gateway(void)
{
  UID     uid = userpo->uid;
  PTCENT *ptcp = ptctab + uid;
  char   *viap;
  char   *p;
  DEST    user;
  DEST    dest;
  /*NODE   *np;
  PEER   *pp;*/

  cpyid(usrcal, calofs(UPLINK, userpo->uid));    /* Mycall                */

  switch (g_utyp(userpo->uid)) {

    case L2_USER :
      lnkpoi = g_ulink(userpo->uid);

      cpyid(user.call, lnkpoi->srcid);            /* Ziel-Rufzeichen      */

/* Jetzt stellen wir das Addressfeld des eingehenden Links zusammen.      */
/* In usrvia wird der bisherige Weg gespeichert, in user.via der          */
/* restliche.                                                             */
/* Der Weg wird nur soweit kopiert, bis wir den ersten Digi kennen, der   */
/* Rest ist dann unwichtig.                                               */

      for (viap = lnkpoi->viaidl; *viap; viap += L2IDLEN);
      for (p = usrvia; viap > lnkpoi->viaidl; ) {
        viap -= L2IDLEN;
        memcpy(p, viap, L2IDLEN);
        p[L2IDLEN - 1] ^= L2CH;
        /* if (iscall(p,&np,&pp,VC|VC_FAR) > 0)
          for (; viap > lnkpoi->viaidl && (!(viap[L2IDLEN - 1] & L2CH));
               viap -= L2IDLEN); */
        if (!(p[L2IDLEN - 1] & L2CH)) {
          p[L2IDLEN - 1] |= L2CH;
          p[L2IDLEN] = 0;
          for (p = user.via; viap > lnkpoi->viaidl; ) {
            viap -= L2IDLEN;        /* den Rest regulaer kopieren         */
            cpyid(p, viap);         /* die muessen alle noch              */
            p += L2IDLEN;
          }
          break;
        }
        p += L2IDLEN;
      }
      *p = 0;

      break;

    case L4_USER :
      cirpoi = g_ulink(userpo->uid);

      cpyid(user.call, cirpoi->destca);           /* Ziel-Rufzeichen      */

      user.via[0] = 0;              /* hier werden wir spaeter mal aus    */
                                    /* cirpoi->upnod/upnodv den alten     */
                                    /* und mit einer L4-modif den weitern */
                                    /* weg rausfinden.                    */

      cpyid(usrvia, myid);          /* eigenes Call                       */
      usrvia[L2IDLEN - 1] |= L2CH;
      usrvia[L2IDLEN] = 0;
      break;

    default :
      return;
  }

  user.port = NOPORT;               /* Port ist uns egal                  */
  user.typ  = 0;

  ptcp->local = PTC_LOCAL;

  conusr(conprm2(&user, &dest), &dest);
  ptcp->recflg = FALSE;             /* nie Reconnect                      */
}

void ccpcmd(void) {
  cpyid(usrcal, calofs(UPLINK, userpo->uid));

  if (ismemr()) {                   /* keine Arbeit ohne Speicher       */
    if (   userpo->sysflg           /* Sysop oder kein Sysop-Port?      */
        || g_utyp(userpo->uid) != L2_USER
        || !sysoponly(((LNKBLK*)g_ulink(userpo->uid))->liport)
       ) {
      if (   intern_command(cmdtab) /* Interner Befehl?                 */
          && read_txt()             /* Text lesen?                      */
          && extern_command()       /* Externer Befehl?                 */
         )
        inv_cmd();                  /* unbekannter Befehl               */
      else
        userpo->errcnt = 0;
    } else {                        /* SYSOP-Port                       */
      if (intern_command(syscmdtab))
        inv_cmd();                  /* einfach nur Invalid Command      */
      else
        userpo->errcnt = 0;
    }
  }
}

void l7rx(void) {
  FILE           *prot;
  char huge      *usnxtc;
  WORD            usget;
  WORD            zeichen;
  MBHEAD         *mhdp;
  MBHEAD         *usrmhd;
  MBHEAD         *mbp;
  UID             uid;
  UID             p_uid;
  PTCENT         *ptcp;

  /*=== eingelaufene Info Frames fuer den CCP verarbeiten ===*/
  while ((mhdp = (MBHEAD *) userhd.head) != (MBHEAD *) &userhd.head)
  {
     ulink((LEHEAD *)mhdp);
     uid = mhdp->type;              /* User ID lesen                    */
     ptcp = ptctab+uid;
     userpo = ptcp->ublk;           /* Userblock-Zeiger lesen           */
     if (userpo == NULL) {          /* nicht im CCP?                    */
       dealmb(mhdp);
       continue;
     }

     /*==================================================================*/
     /*=== eingelaufene Info Frames fuer User verarbeiten             ===*/
     /*------------------------------------------------------------------*/

     if ((usrmhd = userpo->mbhd) == NULL)
       userpo->mbhd = mhdp;
     else {
       usnxtc = usrmhd->mbbp;
       usget = usrmhd->mbgc;
       while (usrmhd->mbgc < usrmhd->mbpc)
         getchr(usrmhd);
       while (mhdp->mbgc < mhdp->mbpc)
         putchr(getchr(mhdp), usrmhd);
       usrmhd->mbbp = usnxtc;
       usrmhd->mbgc = usget;
       dealmb(mhdp);
     }

     while (userpo && (mhdp = userpo->mbhd) != NULL && getlin(mhdp)) {
       if (l7tosh(mhdp))            /* Shell hat verarbeitet        */
         continue;

        if (userpo->fp != NULL)     /* Laeuft Datei-Uebertragung?   */
        {
          if (   userpo->status == US_SBIN  /* binaersenden?                */
              && abort_sbin(mhdp) == FALSE) /* kam #OK#?, ignorieren        */
          {
            dealmb(mhdp);
            userpo->mbhd = NULL;
            continue;
          }

          fclose(userpo->fp);               /* Ja, dann abbrechen           */
          userpo->fp = NULL;

          if (userpo->fdefblk != NULL) {
            xremove(userpo->fdefblk->data);
            dealoc((MBHEAD *)ulink((LEHEAD *) userpo->fdefblk));
            userpo->fdefblk = NULL;
          }

          mbp = getmbp();
          putstr("\r- Aborted -\r\r", mbp);
          prompt(mbp);
          seteom(mbp);
          dealmb(mhdp);                    /* Abbruchzeile ignorieren */
          userpo->mbhd = NULL;
          userpo->status = US_CCP;
          continue;
        }

        if (userpo->status == US_RBIN)     /* BIN-Load                     */
        {
          program_load(mhdp);
          if (mhdp->mbgc == mhdp->mbpc)
          {
             dealmb(mhdp);
             userpo->mbhd = NULL;
          }
          continue;
        }

        if (userpo->convers != NULLCONNECTION)
          if (convers_input(mhdp))
          {
             if (mhdp->mbgc == mhdp->mbpc)
             {
               dealmb(mhdp);
               userpo->mbhd = NULL;
             }
             continue;
          }

        clipoi = clilin;
        clicnt = 0;
        while (   (mhdp->mbgc < mhdp->mbpc)
               && ((zeichen = getchr(mhdp)) != CR))
        {
          if ((zeichen == BS) || (zeichen == DEL))
          {
             if (clicnt != 0)
             {
                --clipoi;
                --clicnt;
             }
          }
          else
          {
             if ((zeichen != LF) && (clicnt < sizeof(clilin) - 5))
             {
                *clipoi++ = zeichen;
                ++clicnt;
             }
          }
        }

        *clipoi = '\0';                      /* und mit NULL terminieren! */

        if (mhdp->mbgc == mhdp->mbpc)
        {
          dealmb(mhdp);
          userpo->mbhd = NULL;
        }

        /*=== Zeile vom User auswerten ===*/

        switch (userpo->status) {
          case US_WBIN :
            start_autobin();
            continue;
          case US_RTXT :
            load_text();
            continue;
        }

#ifdef PACSAT
        if (userpo->pacsat != NULL) {
          l7_to_pacsat();
          continue;
        }
#endif
        clipoi = clilin;

        switch (userpo->status) {
          case US_WPWD :
            get_password();
            continue;
          case US_TALK :
            if (*clipoi == '/' && tolower(*(clipoi+1)) == 'q')
            {
              mbp = getmbp();
              prompt(mbp);
              seteom(mbp);
              userpo->talkcall[0] = '\0';
              userpo->status = US_CCP;
            }
            else
              talk_to(userpo->talkcall, 0);
            continue;
          case US_CREQ :
            p_uid = ptcp->p_uid;
            disusr(p_uid);
            ptcp->p_uid = NO_UID;
            ptctab[p_uid].p_uid = NO_UID;
            userpo->status = US_CCP;
            break;
        }

        clipoi = clilin;

        /* hier werden alle Eingaben in einer Datei protokolliert */
        /* wenn dies gewnscht wird !                             */

        if ( (proto == 2) ||
             ((proto == 1) && (issyso () )))
        {
          if ((prot = xfopen("COMMAND.LOG","at")) != NULL)
          {
            fprintf(prot, "(%u) %.6s %s > %s\n\n",
                          uid,
                          calofs(UPLINK,uid),
                          ctime(&sys_time),
                          clipoi);
            fclose(prot);
          }
        }

        if (skipsp(&clicnt, &clipoi))
          ccpcmd();                       /* Zeile mit Inhalt             */
        else
        {                                 /* leere Zeile                  */
          mbp = getmbp();
          prompt(mbp);
          seteom(mbp);
        } /* else */
    } /* while */
  } /* while */
}

void l7tx(void) {
  MBHEAD         *mbp;
  LONG           pos;
  WORD           c;
  WORD           i;

  /*
   *  Wenn noch Reste aus einer Datei zu senden sind,
   *  diese an den User senden
   */
  for ( userpo  = (USRBLK *) usccpl.head;
        userpo != (USRBLK *) &usccpl;
        userpo  = (USRBLK *) userpo->unext )
  {
     if (userpo->status == US_DIG) {
       gateway();
       if (userpo->status == US_DIG)
         userpo->status = US_CCP;
       continue;
     }

     if (userpo->fp != NULL)
     {
        pos = ftell(userpo->fp);
        LOOP
        {
          mbp = getmbp();
          if (userpo->status == US_SBIN) {
             for (i = 0; i < paclen; ++i)
             {
                if ((c = fgetc(userpo->fp)) == EOF)
                  break;    /* for ... */
                putchr(c, mbp);
             }
          } else {
             for (i = 0; i < paclen; ++i)
             {
                if ((c = fgetc(userpo->fp)) == EOF)
                  break;    /* for ... */
                if (c != CR)
                  putchr(c == '\n' ? CR : c, mbp);
             }
          }

          if (send_msg(FALSE, mbp))
          {
            if (c == EOF)
            {
               mbp = getmbp();
               putchr('\r', mbp);
               prompt(mbp);
               send_msg(TRUE, mbp);
               fclose(userpo->fp);
               userpo->fp = NULL;
               if (userpo->fdefblk != NULL) {
                 xremove(userpo->fdefblk->data);
                 dealoc((MBHEAD *)ulink((LEHEAD *) userpo->fdefblk));
                 userpo->fdefblk = NULL;
               }
               userpo->status = US_CCP;
               break;      /* LOOP */
             }
             pos = ftell(userpo->fp);
          }
          else
          {
             dealmb((MBHEAD *)ulink((LEHEAD *) mbp));
             fseek(userpo->fp, pos, SEEK_SET);
             break;        /* LOOP */
          }
        }
     }
  }

  convers_output();
}

/**************************************************************************/
/* CONNECT                                                                */
/*------------------------------------------------------------------------*/
void ccpcon(char *Direct)
{
  DEST dest;

  cpyid(usrvia, myid);
  usrvia[L2IDLEN - 1] |= L2CH;
  usrvia[L2IDLEN] = 0;
  conusr(conprm(&clicnt, &clipoi, &dest), &dest);
  ptctab[userpo->uid].recflg = (Direct == NULL);
}

/**************************************************************************/
/* CQ                                                                     */
/*------------------------------------------------------------------------*/
void ccpcq(void)
{
  MBHEAD *mbp;
  WORD    prt = DefDownport;

  getport(&clicnt, &clipoi, &prt);
  skipsp(&clicnt, &clipoi);
  mbp = getmbp();
  mbp->l2fflg = L2CPID;
  while (clicnt-- > 0)
    putchr(*clipoi++, mbp);
  putchr(CR, mbp);
  rwndmb(mbp);
  sdui(cqdil, cqdest, usrcal, prt, mbp);
  dealmb(mbp);
  mbp = getmbp();
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/* BEACON                                                                 */
/*------------------------------------------------------------------------*/
void ccpbea(void)
{
  MBHEAD *mbp;
  BEACON *beapoi;
  char call[7];
  char digil[57];
  WORD port;
  WORD interval;
  WORD telemetrie;
  WORD chaptr;

  if (issyso())
  {
    skipsp(&clicnt, &clipoi);
    if (clicnt)
      if ((port = (WORD) (nxtnum(&clicnt, &clipoi) & 0x7F)) < L2PNUM) {
        beapoi = &beacon[port];
        skipsp(&clicnt, &clipoi);
        if (*clipoi == '=') {
          ++clipoi;
          --clicnt;
          skipsp(&clicnt, &clipoi);
          chaptr = 0;
          while ((clicnt-- >0) && chaptr < 79)
            beapoi->text[chaptr++] = *clipoi++;
          beapoi->text[chaptr] = '\0';
          if (beapoi->text[0] == '.')
            beapoi->text[0] = '\0';
        } else {
          interval = nxtnum(&clicnt, &clipoi);
          telemetrie = nxtnum (&clicnt, &clipoi);
          if (getcal(&clicnt, &clipoi, FALSE, call) == TRUE) {
            cpyid(beapoi->beades, call);
            getdig(&clicnt, &clipoi, TRUE, digil);
            cpyidl(beapoi->beadil, digil);
            beapoi->interval = interval;
            beapoi->telemetrie = telemetrie;
          }
        }
        userpo->sysflg = 2;
      }
  }

  mbp = putals("Beacons:\r");
  for (port = 0, beapoi = beacon; port < L2PNUM; ++port, ++beapoi) {
    if (beapoi->interval != 0) {
      if (userpo->sysflg == 2)
      beapoi->beatim = 0;
      putnum(port, mbp);
      putchr(' ', mbp);
      putnum(beapoi->interval, mbp);
      putchr(' ', mbp);
      putnum(beapoi->telemetrie, mbp);
      putchr(' ', mbp);
      putid(beapoi->beades, mbp);
      putdil(beapoi->beadil, mbp);
      putchr('\r', mbp);
      putstr(beapoi->text, mbp);
      putchr('\r', mbp);
    }
  }
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/* READ - Datei lesen                                                     */
/*------------------------------------------------------------------------*/
void ccpread(char *text)                 /* READ - Befehl (Dateien lesen) */
{
  char file[MAXPATH+1];

  MBHEAD *mbp;

/* wenn text == NULL, dann war es ein Readbefehl
   ansonsten, enthaelt text entweder den namen einer infodatei
   oder einer tempdatei
   ob die Datei geloescht werden muss, erfaehrt man,
    wenn userpo->fdefblk != NULL ist
*/

  if (text != NULL)
  {
    normfname(text);
    if (strpbrk(text, ":\\/") == NULL) {
      strcpy(file,textpath);
      strcat(file,text);
    }
    else
      strcpy(file,text);
    userpo->fp = xfopen(file,"rt");
  }
  else
  {
    if (issyso())
     {
      strncpy(file, (char*)clipoi, MAXPATH);
      file[MAXPATH] = '\0';
     }
    userpo->fp = xfopen(file, "rt");
  }

  if (userpo->fp == NULL) {
    mbp = getmbp();
    if (text != NULL)
      if (strcmp(text, "CMD.TMP") == 0) {
        putstr("CLI failed!\r", mbp);
        prompt(mbp);
        seteom(mbp);
        return;
      }
    if (userpo->fdefblk != NULL) {
      dealoc((MBHEAD *)ulink((LEHEAD *) userpo->fdefblk));
      userpo->fdefblk = NULL;
    }
    putstr("Sri, no text available!\r", mbp);
    prompt(mbp);
    seteom(mbp);
  }
}

/**
 * Parameter-Auswertung fuer LOAD/EDIT.
 * Es kann immer nur ein EDIT/LOAD zur Zeit laufen, dafuer aber mit
 * vollen Pfaden. Dies ist wohl keine echte Einschraenkung, es sollten
 * sowieso nicht zwei Sysops auf einmal schrauben, das bringt nur Chaos.
 */
BOOLEAN loadprm(void) {
  char name[MAXPATH], *c;

  if (issyso()) {
    if (!*loadname)
    {
      clipoi[clicnt] = '\0';
      if (sscanf((char *) clipoi, "%s", name) == 1)
      {
        /* TMP-File auf dem Pfad des Zielfiles wegen Rename */

        if (strpbrk(name, ":/\\") == NULL)
        {
          strcpy(loadname,textpath);
          strcpy(loadtmp,textpath);
        }
        else
        {
          strcpy(loadtmp, name);
          if ((c = strrchr(loadtmp, '/')) == NULL)
            if ((c = strrchr(loadtmp, '\\')) == NULL)
              c = strchr(loadtmp, ':');
          c++;
          *c = '\0';
        }
        strcat(loadname,name);
        strcat(loadtmp,"LOAD.TMP");
        return (TRUE);
      } else
        putmsg("Invalid filename!\r");
    } else
      putmsg("EDIT/LOAD in use by other Sysop\r");
  }
  else
    invmsg();

  return (FALSE);
}

/**************************************************************************/
/* EDIT                                                                   */
/*------------------------------------------------------------------------*/
void ccpedi(void)
{
  MBHEAD *mbp;

  if (loadprm()) {
#ifndef MC68302
    if ((loadfp = xfopen(loadtmp,"wt")) != NULL)
#else
    xremove(loadname);
    if ((loadfp = xfopen(loadname, "wt")) != NULL)
#endif
    {
      userpo->status = US_RTXT;
      mbp = getmbp();
      putprintf(mbp,"editing>%s\r"
                    "Enter text. End with '.' in a new line.\r",loadname);
      seteom(mbp);
    }
    else {
      putmsg("Open error!\r");
      loadname[0] = loadtmp[0] = 0;
    }
  }
}

/**************************************************************************/
/* LOAD                                                                   */
/*------------------------------------------------------------------------*/
void ccpload(void)
{
  MBHEAD *mbp;

  if (loadprm()) {
#ifndef MC68302
    if ((loadfp = xfopen(loadtmp,"wb")) != NULL)
#else
    xremove(loadname);
    if ((loadfp = xfopen(loadname, "wb")) != NULL)
#endif
    {
      userpo->status = US_WBIN;
      mbp = getmbp();
      putstr("Waiting for AUTOBIN-Transfer...\r", mbp);
      seteom(mbp);
      checksum = 0L;
      crc = 0;
    }
    else {
      putmsg("File error!\r");
      loadname[0] = loadtmp[0] = 0;
    }
  }
}

/*
 * Qualitaet links oder rechtsbuendig ausgeben
 */
void putquality(MBHEAD *mbp, unsigned long qual, int align) {
#define QA_LEFT  0
#define QA_RIGHT 1
  if (align == QA_LEFT) {
    if (qual) putprintf(mbp, "%-6ld ", qual*10L);
    else putstr("----   ", mbp);
  } else {
    if (qual) putprintf(mbp, " %6ld", qual*10L);
    else putstr("   ----", mbp);
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
static void putrou(PEER *pp, MBHEAD *mbp, BOOLEAN printver)
{
  char *c_state[] = {"      ","setup ","conn. ","active"};
  /* char *t_state[] = {"-   ", "+REQ", "+   ", "-REQ"}; */

#define S_UNUSED 0
#define S_SETUP  1
#define S_CONN   2
#define S_ACTIVE 3
  int   typ = pp->typ;
  int   state;
  char *c;
  char *cp;

  mbp->l4time = mbp->mbpc;
  putid(pp->l2link->call, mbp);        /* Node Call ausgeben              */
  if (pp->primary != pp)
    putchr('*', mbp);
  putspa(10, mbp);                     /* Qua-Po-Dst Werte ausgeben       */

  putprintf(mbp, "%2.2s ", typtbl + pp->typ*2);
  putprintf(mbp, "%2d %4d", pp->l2link->port,
                            pp->num_routes);

  if (pp->nbrl2l != NULL) {
    if (pp->nbrl2l->state < L2SIXFER)
      state = S_SETUP; /* setup */
    else
      state = S_CONN; /* connected */
  } else {
    if (pp->typ == LOCAL_M) {
      if (pp->quality > 0)
        state = S_ACTIVE;   /* active */
      else
        state = S_UNUSED; /* unused */
    } else
      state = S_UNUSED; /* nicht connected */
  }

  if (typ != LOCAL) {
    putquality(mbp, pp->my_quality, QA_RIGHT);
    putchr('/', mbp);
    if (pp->my_quality)
      putquality(mbp, pp->his_quality, QA_LEFT);
    else
      putquality(mbp, 0, QA_LEFT);
  }

  /* switch (typ) {
    case TNN :
      putprintf(mbp, "%4d/%-4d", pp->brotim, broint_i);
      break;
    case NETROM :
    case THENET :
      putprintf(mbp, "%4d/%-4d", pp->brotim, broint_ui);
      break;
    case FLEXNET :
      putprintf(mbp, "%4d/%4.4s", pp->brotim, t_state[pp->token]);
      break;
    case LOCAL_M :
      putprintf(mbp, "%4d/%-4d", pp->rtt_time, MESSTIME);
      break;
    case INP :
      putprintf(mbp, "%4d/%-4d", pp->rtt_time, L3_RTT_TIME);
      break;
  } */

  putspa(36, mbp);

  putstr(c_state[state], mbp);

  if (!printver) {
    putchr(' ', mbp);
    if (*(c = pp->l2link->digil )) {
      while (*c) {
        putid(c, mbp);
        putchr(' ', mbp);
        c += L2IDLEN;
      }
    }
  } else {
     switch (pp->typ)
     {
       case NETROM :
         cp = "NET/ROM (UI)";
         break;
       case THENET :
         cp = "THENET (UI)";
         break;
       case TNN :
         putprintf(mbp,"TNN V%d.%d (I) ",(pp->version/100),(pp->version%100));
         cp = "";
         break;
       case INP :
         cp = "INP Node";
         break;
       case FLEXNET :
         switch (pp->version & 0x07)
         {
           case 0 : cp = "FlexNet"; break;
           case 1 : cp = "BayCom"; break;
           case 2 : cp = "Digiware"; break;
           case 3 : cp = "TheNetNode"; break;
           default: cp = "unknown"; return;
         }
         putstr(cp, mbp);
         if (pp->version)
           putprintf (mbp, " V%d.%d",((pp->version>>8) / 10),
                                     ((pp->version>>8) % 10));
       default :
         cp = "";
         break;
     }
     putstr(cp, mbp);
  }
  putchr('\r', mbp);
}

/*------------------------------------------------------------------------*/
/*  ROUTES COMMAND      Ausgabe einer formatierten Routes-Liste an User.  */
/*                      Eingabe von Routes durch SYSOP.                   */
/*------------------------------------------------------------------------*/
void ccprou(void)
{
  MBHEAD *mbp;
  BOOLEAN printver = FALSE;
  PEER   *i_pp, *j_pp;
  int     i,j;
  int     max_peers;
  int     flag[MAX_PEERS];

  max_peers = netp->max_peers;
  memset(flag, 0, sizeof(flag));

  if (clicnt != 0)
    if (*clipoi == 'v')
      printver = TRUE;           /* Version mit ausgeben */

  mbp = getmbp();
  putstr("Routes of ",mbp);     /* Konfiguration zeigen */
  putalt(alias, mbp);
  putid(myid, mbp);
  putprintf(mbp, " (%d/%d)\r", netp->num_peers, netp->max_peers);
  putstr("Node-----Typ-Po--Dst---L3SRTT[ms]---State--", mbp);

  putstr(printver ? "Software/Version------\r"
                  : "Route--------------\r", mbp);

  for (i = 0, i_pp = netp->peertab; i < max_peers; i++, i_pp++)
    if (i_pp->used)
      if (i_pp->primary == i_pp) {
        putrou(i_pp, mbp, printver);
        for (j = 0, j_pp = netp->peertab; j < max_peers; j++, j_pp++)
          if (j_pp->used)
            if (j_pp->primary == i_pp && j_pp != i_pp)
              putrou(j_pp, mbp, printver);
      }

  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/* SysOp                                                                  */
/*------------------------------------------------------------------------*/
void ccpsys(void)                      /* SYSOP - Befehl (Als Sysop anmelden) */
{
  WORD num;
  WORD i,j;
  MBHEAD *mbp;

  if (paswle != 0)
  {
    mbp = putals("");
    srand((UWORD)tic10);
    for (i = 0; i < 5; ++i) {
      do {
    do;
    while (((num = (rand()%256)) >= paswle) || (paswrd[num] == ' '));
    for (j = 0; j < i; ++j) {
      if ((userpo->paswrd[j] & 0xFF) == num)
      break;
    }
      } while (i != j);
      userpo->paswrd[i] = num;
      putchr(' ', mbp);
      putnum((num +1), mbp);
    }
    putchr('\r', mbp);
    seteom(mbp);
    for (i = 0; i < 5; ++i)                     /* Antwort aufbauen */
      userpo->paswrd[i] = paswrd[userpo->paswrd[i]];
    userpo->status = US_WPWD;
  }
}

void l2user(MBHEAD *, WORD, char *);
void l4user(MBHEAD *, WORD, char *);
void ptcuser(MBHEAD *, WORD, char *);
void hostuser(MBHEAD *, WORD, char *);

/************************************************************************/
/* USER                                                                 */
/*----------------------------------------------------------------------*/
void ccpuse(void)
{
  WORD    port;
  MBHEAD *mbp;
  #define USE_ALL   255
  #define USE_MASK  254
  #define USE_CALL  253
  #define USE_CONV  252
  #define USE_HOST  251
  BOOLEAN mhprm(char *, WORD, UBYTE *);
  char    call[L2IDLEN+1];
  char    mask[MAXMASK];
  int     i;

/* Titelzeile in neuen Buffer                                           */
  mbp = putals(" ");
  putprintf(mbp, "%s%d)", signon, nmbfre);
  i = mbp->mbpc;

/* Ueberpruefen, ob Befehl mit Parametern eingegeben wurde...           */
  if (skipsp(&clicnt, &clipoi))
  {
    if (getport(&clicnt, &clipoi, &port)) {
      /* Bei U Port alle L2-Uses dieses Ports zeigen */
      l2user(mbp, port, "");
      if (i == mbp->mbpc) putchr('\r', mbp);
      prompt(mbp);
      seteom(mbp);
      return;
    }

    if (strchr(clipoi, '+'))
    {
      l2user(mbp, USE_ALL, "");   /* Level 2 User in Tabellenform anzeigen */
      l4user(mbp, USE_ALL, "");   /* Level 4 User in Tabellenform anzeigen */
      hostuser(mbp, USE_ALL, ""); /* Host-User in Tabellenform anzeigen    */
    } else
    if (toupper(*clipoi) == 'C' && clicnt == 1)
    {
      l4user(mbp, USE_ALL, "");  /* Bei U C nur die L4 User ausgeben         */
    } else
    if (toupper(*clipoi) == 'L' && clicnt == 1)
    {
      l2user(mbp, USE_ALL, "");  /* Bei U L alle L2 user anzeigen            */
    } else
    if (toupper(*clipoi) == 'H' && clicnt == 1)
    {
      ptcuser(mbp, USE_CONV, "");
      ptcuser(mbp, USE_HOST, "");
      hostuser(mbp, USE_ALL, "");
    } else
    if (getcal(&clicnt, &clipoi, TRUE, call) == TRUE) {
      ptcuser(mbp, USE_CALL, call);
      l2user(mbp, USE_CALL, call);
      l4user(mbp, USE_CALL, call);
      hostuser(mbp, USE_CALL, call);
    } else
    if (mhprm( clipoi, clicnt, mask ) == TRUE) {
      ptcuser(mbp, USE_MASK, mask);
      l2user(mbp, USE_MASK, mask);
      l4user(mbp, USE_MASK, mask);
      hostuser(mbp, USE_MASK, mask);
    }
  if (i == mbp->mbpc) putchr('\r', mbp);
  }
  else
    ptcuser(mbp, USE_ALL, "");
  prompt(mbp);
  seteom(mbp);
}

/*
 * Formatierte Ausgabe einer Zahl 7stellig plus Suffix (k,M,G)
 */
void put_kMG(MBHEAD *mbp, ULONG num) {
  char *kMG = " kMG";
  int   suffix = 0;

  while ((num > 999999L) && (suffix < 3)) {
    num /= 1024L;
    suffix++;
  }
  putprintf(mbp, " %6lu%c", num, kMG[suffix]);
}

/*
 * Foratierte Ausgabe mit Punkten
 */
void put_pktnum(MBHEAD *mbp, ULONG num) {
  char str[20], *p;
  int  len;

  sprintf(str, "%lu", num);
  len = (int)(strlen(p = str) % 3);
  if (len == 0) len = 3;
  while (len--) putchr(*p++, mbp);
  while (*p) {
    if (*p) putchr('.', mbp);
    for (len = 0; len < 3; len++) putchr(*p++, mbp);
  }
}

/*
 * Baudrate, Counter und Connect-Zeit aus der Patchcord-Tabelle ausgeben.
 */
void putptcinfo(PTCENT *ptcp, MBHEAD *mbp) {
  ULONG Baud = (ptcp->rxbps + ptcp->txbps) * 8;
  ULONG d, h, m, s;

  /* Die Ausgabe aller Werte erfolgt 7stellig plus Suffix (k,M,G) */

  put_kMG(mbp, ptcp->inforx);            /* empfangene Bytes     */
  put_kMG(mbp, ptcp->infotx);            /* gesendete Bytes      */
  put_kMG(mbp, Baud);                    /* errechnete Baudrate  */

  d = ptcp->contime;
  s = d % 60L; d /= 60L;
  m = d % 60L; d /= 60L;
  h = d % 24L; d /= 24L;
  if (d < 1L)
    putprintf(mbp, " %2lu:%02lu:%02lu", h, m, s); /* hh:mm:ss */
  else
  if (d < 99L)
    putprintf(mbp, " %2lu/%02lu:%02lu", d, h, m); /* dd/hh:mm */
  else
    putprintf(mbp, "%5lu/%02lu", d, h);          /* ddddd/hh */
}

/*------------------------------------------------------------------------*/
/*
 *   Level 2 User in Tabellenform anzeigen:
 *
 *   Po SrcCall   DstCall   LS  Rx Tx Tr SRTT    RxkB     TxkB   Baud   ConTime Pri
 *   -------------------------------------------------------------------------
 *    0 DD1FR     DB0KH     IXF  2 10  3 1234     3456   72345  122   0:45:16   0
 *    1 DB0KH     DF7ZE     REJ  0  0  0  254      652   52345  345   1:23:01  10
 *   /  /        /        /   /   /  /    /        /       /    /        /   /
 * 0)  1)      2)       3)  4)  5) 6)   7)       8)      9)  10)      11) 12)
 *   0)  Port
 *   1)  Quellrufzeichen des L2-QSOs
 *   2)  Zielrufzeichen des L2-QSOs
 *   3)  L2-Link-Status:
 *         SET = Link-Setup
 *         FMR = Frame Reject
 *         DRQ = Disconnect Request
 *         IXF = Info Transfer
 *         REJ = REJ Sent
 *         WAK = Waiting Ackknowledge
 *         DBS = Device Busy
 *         RBS = Remote Busy
 *         BBS = Both Busy
 *         WDB = Waiting Ack And Device Busy
 *         WRB = Waiting Ack And Remote Busy
 *         WBB = Waiting Ack And Both Busy
 *         RDB = REJ Sent and Device Busy
 *         RRB = REJ Sent and Remote Busy
 *         RBB = REJ Sent and Both Busy
 *         HTH = HTH waiting
 *   4)  Anzahl der empfangenen Frames in der Warteschlange fuer diesen
 *       Link
 *   5)  Anzahl der noch zu sendenden Frames in der Warteschlange fuer
 *       diesen Link
 *   6)  Anzahl Retries
 *   7)  Stand des 'Smoothed Round Trip Timers'
 *   8)  Anzahl empfangender Bytes seit Bestehen des Links
 *   9)  Anzahl gesendetet Bytes seit Bestehen des Links
 *   10) Aus 8) + 9) errechnete effektive Baudrate fuer diesen Link
 *   11) Connectzeit
 *   12) Bei DAMA-Netzeinstiegen: aktuelle Prioritaet des Users
 *       (0 = hoechste Prioritaet)
 *  */

void l2user(MBHEAD *mbp, WORD what, char *pstr)
{
  LNKBLK *lp;
  char    lsts[] = {"DISSETFMRDRQIXFREJWAKDBSRBSBBSWDBWRBWBBRDBRRBRBBHTH"};
  char    tmp1[10],
          tmp2[10];
  LHEAD  *actlp;
  PTCENT *ptcp;
  int     port;
  BOOLEAN first = TRUE;

  for (port = 0, actlp = &l2actl[0]; port < L2PNUM; port++, actlp++) {
    for (lp  = (LNKBLK *) actlp->head;
         lp != (LNKBLK *) actlp;
         lp  = lp->next) {
      switch (what) {
        case USE_ALL  : break;
        case USE_MASK : if (   !c6mtch(lp->dstid, pstr)
                            && !c6mtch(lp->srcid, pstr)) continue;
                        break;
        case USE_CALL : if (   !cmpid(lp->dstid, pstr)
                            && !cmpid(lp->srcid, pstr)) continue;
                        break;
        default       : if (what < L2PNUM && port != what) continue;
      }
      ptcp = ptctab + g_uid(lp, L2_USER);
      mbp->l4time = mbp->mbpc;
      call2str(tmp1, lp->srcid);
      call2str(tmp2, lp->dstid);
      if (first) {
        putstr("\rL2 - User:\r", mbp);
        putstr("Po SrcCall   DstCall   LS  Rx Tx Tr SRTT    RxB     TxB    Baud   ConTime Pri\r", mbp);
        putstr("-------------------------------------------------------------------------------\r", mbp);
        first = FALSE;
      }
      putprintf(mbp,
      "%2d %-9.9s %-9.9s %3.3s%3u%3u%3u%5u",
      lp->liport,                                   /* Port nr user         */
      tmp1,                                         /* Quell-Rufzeichen     */
      tmp2,                                         /* Ziel-Rufzeichen      */
      &lsts[lp->state * 3],                         /* Link-Status          */
      lp->rcvd,                                     /* Frames in RX-Queue   */
      lp->tosend,                                   /* Frames in TX-Queue   */
      lp->tries,                                    /* Link-Retries         */
      lp->SRTT);                                    /* Round Trip Timer     */

      putptcinfo(ptcp, mbp);

      if (dama(lp->liport))
        putprintf(mbp," %3d\r",lp->damapm);        /* DAMA-Prioritaet       */
      else
        putstr("   -\r", mbp);
    }
  }
}

/*------------------------------------------------------------------------*/

/*
 *   Level 4 User in Tabellenform anzeigen:
 *
 *   Call      Node              S   Rx  Tx Tr Win    RxB      TxB   Baud   ConTime
 *   ------------------------------------------------------------------------------
 *   DL9HCJ    HHOST :DB0HHO    IXF   0   1  0  10     4321    45621  153  01:33:12
 *   DG9FU     KS    :DB0EAM    IXF   0   0  0  10    87554    12874  743  01:59:03
 *    /         /                /   /   /  /   /        /        /    /        /
 *    1)        2)               3)  4)  5) 6)  7)       8)       9)  10)      11)
 *
 *   1)  Rufzeichen des Users
 *   2)  Ident und Call des Knotens an dem der User eingeloggt ist
 *   3)  L4-Circuit-Status:
 *         SET = Circuit-Setup
 *         IXF = Info-Transfer
 *         DRQ = Disconnect-Request
 *   4)  Anzahl der empfangenen Frames in der Warteschlange fuer diesen
 *       Circuit
 *   5)  Anzahl der noch zu sendenden Frames in der Warteschlange fuer
 *       diesen Circuit
 *   6)  Anzahl Transport-Retries
 *   7)  Transport Fenstergroesse
 *   8)  Anzahl empfangender Bytes seit Bestehen des Circuits
 *   9)  Anzahl gesendetet Bytes seit Bestehen des Circuits
 *   10) Aus 8) + 9) errechnete effektive Baudrate fuer diesen Circuit
 *   11) Connectzeit
 *
 */

void l4user(MBHEAD *mbp, WORD what, char *pstr)
{
  CIRBLK *p;
  WORD    i;
  char    lsts[] = {"-SID"};  /* {"---SETIXFDRQ"}; */
  char    tmp1[10],
          tmp3[10];
  NODE   *np;
  PTCENT *ptcp;
  BOOLEAN first = TRUE;

  /*
   *    Circuit-Tabelle durchgehen und fuer alle nicht disconnecteten
   *    Circuits Info anzeigen
   */

  for (p = cirtab, i = 0; i < NUMCIR; ++p, ++i) {
    if (p->state != 0) {                        /* nur aktive Circuits  */
      switch (what) {
        case USE_ALL  : break;
        case USE_MASK : if (!c6mtch(p->upcall, pstr)) continue;
                        break;
        case USE_CALL : if (!cmpid(p->upcall, pstr)) continue;
                        break;
      }
      ptcp = ptctab + g_uid(p, L4_USER);
      mbp->l4time = mbp->mbpc;
      np = p->l3node;
      call2str(tmp1, p->upcall);

      call2str(tmp3, np->id);
      /*find_best_qual((int)(np-netp->nodetab), &bestpp, DG);
      call2str(tmp2, bestpp->l2link->call);*/

      if (first) {
        putstr("\rL4 - User:\r", mbp);
        putstr("Call      Node       S  Rx  Tx Tr Win SRTT     RxB     TxB    Baud   ConTime\r", mbp);
        putstr("-----------------------------------------------------------------------------\r", mbp);
        first = FALSE;
      }

      putprintf(mbp,
          "%-9.9s %-9.9s %c%c%c%3u %3u %2u %2u %5u ",
          tmp1,                                /* User-Call            */
          tmp3,                                /* Node                 */
          ((p->l4flag & L4FBUSY) ? '.':' '),
          lsts[(int)p->state],                 /* Circuit Status       */
          ((p->l4flag & L4FPBUSY) ? '.':' '),
          p->numrx,                            /* Frames in RX-Queue   */
          p->numtx,                            /* Frames in TX-Queue   */
          p->l4try,                            /* Transport-Retries    */
          p->window,                           /* Transport-Window     */
          p->SRTT);

      putptcinfo(ptcp, mbp);

      putchr('\r', mbp);
    }
  }
}


/*----------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------*/
void viaput(WORD seite, UID uid, MBHEAD *mbp)
{
  UBYTE   typ = g_utyp(uid);
  LNKBLK *lp;
  CIRBLK *cp;
  char   *p;

  if(typ == L2_USER) {
    lp = g_ulink(uid);
    p = ndigipt(lp->viaidl);
    if ((*p != '\0') || (!updmheard(lp->liport)))
     {
      putstr(seite == UPLINK ? "\r Uplink" : "\r Downlink", mbp);
      if (*p == '\0')         /* ohne Digis            */
        putprintf(mbp, " %s", portpar[lp->liport].name);
      else
        putdil(p, mbp);
     }
  } else {
    if (typ == L4_USER && seite == UPLINK)      /* User ist Circuit     */
    {
/************************************************************************\
*                                                                        *
* Die Uplinkinformation wird nur angezeigt, wenn entweder der letzte     *
* Absenderknoten nicht der Uplinkknoten ist oder aber wenn beim Uplink   *
* Digis verwendet wurden. Dann steht in einer eigenen Zeile:             *
* ' Uplink @ uplinkknoten via digikette'                                 *
*                                                                        *
\************************************************************************/
      cp = g_ulink(uid);
      if ((!cmpid(cp->upnod,cp->downca))
          || (*(cp->upnodv) != '\0'))
      {
        putstr("\r Uplink @ ",mbp);
        putid(cp->upnod,mbp);
        putdil(cp->upnodv,mbp);
      }
    }
  }
}

/* Ausgeben der Patchcordliste, eventuell auch nur fr ein Call oder eine */
/* Menge von Calls.                                                       */
void ptcuser(MBHEAD *mbp, WORD what, char *pstr)
{
  int     updown;
  PTCENT *ptcp;
  UID     uid;
  WORD    cvsflg = 0;

  if (what == USE_CONV) {
    cvsflg = 1;
    what = USE_ALL;
  }

  /*
   * Ausgegeben werden alle Uplinks aus der Patchcord mit ihren Downlinks
   * und die CCP-User (Convers, echte User usw)
   */
  if (what != USE_HOST)
    putchr('\r', mbp);
  for (uid = 0, ptcp = ptctab; uid < NUMPAT; ++uid, ptcp++)
  {
    if (ptcp->state == 0) continue;
    switch (what) {
      case USE_ALL  : break;
      case USE_MASK : if (   (!c6mtch(calofs(UPLINK, uid), pstr))
                          && (!c6mtch(calofs(DOWNLINK, uid), pstr)))
                        continue;
                      break;
      case USE_CALL : if (   (!cmpid(calofs(UPLINK, uid), pstr))
                          && (!cmpid(calofs(DOWNLINK, uid), pstr)))
                        continue;
                      break;
      case USE_HOST : if (   (g_utyp(uid) != HOST_USER)
                          && (g_utyp(ptcp->p_uid) != HOST_USER))
                        continue;
                      break;
    }
    mbp->l4time = mbp->mbpc;
    switch (ptcp->state) {
      case UPLINK :               /* kommt vom CCP (Convers)          */
        if (ptcp->ublk) {         /* ist der im CCP?                  */
          if (   (!cvsflg &&  ptcp->ublk->convflag)
              || ( cvsflg && !ptcp->ublk->convflag))
                continue;
          if (ptcp->ublk->convers != NULLCONNECTION) {
            putcvsu(ptcp->ublk, mbp);    /* Convers-Verb.             */
            putchr('\r', mbp);
            continue;
          }
        }
        break;
      case D_IPLINK :
      case U_IPLINK :
        updown = ptcp->state == D_IPLINK ? DOWNLINK : UPLINK;
        putuse(updown, uid, mbp);
        putspa(37, mbp);
        putstr("<-->  IP-Router", mbp);
        viaput(updown, uid, mbp);
        putchr('\r', mbp);
      default:
        continue;
    }
    if (cvsflg)
      continue;
    putuse(UPLINK, uid, mbp);
    if (ptcp->p_uid != NO_UID) {  /* gibts einen Partner-Link?        */
      putspa(37, mbp);
      putstr(ptcp->ublk ? "<..>  " : "<-->  ", mbp);
      putuse(DOWNLINK, ptcp->p_uid, mbp);
    }
    viaput(UPLINK, uid, mbp);
    if (ptcp->p_uid != NO_UID)
      viaput(DOWNLINK, ptcp->p_uid, mbp);
    putchr('\r', mbp);
  }
}

/*
 *
 *   Host-User in Tabellenform anzeigen:
 *
 *   CH Call      F     NT    RX    TX    ST     RxB     TxB    Baud   ConTime
 *   -------------------------------------------------------------------------
 *   03 DB0IL-3   CD  7199     1     0     0      65    1494     120   0:02:05
 *   05 DB0IL-5   C   7086     0     0     0      51     595      56   0:02:05
 *   06 OZ5BBS-1  C   7068     0     0     0    7620    1598      96   0:09:37
 *    /  /        /      /     /     /     /       /       /       /         /
 *   1) 2)       3)     4)    5)    6)    7)      8)      9)      10)       11)
 *
 *   1)  Hostmode-Kanal
 *   2)  Rufzeichen des Users (Connect vom User) oder eigenes Call (Connect
 *       vom Host zum Knoten)
 *   3)  Hostmode-Flags
 *         C = Connected
 *         D = Disconnecten wenn Info uebertragen
 *   4)  Noactivity-Timer
 *   5)  empfangene Frames in Warteschlange
 *   6)  zu sendende Frames in Warteschlange
 *   7)  Statusmeldungen in Warteschlange
 *   8)  Anzahl empfangender Bytes seit Bestehen des Links
 *   9)  Anzahl gesendetet Bytes seit Bestehen des Links
 *   10) Aus 8) + 9) + 11) errechnete effektive Baudrate fuer diesen Link
 *   11) Connectzeit
 *
 */

void
hostuser(MBHEAD *mbp, WORD what, char *pstr)
{
  HOSTUS  *hp;
  int     i;
  char    str[10];
  PTCENT *ptcp;
  BOOLEAN first = TRUE;

  for (hp = hstubl + 1, i = 1; i < MAXHST; ++hp, ++i)
   {
    if (   
           (!hp->conflg)
        &&
           (!hp->disflg)
        && 
           (cmpid(hp->call, hostid))
       )
      continue;
    switch (what)
     {
      case USE_ALL  : break;
      case USE_MASK : if (!c6mtch(hp->call, pstr)) continue;
                      break;
      case USE_CALL : if (!cmpid(hp->call, pstr)) continue;
                      break;
     }
    call2str(str, hp->call);
    if (first)
     {
      putstr("\rHost-User:\r"
             "CH Call      F     NT    RX    TX    ST     RxB     TxB    Baud   ConTime\r"
             "-------------------------------------------------------------------------\r", mbp);
      first = FALSE;
     }
    putprintf(mbp, "%02ld %-9.9s %c%c %5u %5u %5u %5u ",
                    hp - hstubl, str, (hp->conflg ? 'C':' '),
                    (hp->disflg ? 'D':' '), hp->noacti, hp->inlin,
                    hp->outlin, hp->outsta);
    ptcp = ptctab + g_uid(hp, HOST_USER);
    putptcinfo(ptcp, mbp);
    putchr('\r', mbp);
   }
}

/************************************************************************/
/* BroadCast                                                            */
/*----------------------------------------------------------------------*/
void ccpbcn(void)
{
  /* hier koennte man einen Broadcast-pro-Nachbar einfuehren, erstmal leer */
  invmsg();
}

/************************************************************************/
/* Time                                                                 */
/*----------------------------------------------------------------------*/
void ccptim(void)
{
#ifdef MC68K
  UWORD t1,t2,t3;
  char t4;
  struct tm *tim;
#endif
  MBHEAD *mbp;

#ifdef MC68K
  if (issyso()) {
    t1 = nxtnum(&clicnt, &clipoi);
    t4 = *clipoi++;
    clicnt--;
    t2 = nxtnum(&clicnt, &clipoi);
    clipoi++;
    clicnt--;
    t3 = nxtnum(&clicnt, &clipoi);
    if (t4 == '.') {
      if ( t1 <= 31 && t2 <= 12 && t3 <= 99 ) {
    if (t3 < 92)
         t3 += 100;
    tim = localtime(&sys_time);
    tim->tm_mday = t1;
    tim->tm_mon = t2 - 1;
    tim->tm_year = t3;
    sys_time = mktime(tim);
    stime(&sys_time);
      }
    }
    if (t4 == ':') {
      if ( t1 <= 23 && t2 <= 59 && t3 <= 59 ) {

    tim = localtime(&sys_time);
    tim->tm_hour = t1;
    tim->tm_min = t2;
    tim->tm_sec = t3;
    sys_time = mktime(tim);
    stime(&sys_time);
      }
    }
  }
#endif
  mbp = putals("Time: ");
  puttim(&sys_time, mbp);
  putstr(" (", mbp);
  putlong(tic10, FALSE, mbp);
  putstr(")\r", mbp);
  prompt(mbp);
  seteom(mbp);
}

/************************************************************************/
/* CLEAR                                                                */
/*----------------------------------------------------------------------*/
void ccpclr(void)
{
  int   i;
  STAT *statp;

  if (userpo->sysflg >= 1)
  {
    memset(portstat, 0, sizeof(portstat));

    for (i = 0, statp = mh; i < L2PNUM; i++, statp++) {
      memset(statp->call+sizeof(statp->call), 0,
             sizeof(STAT)-sizeof(statp->call));
    }

    l1sclr("*");

    time(&clear_time);

    putmsg("\rStatistic-table cleared!\r");
    userpo->sysflg = 2;
  }
  else
    invmsg();
}

/************************************************************************/
/* Statistik-Command                                                    */
/* Syntax: S + <call>         nimmt ein neues Call in die Statistik auf */
/*         S - <call>         loescht ein Call aus der Statistik        */
/*         S r                zeigt nur die Systemstatistik und         */
/*         S l                zeigt nur die Link-statistik              */
/*         S i                zeigt nur die IP-statistik                */
/*         S                  zeigt alles (wie bisher)                  */
/*----------------------------------------------------------------------*/
void ccpsta(void)
{
  MBHEAD   *mbp;
  STAT     *statp;
  WORD      i,j;
  char      call[7];
  ULONG     summe;            /* Gesamter Datendurchsatz in KBytes */
  LONG      upt,upd,uph;
  PORTSTAT *pstatp;
  PORTINFO *portp;
  ULONG     rxoverhead = 0L, txoverhead = 0L;
  int       ch;
#define PORTSTATFLAG  1             /* Die Reihenfolge muss mit chars   */
#define ERRORSTATFLAG 2             /* bereinstimmen                   */
#define LINKSTATFLAG  4
#define HARDWAREFLAG  8
#define IPSTATFLAG    16
#define STATFLAG      32
  int       flag = 0;
  char     *chars = "PELHIS", *cp;

  mbp = getmbp();

  skipsp(&clicnt, &clipoi);
  ch = toupper(*clipoi);

  for (cp = chars, i = 1; *cp; cp++, i<<=1)
    if (ch == *cp) flag |= i;

  if (ch == '*')
    flag = (~0);                   /* Monats-Statistik (alles)         */

  if (flag == 0)
    flag |= STATFLAG;

  if (issyso())
  {
    /******* Delete Call from Statistics **************/
    if (ch == '-')
    {
      clipoi++;
      clicnt--;
      if (getcal(&clicnt, &clipoi, TRUE, call) == TRUE)
      {
        for (statp = mh, j = 0; j < MAXSTAT; statp++, j++)
          if (cmpid(statp->call, call))
            statp->call[0] = '\0';
      }
      flag |= LINKSTATFLAG;
    }

    /******** Add Call to Statistics *****************/
    if (*clipoi == '+')
    {
      clipoi++;
      clicnt--;
      if (getcal(&clicnt, &clipoi, TRUE, call) == TRUE)
      {
        /**
         * Wenn das Call schon in der Statistic steht, dann
         * tragen wir es nicht nochmal ein.
         */
        for (statp = mh, j = 0; j < MAXSTAT; statp++, j++)
          if (cmpid(statp->call, call))
            break;
        if (j >= MAXSTAT) {
          for (statp = mh, j = 0; j < MAXSTAT; statp++, j++)
            if (!*statp->call) {
              memset(statp, 0, sizeof(STAT));
              cpyid(statp->call, call);
              statp->hfirst = sys_time;
              statp->hlast = sys_time;
              userpo->sysflg = 2;
              break;
            }
        }
      }
      flag |= LINKSTATFLAG;
    }
  }
  summe = 0L;

  /********** Show System Statistics *********************/
  putstr("\r System Statistics: ", mbp);       /* aktuelle Uhrzeit      */
  puttim(&clear_time, mbp);
  putstr(" - ", mbp);
  puttim(&sys_time, mbp);
  putstr("\r           Startup: ", mbp);       /* Startzeit             */
  puttim(&start_time, mbp);

  upt = sys_time - start_time;                 /* Uptime in seconds     */
  upd = upt/SECONDS_PER_DAY;                   /* Uptime days           */
  upt %= SECONDS_PER_DAY;
  uph = upt/SECONDS_PER_HOUR;                  /* Uptime hours          */
  upt %= SECONDS_PER_HOUR;

  putprintf(mbp,  "\r            Uptime:%9ld/%02ld:%02ld\r",
                  upd, uph, upt/SECONDS_PER_MIN);

  if (flag & STATFLAG) {
    putprintf(mbp, "\r                       (min)    (now)    (max)\r"
                   "        Rounds/sec: %8lu %8lu %8lu\r",
                   rounds_min_sec, rounds_pro_sec, rounds_max_sec);

    putprintf(mbp,  "      Free Buffers: %8u %8u %8u\r"
                    "Overall Throughput:%18lu %8lu Baud\r"
                    "   Active L2-Links:%18u %8u\r"
                    "   Active Circuits:%18u %8u\r"
                    "      Active Nodes:%18u %8u\r",
                        nmbfre_min, nmbfre, nmbfre_max,
                        thbps*8L, thbps_max*8L,
                        nmblks, nmblks_max,
                        nmbcir, nmbcir_max,
                        netp->num_nodes,
                        num_nodes_max);

#ifdef __LINUX__
    print_load (mbp);
#else
    if (rounds_max_sec)
      putprintf(mbp, "\r          CPU load: %lu%%",
          100 - (((ULONG)rounds_pro_sec)*100L) / ((ULONG)rounds_max_sec));
#endif
    if (nmbfre_max)
      putprintf(mbp, "\r      Buffer usage: %lu%%",
          100 - (((ULONG)nmbfre)*100L) / ((ULONG)nmbfre_max));

    putprintf(mbp,   "\r      Network Heap: %lu Bytes"
                     "\r   Free RAM (Fmem): %lu Bytes\r",
          sizeof(NETWORK) + (ULONG)netp->num_peers * (sizeof(PEER) +
          (ULONG)netp->max_nodes * sizeof(ROUTE)),
          (ULONG)coreleft());
  }

  /********** Show Tokenring Statistics *********************/
  if (flag & PORTSTATFLAG) {

     /******************** number of byte rx/tx per port *******************/
     summe = 0L;

     putstr("\r Port-Statistics:\r\r              Links      RxB      TxB   RxBaud   TxBaud  RxOver TxOver\r", mbp);

     for (i=0,pstatp=portstat,portp=portpar; i<L2PNUM; i++,pstatp++,portp++)
     {
       if (portenabled(i))
       {
         if (pstatp->rx_bytes/100L)
           rxoverhead = pstatp->rx_overhead/(pstatp->rx_bytes/100L);
         if (rxoverhead > 99) rxoverhead = 100;
         if (pstatp->tx_bytes/100L)
           txoverhead = pstatp->tx_overhead/(pstatp->tx_bytes/100L);
         if (txoverhead > 99)
           txoverhead = 100;

         putprintf(mbp, "%2u:%-10s%3u/%-3u ", i, portp->name,
                                              portp->nmblks,
                                              portp->nmbstn);
         put_kMG(mbp, pstatp->rx_bytes);
         putchr(' ', mbp);
         put_kMG(mbp, pstatp->tx_bytes);
         putchr(' ', mbp);
         put_kMG(mbp, pstatp->rx_baud*8L);
         putchr(' ', mbp);
         put_kMG(mbp, pstatp->tx_baud*8L);
         putprintf(mbp, "   %3lu%%   %3lu%%\r", rxoverhead,
                                                txoverhead);
         summe += (pstatp->rx_bytes + pstatp->tx_bytes);
       }
     }
     putstr("\rTotal = ",mbp);
     put_pktnum(mbp, summe);
     putstr(" Bytes\r", mbp);
  }

  /************* Fehler-Statistik ************/
  if (flag & ERRORSTATFLAG) {

    putstr("\r Error-Statistics:\r\r                RxID  RxLen  RxCtl Resets\r", mbp);

    for (i=0,pstatp=portstat,portp=portpar; i<L2PNUM; i++,pstatp++,portp++)
    {
      if (portenabled(i))
      {
        putprintf(mbp, "%2u:%-10s ", i, portp->name);
        for (j = 0; j < 3; j++)
           putprintf(mbp, "%6u ", pstatp->invalid[j]);
        putprintf(mbp, "%6u\r", pstatp->reset_count);
      }
    }
  }

  if (flag & HARDWAREFLAG)
    l1stat("*", mbp);

  /************* Show Link Statistics *****************/
  if (flag & LINKSTATFLAG) {
    putstr("\rLink-Statistics:\r",mbp);
    putstr("\r    Bytes total          I         RR        REJ        RNR  %RR %REJ %RNR\r",mbp);
    for (i = MAXSTAT, statp = mh; i--; statp++)
    {
      if (*statp->call)
      {
        mbp->l4time = mbp->mbpc;
        putstr("Link to ", mbp);
        putid(statp->call, mbp);
        putspa(25, mbp);
        puttim(&statp->hfirst, mbp);
        putstr(" - ", mbp);
        puttim(&statp->hlast, mbp);

        putprintf(mbp, "\r RX: %10lu %10lu %10lu %10lu %10lu",
                       statp->rxByte,
                       statp->rxIno,
                       statp->rxRRno,
                       statp->rxREJno,
                       statp->rxRNRno);
        if (statp->txIno > 0L)
          putprintf(mbp, "%5lu%5lu%5lu",
                         (statp->rxRRno *100L)/statp->txIno,
                         (statp->rxREJno*100L)/statp->txIno,
                         (statp->rxRNRno*100L)/statp->txIno);

        putprintf(mbp, "\r TX: %10lu %10lu %10lu %10lu %10lu",
                       statp->txByte,
                       statp->txIno,
                       statp->txRRno,
                       statp->txREJno,
                       statp->txRNRno);
        if (statp->rxIno > 0L)
          putprintf(mbp, "%5lu%5lu%5lu",
                         (statp->txRRno *100L)/statp->rxIno,
                         (statp->txREJno*100L)/statp->rxIno,
                         (statp->txRNRno*100L)/statp->rxIno);
        putstr("\r", mbp);
      }
    }
  }

#ifdef IPROUTE
  /************* Show IP-Gateway Statistics ***********/
  if (flag & IPSTATFLAG) {
     putstr("\rIP-Gateway-Statistics:\r\r", mbp);
     for (i = 1; i <= NUMIPMIB; ) {
       mbp->l4time = mbp->mbpc;
       for (j = 0; j < 3 && i <= NUMIPMIB; j++, i++) {
         putspa(26*j, mbp);
         putstr(Ip_mib[i].name, mbp);
         putchr(':', mbp);
         putspa(26*j+19, mbp);
         putnum(Ip_mib[i].value.integer, mbp);
       }
       putchr('\r', mbp);
     }
     putchr('\r', mbp);
  }
#endif

  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

/************************************************************************/
/* Test-Command                                                         */
/*----------------------------------------------------------------------*/
void ccptst(void)
{
  MBHEAD *mbp;
  WORD   port;

  if (issyso())                               /* Bin ich Sysop? */
  {
    if ( (port = (char) nxtnum(&clicnt, &clipoi)) >= L2PNUM )
    {
      putmsg("\rInvalid Port\r");
      return;
    }

     if (!portenabled(port)) /* Port nicht eingeschaltet */
     {
       putmsg("\rPort disabled\r");
       return;
     }

     l1ctl(L1CTST, port);
     mbp = putals("\rTest - Port ");
     putnum(port, mbp);
     putchr('\r', mbp);
     prompt(mbp);
     seteom(mbp);
  }
  else
    invmsg();
}

/************************************************************************/
/* Version-Command                                                      */
/*----------------------------------------------------------------------*/
void ccpver(void)
{
  MBHEAD *mbp;                          /* message-buffer-pointer       */

  mbp = putals(version);                /* Versionskennung zeigen       */
  putstr("      Copyright by NORD><LINK, free for non-commercial usage.\r", mbp);
  putprintf(mbp, "  This version compiled for %d Ports, %d L2-Links and %d Circuits.\r",L2PNUM,LINKNMBR,NUMCIR);

  if (clicnt != 0 && *clipoi == '+') {
    putstr("Compiled options: "
#ifdef IPROUTE
    "IP-router "
#endif
#ifdef PACSAT
    "PACSAT "
#endif
#ifdef PADDLE
    "Paddle "
#endif
#ifdef FLEXHOST
    "Local-hosting "
#endif
#ifdef PROFILER
    "Profiling "
#endif
    "\r", mbp);
    putstr("Hardware:", mbp);
    l1enum(mbp);
    putchr('\r', mbp);
  }

  prompt(mbp);
  seteom(mbp);
}

/************************************************************************/
/* Links-Command (NEU ! FlexNet)                                        */
/*----------------------------------------------------------------------*/
void ccplnk(void)
{
  MBHEAD *mbp;
  char    call[L2IDLEN];
  char    ident[L2CALEN];
  char    digil[L2VLEN+1];
  UWORD   port;
  char    mode;
  char    typ[] = {"  "};
  char    typs = 0;
  char   *via;
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;
  char   *cp;

  mbp = getmbp();

  if (issyso())
  {
    mode = *clipoi;
    clipoi++;
    clicnt--;
    skipsp(&clicnt, &clipoi);
    typ[0] = toupper(*clipoi);
    clipoi++;
    clicnt--;
    if (*clipoi != ' ')
    {
      typ[1] = *clipoi++;
      clicnt--;
    }

    if ((port = (UWORD) nxtnum(&clicnt, &clipoi)) < L2PNUM)
    {
      skipsp(&clicnt, &clipoi);

      if (strchr((char *)clipoi,':'))
        *strchr((char *)clipoi,':') = ' ';

      if (getide(&clicnt, &clipoi, ident) == TRUE)
      {
        skipsp(&clicnt, &clipoi);
        if ((/*wildch = */getcal(&clicnt, &clipoi, TRUE, call)) > 0)
        {
          getdig(&clicnt, &clipoi, VCpar, digil);
          digil[2*L2IDLEN] = 0;

          for (cp = typtbl; *cp; cp += 2)
            if ((cp[0] == typ[0]) && (cp[1] == typ[1])) /* Typ stimmt */
              typs = ((int)(cp-typtbl))/2;

          if (mode == '+')
            pp = register_neigb(call,digil,ident,port,typs);

          if (mode == '-')
            unregister_neigb(call,digil,port);

        } /* if (getcal(&clicnt ... */
      }  /* if (ident_ok... */
    }  /* if (port = nxtnum(&clicnt, &clipoi) < L2PNUM) */
    /*putstr("Syntax: L +/- TYP PORT ALIAS:CALL[-*] [Digi1 [Digi2]]\r", mbp);*/
  }  /* if (sysop...  */

  putstr("Links of ",mbp);     /* Konfiguration zeigen */
  putalt(alias, mbp);
  putid(myid, mbp);
  putprintf(mbp, " (%d/%d)\r", netp->num_peers, netp->max_peers);

  putstr("Type-Port--Alias:Call------Route--------------\r", mbp);

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used) {
      mbp->l4time = mbp->mbpc;     /* Zaehler merken fuer putspa()      */
      putspa(2, mbp);
      putprintf (mbp, "%2.2s", typtbl + pp->typ*2);
      putspa(6, mbp);
      if (pp->l2link->port < 10) putchr(' ', mbp);
      putnum(pp->l2link->port, mbp);
      putstr("  ", mbp);
      putide(pp->l2link->alias, mbp);
      putchr(':', mbp);
      putid(pp->l2link->call, mbp);
      putspa(27, mbp);
      via = pp->l2link->digil;   /* nicht putdil() wegen "via" */
      if (via[0]) putid(via, mbp);
      putchr(' ', mbp);
      if (via[7]) putid(via+7, mbp);
      putchr('\r', mbp);
    }
  prompt(mbp);
  seteom(mbp);
}

/************************************************************************/
/* Quit-Command                                                         */
/*----------------------------------------------------------------------*/
void ccpquit(void)
{
  MBHEAD *mbp;
  FILE   *fp;
  WORD   c;

  mbp = getmbp();

  if ((fp = xfopen("QUIT.TXT","rt")) != NULL)
  {
    while ((c = fgetc(fp)) != EOF)
      if (c != CR)
        putchr(c == '\n' ? CR : c, mbp);
    fclose(fp);
  }
  else {
    putstr("\r73 de ", mbp);
    putid(myid, mbp);
  }
  putchr('\r', mbp);
  seteom(mbp);
  disusr(userpo->uid);
}


/************************************************************************/
/*                                                                      */
/* ECHO Befehl                                                          */
/*                                                                      */
/* Funktion : Rest der Eingabezeile des Users zurueck schicken.         */
/*            Anwendung z.B. fuer RTT Messung.                          */
/*                                                                      */
/* Syntax   : //E <text>                                                */
/*                                                                      */
/*----------------------------------------------------------------------*/
void ccpecho(void) {
  MBHEAD *mbp;

  mbp = getmbp();
  if(clicnt > 0 && !strnicmp(clilin, "//E", 3)) {
     putchr('\r', mbp);
     while(clicnt > 0) {
    putchr(*clipoi++, mbp);
    clicnt--;
     }
     putchr('\r', mbp);
  }
  prompt(mbp);
  seteom(mbp);
}

/************************************************************************/
/*                                                                      */
/* TALK Befehl                                                          */
/*                                                                      */
/* Funktion : Nachricht an einen anderen User schicken, der im CCP und  */
/*            nicht anderweitig connected ist!                          */
/* Syntax   : TALK <user> <text>                                        */
/* Ausgabe  : Msg from <call>: <text>                                   */
/*----------------------------------------------------------------------*/
void ccptalk(void)
{
  char   tmp[8];
  WORD   suc;
  MBHEAD *mbp;
  char call[L2IDLEN];

  if (skipsp(&clicnt, &clipoi)) {                      /* steht da was? */
    if (!strnicmp((char *)clipoi, "ALL", 3)) {         /* an alle?      */
      nextspace(&clicnt, &clipoi);
      if (skipsp(&clicnt, &clipoi) == FALSE) {         /* kein Text?    */
        putmsg("No Text\r");
        return;
      }
      call[0] = '*';
      suc = talk_to(call, 0);                          /* weiterpetzen  */
     } else
     if (getcal(&clicnt, &clipoi, TRUE, call) == TRUE) { /* ein call ?  */
       if (skipsp(&clicnt, &clipoi)) {                 /* kommtn Text?  */
         suc = talk_to(call, 0);                       /* weiterpetzen  */
       } else {
         suc = talk_to(call, 1);                       /* gibs den?     */
         mbp = getmbp();
         if (suc) {
           cpyid(userpo->talkcall, call);              /* call merken   */
           userpo->status = US_TALK;
           callss2str(tmp, call);
           putprintf(mbp, "You are now talking with %s. Leave this mode with /q\r", tmp);
         } else {
           putstr("No such User!\r", mbp);
           prompt(mbp);                                /* Prompt dran   */
         }
         seteom(mbp);                                  /* fertig        */
         return;
       }
     } else {
       putmsg("Invalid Call\r");
       return;
     }
     putmsg(suc ? "Msg sent\r" : "No User\r");
  } else
    putmsg("No Arguments\r");
}

BOOLEAN talk_to(char *call, WORD test)
{
  char   tmp[8];
  WORD   cnt = 0;
  USRBLK *save_userpo = userpo;
  MBHEAD *mbp;

  callss2str(tmp, calofs(UPLINK, userpo->uid));
  strlwr(tmp);

  for (userpo  = (USRBLK *) usccpl.head;
       userpo != (USRBLK *) &usccpl;
       userpo  = (USRBLK *) userpo->unext)
  {
     if (       userpo->convers == NULLCONNECTION
         && (   userpo->status == US_CCP
             || userpo->status == US_TALK)
         &&     userpo != save_userpo
         && (   cmpcal(calofs(UPLINK, userpo->uid), call)
             || call[0] == '*')
        ) {
       if (test) {
         userpo = save_userpo;
         return (TRUE);
       }
       mbp = getmbp();
       putprintf(mbp, "Msg from %s: %s\r", tmp, clipoi);
       seteom(mbp);
       if (call[0] != '*') {
         userpo = save_userpo;
         return (TRUE);
       }
       cnt++;
     }
  }
  userpo = save_userpo;
  return (cnt ? TRUE : FALSE);
}

/************************************************************************/
/* Mailbox-Befehl                                                       */
/************************************************************************/
void ccpmail(void)
{
  if (issyso() && skipsp(&clicnt, &clipoi)) {
    ccp_call(boxid);               /* Rufzeichen setzen                 */
  } else {                          /* Connect zur Mailbox               */
    if (boxid[0]) {
      call2str((char *)(clipoi = clilin), boxid);
      clicnt = strlen((char *)clipoi);
      ccpcon(0);
    } else
      putmsg("No mailbox!\r");
  }
}

/************************************************************************/
/* DXCluster-Command                                                    */
/*----------------------------------------------------------------------*/
void ccpdxc(void)
{
  if (issyso() && skipsp(&clicnt, &clipoi)) {
    ccp_call(dxcid);                /* Rufzeichen setzen                 */
  } else {                          /* Connect zur Mailbox               */
    if (dxcid[0]) {
      call2str((char *)(clipoi = clilin), dxcid);
      clicnt = strlen((char *)clipoi);
      ccpcon(0);
    } else
      putmsg("No DX-cluster!\r");
  }
}

/************************************************************************/
/* Paddle-Command                                                       */
/*----------------------------------------------------------------------*/
#ifdef PADDLE           /* spezielle Hardware fr AtariST */
char *padread(WORD i);
extern WORD paddles[8];
void ccppaddle(void)
{
  int i;
  MBHEAD *mbp;

  mbp = putals("Analog inputs:\r");

  for(i=0; i<6; i++)
    putstr(padread(i),mbp);

  putchr(CR, mbp);
  prompt(mbp);
  seteom(mbp);
}
#endif

/* End of L7CCP.C */
