#!/usr/bin/perl
#
$StoreDir = '/usr/lbbs/contrib/7plus-rx/7plus';

while(<STDIN>) {
   chop;
   if(/^T(.*)/) {
      $To = $1;
   } elsif(/^A(.*)/) {
      $At = $1;
   } elsif(/^F(.*)/) {
      $From = $1;
   } elsif(/^I(.*)/) {
      $Id = $1;
   } elsif(/^\s*$/) {
      last;
   }
}

# Ok header extracted.
$Subject = <STDIN>;

@Body = <STDIN>;

while(scalar(@Body)) {

   while($line = shift(@Body)) {
      if($line =~ /^\s*go_7\+\.\s+(\d+)\s+\S+\s+(\d+)\s+(\S+)\s+/) {
         $Hdr_Part = $1;
         $Hdr_Parts = $2;
         $Hdr_File = $3;
# Found a go_7+. line :-).
         last;
      }
   }
   if(scalar(@Body) == 0) {
print "End\n";
      last;
   }
print "$Hdr_Part $Hdr_Parts $Hdr_File\n";

   $Filename = &MakeFilename();
   open(FILE, ">$Filename");
print "$Filename\n";
   print FILE "$To @ $At < $From \$$Id\n\n";

   print FILE $line;

   while($line = shift(@Body)) {
      print FILE $line;

      if($line =~ /^\s*stop_7\+\.\s+/) {
# Found a stop_7+. line :-).
         last;
      }
   }

   close(FILE);

}


exit 0;

# We want to test is exists, and modify the file slightly if it does
#  already.
sub MakeFilename {
   local($Filename);

   $Filename = $StoreDir . "/" . $Hdr_File . "." . $Hdr_Part . "of" . $Hdr_Parts;

   $Filename;
}
