#!/usr/bin/perl
#
#	Another filter to attempt to pluck out any IARU information what
#	might be contained with R: lines.
#
#
$SaveFile = '/usr/lbbs/contrib/icao/LIST';

while(<>) {
   # This regexp should do to match an R: line with enough info.
   if(/^R\:\d{6}\/\d{4}[zZ]{0,1}\s+\d*\@[\:]{0,1}(\S+)\s+(.*)$/) {
      # See if IARU is part of HA address.
      $system = $1;
      $rest = $2;
      
      # Won't be the least or most significant part of the address, so
      #  therefore bounded by dots '.', must be two numbers, two digits,
      #  two numbers.  That's good enough for me.
      if($system =~ /\.([A-Za-z]{2}\d{2}[A-Za-z]{2})\./) {
         $iaru = $1;
         &Add();
         next;
      }

      # I'll see how this algo goes, bounded by anything which is NON
      #  alphanumric, again must be two numbers, two digits, two numbers.
      # Will check IARU output to see how well this algo does.
      if($rest =~ /\W([A-Za-z]{2}\d{2}[A-Za-z]{2})\W/) {
         $iaru = $1;
         &Add();
         next;
      }
   }
}

exit 0;

sub Add
{
   # Lets see if it doesn't already exist in there.
   if(open(FILE, "$SaveFile")) {
      while(<FILE>) {
         chop;

         if(/$system\t$iaru/) {
            close(FILE);
            0;
            return;
         }
      }
      
      close(FILE);
   }

   if(!open(FILE, ">>$SaveFile")) {
      # Shitty open() schematics, I want open($pathname, O_RDWR|O_CREAT, umask) no O_TRUNC!
      if(!open(FILE, "+>$SaveFile")) {
         return;
      }
   }

   print FILE "$system\t$iaru\n";

   close(FILE);

   0;
}
