#!/usr/bin/perl
#
#
#	This is based on my shell script version from 18/04/1995.
#
#	This currently uses the 3rd field in the MGateway file, when it
#	 should really be using the 2nd.
#
#	Version 1.4	25/09/1995
#
#
$TmpBody = "/usr/lbbs/tmp/rline" . $$;
$Prefix = "/usr/lbbs/spool/incoming/";
$CheckBBS = "/usr/lbbs/contrib/mail_from_sendmail/DB";
$CheckHA = "/usr/lbbs/contrib/mail_from_sendmail/HA";
$Log = "/usr/lbbs/tmp/mail.log";

if($#ARGV < 1) {
   print "$0: <host> <bbs>!<user>\n";
   exit 1;
}

$ARGV[1] =~ /(.*)!(.*)/;
$At = $1;
$At =~ tr/a-z/A-Z/;
$To = $2;
$To =~ tr/a-z/A-Z/;


#print "$To @ $At\n";
#print "$TmpBody\n";


if(!open(OUT, "+>$TmpBody")) {
   print "ERROR: Can not create tmp file for body of message\n";
   exit 1;
}

$_ = <STDIN>;
/^\s*\S+\s+(.+)!(\S+)\s/;
$From_Host = $1;
$From_Host =~ tr/a-z/A-Z/;
$From_User = $2;
$From_User =~ tr/a-z/A-Z/;


#print "$From_User @ $From_Host\n";


while(<STDIN>) {
   chop;
   if(/^Message-ID:\s+(.*)/i) {
      $Message_ID = $_;
   } elsif(/^From:\s+(.*)/i) {
      $From = $_;
   } elsif(/^Date:\s+(.*)/i) {
      $Date = $_;
   } elsif(/^References:\s+(.*)/i) {
      $References = $_;
   } elsif(/^Subject:\s+(.*)/i) {
      $Subject = $1;
   } elsif(/^\s*$/) {
      last;
   }
}

@Body = <STDIN>;



open(CHECK, $CheckBBS);

while(<CHECK>) {
   chop;
   if(/^\s*#/) {
      next;
   } elsif(/^\s*${From_User}\s+(\S+)/i) {
      $Real_Rline = $1;
      $Real_Rline =~ tr/a-z/A-Z/;
      last;
   }
}

close(CHECK);



open(CHECK, $CheckHA);

while(<CHECK>) {
   chop;
   if(/^\s*#/) {
      next;
   } elsif(/^\s*${At}\s*(\S+)/i) {
      $At = $1;
      $At =~ tr/a-z/A-Z/;
 #     print "New HA is: $At\n";
      last;
   }
}

close(CHECK);



print OUT "CP\n";
print OUT "T$To\n";
print OUT "F$From_User\n";
print OUT "A$At\n";
print OUT "\n";
print OUT "$Subject\n";

$year = (gmtime(time))[5];
$month = (gmtime(time))[4] + 1;
$day = (gmtime(time))[3];
$hour = (gmtime(time))[2];
$min = (gmtime(time))[1];
$SpoolTo = sprintf("$Prefix%05d%02d%02d%02d", $$, $hour, $min, $sec);

if(defined($Real_Rline)) {
   $line = sprintf("%02d%02d%02d/%02d%02d", $year, $month, $day, $hour, $min);
   print OUT "R:$line @:$Real_Rline LBBS\n";
}
if(defined($Message_ID)) {
   print OUT "T:$Message_ID\n";
}
if(defined($From)) {
   print OUT "T:$From\n";
}
if(defined($References)) {
   print OUT "T:$References\n";
}
if(defined($Date)) {
   print OUT "T:$Date\n";
}

foreach $line (@Body) {
   print OUT $line;
}

close(OUT);


if(rename($TmpBody, $SpoolTo)) {
   &Log("$To @ $At < $From_User");
   exit 0;
} else {
   &Log("$To @ $At < $From_User *** Error");
   print "ERROR: Unable to rename message";
   exit 1;
}

exit 0;



sub Log {
   local($Msg) = $_[0];
   
   if(open(LOG, ">>$Log")) {
      print LOG "$Msg\n";
      close(LOG);
   }
}
