#!/bin/sh
#
#  Use me (now and again) to update the working HA file.
#
#  Usage: rline.build.sh G7LED G7LED.GB7MIP.#29.GBR.EU >HA
#

if [ $# -lt 2 ]
then
   echo "Usage: $0 <MyCall> <MyHa>"
   echo "       e.g. '$0 G7LED G7LED.GB7MIP.#29.GBR.EU'";
   exit 1
fi

MyCall="$1"
MyHa="$2"

###################

TMP=/tmp/lbbs.buildHA.$$

echo "Extracting entries from WP base" 1>&2
/usr/lbbs/contrib/mail_from_sendmail/rline.buildHA.pl | sort > $TMP
echo "Done..." 1>&2

(
   echo "#"
   echo "# This file has been auto-magically generated by rline.build.sh"
   echo "#"
   echo "# Don't forget this is a fallback resource DB, an MGateway file"
   echo "#  entry should take precedence"
   echo "#"
   echo "# LBBS dumped WP database entries"
   echo "#"
   echo "$MyCall		$MyHa"
   echo "#"
# Put the G's at the top, improves linear search for most traffic.
# As I live in G-land :-)
   grep -i "^G" $TMP
   grep -iv "^G" $TMP
)

rm -f $TMP
