/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_inou.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_INOU_G
#include "box_inou.h"

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef SHELL_H
#include "shell.h"
#endif


/* ========================================================================= */
/* Der eher dem Output zuzuordnende Teil der Box:                            */
/* ========================================================================= */

Static void x_Vwuser(short unr, Char *s, boolean crlf, boolean in_trace);

Static void x_show_puffer(short unr, uchar *base, long size, boolean in_trace,
			  boolean transparent);


/* ************************** Die Trace-Rueckkoppelung ************************ */

Static void fill_traceheader(boolean userinp, short unr, Char *hs, boolean cr)
{
  Char w[256];

  sprintf(hs, "%ld", unr);
  lspacing(hs, 2);
  sprintf(w, "%ld", user[unr]->action);
  lspacing(w, 3);
  utc_clock();
  sprintf(hs + strlen(hs), "%s %s %s", w, clock_.zeit, user[unr]->call);
  if (userinp)
    strcat(hs, ">");
  else
    strcat(hs, "<");
  rspacing(hs, 23);
}


void trace_string(boolean userinp, short unr, short trace, Char *s1,
		  boolean cr)
{
  Char hs[256], s2[256], s[256];

  box_ttouch(trace);
  strcpy(s, s1);   /* local copy wegen crlf-Wandlung in Linux */

  if (user[trace]->fulltrace) {
    if (cr)
      x_Vwuser(trace, s, true, true);
    else
      x_Vwuser(trace, s, false, true);
    return;
  }

  if (!cr) {
    if (strlen(user[unr]->tracefract) + strlen(s) <= 255)
      strcat(user[unr]->tracefract, s);
    return;
  }

  if (userinp && *user[unr]->tracefract != '\0') {
    *hs = '\0';
    trace_string(false, unr, trace, hs, true);
	/* loest tracefract-aussendung aus */
  }

  fill_traceheader(userinp, unr, hs, cr);
  x_Vwuser(trace, hs, false, true);

  if (*user[unr]->tracefract == '\0' && strlen(s) <= 56) {
    x_Vwuser(trace, s, true, true);
    return;
  }

  if (strlen(user[unr]->tracefract) + strlen(s) <= 255)
    sprintf(s2, "%s%s", user[unr]->tracefract, s);
  else
    strcpy(s2, s);
  *user[unr]->tracefract = '\0';

  while (*s2 != '\0') {
    sprintf(hs, "%.56s", s2);
    strdelete((void *)s2, 1, 56);
    x_Vwuser(trace, hs, true, true);
    if (*s2 == '\0')
      break;
    *hs = '\0';
    rspacing(hs, 23);
    x_Vwuser(trace, hs, false, true);
  }

}


Static void trace_buf(boolean userinp, short unr, short trace, uchar *p1,
		      long s1)
{
  Char hs[256], w[256];
  uchar *p;
  long s;

  if (s1 <= 0 || p1 == NULL)
    return;

  box_ttouch(trace);

  *hs = '\0';
  if (*user[unr]->tracefract != '\0')
    trace_string(false, unr, trace, hs, true);

  if (!user[trace]->fulltrace) {
    fill_traceheader(userinp, unr, hs, false);
    sprintf(w, "%ld", s1);
    sprintf(hs + strlen(hs), "<%s>", w);
    x_Vwuser(trace, hs, true, true);
    return;
  }

  s = s1;
  p = Malloc(s);   /* local copy fuer Linux */
  if (p == NULL)
    return;
  memcpy(p, p1, s);
  x_show_puffer(trace, p, s, true, false);
  mymfreep(&p);
}


/* ************************** Die Ausgaberoutinen **************************** */


/* Loescht den Spooler    */

void abort_useroutput(short unr)
{
  userstruct *WITH;

  debug0(2, unr, 104);
  if (boxrange(unr)) {
    WITH = user[unr];
    boxspoolabort(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print));
  }
}


/* gibt einen Speicherbereich auf den Spooler aus. Sucht nach dem #BIN#- */
/* Start, um den Wechsel von Strip-LF zu LF-Sendung mitzubekommen        */

Static void x_show_puffer(short unr, uchar *base, long size, boolean in_trace,
			  boolean transparent)
{
  long err;
  short k;
  Char hs[256];
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  upd_statistik(unr, 0, size, 0, 0);

  WITH = user[unr];
  if (!in_trace && WITH->trace_to > 0 && WITH->trace_to != unr)
    trace_buf(false, unr, WITH->trace_to, base, size);

  if (WITH->tell >= minhandle) {
    sfwrite(WITH->tell, size, base);
    return;
  }
  if (WITH->action == 76) {
    k = Str2int(WITH->input2);
    sfwrite(k, size, base);
    return;
  }

  if (transparent) {
    boxmemspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), false,
		base, size);

    return;
  }

  err = get_binstart(base, size, hs);

  if (err <= 0) {
    boxmemspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), true, base,
		size);
    return;
  }

  boxmemspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), true, base,
	      err);
  boxspoolfend(WITH->pchan);
  boxmemspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), false,
	      (uchar *) (&base[err]), size - err);

}


void show_puffer(short unr, uchar *base, long size)
{
  x_show_puffer(unr, base, size, false, false);
}


void trans_show_puffer(short unr, uchar *base, long size)
{
  x_show_puffer(unr, base, size, false, true);
}


/* Zeilenweise Ausgabe ueber den Spooler  */

Static void x_Vwuser(short unr, Char *s, boolean crlf, boolean in_trace)
{
  short k;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  upd_statistik(unr, 0, strlen(s), 0, 0);

  WITH = user[unr];
  if (!in_trace && WITH->trace_to > 0 && WITH->trace_to != unr)
    trace_string(false, unr, WITH->trace_to, s, crlf);

  if (WITH->tell >= minhandle) {
    string_to_file(&WITH->tell, s, crlf);
    return;
  }

  if (WITH->action == 76) {  /* export... */
    k = Str2int(WITH->input2);
    string_to_file(&k, s, crlf);
  } else
    boxspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), s, crlf);

}


void wuser(short unr, Char *s)
{
  x_Vwuser(unr, s, false, false);
}


void chwuser(short unr, uchar c)
{
  short k;
  Char s[256];
  userstruct *WITH;

  if (!boxrange(unr))
    return;

  upd_statistik(unr, 0, 1, 0, 0);   /* ein Byte mehr */

  WITH = user[unr];
  if (WITH->trace_to > 0 && WITH->trace_to != unr) {
    sprintf(s, "%c", c);
    trace_string(false, unr, WITH->trace_to, s, false);
  }

  if (WITH->tell >= minhandle) {
    sfwrite(WITH->tell, 1, &c);
    return;
  }

  if (WITH->action == 76) {  /* export... */
    k = Str2int(WITH->input2);
    sfwrite(k, 1, &c);
  } else
    boxmemspool(WITH->tcon, WITH->pchan, boxprn2bios(WITH->print), false, &c,
		1);
}


void wlnuser(short unr, Char *s)
{
  x_Vwuser(unr, s, true, false);
}


void wlnuser0(short unr)
{
  wlnuser(unr, "");
}


/* ========================================================================= */
/* Der eher dem Input zuzuordnende Teil der Box:                             */
/* ========================================================================= */


/* Die Abbruchroutine fuer die Box. Wird benutzt bei Disconnect oder  */
/* auch geschlossenem Terminal, aufgerufen vom PR-Terminal            */

void abort_box(short unr, boolean save)
{
  userstruct *WITH;

  debug0(2, unr, 105);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  abort_useroutput(unr);
  sfclosedel(&WITH->sendchan);
  WITH->input2[0] = '\0';
  melde_user_ab(unr, save);
}


void box_timing(long tct)
{
  box_timing2(tct);
}


void sort_new_mail(short unr, Char *pattern, Char *rcall)
{
  sort_new_mail2(unr, pattern, rcall);
}


void box_rawinput(short unr, unsigned short infosize,
		  unsigned short *infstart, uchar *info)
{
  uchar *p;
  long hsize;
  userstruct *WITH;

  if (infosize > 256 || infosize < *infstart || *infstart <= 0) {
    debug(0, unr, 83, "infosize/infstart invalid");
    *infstart = SHORT_MAX;
    return;
  }

  if (!boxrange(unr))
    return;
  if ((unsigned)user[unr]->action < 32 &&
      ((1L << user[unr]->action) & 0xc000L) != 0) {
    *infstart = SHORT_MAX;
    return;
  }

  WITH = user[unr];

  if (WITH->trace_to > 0 && WITH->trace_to != unr) {
    p = info;
    trace_buf(true, unr, WITH->trace_to, (uchar *)(&p[*infstart - 1]),
	      infosize - *infstart + 1);
  }
  p = &info[*infstart - 1];
  hsize = infosize - *infstart + 1;

  upd_statistik(unr, hsize, 0, 0, 0);
  box_ttouch(unr);

  switch (user[unr]->action) {

  case 96:   /* YAPP - Upload */
    yapp_responses(unr, p, hsize);
    break;

  case 97:
  case 98:
    yapp_input(unr, p, hsize);
    break;

  case 99:
    if (write_pty(unr, hsize, p) == 0) {  /* SHELL und externe Kommandos */
      boxsetrwmode(user[unr]->pchan, 0);
      user[unr]->action = 0;
    }
    break;
  }

  *infstart = infosize + 1;

}


void fbbpack(short unr, unsigned short infosize, unsigned short *infstart,
	     uchar *info)
{
  uchar *p;
  userstruct *WITH;

  if (infosize > 256 || infosize < *infstart || *infstart <= 0) {
    debug(0, unr, 83, "infosize/infstart invalid");
    *infstart = SHORT_MAX;
    return;
  }

  if (!boxrange(unr))
    return;
  if ((unsigned)user[unr]->action < 32 &&
      ((1L << user[unr]->action) & 0xc000L) != 0) {
    *infstart = SHORT_MAX;
    return;
  }

  WITH = user[unr];

  if (WITH->trace_to > 0 && WITH->trace_to != unr) {
    p = info;
    trace_buf(true, unr, WITH->trace_to, (uchar *)(&p[*infstart - 1]),
	      infosize - *infstart + 1);
  }
  /* schuetzt sich selber gegen unsinnige Eingaben */
  fbbpack2(unr, infosize, infstart, info);
}



void fbb2pack(short unr, unsigned short infosize, unsigned short *infstart,
	      uchar *info)
{
  uchar *p;
  userstruct *WITH;

  if (infosize > 256 || infosize < *infstart || *infstart <= 0) {
    debug(0, unr, 84, "infosize/infstart invalid");
    *infstart = SHORT_MAX;
    return;
  }

  if (boxrange(unr)) {
    if ((unsigned)user[unr]->action < 32 &&
	((1L << user[unr]->action) & 0xc000L) != 0) {
      *infstart = SHORT_MAX;
      return;
    }

    WITH = user[unr];
    if (WITH->trace_to > 0 && WITH->trace_to != unr) {
      p = info;
      trace_buf(true, unr, WITH->trace_to, (uchar *)(&p[*infstart - 1]),
		infosize - *infstart + 1);
    }
  }

  /* schuetzt sich selber gegen unsinnige Eingaben, trotzdem obige Sicherheitsabfragen */

  fbb2pack2(unr, infosize, infstart, info);
}


/* ------------------------ UNPROTO LIST REQUEST -------------------- */


void raw_unproto_request(short pid, short callcount, short heardfrom,
			 Char *port, Char (*calls)[10], long len, uchar *buf)
{
  short x;
  Char path[256];
  Char s[260];

  if (len < 1)
    return;
  if (len > 256)
    return;
  if (callcount < 2)
    return;
  if (callcount > 2) {
    if (heardfrom < callcount)
      return;
  }
  if (pid != 0xf0)
    return;
  if (boxboxssid() == 0) {
    if (strcmp(calls[1], Console_call))
      return;
  } else {
    sprintf(path, "%s-%ld", Console_call, boxboxssid());
    if (strcmp(calls[1], path))
      return;
  }

  strcpy(path, calls[2]);
  for (x = 3; x < callcount; x++)
    sprintf(path + strlen(path), " %s", calls[x]);

  for (x = 0; x < len; x++)
    s[x] = (Char)buf[x];
  s[len] = '\0';

  unproto_request1(calls[0], port, path, s);
}


/* ------------------------------------------------------------------ */


void box_get_next_input(void)
{
  boxintype *hpbi;
  short unr, olda;
  boolean was_server;
  userstruct *WITH;
  Char STR1[256];

  unr = 1;

  do {

    if (user[unr] != NULL && user[unr]->inputroot != NULL &&
	user[unr]->wait_pid <= 0 &&
	(user[unr]->f_bbs ||
	 boxspoolstatus(user[unr]->tcon, user[unr]->pchan, -1) <= maxuserspool)) {
      WITH = user[unr];
      WITH->cputime = statclock();

_L1:
      if ((unsigned)WITH->action < 32 && ((1L << WITH->action) & 0xc000L) != 0) {
	sfclosedel(&WITH->prochandle);
	WITH->lastprocnumber = 0;
	WITH->lastprocnumber2 = 0;
	while (WITH->inputroot != NULL) {
	  hpbi = WITH->inputroot;
	  WITH->inputroot = WITH->inputroot->next;
	  Free(hpbi);
	}
      }

      if (WITH->inputroot != NULL) {
	olda = 0;
	was_server = false;
	if (WITH->smode || WITH->action == 90 || WITH->action == 80)
	{  /* server / talk / converse */
	  if (WITH->inputroot->line[0] == '!') {
	    olda = WITH->action;
	    WITH->action = 0;
	    was_server = WITH->smode;
	    WITH->smode = false;
	    strdelete((void *)WITH->inputroot->line, 1, 1);
	    if (WITH->lastprocnumber == 0) {
	      if (was_server)
		wlnuser(unr, "[server off]");
	      else if (olda == 80)
		wlnuser(unr, "[talk off]");
	      else
		wlnuser(unr, "[converse off]");
	    }
	  }
	}

	box_ttouch(unr);
	WITH->in_begruessung = WITH->inputroot->in_begruessung;
	box_command_fract(unr, WITH->inputroot->line,
			  WITH->inputroot->return_);
	if (user[unr] != NULL) {
	  if (*WITH->inputroot->line == '\0') {
	    if (WITH->inputroot->in_begruessung) {
	      WITH->in_begruessung = false;
	      wlnuser0(unr);
	    }
	    sfclosedel(&WITH->prochandle);
	    WITH->lastprocnumber = 0;
	    WITH->lastprocnumber2 = 0;
	    hpbi = WITH->inputroot;
	    WITH->inputroot = WITH->inputroot->next;
	    Free(hpbi);

	    if (was_server || olda > 0) {
	      if (WITH->action != 0) {
		if (was_server)
		  was_server = false;
		else if (olda == 80)
		  end_talk_mode(WITH->talk_to, true);
		else if (olda == 90) {
		  send_conv(unr, "*** logging out");
		  WITH->convchan = -1;
		}
		olda = WITH->action;
	      } else {
		wlnuser0(unr);
		wlnuser0(unr);
		if (was_server)
		  wlnuser(unr, "[server on]");
		else if (olda == 80)
		  wlnuser(unr, "[talk on]");
		else
		  wlnuser(unr, "[converse on]");
	      }
	      WITH->action = olda;
	      WITH->smode = was_server;
	    }

	  } else if (was_server || olda > 0) {
	    sprintf(STR1, "!%s", WITH->inputroot->line);
	    strcpy(WITH->inputroot->line, STR1);
	    WITH->action = olda;
	    WITH->smode = was_server;
	  }


	  if (WITH->inputroot != NULL && statclock() - WITH->cputime < ttask) {
	    if (WITH->f_bbs ||
		boxspoolstatus(WITH->tcon, WITH->pchan, -1) <= maxuserspool) {
	      if (WITH->wait_pid <= 0)
		goto _L1;
	    }
	  }
	}
      }


      if (user[unr] != NULL && WITH->inputroot == NULL &&
	  WITH->tell >= minhandle)
	stop_tell(unr);
      if (user[unr] != NULL)
	upd_statistik(unr, 0, 0, WITH->cputime, statclock());

    }

    unr++;

  } while (unr <= maxuser);
}



Static void clear_immediately_input(short unr)
{
  boxintype *hpbi;
  short olda;

  boolean was_server;
  userstruct *WITH;
  Char STR1[256];

  if (!boxrange(unr))
    return;

  WITH = user[unr];

  WITH->cputime = statclock();

  if ((unsigned)WITH->action < 32 && ((1L << WITH->action) & 0xc000L) != 0) {
    WITH->lastprocnumber = 0;
    WITH->lastprocnumber2 = 0;
    sfclosedel(&WITH->prochandle);
    while (WITH->inputroot != NULL) {
      hpbi = WITH->inputroot;
      WITH->inputroot = WITH->inputroot->next;
      Free(hpbi);
    }
  }

  while (WITH->inputroot != NULL && WITH->wait_pid <= 0) {
    olda = 0;
    was_server = false;
    if (WITH->smode || WITH->action == 90 || WITH->action == 80)
    {  /* server / talk / converse */
      if (WITH->inputroot->line[0] == '!') {
	olda = WITH->action;
	WITH->action = 0;
	was_server = WITH->smode;
	WITH->smode = false;
	strdelete((void *)WITH->inputroot->line, 1, 1);
	if (WITH->lastprocnumber == 0) {
	  if (was_server)
	    wlnuser(unr, "[server off]");
	  else if (olda == 80)
	    wlnuser(unr, "[talk off]");
	  else
	    wlnuser(unr, "[converse off]");
	}
      }
    }

    box_ttouch(unr);
    WITH->in_begruessung = WITH->inputroot->in_begruessung;
    box_command_fract(unr, WITH->inputroot->line, WITH->inputroot->return_);
    if (user[unr] == NULL)
      continue;

    if (*WITH->inputroot->line != '\0') {
      if (WITH->smode || olda > 0) {
	sprintf(STR1, "!%s", WITH->inputroot->line);
	strcpy(WITH->inputroot->line, STR1);
	WITH->action = olda;
	WITH->smode = was_server;
      }
      continue;
    }


    if (WITH->inputroot->in_begruessung) {
      WITH->in_begruessung = false;
      wlnuser0(unr);
    }
    sfclosedel(&WITH->prochandle);
    WITH->lastprocnumber = 0;
    WITH->lastprocnumber2 = 0;
    hpbi = WITH->inputroot;
    WITH->inputroot = WITH->inputroot->next;
    Free(hpbi);

    if (!(was_server || olda > 0))
      continue;

    if (WITH->action != 0) {
      if (was_server)
	was_server = false;
      else if (olda == 80)
	end_talk_mode(WITH->talk_to, true);
      else if (olda == 90) {
	send_conv(unr, "*** logging out");
	WITH->convchan = -1;
      }
      olda = WITH->action;
    } else {
      wlnuser0(unr);
      wlnuser0(unr);
      if (was_server)
	wlnuser(unr, "[server on]");
      else if (olda == 80)
	wlnuser(unr, "[talk on]");
      else
	wlnuser(unr, "[converse on]");
    }
    WITH->action = olda;
    WITH->smode = was_server;
  }


  if (user[unr] != NULL && WITH->inputroot == NULL && WITH->tell >= minhandle)
    stop_tell(unr);
  if (user[unr] != NULL)
    upd_statistik(unr, 0, 0, WITH->cputime, statclock());

}



/* Die Haupteingabe der Box. Zusaetzlich gibt es noch fbbpack und fbb2pack   */

void box_input(short unr, boolean block, boolean inbegruessung, Char *cmd,
	       boolean return_)
{
  Char p[256];
  long l;
  boxintype *hpbi, *hpb2;
  userstruct *WITH;

  if (!boxrange(unr))
    return;


  WITH = user[unr];
  if ((unsigned)WITH->action < 32 && ((1L << WITH->action) & 0xc000L) != 0)
	/* user hatte QUIT eingegeben, dann soll er auch nicht senden */
	  return;

  l = strlen(cmd);
  if (l > 255) {
    debug(0, unr, 154, "len(cmd) > 255 -> abort");
    WITH->action = 15;
    return;
  }

  if (WITH->trace_to > 0 && WITH->trace_to != unr)
    trace_string(true, unr, WITH->trace_to, cmd, return_);

  if (WITH->action == 99) {
    strcpy(p, cmd);
    if (return_ && l < 255) {
      strcat(p, "\015");
      l++;
    }
    if (write_pty(unr, l, p) != 0) {  /* SHELL und externe Kommandos */
      upd_statistik(unr, l, 0, 0, 0);
      return;
    }
    boxsetrwmode(WITH->pchan, 0);
    WITH->action = 0;
  }

  if (*cmd == '\0' && return_ && WITH->action == 0 && WITH->errors >= 0 &&
      (WITH->lastprocnumber > 0 ||
       boxspoolstatus(WITH->tcon, WITH->pchan, -1) > 750)) {
    sfclosedel(&WITH->prochandle);
    WITH->lastprocnumber = 0;
    WITH->lastprocnumber2 = 0;
    while (WITH->inputroot != NULL) {
      hpbi = WITH->inputroot;
      WITH->inputroot = WITH->inputroot->next;
      Free(hpbi);
    }
    abort_useroutput(unr);
  }

  hpb2 = Malloc(sizeof(boxintype));
  if (hpb2 == NULL) {
    debug(0, unr, 154, "no mem for input stack -> abort");
    WITH->action = 15;
    return;
  }

  strcpy(hpb2->line, cmd);
  hpb2->return_ = return_;
  hpb2->block = block;
  hpb2->in_begruessung = inbegruessung;
  hpb2->next = NULL;

  if (WITH->inputroot != NULL) {
    hpbi = WITH->inputroot;
    while (hpbi->next != NULL)
      hpbi = hpbi->next;
    hpbi->next = hpb2;
  } else
    WITH->inputroot = hpb2;

  if (return_)
    l++;
  upd_statistik(unr, l, 0, 0, 0);

  if (l <= 5)
    return;

  if (cmd[0] == '#') {
    if (strpos2(cmd, "#BIN#", 1) == 1)
      clear_immediately_input(unr);
  }
}



/* MODE 0   = User
        1   = outgoing forward
        2   = Tell - Abarbeitung
        3   = system login
        4   = modem out
        5   = modem in

UM_USER     =   0;
UM_SF_OUT   =   1;
UM_TELLREQ  =   2;
UM_SYSREQ   =   3;
UM_MODEM_OUT=   4;
UM_MODEM_IN =   5;
*/

short melde_user_an(Char *calls1, short cons, short chan, short mode,
		    boolean reconnect)
{
  short Result;
  short x, y, z, newchan;
  boolean double_;
  short dct;
  long count;
  Char calls[256];
  Char hs[256], path[256];
  Char lan[256];
  userstruct *WITH;
  Char STR1[256];
  Char STR13[30];

  debug(1, 0, 106, calls1);

  Result = 0;
  newchan = 0;
  if (cons < 0)
    cons = 0;
  if (chan < 0)
    chan = 0;
  if (cons == 0 && chan == 0 && mode != UM_SYSREQ && mode != UM_TELLREQ)
    return Result;

  count = statclock();
  strcpy(hs, calls1);
  get_word(hs, path);
  upper(path);
  del_callextender(path, calls);
  strcpy(path, calls1);
  cut(path, 80);
  del_blanks(path);

  if (mode == UM_SF_OUT)   /* nu isser da, der connect */
    abort_routing(calls);
  if (maxavail__() < 20000)
    boxfreemostram(true);
  if (memavail__() >= 20000 && callsign(calls)) {
    x = 1;
    while (x <= maxuser && user[x] != NULL)
      x++;
    if (x <= maxuser) {
      user[x] = Malloc(sizeof(userstruct));
      if (user[x] != NULL) {
	user[x]->call[0] = '\0';
	load_userfile(false, true, calls, user[x]);

	dct = 1;

	if (user[x]->sf_level == 0) {
	  if (in_sfp(user[x]->call))
	    user[x]->sf_level = 1;
	}

	if (user[x]->sf_level < 1 && user[x]->pwmode < 10 && cons < 1 &&
	    mode != UM_TELLREQ && mode != UM_SYSREQ &&
	    mode != UM_SF_OUT && !in_sfp(calls)) {
	  for (y = 1; y <= maxuser; y++) {
	    if (user[y] != NULL) {
	      if (y != x) {
		if (!strcmp(user[y]->call, calls)) {
		  if (!user[y]->supervisor)
		    dct++;
		}
	      }
	    }
	  }
	}

	double_ = (dct > maxuserconnects);

	if ((!double_ && !(gesperrt && user[x]->pwmode < 10)) 
	    || (in_sfp(calls) && sf_allowed) || (chan == 0)) {
	  WITH = user[x];
	  utc_clock();
	  if (cons > 1 && WITH->level < 1)
	    WITH->level = 1;
	  if (WITH->level > 0 &&
	      (mode != UM_MODEM_IN || strlen(WITH->password) >= 4)) {
	    WITH->magic1 = magicconst;
	    WITH->magic2 = magicconst;
	    WITH->magic3 = magicconst;

	    if (mode != UM_SYSREQ && mode != UM_TELLREQ) {
	      WITH->is_authentic = false;
	      z = actual_connects();
	      if (z > hiscore_connects) {
		hiscore_connects = z;
		flush_bidseek();

		sprintf(hs, "%ld", hiscore_connects);
		sprintf(STR1, "new connect hiscore: %s", hs);
		append_profile(-1, STR1);
	      }
	    } else
	      WITH->is_authentic = true;

	    newchan = x;
	    WITH->umode = mode;
	    WITH->logindate = clock_.ixtime;
	    WITH->lastatime = clock_.ixtime;
	    WITH->lastcmdtime = clock_.ixtime;
	    WITH->supervisor = false;
	    WITH->rsysop = false;
	    WITH->hidden = false;
	    WITH->f_bbs = false;
	    WITH->console = (cons > 0);
	    WITH->sf_to = false;
	    WITH->undef = false;
	    WITH->inputroot = NULL;
	    WITH->lastprocnumber = 0;
	    WITH->lastprocnumber2 = 0;
	    WITH->prochandle = nohandle;
	    WITH->procbuf = NULL;
	    WITH->sendheader = NULL;
	    WITH->yapp = NULL;
	    WITH->bin = NULL;
	    WITH->lt_required = false;
	    WITH->pty = nohandle;
	    WITH->ptynum = -1;
	    WITH->ptyid[0] = '\0';
	    WITH->ptytouch = 0;
	    WITH->ptylfcrconv = true;
	    WITH->ptybuflen = 0;
	    WITH->wait_pid = -1;
	    WITH->wait_file[0] = '\0';
	    WITH->procbufsize = 0;
	    WITH->procbufseek = 0;
	    WITH->cputime = 0;
	    WITH->in_begruessung = false;
	    WITH->newmsg = false;

	    if (mode == UM_SF_OUT) {
	      WITH->f_bbs = true;
	      WITH->sf_to = true;
	    } else if (mode == UM_MODEM_OUT) {
	      WITH->f_bbs = true;
	      WITH->sf_to = true;
	    }

	    WITH->pchan = chan;
	    WITH->tcon = cons;
	    WITH->print = false;
	    if (!box_pw)
	      WITH->se_ok = (WITH->pwmode != PWM_MUST_PRIV &&
			     WITH->pwmode != PWM_SYSOPPRIV &&
			     WITH->pwmode != PWM_RSYSOPPRIV);
	    else
	      WITH->se_ok = false;
	    if (!WITH->se_ok)
	      WITH->level = 1;

	    if (mode == UM_SYSREQ) {
	      WITH->supervisor = true;
	      WITH->se_ok = true;
	      WITH->level = 127;
	    }


	    strcpy(WITH->brett, calls);
	    WITH->reply_brett[0] = '\0';
	    WITH->reply_nr = 0;
	    WITH->in_reply = false;
	    WITH->lastroption[0] = '\0';
	    WITH->input[0] = '\0';
	    WITH->input2[0] = '\0';
	    strcpy(WITH->lastcmd, "***login");
	    *WITH->tellmbx = '\0';
	    WITH->action = 0;
	    WITH->tell = nohandle;
	    WITH->sendchan = nohandle;
	    WITH->SID[0] = '\0';
	    WITH->MSID[0] = '\0';
	    WITH->FSID[0] = '\0';
	    WITH->sfpwdb[0] = '\0';
	    WITH->sfpwtn[0] = '\0';
	    WITH->tellfname[0] = '\0';
	    WITH->sf_ptr = NULL;
	    WITH->binsfptr = NULL;
	    WITH->fwdmode = 0;
	    WITH->errors = 0;
	    WITH->processtime = 0;
	    WITH->talk_to = 0;
	    WITH->isfirstchar = true;
	    WITH->laterflag = false;
	    WITH->msgselection = 0;
	    WITH->sf_master = (mode == UM_SF_OUT);
	    WITH->smode = false;
	    strcpy(WITH->spath, "/");
	    WITH->pagcount = 0;
	    WITH->paging = 0;   /* steht erstmal auf 0 */
	    WITH->changed_dir = false;
	    strcpy(WITH->conpath, path);

	    for (y = 0; y < maxfbbprops; y++) {
	      WITH->fbbprop[y].line[0] = '\0';
	      WITH->fbbprop[y].brett[0] = '\0';
	      WITH->fbbprop[y].nr = 0;
	      WITH->fbbprop[y].crc = 0;
	      WITH->fbbprop[y].pack = false;
	      WITH->fbbprop[y].x_nr = 0;
	      WITH->fbbprop[y].bid[0] = '\0';
	      WITH->fbbprop[y].rname[0] = '\0';
	      WITH->fbbprop[y].unpacked = false;
	      WITH->fbbprop[y].mtype = '\0';
	    }

	    WITH->lastsfcall[0] = '\0';
	    WITH->no_binpack = false;
	    WITH->emblockct = 0;

	    del_blanks(WITH->call);
	    if (*WITH->call == '\0') {
	      strcpy(WITH->call, calls);
	      WITH->name[0] = '\0';
	      WITH->mybbs[0] = '\0';
	      WITH->lastdate = WITH->logindate;
	    } else if (WITH->lastdate == 0)
	      WITH->lastdate = WITH->logindate;
	    if (*WITH->language == '\0') {
	      user_language(&whichlangmem, &whichlangsize, whotalks_lan,
			    WITH->call, lan);
	      cut(lan, 3);
	      strcpy(WITH->language, lan);
	    }
	    WITH->fulltrace = false;
	    WITH->trace_to = in_tracecalls(WITH->call);
	    *WITH->tracefract = '\0';
	    if (WITH->trace_to > 0 && WITH->trace_to != x) {
	      if (mode == UM_SF_OUT)
		strcpy(hs, "s&f-connect successful");
	      else
		strcpy(hs, "logging in");

	      sprintf(hs, "*** %s %s", WITH->call, strcpy(STR1, hs));
	      trace_string(true, x, WITH->trace_to, hs, true);
	    }

	    if (in_protocalls(WITH->call))
	      append_protolog(x);

	    WITH->convchan = -1;

	    if (mode == UM_USER && !reconnect) {
	      begruessung(x);
	      if (user[x] == NULL)
		return 0;
	    } else if (mode == UM_SF_OUT) {
	      send_tcpip_protocol_frame(x);
	      WITH->action = 100;
	    } else if (mode == UM_TELLREQ) {
	      sprintf(STR1, "%s%s%cTEL", boxstatdir, WITH->call, extsep);
	      strcpy(WITH->tellfname, STR1);
	      validate(WITH->tellfname);
	      WITH->tell = sfcreate(WITH->tellfname, FC_FILE);
	    } else if (mode == UM_MODEM_IN) {
	      wuser(x, "Password: ");
	      WITH->action = 81;
	    } else if (reconnect)
	      show_prompt(x);


	    upd_statistik(x, 0, 0, count, statclock());

	  } else {
	    sprintf(STR13, "boxuser not permitted: %s", user[x]->call);
	    boxprotokoll(STR13);
	    strcpy(hs, "access denied");
	    boxspool(cons, chan, boxprn2bios(false), hs, true);
	  }



	} else {
	  if (!double_) {
	    if (is_german(calls))
	      strcpy(hs,
		"Box ist zu Wartungsarbeiten abgeschaltet. Bitte spaeter nocheinmal versuchen.");
	    else
	      strcpy(hs, "box is closed. try later");
	  } else {
	    if (is_german(calls))
	      strcpy(hs,
		"Sie haben zu viele gleichzeitige Verbindungen mit der Box.");
	    else
	      strcpy(hs, "you have too many simultaneous connections");
	  }
	  boxspool(cons, chan, boxprn2bios(false), hs, true);
	}

	if (newchan <= 0) {
	  if (user[x] != NULL) {
	    Free(user[x]);
	    user[x] = NULL;
	  }
	}

      }
    }
  } else {
    if (!callsign(calls))
      sprintf(hs, "invalid login call %s", calls);
    else if (memavail__() < 20000)
      strcpy(hs, "not enough memory to create a user process");
    else
      strcpy(hs, "?");
    boxspool(cons, chan, boxprn2bios(false), hs, true);
  }
  if (newchan < 0)
    newchan = 0;

  return newchan;


}


void melde_user_ab(short unr, boolean sav)
{
  short x;
  Char hs[256];
  boxintype *hpbi;
  userstruct *WITH;
  Char STR7[256];

  if (boxrange(unr)) {
    WITH = user[unr];
    debug0(1, unr, 107);

    if (WITH->trace_to > 0 && WITH->trace_to != unr) {
      sprintf(hs, "*** %s logging out", WITH->call);
      trace_string(true, unr, WITH->trace_to, hs, true);
    }

    if (WITH->convchan > 0)
      send_conv(unr, "*** logging out");

    sfclosedel(&WITH->sendchan);

    if (WITH->sendheader != NULL)
      Free(WITH->sendheader);

    if (WITH->yapp != NULL) {
      sfclose(&WITH->yapp->filefd);
      if (WITH->yapp->delete_)
        sfdelfile(WITH->yapp->fname);
      Free(WITH->yapp);
    }

    if (WITH->bin != NULL) {
      sfclose(&WITH->bin->filefd);
      if (WITH->bin->write_ || WITH->bin->delete_)
	sfdelfile(WITH->bin->fname);
      Free(WITH->bin);
    }

    sprintf(hs, "%sSHOWDIR%c%ld", tempdir, extsep, unr);
    sfdelfile(hs);

    delete_trace_from(unr);

    if (WITH->emblockct > 0)
      del_emblocks(unr, WITH->emblockct);

    if (WITH->laterflag)
      reset_laterflag(unr);

    if ((WITH->umode >= 32 ||
	 ((1L << WITH->umode) & ((1L << UM_TELLREQ) | (1L << UM_SYSREQ))) == 0) &&
	!WITH->console)
      box_logbuch(unr);

    if ((WITH->supervisor || WITH->rsysop) && WITH->umode != UM_SYSREQ &&
	!WITH->console) {
      strcpy(WITH->lastcmd, "sysop");
      if (WITH->rsysop) {
	sprintf(STR7, "board-%s", WITH->lastcmd);
	strcpy(WITH->lastcmd, STR7);
      }
      strcat(WITH->lastcmd, " logged out");
      append_syslog(unr);
      *WITH->lastcmd = '\0';
    }

    if (in_protocalls(WITH->call)) {
      strcpy(WITH->lastcmd, "***logout");
      append_protolog(unr);
      *WITH->lastcmd = '\0';
    }


    if (WITH->f_bbs)
      check_frag_sf(unr);
    if (WITH->newmsg) {
      sprintf(STR7, "%s%s%cMSG", boxstatdir, WITH->call, extsep);
      sfdelfile(STR7);
    }
    if (sav)
      WITH->lastdate = WITH->logindate;
    if (WITH->talk_to > 0)
      end_talk_mode(WITH->talk_to, true);
    if (WITH->binsfptr != NULL)
      Free(WITH->binsfptr);
    if (*WITH->tellfname != '\0')
      sfdelfile(WITH->tellfname);

    sfclosedel(&WITH->prochandle);
    while (WITH->inputroot != NULL) {
      hpbi = WITH->inputroot;
      WITH->inputroot = WITH->inputroot->next;
      Free(hpbi);
    }

    del_blanks(WITH->call);
    WITH->logins++;
    WITH->sslogins++;

    if (WITH->wait_pid > 0) {
      close_shell(unr);
      WITH->wait_pid = -1;   /* fuer den Atari/Mac */
    }

    if (WITH->umode >= 32 ||
	((1L << WITH->umode) & ((1L << UM_SYSREQ) | (1L << UM_TELLREQ))) == 0) {
      save_userfile(user[unr]);
      if (sav) {
	for (x = 1; x <= maxuser; x++) {
	  if (user[x] != NULL) {
	    if (!strcmp(user[x]->call, WITH->call))
	      user[x]->lastdate = WITH->lastdate;
	  }
	}
      }
    }

  }

  if (boxrange(unr)) {
    debug(5, unr, 107, "now deleting user");
    user[unr]->magic1 = 0;
    user[unr]->magic2 = 0;
    user[unr]->magic3 = 0;
    Free(user[unr]);
    user[unr] = NULL;
  } else {
    sprintf(hs, "user %ld was NIL / userstruct was violated", unr);
    debug(0, -1, 107, hs);
  }

  debug(5, -1, 107, "... done");
}




void _box_inou_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
