/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/

#include "filesys.h"

#include <unistd.h>
#ifdef dpmacos
#include <time.h>
#include <stat.h>
#else
#include <sys/time.h>
#include <sys/stat.h>
#include <dirent.h>
#endif

#include "dpglobal.h"
#include "pastrix.h"
#include "boxglobl.h"
#include "tools.h"







#ifdef dpmacos

/* this is the macintosh localisation for file/folder/path - resolving  */
/* a macintosh does not keep track of files by explicit access paths    */
/* but volume and directory reference ids, resolved at access time     */
/* lets see if we get that resolved in an efficient way so that unix    */
/* access conventions can be used with not too much overhead in         */
/* execution time                                                       */

#include <Files.h>

static short myVolume;
static long myWorkDir;
static char apName[256];
static short apRefNum;

void StartupFilesysInit(void)
{
  Handle apParam;
  GetAppParms(&apName, &apRefNum, &apParam);
  if (GetVRefNum(apRefNum, &myVolume) < 0)
    myVolume = 0;
}



#define DiskFreeDefault 80000000L

long DiskFree(int dummy)
{
  short retVId;
  long retval;
  char hs[256];
  
  if (GetVInfo(myVolume, &hs, &retVId, &retval) < 0)
    return DiskFreeDefault;
  if (retVId != myVolume)
    return DiskFreeDefault;
  return retval;
}



static int namecomp(file_str,wild_str)
char *file_str;
char *wild_str;
{
  char *ptr;
  int len;
  char *wild_ptr;
  char *file_ptr;

  if (strcmp(file_str,"..") == 0) return 1;
  if (strcmp(file_str,".") == 0) return 1;  
  if (strcmp(wild_str,"*") == 0) return 0;
  if (strcmp(wild_str,"*.*") == 0) return 0;
  if (strchr(wild_str,'*') == NULL) {
    return strcmp(file_str,wild_str);
  }
  if (strncmp(wild_str,"*.",2) == 0) {
    if ((ptr = strchr(file_str,'.')) == NULL) return 1;
    return strcmp(ptr+1,wild_str+2);
  }
  if ((wild_ptr = strstr(wild_str,"*.")) != NULL) {
    if ((file_ptr = strchr(file_str,'.')) == NULL) return 1;
    len = wild_ptr - wild_str;
    if (strncmp(file_str,wild_str,len) == 0) { 
      if (strcmp(file_ptr+1,wild_ptr+2) == 0)
        return(0);
      if (strcmp(wild_ptr+2,"*") == 0)
        return(0);
    }
  }
  if ((ptr = strstr(wild_str,".*")) != NULL) {
    len = ptr - wild_str;
    return strncmp(file_str,wild_str,len);
  }
  return 1; 
}

void convert_time(time_t time, DTA *dirr)
{
  uchar h,min,s,d,m,y;
  
  decode_ixtime(time, &d, &m, &y, &h, &min, &s);
  dirr->d_time = Make_DTime(h,min,s);
  dirr->d_date = Make_DDate(d,m,y);
}

static short dir_attribut;
// static struct dirlist *nextptr;

#define RES_NOFILE 2
#define RES_NOMORE 18

short sffirst(Char *pfad, short attr, DTA *dirr)
{
#ifndef dpmacos
  struct dirlist *actptr;
  struct stat buf;
  char tempstr[255];
  
  dir_attribut = attr;
  if (nextptr != NULL) delete_dirlist();
  nextptr = dir_scan(pfad);
  while (nextptr != NULL) {
    actptr = nextptr;
    strcpy(dirr->d_fname,actptr->filename);
    sprintf(tempstr,"%s%s",dirstr,actptr->filename);
    stat(tempstr,&buf);
    dirr->d_length = buf.st_size;
    nextptr = actptr->next;
    free(actptr);
    switch (buf.st_mode & S_IFMT) {
    case S_IFREG:
      if (dir_attribut == 0) {
        dirr->d_attrib = 0;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    case S_IFDIR:
      if (dir_attribut == 16) {
        dirr->d_attrib = 16;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    default:
      break;
    }
  }
#endif
  return RES_NOFILE;
}

short sfnext(DTA *dirr)
{
#ifndef dpmacos
  struct dirlist *actptr;
  struct stat buf;
  char tempstr[255];

  while (nextptr != NULL) {
    actptr = nextptr;
    strcpy(dirr->d_fname,actptr->filename);
    sprintf(tempstr,"%s%s",dirstr,actptr->filename);
    stat(tempstr,&buf);
    dirr->d_length = buf.st_size;
    nextptr = actptr->next;
    free(actptr);
    switch (buf.st_mode & S_IFMT) {
    case S_IFREG:
      if (dir_attribut == 0) {
        dirr->d_attrib = 0;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    case S_IFDIR:
      if (dir_attribut == 16) {
        dirr->d_attrib = 16;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    default:
      break;
    }
  }
#endif
  return RES_NOMORE;
}

int dup(int fd)
{
    return -1;
}

void mktemp(char *name)
{
  validate(name);
}



/* ------------------------------------------------------------------ */


/*
Static boolean alldirsep(Char c)
{
  return (c == dirsep || c == '/' || c == '\\' || c == drivesep);
}
*/

#define alldirsep(c) (c == dirsep || c == '/' || c == '\\' || c == drivesep)

/* C:\TEST\TEST.PAS -> C:\TEST\TEST */

void del_ext(Char *s)
{
  short i;

  i = strlen(s);
  while (i > 0 && s[i - 1] != extsep && !alldirsep(s[i - 1]))
    i--;
  if (s[i - 1] == extsep)
    strdelete((void *)s, i, strlen(s) - i + 1);
}


/* C:\TEST\TEST.PAS -> PAS */

void get_ext(Char *s, Char *sext)
{
  short i;

  sext[0] = '\0';
  i = strlen(s);
  while (i > 0 && s[i - 1] != extsep && !alldirsep(s[i - 1]))
    i--;
  if (s[i - 1] == extsep)
    strsub(sext, s, i + 1, strlen(s) - i);
}


/* C:\TEST\TEST.PAS + TXT -> C:\TEST\TEST.TXT */

void new_ext(Char *s, Char *ext)
{
  del_ext(s);
  sprintf(s + strlen(s), "%c%s", extsep, ext);
}


/* C:\TEST\TEST.PAS -> TEST.PAS */

void del_path(Char *s)
{
  short x;

  x = strlen(s);
  while (x > 0 && !alldirsep(s[x - 1]))
    x--;
  strdelete((void *)s, 1, x);
  cut(s, 80);
}


/* C:\TEST\TEST.PAS -> C:\TEST\ */

void get_path(Char *s)
{
  short x;

  x = strlen(s);
  while (x > 0 && !alldirsep(s[x - 1]))
    x--;
  cut(s, x);
}



/* sind wir am Ende der Datei ? */

boolean myeof(short handle)
{
  boolean Result;
  long apos;

  Result = true;
  if (handle < minhandle)
    return Result;
  apos = sfseek(0, handle, SFSEEKCUR);
  if (sfseek(1, handle, SFSEEKCUR) > apos) {
    sfseek(-1, handle, SFSEEKCUR);
    return false;
  }
  return Result;
}


short sfgetdatime(Char *name, unsigned short *date, unsigned short *time)
{
  time_t_ ixt;

  struct stat buf;
  if (stat(name,&buf) != 0) {
    return -1;
  }
  ixt = buf.st_mtime;
  ix2dostime(ixt, date, time);
  return 0;
}


#include <utime.h>

short sfsetdatime(Char *name, unsigned short *date, unsigned short *time)
{
  short Result;
  time_t_ ixt;

  struct utimbuf utim;
  Result = -1;
  ixt = dos2ixtime(*date, *time);
  utim.modtime = ixt;
  if (utime ((unsigned char *)name,&utim) >= 0)
    Result = 0;
  return Result;
}


long sfsize(Char *name)
{
  struct stat buf;
  if (stat(name,&buf) != 0) {
    return 0;
  }
  return buf.st_size;
}


boolean exist(Char *name)
{
  struct stat buf;
  if (stat(name,&buf) != 0) {
    return 0;
  }
  return 1;
}


short sfrename(Char *oldname, Char *newname)
{
  return rename(oldname, newname);
}


void sfdelfile(Char *name)
{
  unlink(name);
}


void sfgetdir(short d, Char *p)
{
  /* Get Directory */
  /* und zwar als Ergebnis = 'C:\DP\TEST\' */
  /* d 0 = aktuelles Drive */
  *p = '\0';
  getcwd(p, 255);
  if (p[strlen(p) - 1] != dirsep)
    sprintf(p + strlen(p), "%c", dirsep);
}


short sfchdir(Char *p)
{
  return chdir(p);
}


short sfmakedir(Char *name)
{
  return mkdir(name, 0x1ff);
}


short sfremovedir(Char *name)
{
  return rmdir(name);
}



#endif /* of dpmacos */











#ifdef dplinux

/* simply copied that widespread file access code of former dpbox code  */
/* in this single file. Not a real change to previous versions of the   */
/* code. lot of the code was written by Mark Wahl DL4YBG for the first  */
/* localisation of the dpbox code from Atari to Linux                   */

long DiskFree(int dummy)
{
  return 80000000L;
}


typedef struct dirlist {
  char filename[256];
  struct dirlist *next;
} dirlist;


static int namecomp(file_str,wild_str)
char *file_str;
char *wild_str;
{
  char *ptr;
  int len;
  char *wild_ptr;
  char *file_ptr;

  if (strcmp(file_str,"..") == 0) return 1;
  if (strcmp(file_str,".") == 0) return 1;  
  if (strcmp(wild_str,"*") == 0) return 0;
  if (strcmp(wild_str,"*.*") == 0) return 0;
  if (strchr(wild_str,'*') == NULL) {
    return strcmp(file_str,wild_str);
  }
  if (strncmp(wild_str,"*.",2) == 0) {
    if ((ptr = strchr(file_str,'.')) == NULL) return 1;
    return strcmp(ptr+1,wild_str+2);
  }
  if ((wild_ptr = strstr(wild_str,"*.")) != NULL) {
    if ((file_ptr = strchr(file_str,'.')) == NULL) return 1;
    len = wild_ptr - wild_str;
    if (strncmp(file_str,wild_str,len) == 0) { 
      if (strcmp(file_ptr+1,wild_ptr+2) == 0)
        return(0);
      if (strcmp(wild_ptr+2,"*") == 0)
        return(0);
    }
  }
  if ((ptr = strstr(wild_str,".*")) != NULL) {
    len = ptr - wild_str;
    return strncmp(file_str,wild_str,len);
  }
  return 1; 
}

static char filestr[255];
static char dirstr[255];

static struct dirlist *dir_scan(path)
char *path;
{
  char *ptr;
  DIR *dirp;
  struct dirent *dp;
  struct dirlist *startptr;
  struct dirlist *actptr;
  struct dirlist *workptr;
  
  ptr = strrchr(path,'/');
  if (ptr == NULL) {
    strcpy(filestr,path);
    strcpy(dirstr,".");
  }
  else {
    strcpy(filestr,ptr+1);
    strncpy(dirstr,path,strlen(path) - strlen(filestr));
    dirstr[strlen(path) - strlen(filestr)] = '\0';
  }
  if ((dirp = opendir(dirstr)) == NULL) return NULL;
  startptr = NULL;
  actptr = NULL;
  while ((dp = readdir(dirp)) != NULL) {
    if (namecomp(dp->d_name,filestr) == 0) {
      workptr = malloc(sizeof(struct dirlist));
      strcpy(workptr->filename,dp->d_name);
      workptr->next = NULL;
      if (startptr == NULL) startptr = workptr;
      if (actptr != NULL) {
        actptr->next = workptr;
      }
      actptr = workptr;
    }
  }
  closedir(dirp);
  return startptr;
}

static short dir_attribut;
static struct dirlist *nextptr;
#define RES_NOFILE 2
#define RES_NOMORE 18

void delete_dirlist()
{
  struct dirlist *actptr;
  
  while (nextptr != NULL) {
    actptr = nextptr;
    nextptr = actptr->next;
    free(actptr);
  }
}

void convert_time(time_t time, DTA *dirr)
{
  uchar h,min,s,d,m,y;
  
  decode_ixtime(time, &d, &m, &y, &h, &min, &s);
  dirr->d_time = Make_DTime(h,min,s);
  dirr->d_date = Make_DDate(d,m,y);
}

short sffirst(Char *pfad, short attr, DTA *dirr)
{
  struct dirlist *actptr;
  struct stat buf;
  char tempstr[255];
  
  dir_attribut = attr;
  if (nextptr != NULL) delete_dirlist();
  nextptr = dir_scan(pfad);
  while (nextptr != NULL) {
    actptr = nextptr;
    strcpy(dirr->d_fname,actptr->filename);
    sprintf(tempstr,"%s%s",dirstr,actptr->filename);
    stat(tempstr,&buf);
    dirr->d_length = buf.st_size;
    nextptr = actptr->next;
    free(actptr);
    switch (buf.st_mode & S_IFMT) {
    case S_IFREG:
      if (dir_attribut == 0) {
        dirr->d_attrib = 0;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    case S_IFDIR:
      if (dir_attribut == 16) {
        dirr->d_attrib = 16;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    default:
      break;
    }
  }
  return RES_NOFILE;
}

short sfnext(DTA *dirr)
{
  struct dirlist *actptr;
  struct stat buf;
  char tempstr[255];

  while (nextptr != NULL) {
    actptr = nextptr;
    strcpy(dirr->d_fname,actptr->filename);
    sprintf(tempstr,"%s%s",dirstr,actptr->filename);
    stat(tempstr,&buf);
    dirr->d_length = buf.st_size;
    nextptr = actptr->next;
    free(actptr);
    switch (buf.st_mode & S_IFMT) {
    case S_IFREG:
      if (dir_attribut == 0) {
        dirr->d_attrib = 0;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    case S_IFDIR:
      if (dir_attribut == 16) {
        dirr->d_attrib = 16;
        convert_time(buf.st_mtime,dirr);
        return 0;
      }
      break;
    default:
      break;
    }
  }
  return RES_NOMORE;
}



/* ------------------------------------------------------------------ */


/*
Static boolean alldirsep(Char c)
{
  return (c == dirsep || c == '/' || c == '\\' || c == drivesep);
}
*/

#define alldirsep(c) (c == dirsep || c == '/' || c == '\\' || c == drivesep)

/* C:\TEST\TEST.PAS -> C:\TEST\TEST */

void del_ext(Char *s)
{
  short i;

  i = strlen(s);
  while (i > 0 && s[i - 1] != extsep && !alldirsep(s[i - 1]))
    i--;
  if (s[i - 1] == extsep)
    strdelete((void *)s, i, strlen(s) - i + 1);
}


/* C:\TEST\TEST.PAS -> PAS */

void get_ext(Char *s, Char *sext)
{
  short i;

  sext[0] = '\0';
  i = strlen(s);
  while (i > 0 && s[i - 1] != extsep && !alldirsep(s[i - 1]))
    i--;
  if (s[i - 1] == extsep)
    strsub(sext, s, i + 1, strlen(s) - i);
}


/* C:\TEST\TEST.PAS + TXT -> C:\TEST\TEST.TXT */

void new_ext(Char *s, Char *ext)
{
  del_ext(s);
  sprintf(s + strlen(s), "%c%s", extsep, ext);
}


/* C:\TEST\TEST.PAS -> TEST.PAS */

void del_path(Char *s)
{
  short x;

  x = strlen(s);
  while (x > 0 && !alldirsep(s[x - 1]))
    x--;
  strdelete((void *)s, 1, x);
  cut(s, 80);
}


/* C:\TEST\TEST.PAS -> C:\TEST\ */

void get_path(Char *s)
{
  short x;

  x = strlen(s);
  while (x > 0 && !alldirsep(s[x - 1]))
    x--;
  cut(s, x);
}



/* sind wir am Ende der Datei ? */

boolean myeof(short handle)
{
  boolean Result;
  long apos;

  Result = true;
  if (handle < minhandle)
    return Result;
  apos = sfseek(0, handle, SFSEEKCUR);
  if (sfseek(1, handle, SFSEEKCUR) > apos) {
    sfseek(-1, handle, SFSEEKCUR);
    return false;
  }
  return Result;
}


short sfgetdatime(Char *name, unsigned short *date, unsigned short *time)
{
  time_t_ ixt;

  struct stat buf;
  if (stat(name,&buf) != 0) {
    return -1;
  }
  ixt = buf.st_mtime;
  ix2dostime(ixt, date, time);
  return 0;
}


#include <utime.h>

short sfsetdatime(Char *name, unsigned short *date, unsigned short *time)
{
  short Result;
  time_t_ ixt;

  struct utimbuf utim;
  Result = -1;
  ixt = dos2ixtime(*date, *time);
  utim.modtime = ixt;
  if (utime ((unsigned char *)name,&utim) >= 0)
    Result = 0;
  return Result;
}


long sfsize(Char *name)
{
  struct stat buf;
  if (stat(name,&buf) != 0) {
    return 0;
  }
  return buf.st_size;
}


boolean exist(Char *name)
{
  struct stat buf;
  if (stat(name,&buf) != 0) {
    return 0;
  }
  return 1;
}


short sfrename(Char *oldname, Char *newname)
{
  return rename(oldname, newname);
}


void sfdelfile(Char *name)
{
  unlink(name);
}

/* ----------------------------------------------------------------- */


void sfgetdir(short d, Char *p)
{
  /* Get Directory */
  /* und zwar als Ergebnis = '/DP/TEST/' */
  /* d 0 = aktuelles Drive */
  *p = '\0';
  getcwd(p, 255);
  if (p[strlen(p) - 1] != dirsep)
    sprintf(p + strlen(p), "%c", dirsep);
}


short sfchdir(Char *p)
{
  return chdir(p);
}


short sfmakedir(Char *name)
{
  return mkdir(name, 0x1ff);
}


short sfremovedir(Char *name)
{
  return rmdir(name);
}


#endif /* of dplinux */








/* put further localisations in here                                    */















/* These are common routines of all localisations */


void del_dir(Char *name)
{
  short result;
  DTA dirinfo;
  Char STR1[256];

  result = sffirst(name, 0, &dirinfo);
  get_path(name);
  while (result == 0) {
    sprintf(STR1, "%s%s", name, dirinfo.d_fname);
    sfdelfile(STR1);
    result = sfnext(&dirinfo);
  }
}



#define bsize           8192


/* haengt ein File an ein bereits geoeffnetes an */

void app_file2(Char *filea, short k2, long ab, boolean del_source)
{
  uchar *puffer;
  bst psize;
  long done, bc, cstep, hli, fsize;
  short k1;

  if (k2 < minhandle)
    return;
  k1 = sfopen(filea, FO_READ);
  if (k1 < minhandle)
    return;
  fsize = sfseek(0, k1, SFSEEKEND);
  sfseek(0, k1, SFSEEKSET);
  if (ab > 0 && ab <= fsize)
    fsize -= ab;
  else
    ab = 0;
  done = 0;
  hli = 0;
  psize = bsize;
  if (psize > fsize)
    psize = fsize;
  puffer = Malloc(psize);
  if (puffer != NULL) {
    if (ab > 0)
      sfseek(ab, k1, SFSEEKSET);
    bc = 1;
    while (done < fsize && bc > 0) {
      cstep = fsize - done;
      if (cstep > psize)
	cstep = psize;
      bc = sfread(k1, cstep, puffer);
      if (bc <= 0)
	break;
      done += bc;
      bc = sfwrite(k2, cstep, puffer);
      if (bc > 0)
	hli += bc;
    }
    mymfreep(&puffer);
  }
  sfclose(&k1);
  if (hli == fsize && done == fsize && del_source)
    sfdelfile(filea);
}

#undef bsize


#define copysize        8192
#define copysize2       128


Static void filemove_x(Char *filea, Char *fileb, boolean delete_source,
		       long start, long size)
{
  long err;
  uchar *puffer;
  bst psize;
  long done, bc, cstep, hli, fsize;
  short k1, k2;


  if (delete_source && size == 0 && start == 0) {
    sfdelfile(fileb);
    sfrename(filea, fileb);
    return;
  }

  k1 = sfopen(filea, FO_READ);
  if (k1 < minhandle)
    return;

  fsize = sfseek(0, k1, SFSEEKEND);
  sfseek(0, k1, SFSEEKSET);

  if (fsize <= 0) {
    sfclose(&k1);
    return;
  }

  if (size > 0) {
    if (fsize > size - start)
      fsize = size - start;
  } else if (start > 0) {
    if (start <= fsize)
      fsize -= start;
  }

  if (fsize <= 0) {
    sfclose(&k1);
    return;
  }

  psize = copysize;
  if (psize > fsize)
    psize = fsize;
  puffer = Malloc(psize);

  if (puffer == NULL) {
    psize = copysize2;
    if (psize > fsize)
      psize = fsize;
    puffer = Malloc(psize);
  }

  if (puffer == NULL) {
    sfclose(&k1);
    return;
  }
  done = 0;
  hli = 0;
  if (start > 0)
    err = sfseek(start, k1, SFSEEKSET);
  else
    err = 0;
  if (err == start) {
    k2 = sfcreate(fileb, FC_FILE);
    if (k2 >= minhandle) {
      bc = 1;
      while (done < fsize && bc > 0) {
	cstep = fsize - done;
	if (cstep > psize)
	  cstep = psize;
	bc = sfread(k1, cstep, puffer);
	if (bc <= 0)
	  break;
	done += bc;
	bc = sfwrite(k2, cstep, puffer);
	if (bc > 0)
	  hli += bc;
      }
      sfclose(&k2);
    }
  }
  sfclose(&k1);
  if (hli == fsize && done == fsize) {
    if (delete_source)
      sfdelfile(filea);
  } else
    sfdelfile(fileb);
  mymfreep(&puffer);
}

#undef copysize
#undef copysize2


void filecut(Char *filea, Char *fileb, long start, long size)
{
  filemove_x(filea, fileb, true, start, size);
}


void filecut_nodel(Char *filea, Char *fileb, long start, long size)
{
  filemove_x(filea, fileb, false, start, size);
}


void filecopy(Char *filea, Char *fileb)
{
  filemove_x(filea, fileb, false, 0, 0);
}


void filemove(Char *filea, Char *fileb)
{
  filemove_x(filea, fileb, true, 0, 0);
}

/* validate sucht solange eine neue .extension, bis sichergestellt ist, */
/* dass keine bestehende Datei ueberschrieben wird */

void validate(Char *name)
{
  Char ext[13];
  short enum_;
  Char STR1[14];
  Char STR13[256];

  if (!exist(name))
    return;
  get_ext(name, ext);
  del_ext(name);
  enum_ = Str2int(ext) + 1;
  sprintf(ext, "%ld", enum_);
  while (strlen(ext) < 3)
    sprintf(ext, "0%s", strcpy(STR1, ext));
  while (exist((sprintf(STR13, "%s%c%s", name, extsep, ext), STR13))) {
    enum_++;
    sprintf(ext, "%ld", enum_);
    while (strlen(ext) < 3)
      sprintf(ext, "0%s", strcpy(STR1, ext));
  }
  sprintf(name + strlen(name), "%c%s", extsep, ext);
}


/*fuegt eine Zeile an eine bereits geoeffnete Datei an*/

void string_to_file(short *handle, Char *line, boolean crlf)
{
  static uchar crlfarr = 10;
  short l;

  if (*handle < minhandle)
    return;
  l = strlen(line);
  if (sfwrite(*handle, l, line) != l) {
    sfclose(handle);
    return;
  }
  if (crlf) {
    if (sfwrite(*handle, sizeof(uchar), &crlfarr) != sizeof(uchar))
      sfclose(handle);
  }
}


/* funktioniert nur korrekt, wenn Eingabezeilen maximal 253 Bytes lang sind */

boolean file_to_string(short handle, Char *line)
{
  long ct, s2;
  short x, FORLIM;

  *line = '\0';

  if (handle < minhandle)
    return false;
  ct = sfread(handle, 255, line);
  if (ct <= 0)
    return false;
  line[ct] = '\0';
  FORLIM = ct;
  for (x = 1; x <= FORLIM; x++) {
    if (line[x - 1] == '\015' || line[x - 1] == '\n') {
      if (line[x - 1] == '\015') {
	if (line[x] == '\n')
	  s2 = x + 1;
	else
	  s2 = x;
      } else
	s2 = x;
      ct -= s2;
      if (ct > 0) {
	ct = -ct;
	sfseek(ct, handle, SFSEEKCUR);
      }
      line[x - 1] = '\0';
      return true;
    }
  }
  return true;
}


/* Fuegt eine Zeile an eine Datei an, gibt neue Laenge zurueck */

long append(Char *name, Char *zeile, boolean crlf)
{
  short k;
  long sz;

  sz = -1;
  k = sfopen(name, FO_RW);
  if (k < minhandle)
    k = sfcreate(name, FC_FILE);
  if (k < minhandle)
    return sz;
  sz = sfseek(0, k, SFSEEKEND) + strlen(zeile);
  if (crlf)
    sz++;
  string_to_file(&k, zeile, crlf);
  sfclose(&k);
  return sz;
}


/* ----------------------------------------------------------------- */


/* File oeffnen / schliessen im Multitasking */

typedef struct flocktype {
  struct flocktype *next;
  uchar cs;
  short handle;
  boolean write;
  long attime;
  Char name[256];  
} flocktype;


Static flocktype *flockroot;


void handle2name(short handle, Char *name)
{
  flocktype *hp;

  hp = flockroot;
  while (hp != NULL && hp->handle != handle)
    hp = hp->next;
  if (hp != NULL)
    strcpy(name, hp->name);
  else
    *name = '\0';
}


Static void flockp2s(flocktype *hp, Char *hs)
{
  Char w[256];
  long t2;
  short m, s;
  Char STR1[256];

  if (hp == NULL) {
    strcpy(hs, "???");
    return;
  }

  sprintf(w, "%ld", hp->handle);
  lspacing(w, 3);
  strcpy(hs, w);
  if (hp->write)
    strcat(hs, " w ");
  else
    strcat(hs, " r ");
  t2 = (statclock() - hp->attime) / 200;
  s = t2 % 60;
  m = t2 / 60;
  sprintf(w, "%ld", m);
  while (strlen(w) < 2)
    sprintf(w, "0%s", strcpy(STR1, w));
  sprintf(hs + strlen(hs), " %s:", w);
  sprintf(w, "%ld", s);
  while (strlen(w) < 2)
    sprintf(w, "0%s", strcpy(STR1, w));

  sprintf(hs + strlen(hs), "%s %s", w, hp->name);
}


Static void flockprotocole(short i, flocktype *hp, Char *name)
{
  static uchar crlfarr = 10;

  Char hs[256], w[256];
  short k;
  Char STR1[256];

  if (hp != NULL || i <= 2)
    return;
  switch (i) {

  case 0:
  case 3:
    strcpy(w, "open  : ");
    break;

  case 1:
  case 4:
    strcpy(w, "create: ");
    break;

  case 2:
  case 5:
    strcpy(w, "close : ");
    break;

  default:
    strcpy(w, "???   : ");
    break;
  }

  if (hp != NULL)
    flockp2s(hp, hs);
  else
    sprintf(hs, "%s failed!", name);

  sprintf(hs, "%s %s %s%s", clock_.datum, clock_.zeit, w, strcpy(STR1, hs));

  sprintf(w, "file_err%ctxt", extsep);
  sprintf(w, "%s%s", boxprotodir, strcpy(STR1, w));
  if (*lastproc != '\0')
    sprintf(hs + strlen(hs), " - possibly called by %s", lastproc);
  k = open(w, FO_RW);
  if (k < minhandle)
    k = dpsyscreate(w, FO_CREATE, FC_FILE);
  if (k < minhandle)
    return;
  lseek(k, 0, 2);
  write(k, hs, strlen(hs));
  write(k, &crlfarr, sizeof(uchar));
  close(k);
}

short dpsyscreate(char *fname, int flags, int mode)
{
#ifdef dpmacos
   return open(fname, flags);
#else
   return open(fname, flags, mode);
#endif
}


Static short open_locked(boolean create, Char *name, short mode)
{
  short Result, handle;
  flocktype *hp;
  boolean nowrite, wantwrite;
  uchar tcs;

  Result = nohandle;
  tcs = calccs(name);
  handle = nohandle;
  wantwrite = (create || mode != FO_READ);
  hp = flockroot;
  nowrite = true;
  /* ist das File bereits in Benutzung? */

  while (hp != NULL && nowrite) {
    if (hp->cs == tcs) {
      if (!strcmp(hp->name, name)) {
	if (wantwrite)
	  nowrite = false;
	if (hp->write)
	  nowrite = false;
      }
    }
    hp = hp->next;
  }

  hp = NULL;
  if (nowrite) {  /* ok, wir koennen zugreifen */
    if (create)
      handle = dpsyscreate(name, FO_CREATE, mode);
    else
      handle = open(name, mode);

    if (handle < minhandle)  /* File geoeffnet */
      return handle;

    hp = Malloc(sizeof(flocktype));
    if (hp != NULL) {
      hp->next = flockroot;
      hp->cs = tcs;
      strcpy(hp->name, name);
      hp->handle = handle;
      hp->write = wantwrite;
      hp->attime = statclock();
      flockroot = hp;
      if (create)
	flockprotocole(1, hp, name);
      else
	flockprotocole(0, hp, name);
      return handle;
    }
    close(handle);
    if (create)
      sfdelfile(name);
    handle = nohandle;
    if (create)
      flockprotocole(1, hp, name);
    else
      flockprotocole(0, hp, name);
    return handle;
  }

  if (create)
    flockprotocole(4, hp, name);
  else
    flockprotocole(3, hp, name);
  return handle;

  /* kein Verwaltungsspeicher - dann koennen wir auch nicht oeffnen */
}


short sfcreate(Char *name, short mode)
{
  return (open_locked(true, name, mode));
}


short sfopen(Char *name, short mode)
{
  return (open_locked(false, name, mode));
}


Static short lastactivehandle;
Static flocktype *lastactiveflock;


Static flocktype *valid_handle(short handle)
{
  flocktype *hp;

  if (handle == lastactivehandle && lastactiveflock != NULL)
    return lastactiveflock;

  hp = flockroot;
  while (hp != NULL && hp->handle != handle)
    hp = hp->next;

  if (hp != NULL) {
    lastactivehandle = handle;
    lastactiveflock = hp;
    return hp;
  } else
    return NULL;
}


long sfseek(long count, short handle, short mode)
{ 
  if (valid_handle(handle) != NULL)
    return lseek(handle, count, mode);
  else
    return -1;
}


long sfread(short handle, long count, uchar *buf)
{
  if (valid_handle(handle) != NULL)
    return read(handle, buf, count);
  else
    return -1;
}


long sfwrite(short handle, long count, uchar *buf)
{
  if (valid_handle(handle) != NULL)
    return write(handle, buf, count);
  else
    return -1;
}

Static void sfclose_x(short *handle, boolean delete_it)
{
  flocktype *hp, *hpa;
  Char w[256];
  Char dname[256];

  hp = valid_handle(*handle);
  if (hp != NULL) {
    lastactivehandle = nohandle;
    lastactiveflock = NULL;

    hp = flockroot;
    hpa = NULL;
    while (hp != NULL && hp->handle != *handle) {
      hpa = hp;
      hp = hp->next;
    }

    *dname = '\0';
    *w = '\0';
    if (hp != NULL) {
      strcpy(dname, hp->name);
      flockprotocole(2, hp, w);
      if (hpa != NULL) {
	hpa->next = hp->next;
	Free(hp);
      } else {
	hpa = hp->next;
	Free(hp);
	flockroot = hpa;
      }
    } else
      flockprotocole(5, hp, w);
    close(*handle);
    if (delete_it && *dname != '\0')
      sfdelfile(dname);
  }

  *handle = nohandle;
}


void sfclose(short *handle)
{
  sfclose_x(handle, false);
}


void sfclosedel(short *handle)
{
  sfclose_x(handle, true);
}


void sfdispfilelist(short x, dispfilelistproc outproc)
{
  Char hs[256];
  flocktype *hp;

  hp = flockroot;
  while (hp != NULL) {
    flockp2s(hp, hs);
    outproc(x, hs);
    hp = hp->next;
  }
}


void chkopenfiles(long maxopen, Char *fn)
{
  /* maxopen in sekunden */
  flocktype *hp;
  long t2, ta;
  short handle;
  Char hs[256];

  t2 = maxopen * 200;
  ta = statclock();
  hp = flockroot;
  while (hp != NULL) {
    if (hp->attime + t2 >= ta) {  /* Zeit abgelaufen ... */
      hp = hp->next;
      continue;
    }
    /* protokoll schreiben ... */
    sprintf(hs, "%s timed out", hp->name);
    append(fn, hs, true);
    handle = hp->handle;
    hp = hp->next;
    sfclose(&handle);
  }
}

void _filesys_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;

  lastactivehandle = nohandle;
  lastactiveflock = NULL;
  flockroot = NULL;
#ifdef dpmacos
  StartupFilesysInit();
#endif
#ifdef dplinux
  nextptr = NULL;
#endif
}
