/* Output from p2c, the Pascal-to-C translator */
/* From input file "misc_os.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1995 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#include <unistd.h>

#define MISC_OS_G
#include "misc_os.h"


#ifndef HUFFMAN_H
#include "huffman.h"
#endif


/* ------------------------------------------------------------------ */

short kbshift(short i)
{
  return 0;
}


/* ************************************************************************ */


/* Ruft den Watchdog auf     */


Static long lastwdreset;


void dp_watchdog(short what, short value)
{
  boolean ok;
  long t;

  ok = true;
  if (what == 2) {  /*reset angefordert*/
    t = statclock();
    if (t - lastwdreset < 12000 && t > lastwdreset)   /* 1 min */
      ok = false;
    else
      lastwdreset = t;
  } else
    lastwdreset = 0;

  if (ok)
    linux_watchdog(what, value);
}




/* Ruft ein externes Programm auf, Name (auch mit Pfad) in PROG, Uebergabe-  */
/* parameter in PAR                                                          */

short call_prg(Char *prog, Char *par, Char *redir)
{
  int status;
  char string[256];

  if (prog[0] == '\0') return(-1);

  strcpy(string,prog);

  if (par[0] != '\0') {
      strcat(string," ");
      strcat(string,par);
  }

  if (redir[0] != '\0') {
      strcat(string," >");
      strcat(string,redir);
  }
  else strcat(string," >/dev/null");

  strcat(string," 2>&1");

  status = system(string);
#ifdef dpmacos
  return (status);
#endif
#ifdef dplinux
  return (statusconvert(status));
#endif
}


short exec_prg(Char *prog, Char *par, Char *redir)
{
  char string[256];

  if (prog[0] == '\0') return(-1);

  strcpy(string,prog);

  if (par[0] != '\0') {
      strcat(string," ");
      strcat(string,par);
  }

  if (redir[0] != '\0') {
      strcat(string," >");
      strcat(string,redir);
  }
  else strcat(string," >/dev/null");

  strcat(string," 2>&1");

  execl("/bin/sh","sh","-c",string, (char *) 0);

  return (0);
}



/* Ruft den LZH auf, Ein/Ausgabe ueber Dateien s1/s2 */

short huffpacker(boolean encode, Char *s1, Char *s2, boolean crlfconv)
{
  short ret;

  dp_watchdog(2, 4711);   /*watchdog resetten*/
  if (encode)
    ret = enchuf(s1, s2, crlfconv);
  else
    ret = dechuf(s1, s2, crlfconv);
  return ret;
}


/* Ruft den LZH auf, Eingabe im Speicher, Ausgabe bei genug RAM ebenfalls im */
/* RAM, ansonsten in Datei f2                                                */

short huffmempacker(boolean encode, uchar *mem, long size, uchar **rmem,
		    long *rsize, Char *f2, boolean crlfconv)
{
  short ret;
  long rr;

  dp_watchdog(2, 4711);   /* watchdog resetten */
  if (encode)
    ret = enchufmem(mem, size, (void **)rmem, &rr, f2, crlfconv);
  else
    ret = dechufmem(mem, size, (void **)rmem, &rr, f2, crlfconv);
  *rsize = rr;
  return ret;
}


/* ******************************************************************** */

void _misc_os_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}





/* End. */
