/*
 * This is Ping-Pong convers/conversd derived from the wampes
 * convers package written by Dieter Deyke <deyke@hpfcmdd.fc.hp.com>
 *
 * Modifications by Fred Baumgarten <dc6iq@insl1.etec.uni-karlsruhe.de>
 * $Revision: 3.12 $$Date: 1996/03/03 10:09:47 $
 */

#ifndef SOMAXCONN
#define SOMAXCONN       5
#endif

#ifndef WNOHANG
#define WNOHANG         1
#endif

#if defined(POSIX) || defined(PCFLEX)
#define FD_SET_TYPE fd_set
#endif

#ifndef FD_SET_TYPE
#define FD_SET_TYPE struct fd_set
#endif

#if defined(__TURBOC__) || defined(__STDC__)
#define __ARGS(x)       x
#ifndef __DOTS
#define __DOTS		,...
#endif
#else
#define __ARGS(x)       ()
#define const
#ifndef __DOTS
#define __DOTS
#endif
#endif

#ifndef min
#define min(a,b) ((a) >= (b) ? (b) : (a))
#define max(a,b) ((a) >= (b) ? (a) : (b))
#endif

#define MAXCHANNEL      32767
#define uchar(x) ((x) & 0xff)

#ifdef PCFLEX
#define PF_DEFAULT  PF_AX25
#else
#define PF_DEFAULT  0
#endif

struct mbuf {
  struct mbuf *next;
  char *data;
};

struct clist {
  int channel;			/* channel number */
  int channelop;		/* channel operator status */
  long time;			/* join time */
  struct clist *next;		/* pointer to next entry */
};

#define NULLCLIST ((struct clist *) 0)

struct connection {
  int type;                     /* Connection type */
#define CT_UNKNOWN      0
#define CT_USER         1
#define CT_HOST         2
#define CT_CLOSED       3
#ifndef PCFLEX
  char name[64];                /* Name of user or host */
  char host[64];                /* Name of host where user is logged on */
  char rev[64];                 /* revision of software (CT_HOST) */
#else
  char name[15];
  char host[15];
  char rev[15];
#endif
  struct connection *via;       /* Pointer to neighbor host */
  int channel;                  /* current channel number */
  struct clist *chan_list;	/* linked list of joined channels */
  long time;                    /* Connect time */
  int locked;                   /* Set if mesg already sent */
  int fd;                       /* Socket descriptor */
#define IBUF_SIZE 2048
  char *ibuf;			/* Pointer only !! */
  int icnt;                     /* Number of bytes in input buffer */
  struct mbuf *obuf;            /* Output queue */
  long received;                /* Number of bytes received */
  long xmitted;                 /* Number of bytes transmitted */
#ifndef PCFLEX
  char away[512];               /* Away string */
#else
  char away[60];
#endif
  int amprnet;			/* is it /..UDAT (1) or /..USER (0) ? */
  int oldaway;			/* is it the pre3.02 Version of away ? */
  long atime;                   /* time of last "away" state change */
  long mtime;                   /* time of last message receive */
#ifndef PCFLEX
  char pers[512];               /* Personal string */
#else
  char pers[80];
#endif
  int verbose;                  /* verbose mode */
  char prompt[4];               /* prompt mode */
#ifndef PCFLEX
  char query[64];               /* name of queried user */
  char notify[512];             /* List of calls you like to be notified */
#else
  char query[10];
  char notify[40];
#endif
  char *filter; 		/* filtered calls */
  int has_filter;
  time_t filter_time;		/* time filter was set */
  int charset_in;               /* charset - default ISO (ansi) */
  int charset_out;              /* charset - default ISO (ansi) */
  int channelop;		/* channel operator of current channel ? */
  int operator;			/* convers operator */
  long expected;		/* expected answer */
  int invitation_channel;	/* last invitation was from this channel */
  int width;			/* user screen width */
  time_t time_write;            /* XXX */
  int hcmd_sent;                /* /HOST already sent */
  struct connection *next;      /* Linked list pointer */
};

#define CM_UNKNOWN   (1 << CT_UNKNOWN)
#define CM_USER      (1 << CT_USER)
#define CM_HOST      (1 << CT_HOST)
#define CM_CLOSED    (1 << CT_CLOSED)

#define NULLCONNECTION  ((struct connection *) 0)

#define NR_PERMLINKS 20

struct permlink {
#ifndef PCFLEX
  char name[80];                /* Name of host */
#else
  char name[15];
#endif
  char socket[80];              /* Name of socket to connect to */
#ifndef PCFLEX
  char command[256];
#endif
  struct connection *connection;/* Pointer to associated connection */
  long statetime;               /* Time of last (dis)connect */
  int tries;                    /* Number of connect tries */
  long waittime;                /* Time between connect tries */
  long retrytime;               /* Time of next connect try */
  long testwaittime;            /* Time between tries */
  long testnexttime;            /* Time of next test */
  long rxtime;                  /* rtt by other side */
  long txtime;                  /* rtt found out by me */
  int quality;			/* quality of given link */
  int group;			/* link list group */
  int permanent;		/* this is a permanent entered link */
};

#define NULLPERMLINK  ((struct permlink *) 0)

extern struct permlink *permarray[NR_PERMLINKS];

struct destination {
#ifndef PCFLEX
  char name[80];		/* destination name */
  char rev[64];                 /* revision of software (CT_HOST) */
#else
  char name[15];
  char rev[15];
#endif
  struct permlink *link;	/* link to this destination */
  long rtt;			/* round trip time to this host */
  long last_sent_rtt;		/* last donwnstream sent rtt */
  int downstream[NR_PERMLINKS];	/* all up/downstream times */
  struct destination *next;	/* a one dimansional list is ok for now :-) */
};

#define NULLDESTINATION  ((struct destination *) 0)

struct channel {
  char name[80];		/* ascii name of channel */
  char topic[512];		/* topic of channel */
  long time;			/* when was the topic set ? */
  int chan;			/* integer value of channel (<32768 !) */
  int flags;			/* channel flags */
#define M_CHAN_S 0x01	/* secret channel - number invisible */
#define M_CHAN_P 0x02	/* private channel - only join by invitation */
#define M_CHAN_T 0x04	/* topic settable by operator only */
#define M_CHAN_I 0x08	/* invisible channel - only sysops can see */
#define M_CHAN_M 0x10	/* moderated channel - operators may talk */
#define M_CHAN_L 0x20	/* local channel - no forwarding */
  struct channel *next;		/* linked list again */
};

#define NULLCHANNEL  ((struct channel *) 0)

struct cmdtable {
  char *name;
  void (*fnc)();
  char *help;
  int states;
};

extern void appendstring __ARGS((struct connection *cp, const char *string));
extern void appendc __ARGS((struct connection *cp, const int n, const int ast));
extern void appendprompt __ARGS((struct connection *cp, const int ast));
extern void destroy_channel __ARGS((int number));
extern void free_connection __ARGS((struct connection *cp));
extern int queuelength __ARGS((const struct mbuf *bp));
extern void free_closed_connections __ARGS((void));
extern char *getarg __ARGS((char *line, int all));
extern char *getargcs __ARGS((char *line, int all));
extern char *formatline __ARGS((char *prefix, char *text, int linelen));
extern char *ts __ARGS((long gmt));
extern char *ts2 __ARGS((long gmt));
extern char *ts3 __ARGS((long seconds, char *buffer));
extern char *ts4 __ARGS((long seconds));
extern struct connection *alloc_connection __ARGS((int fd, int linuxbug));
extern void accept_connect_request __ARGS((int flisten));
extern void clear_locks __ARGS((void));
extern int count_user __ARGS((int channel));
extern void send_awaymsg __ARGS((char *name, char *host, long time, char *text, int channel));
extern void send_mode __ARGS((struct channel *chan));
extern void send_opermsg __ARGS((char *name, char *host, char *from, int channel));
extern void send_persmsg __ARGS((char *name, char *host, int channel, char *text, long time));
extern void send_topic __ARGS((char *name, char *host, long time, int channel, char *text));
extern void send_user_change_msg __ARGS((char *name, char *host, int oldchannel, int newchannel, char *pers, long time));
extern void send_msg_to_user __ARGS((char *fromname, char *toname, char *text));
extern void send_msg_to_channel __ARGS((char *fromname, int channel, char *text));
extern void send_invite_msg __ARGS((char *fromname, char *toname, int channel));
extern void log_user_change __ARGS((char *name, char *host, int oldchannel, int newchannel));
extern void update_destinations __ARGS((struct permlink *p, char *name, long rtt, char *rev));
extern struct permlink *update_permlinks __ARGS((char *name, struct connection *cp, int isperm));
extern void connect_permlinks __ARGS((void));
extern int get_hash __ARGS((char *name));
extern int whitelisted __ARGS((char *name));
extern char *sstrcpy __ARGS((char *dest, const char *src, unsigned int size));
extern void send_filter_msg __ARGS((char *name, char *host, time_t time, char *filter));

extern struct connection *connections;
extern struct permlink *permlinks;
extern struct permlink *notpermlinks;
extern struct destination *destinations;
extern struct channel *channels;

extern time_t boottime;
extern time_t currtime;
extern char myhostname[];
extern char userfile[];
extern char motdfile[];
extern char convtype[];
extern char myrev[];
extern char myfeatures[];
extern int amprnet;
extern unsigned int secretnumber;
#ifdef PCFLEX
extern char rootpath[];
#endif
