/****************************************************************************
*	   PREDICT: A satellite tracking/orbital prediction program         *
*		Copyright John A. Magliacane, KD2BD 1991-1999               *
*			Project started: 26-May-91                          *
*	   		  Last update: 17-Oct-99                            *
*****************************************************************************
* This program is used by PREDICT to annunciate satellite coordinates       *
* though the system's soundcard (/dev/dsp) using stored 8 kHz unsigned      *
* linear stored speech samples.  It is called as a background process.      *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.                                                                  *
*                                                                           *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.                                                         *
*                                                                           *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "vocalizer.h"

FILE *sd;

void saynumber(numstr)
char *numstr;
{
	int x, byte;
	FILE *fd;
	char filename[80];

	for (x=0; numstr[x]!=0; x++)
	{
		sprintf(filename,"%s%c",path,numstr[x]);
		fd=fopen(filename,"rb");

		byte=fgetc(fd);

		while (feof(fd)==0)
		{
			fputc(byte,sd);
			byte=fgetc(fd);
		}

		fclose(fd);
	}
}

void saydirection(dir)
char dir;
{
	int byte;
	char filenpath[80];
	FILE *fd;

	fd=NULL;

	if (dir=='+')
	{
		sprintf(filenpath,"%sapproaching",path);
		fd=fopen(filenpath,"rb");
	}

	if (dir=='-')
	{
		sprintf(filenpath,"%sreceding",path);
		fd=fopen(filenpath,"rb");
	}

	if (fd!=NULL)
	{
		byte=fgetc(fd);

		while (feof(fd)==0)
		{
			fputc(byte,sd);
			byte=fgetc(fd);
		}

		fclose(fd);
	}
}

void sayfile(name)
char *name;
{
	int byte;
	char filename[40];
	FILE *fd;

	sprintf(filename,"%s%s",path,name);
	fd=fopen(filename,"rb");

	if (fd!=NULL)
	{
		byte=fgetc(fd);

		while (feof(fd)==0)
		{
			fputc(byte,sd);
			byte=fgetc(fd);
		}

		fclose(fd);
	}
}

int main(argc,argv)
int argc;
char *argv[];
{
	sd=fopen("/dev/dsp","wb");

	if (argc>=3 && sd!=NULL)
	{
		sayfile("intro");

		saynumber(argv[1]);
		sayfile("azimuth");

		saynumber(argv[2]);
		sayfile("elevation");

		if (argc==4)
			saydirection(argv[3][0]);

		fclose(sd);
		exit(0);
	}

	else
		exit(-1);
}
