#define VERSION		"LinuxNode v0.1.12"

#define STATE_IDLE	0
#define STATE_TRYING	1
#define STATE_CONNECTED	2
#define STATE_PINGING	3
#define STATE_EXTCMD	4

#define PERM_LOGIN		1	/* Permit login			*/
#define PERM_AX25		2	/* AX.25 gatewaying		*/
#define PERM_NETROM		4	/* NETROM gatewaying		*/
#define PERM_TELNET_LOCAL	8	/* Telnet to "local" hosts	*/
#define PERM_TELNET_AMPR	16	/* Telnet to 44.xx.xx.xx hosts	*/
#define PERM_TELNET_INET	32	/* Telnet to other hosts	*/
#define PERM_HIDDEN		64	/* Use hidden ports		*/

#define PERM_TELNET (PERM_TELNET_LOCAL & PERM_TELNET_AMPR & PERM_TELNET_INET)

struct user
{
	int		pid;
	int		fd;
	unsigned short	ul_type;
	unsigned short	dl_type;
	long		logintime;
	long		cmdtime;
	unsigned char	state;
	char		call[10];
	char		ul_name[32];
	char		dl_name[32];
	char    	dl_port[32];
};

extern struct user User;

extern char NrId[20];

extern long IdleTimeout;
extern long ConnTimeout;
extern char *HostName;
extern char *CallServer;
extern int ReConnectTo;

struct cmd {
	char	*name;
	int	(*function)	(int argc, char **argv);
};

extern struct cmd Nodecmds[];

struct alias {
	char		*name;
	char		*command;

	struct alias	*next;
};

extern struct alias *Aliases;

struct ecmd {
	char		*name;
	unsigned char	flags;
	unsigned char	ok;
	int		uid;
	int		gid;
	char		*path;
	char		*argv[32];

	struct ecmd     *next;
};

extern struct ecmd *Extcmds;

/* in main.c */
extern void node_perror(char *str, int err);
extern char *print_node(const char *alias, const char *call);
extern int parse_args(char *argv[],char *cmd);
extern int cmdparse(struct cmd *cmds, char *cmdline);

/* in user.c */
extern void login_user(void);
extern void logout_user(void);
extern void update_user(void);
extern int user_list(int argc, char **argv);

/* in config.c */
extern int is_hidden(const char *port);
extern int check_perms(int what, unsigned long peer);
extern char *read_perms(char *user, int family, unsigned long peer, char *port);
extern int read_config(void);

/* in command.c */
extern int do_bye(int argc, char **argv);
extern int do_mheard(int argc, char **argv);
extern int do_help(int argc, char **argv);
extern int do_ports(int argc, char **argv);
extern int do_links(int argc, char **argv);
extern int do_routes(int argc, char **argv);
extern int do_nodes(int argc, char **argv);

/* in gateway.c */
extern int do_connect(int argc, char **argv);
extern int do_finger(int argc, char **argv);
extern int do_ping(int argc, char **argv);

/* in extcmd.c */
extern int extcmd(struct ecmd *ep, char *cmdline);
