/*
 * broadcast.h
 *
 * broadcats protocol structures and defines
 *
 */

typedef struct
{
	int CRCError;
	int VersionError;
} BROADCASTSTATS;

/* protocol ids */
#define NOPROTOCOL         0xF0
#define BROADCASTFILE      0xBB
#define BROADCASTDIRECTORY 0xBD

#define VERSION      0
#define VERSIONMASK  0x0C

typedef struct HOLESTRUCT
{
  struct HOLESTRUCT * pPrev;
  struct HOLESTRUCT * pNext;
  unsigned long start;
  unsigned long finish;
} HOLE;
typedef HOLE * LPHOLE;

typedef struct BCFILESTRUCT
{
  struct BCFILESTRUCT *   pPrev;
  struct BCFILESTRUCT *   pNext;
  unsigned long     fileId;
  int     bHeaderReceived;
  unsigned long   fileSize;
  unsigned long   fileReceived;
  int      nHoles;
  LPHOLE   pFirstHole;
  int hFile;
} BCFILE;
typedef BCFILE * LPBCFILE;

typedef struct
  {
  /* required Header Information */
  unsigned long fileId;              /* 0x01 */
  char          fileName[9];         /* 0x02 */
  char          fileExt[4];          /* 0x03 */
  unsigned long fileSize;            /* 0x04 */
  unsigned long createTime;          /* 0x05 */
  unsigned long modifiedTime;        /* 0x06 */
  unsigned char SEUflag;             /* 0x07 */
  unsigned char fileType;            /* 0x08 */
  unsigned int  bodyCRC;             /* 0x09 */
  unsigned int  headerCRC;           /* 0x0A */
  unsigned int  bodyOffset;          /* 0x0B */

  /* Extended Header Information */
  char          source[33];          /* 0x10 */
  char          uploader[7];         /* 0x11 */
  unsigned long uploadTime;          /* 0x12 */
  unsigned char downloadCount;       /* 0x13 */
  char          destination[33];     /* 0x14 */
  char          downloader[7];       /* 0x15 */
  unsigned long downloadTime;        /* 0x16 */
  unsigned long expireTime;          /* 0x17 */
  unsigned char priority;            /* 0x18 */
  unsigned char compression;         /* 0x19 */
  char          BBSMessageType;      /* 0x20 */
  char          BID[33];             /* 0x21 */
  char          title[33];           /* 0x22 */
  char          keyWords[33];        /* 0x23 */
  char          description[33];     /* 0x24 */
  char          compressionDesc[33]; /* 0x25 */
  char          userFileName[33];    /* 0x26 */
  } FILEHEADER;

typedef FILEHEADER * LPFILEHEADER;

void BroadcastFrame( unsigned char PID, char * ax5Frame, int dataOffset, int nFrame );
void BroadcastFile( char * ax5Frame, int dataOffset, int nFrame );
LPBCFILE FindFile( int fileId );
void LoadHoleFile( int hHoleFile, LPBCFILE pFile );
void FillFileHole( LPBCFILE pFile, char * ax25Frame, int start, int finish, int dataOffset );
int GetFileLength( char * pHeader, int nHeader );
void SaveBroadcastFiles( void );
void BroadcastDirectory( char * ax25Frame, int dataOffset, int nFrame );
int CheckCRC( char * pFrame, int nFrame );

