/* totals.c - Report tool for use with STATS AX.25 monitor program.
   This module is part of totals.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "monfile.h"


/* configuration constants */

#define MAX_CIRCUIT 	400	/* number of entrys in circuit table	 */
#define MAX_DIGIS 	100	/* number of entrys in digi table	 */

#define FALSE 	0
#define TRUE 	!FALSE

struct TOTALS {
	char call[10];
	unsigned long rx_tbytes;		/* total bytes */
	unsigned long rx_udbytes;		/* unique data bytes */
	unsigned long rx_ndbytes;		/* non-digi data bytes */
	unsigned long rx_tdbytes;		/* total data bytes */
	unsigned long tx_tbytes;		/* total bytes */
	unsigned long tx_udbytes;		/* unique data bytes */
	unsigned long tx_ndbytes;		/* non-digi data bytes */
	unsigned long tx_tdbytes;		/* total data bytes */
} total[MAX_CIRCUIT];

struct DIGI_TOTALS{
	char call[10];
	unsigned long bytes;
	unsigned long packets;
} digi_tab[MAX_DIGIS];

struct FREQ_RECORD freq ={0,0,0,0,0,0,0,0,0,0,0};


int	nr_digis = 0;
int	nr_calls = 0;

int	dnum;
int	cnum;

char	line[160];

extern char *strupr();
int compare(),d_compare();
void do_time(),do_freq(),do_circuit(),do_digi(),find_call(),find_digi();

char *sel_call;
int sel_flag=0;
unsigned long recnum=1;

int
main (argc, argv)
int	argc;
char	*argv[];
{
	char c;
	int i;

	if (argc==2) {
		sel_flag=1;
		sel_call = argv[1];
		strupr(sel_call);
		fprintf(stderr,"Collecting data for circuits including %s only.\n",
			sel_call);
		}

	fprintf(stderr,"Totaling ...\n");
	while(!feof(stdin)){
		switch(c = getc(stdin)){
			case 'T':
				do_time();
				break;

			case 'F':
				do_freq();
				break;

			case 'C':
				do_circuit();
				break;

			case 'D':
				do_digi();
				break;

			default:
				fprintf(stderr,"Error: Unknown record type '%c'.\n",c);
				fprintf(stderr,"Line ignored.\n");
				break;
		}
	recnum++;
	}
/*	close(fp);*/
	if (sel_flag) {
		find_call(sel_call);
		fprintf(stdout,"Z,%s,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld\n",
			total[cnum].call,
			total[cnum].rx_tbytes,
			total[cnum].rx_udbytes,
			total[cnum].rx_ndbytes,
			total[cnum].rx_tdbytes,
			total[cnum].tx_tbytes,
			total[cnum].tx_udbytes,
			total[cnum].tx_ndbytes,
			total[cnum].tx_tdbytes);
		}

	fprintf(stderr,"\rSorting ...    \n");
	qsort(&total[0],nr_calls,sizeof(struct TOTALS),compare);
	qsort(&digi_tab[0],nr_digis,sizeof(struct DIGI_TOTALS),d_compare);
	fprintf(stderr,"Writing TOTAL file...\n");
/*	if(!(fp = fopen("TOTAL","w"))){
		printf("Fatal error: can't open TOTAL file\n");
		exit(1);
	}
*/
	fprintf(stdout,"F,%lu,%lu,%lu,",freq.t_packets,freq.t_bytes,freq.u_packets);
	fprintf(stdout,"%lu,%lu,%lu,",freq.u_bytes,freq.l32,freq.l64);
	fprintf(stdout,"%lu,%lu,%lu,",freq.l128,freq.l256,freq.g256);
	fprintf(stdout,"%lu,%lu\n",freq.dcd_on_ticks,freq.dcd_off_ticks);
	for(i=0; i < nr_digis; i++){
		fprintf(stdout,"D,%s,%ld,",digi_tab[i].call,digi_tab[i].bytes);
		fprintf(stdout,"%ld\n",digi_tab[i].packets);
	}

	for(i=0; i < nr_calls; i++){
		if ((!sel_flag) || (strcmp(sel_call,total[i].call)!=0)) {
		  fprintf(stdout,"S,%s,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld\n",
			total[i].call,
			total[i].rx_tbytes,
			total[i].rx_udbytes,
			total[i].rx_ndbytes,
			total[i].rx_tdbytes,
			total[i].tx_tbytes,
			total[i].tx_udbytes,
			total[i].tx_ndbytes,
			total[i].tx_tdbytes);
			}

	}
/*	fclose(fp);*/

	return(0);
}

void
do_time()
{
	fgets(line,160,stdin);
}

void
do_freq()
{
	unsigned long t_packets;	/* total packets */
	unsigned long t_bytes;		/* total bytes */
	unsigned long u_packets;	/* unique packets */
	unsigned long u_bytes;		/* unique bytes */
	unsigned long l32;		/* <=32 */
	unsigned long l64;		/* <=64 */
	unsigned long l128;		/* <=128 */
	unsigned long l256;		/* <=256 */
	unsigned long g256;		/* > 256 */
	unsigned long dcd_on_ticks;	/* ticks when DCD was on */
	unsigned long dcd_off_ticks;	/* ticks when DCD was off */

	fscanf(stdin,",%ld,%ld,%ld,%ld,",&t_packets,&t_bytes,&u_packets,&u_bytes);
	fscanf(stdin,"%ld,%ld,%ld,%ld,%ld,",&l32,&l64,&l128,&l256,&g256);
	fscanf(stdin,"%ld,%ld\n",&dcd_on_ticks,&dcd_off_ticks);
	
	freq.t_packets += t_packets;
	freq.t_bytes += t_bytes;
	freq.u_packets += u_packets;
	freq.u_bytes += u_bytes;
	freq.l32 += l32;
	freq.l64 += l64;
	freq.l128 += l128;
	freq.l256 += l256;
	freq.g256 += g256;
	freq.dcd_on_ticks += dcd_on_ticks;
	freq.dcd_off_ticks += dcd_off_ticks;
}

void
do_circuit()
{
	char to[10],from[10];
	int digis,pid;
	unsigned long u_dpackets,nd_dpackets,t_dpackets;
	unsigned long nd_packets,t_packets,u_dbytes;
	unsigned long nd_dbytes,t_dbytes,nd_bytes,t_bytes;
	unsigned long c_time,sabm,ua,disc,dm,rej,rr,rnr,i,ui;
	unsigned long frmr,poll,final,l32,l64,l128,l256,g256;
	
	fscanf(stdin,",%[^,],%[^,],%d,",to,from,&digis);
	fscanf(stdin,"%d,",&pid);
	fscanf(stdin,"%lu,%lu,",&u_dpackets,&nd_dpackets);
	fscanf(stdin,"%lu,%lu,",&t_dpackets,&nd_packets);
	fscanf(stdin,"%lu,%lu,",&t_packets,&u_dbytes);
	fscanf(stdin,"%lu,",&nd_dbytes);
	fscanf(stdin,"%lu,%lu,",&t_dbytes,&nd_bytes);
	fscanf(stdin,"%lu,",&t_bytes);
	fscanf(stdin,"%lu,",&c_time);
	fscanf(stdin,"%lu,%lu,%lu,",&sabm,&ua,&disc);
	fscanf(stdin,"%lu,%lu,%lu,",&dm,&rej,&rr);
	fscanf(stdin,"%lu,%lu,",&rnr,&i);
	fscanf(stdin,"%lu,%lu,",&ui,&frmr);
	fscanf(stdin,"%lu,%lu,%lu,",&poll,&final,&l32);
	fscanf(stdin,"%lu,%lu,%lu,",&l64,&l128,&l256);
	fscanf(stdin,"%lu\n",&g256);

	if (sel_flag) {
		if ((strcmp(sel_call,to)!=0) && (strcmp(sel_call,from)!=0))
			return;
		}

	if (t_dbytes > t_bytes) {
		fprintf(stderr,"\nDbytes > Tbytes in rec %lu - record discarded\n",recnum);
		return;
		}
	if (u_dbytes > nd_dbytes) {
		fprintf(stderr,"\nUbytes > ndbytes in rec %lu - fixed\n",recnum);
		nd_dbytes = u_dbytes;
		}

	find_call(to);
	total[cnum].rx_tbytes += t_bytes;
	total[cnum].rx_udbytes += u_dbytes;
	total[cnum].rx_ndbytes += nd_dbytes;
	total[cnum].rx_tdbytes += t_dbytes;

	find_call(from);

	total[cnum].tx_tbytes += t_bytes;
	total[cnum].tx_udbytes += u_dbytes;
	total[cnum].tx_ndbytes += nd_dbytes;
	total[cnum].tx_tdbytes += t_dbytes;

}

void
do_digi()
{
	unsigned long packets,bytes;
	char call[10];

	fscanf(stdin,",%[^,],%ld,%ld\n",call,&packets,&bytes);
	find_digi(call);
	digi_tab[dnum].bytes += bytes;
	digi_tab[dnum].packets += packets;	
}

void
find_call(call)
char *call;
{
	int i;

	for(i = 0; i < nr_calls; i++){
		if(!strcmp(total[i].call,call)){
			cnum = i;
			return;
		}
	}
	if(i == MAX_CIRCUIT){
		fprintf(stderr,"Fatal error: circuit table is full!\n");
		exit(1);
	}
	nr_calls++;
	fprintf(stderr,"\r%-3d %-9s",nr_calls,call);
	cnum = i;
	strcpy(total[i].call,call);
	total[i].rx_tbytes =
	total[i].rx_udbytes =
	total[i].rx_ndbytes =
	total[i].rx_tdbytes =
	total[i].tx_tbytes =
	total[i].tx_udbytes =
	total[i].tx_ndbytes =
	total[i].tx_tdbytes = 0l;

}

void
find_digi(call)
char *call;
{
	int i;

	for(i = 0; i < nr_digis; i++){
		if(!strcmp(digi_tab[i].call,call)){
			dnum = i;
			return;
		}
	}
	if(i == MAX_DIGIS){
		fprintf(stderr,"Fatal error: digi table is full!\n");
		exit(1);
	}
	nr_digis++;
	strcpy(digi_tab[i].call,call);
	dnum = i;
	digi_tab[i].bytes =
	digi_tab[i].packets = 0l;
}

int compare(arg1,arg2)
struct TOTALS *arg1,*arg2;
{
	long tmp;
	if (sel_call) tmp = arg1->rx_tbytes - arg2->rx_tbytes;
	else tmp = arg1->tx_tbytes - arg2->tx_tbytes;

	if(!tmp)
		return 0;

	if(tmp < 0)	 	/* sort in reverse order */
		return 1;
	else
		return -1;
}

int d_compare(arg1,arg2)
struct DIGI_TOTALS *arg1,*arg2;
{
	long tmp;
	tmp = arg1->bytes - arg2->bytes;

	if(!tmp)
		return 0;

	if(tmp < 0)	 	/* sort in reverse order */
		return 1;
	else
		return -1;
}
