.TH SUDO 8
.SH NAME
sudo, visudo \- execute a command as the superuser and edit the sudoers file

.SH SYNOPSIS
.B sudo
-V | -h | -v | -k |
.I <command>
.sp
.B visudo
[-V]

.SH DESCRIPTION
.I Sudo
allows a permitted user to execute a 
.I command 
as the superuser.
.I Sudo 
determines who is an authorized user by consulting the file
.I /etc/sudoers.
By giving
.I sudo
the
.I -v
flag a user can update the time stamp without running a command.
The password prompt itself will also time out if the password is
not entered with N minutes (again, this is defined at installation
time and defaults to 5 minutes).

The
.I sudoers
file is composed of an optional host alias section, an optional command
alias section and the user specification section. All command or host
aliases need to start with their respective keywords (Host_Alias/Cmnd_Alias).
Note that only the first occurrance of a user name will be significant in
the user specification section.

.nf
user specification format: 
  user access_group [: access_group] ...

    access_group ::= host_type = [op]cmnd_type [,[op]cmnd_type] ... 
       host_type ::= a lower-case host name OR a host alias.
       cmnd_type ::= an command OR a command alias.
              op ::= the logical '!' NOT operator.

host alias section format:
  Host_Alias HOSTALIAS = host-list

      Host_Alias ::= a keyword.
       HOSTALIAS ::= an upper-case alias name.
       host-list ::= a comma separated list of hosts/addresses/networks.

command alias section format:
  Cmnd_Alias CMNDALIAS = cmnd-list

      Cmnd_Alias ::= a keyword.
       CMNDALIAS ::= an upper-case alias name.
       cmnd-list ::= a comma separated list commands.

Text after a pound sign '#' is considered a comment.
Long lines can be newline escaped with the backslash '\\' character.
The reserved alias 'ALL' can be used for both {Host,Cmnd}_Alias'.
    DO NOT define an alias of 'ALL', it will NOT be used.
    Note that 'ALL' implies the entire universe of hosts/commands.
    You can subtract elements from the universe by using the syntax:
       user  host=ALL,!ALIAS1,!/etc/halt...
.fi

Examples

    # Host alias specification
    Host_Alias  HUB=houdini.rootgroup.com:\\
                REMOTE=merlin,kodiakthorn,spirit
    Host_Alias  MACHINES=kalkan,alpo,milkbones,128.138.199.1
    Host_Alias  SERVERS=houdini,merlin,kodiakthorn,spirit
    Host_Alias  CSNETS=128.138.243.0,128.138.204.0,128.138.242.0

    # Command alias specification
    Cmnd_Alias  LPCS=/usr/etc/lpc,/usr/ucb/lprm
    Cmnd_Alias  SHELLS=/bin/sh,/bin/csh,/bin/tcsh
    Cmnd_Alias  MISC=/bin/rm,/bin/cat:\\
                SHUTDOWN=/etc/halt,/etc/shutdown

    # User specification
    britt       REMOTE=SHUTDOWN:ALL=LPCS
    robh        ALL=ALL,!SHELLS
    nieusma     SERVERS=SHUTDOWN,/etc/reboot:\\
                HUB=ALL,!SHELLS
    jill        houdini.rootgroup.com=/etc/shutdown,MISC
    markm       HUB=ALL,!MISC,!/etc/shutdown,!/etc/halt
    billp       ALL=/usr/local/bin/top:MACHINES=SHELLS
    davehieb    merlin=ALL:SERVERS=/etc/halt:\\
                kodiakthorn=ALL
    steve       CSNETS=/usr/su_commands/

The above
.I sudoers
file specification is composed of 4 host alias specifications, 3
command alias specifications and 8 user specifications.  Britt is
permitted to execute /etc/halt, /etc/shutdown, /usr/etc/lpc and
/usr/ucb/lprm on the REMOTE machines (merlin, kodiakthorn, and
spirit).  Robh is permitted to execute any command except for the group
of SHELL commands on any machine.  Jill is permitted to execute
/etc/shutdown, /bin/rm, and /bin/cat on houdini.  Davehieb can execute
any command on machines merlin and kodiakthorn and can halt the
SERVERS.  Steve can run any command located in the directory
/usr/su_commands on all machines on the subnets listed in OURNETS.

The
.I sudoers
file SHOULD be edited by the 
.I visudo 
command which locks the file and does gramatical checking. This provides
a mechanism for the prevention of stupid syntax errors.

Sudo was designed to log via the 4.3 BSD syslogging facility but
can log to a file instead if so desired.

If an unauthorized user executes sudo, mail will be sent from the user to 
the local authorities (defined at installation time).

All preferences are defined at installation time and are derived from
the sudo.h include file and the Makefile.

.SH OPTIONS
.I sudo
accepts the following command line options:
.IP -V
The -V (version) option causes sudo (or visudo) to print the version number
and exit.
.IP -h
The -h (help) option causes sudo to print the version of sudo and a usage
message before exiting.
.IP -v
If given the -v (validate) option, sudo will update the user's timestamp file,
prompting for a password if necesary.  This extends the sudo timeout
to for another N minutes (where N is defined at installation time and defaults
to 5 minutes) but does not run a command.
.IP -k
The -k (kill) option to sudo removes the user's timestamp file, thus
requiring a password the next time
.I sudo
is run.  This option does not require and password and was added to
allow a user to revoke sudo permissions from a .logout file.

.SH RETURN VALUES
.I sudo
quits with an exit value of 1 if there is a configuration/permission problem
or if
.I sudo
cannot execute the given command.  In the latter case the error string is
printed to stdout via
.I perror(3).
If sudo cannot
.I stat(3)
one or more entries in the user's PATH the error is printed on stdout via
.I perror(3).
(If the directory does not exist or if it is not really a directory, the
entry is ignored and no error is printed.)  This should not happen under
normal circumstances.  The most common reason for
.I stat(3)
to return "permission denied" is if you are running an automounter and
one of the directories in your PATH is on a machine that is currently
unreachable.

.SH SECURITY NOTES
.I sudo
tries to be safe when executing external commands.  To this end
LD_* and SHLIB_PATH (on hpux only) environmental variables are removed
from the environment passed on to all commands executed.
.sp
Also,
.I sudo
checks '.' and '' (both denoting current directory) last when searching for
a command in the user's PATH (if one or both are in the PATH).
Note, however, that the actual PATH environmental variable is
.I not
modified and is passed unchanged to the program that
.I sudo
executes.
.sp
For security reasons, if your OS supports shared libraries, sudo should always
be statically linked.
.SH FUTURE ENHANCEMENTS
.nf
Allow nesting of host and command aliases.
Allow the host specifier in the sudoers file
    to use universe notation (user ALL,!SERVERS, ... = commands).
Allow user aliases in the sudoers file (like host/command aliases).
Allow alias nesting.
Have visudo do more extensive checking on the sudoers file.
.fi

.SH FILES
.nf
/etc/sudoers                 file of authorized users.
/etc/stmp                    lock file for visudo.
/usr/local/bin/sudo          the executable itself.
/usr/local/etc/visudo        utility for modifying the sudoers file.
.fi

.SH ENVIRONMENT VARIABLES
.nf
SUDO_USER                    Set to the login of the user who invoked sudo
SUDO_UID                     Set to the uid of the user who invoked sudo
.fi

The following are used only if
.I visudo
was compiled with the ENV_EDITOR option:
.nf

EDITOR                       Used by visudo as the editor to use.
VISUAL                       Used by visudo if EDITOR is not set.
.fi

.SH AUTHORS
Many people have worked on
.I sudo
over the years, this version is done by:
.nf

Jeff Nieusma                 <nieusma@csn.org>
David Hieb                   <davehieb@csn.org>

See the HISTORY file in the sudo distribution for more details.
.fi

Please send all bugs, comments, and changes to sudo-bugs@cs.colorado.edu.

.SH DISCLAIMER
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
675 Mass Ave, Cambridge, MA 02139, USA.

.SH CAVEATS
There is no easy way to prevent a user from gaining a root shell if 
that user has access to commands that are shell scripts or that 
allow shell escapes.

.SH BUGS
The
.I -V
flag gives the version of the
.I sudo
package rather than the individual
.I sudo
or
.I visudo
program.

.SH SEE ALSO
su(1)
