/* 
 * The modifications to support SSLeay were done by Tim Hudson
 * tjh@mincom.oz.au
 *
 * You can do whatever you like with these patches except pretend that
 * you wrote them. 
 *
 * Email ssl-users-request@mincom.oz.au to get instructions on how to
 * join the mailing list that discusses SSLeay and also these patches.
 *
 */

/* Note: I've changed the handling of varadic functions in here as 
 *       before varargs was *not* being used ... and this is rather 
 *       silly! --tjh
 */

/*
 * Copyright (c) 1985, 1988, 1990 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1985, 1988, 1990 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)ftpd.c	5.40 (Berkeley) 7/2/91";
#endif /* not lint */

/*
 * FTP server.
 */

#if defined(SOLARIS2) || defined(IRIX)
#ifndef USE_STDARG
#define USE_STDARG
#endif /* USE_STDARG */
#endif

#include <stdio.h>

#if !defined(_STDARG_H) && !defined(__STDARG_H__) && !defined(USE_STDARG)
#include <varargs.h>
#else
#ifndef USE_STDARG
#define USE_STDARG
#endif
#include <stdarg.h>
#endif /* _STDARG_H || __STDARG_H__ */

#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>

#ifdef SOLARIS2
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#define L_INCR SEEK_CUR
#endif

#include <netinet/in.h>
#ifndef LINUX
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif

#define	FTP_NAMES
#include <arpa/ftp.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>

#include <signal.h>
#include <dirent.h>
#include <fcntl.h>
#include <time.h>
#include <pwd.h>
#include <setjmp.h>
#include <netdb.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#ifndef SOLARIS2
#include <strings.h>
#endif

#include "pathnames.h"

#ifdef USE_SSL

#include "rsa.h"        /* extra ... */
/*
#include "asn1.h"
*/
#include "x509.h"
#include "pem.h"
#include "ssl.h"
/*
#include "ssl_err.h"
*/

SSL *ssl_con;
SSL_CTX *ssl_ctx;
SSL *ssl_data_con;
int ssl_debug_flag=0;
int ssl_only_flag=0;
int ssl_active_flag=0;
int ssl_secure_flag=0;
int ssl_verify_flag=SSL_VERIFY_NONE;
int ssl_certsok_flag=0;
int ssl_auto_login=0;

static char *auth_ssl_name=NULL;


int ssl_data_active_flag=0;

/* for the moment this is a compile time option only --tjh */
int ssl_encrypt_data=1;

char ssl_file_path[1024];    /* don't look at that nasty value to the left */

X509 *ssl_public_cert;
RSA *ssl_private_key;

static char *my_ssl_key_file=NULL;
static char *my_ssl_cert_file=NULL;

#include "ssl_port.h"

#endif /* USE_SSL */

#ifdef USE_STDARG
int reply(int n,...);
int lreply(int n, ...);
#else
int reply();
int lreply();
#endif

/*
 * File containing login names
 * NOT to be used on this machine.
 * Commonly used to disallow uucp.
 */
extern	int errno;
extern	char *crypt();
extern	char version[];
extern	char *home;		/* pointer to home directory for glob */
extern	FILE *ftpd_popen(), *fopen(), *freopen();
extern	int  ftpd_pclose(), fclose();
extern FILE *popen();
extern int pclose();
extern	char *getline();
extern	char cbuf[];
extern	off_t restart_point;

struct	sockaddr_in ctrl_addr;
struct	sockaddr_in data_source;
struct	sockaddr_in data_dest;
struct	sockaddr_in his_addr;
struct	sockaddr_in pasv_addr;

int	data;
jmp_buf	errcatch, urgcatch;
int	logged_in;

struct	passwd *pw;
int	debug;
int	timeout = 900;    /* timeout after 15 minutes of inactivity */
int	maxtimeout = 7200;/* don't allow idle time to be set beyond 2 hours */
int	logging;
int	guest;
int	type;
int	form;
int	stru;			/* avoid C keyword */
int	mode;
int	usedefault = 1;		/* for data transfers */
int	pdata = -1;		/* for passive mode */
int	transflag;
off_t	file_size;
off_t	byte_count;
#if !defined(CMASK) || CMASK == 0
#undef CMASK
#define CMASK 027
#endif
int	defumask = CMASK;		/* default umask value */
char	tmpline[7];
char	hostname[MAXHOSTNAMELEN];
char	remotehost[MAXHOSTNAMELEN];

/*
 * Timeout intervals for retrying connections
 * to hosts that don't accept PORT cmds.  This
 * is a kludge, but given the problems with TCP...
 */
#define	SWAITMAX	90	/* wait at most 90 seconds */
#define	SWAITINT	5	/* interval between retries */

int	swaitmax = SWAITMAX;
int	swaitint = SWAITINT;

void	lostconn(), myoob();
FILE	*getdatasock(), *dataconn();

#ifdef SETPROCTITLE
char	**Argv = NULL;		/* pointer to argument vector */
char	*LastArgv = NULL;	/* end of argv */
char	proctitle[BUFSIZ];	/* initial part of title */
#endif /* SETPROCTITLE */

main(argc, argv, envp)
	int argc;
	char *argv[];
	char **envp;
{
	int addrlen, on = 1, tos;
	char *cp;
	char *optarg;

	/*
	 * LOG_NDELAY sets up the logging connection immediately,
	 * necessary for anonymous ftp's that chroot and can't do it later.
	 */
	openlog("ftpd", LOG_PID | LOG_NDELAY, LOG_DAEMON);
	addrlen = sizeof (his_addr);
	if (getpeername(0, (struct sockaddr *)&his_addr, &addrlen) < 0) {
		syslog(LOG_ERR, "getpeername (%s): %m",argv[0]);
		exit(1);
	}
	addrlen = sizeof (ctrl_addr);
	if (getsockname(0, (struct sockaddr *)&ctrl_addr, &addrlen) < 0) {
		syslog(LOG_ERR, "getsockname (%s): %m",argv[0]);
		exit(1);
	}
#ifdef IP_TOS
#ifdef IPTOS_LOWDELAY
	tos = IPTOS_LOWDELAY;
	if (setsockopt(0, IPPROTO_IP, IP_TOS, (char *)&tos, sizeof(int)) < 0)
		syslog(LOG_WARNING, "setsockopt (IP_TOS): %m");
#endif
#endif
	data_source.sin_port = htons(ntohs(ctrl_addr.sin_port) - 1);
	debug = 0;
#ifdef SETPROCTITLE
	/*
	 *  Save start and extent of argv for setproctitle.
	 */
	Argv = argv;
	while (*envp)
		envp++;
	LastArgv = envp[-1] + strlen(envp[-1]);
#endif /* SETPROCTITLE */

	argc--, argv++;
	while (argc > 0 && *argv[0] == '-') {
	        optarg=*(argv+1);
		for (cp = &argv[0][1]; *cp; cp++) switch (*cp) {

		case 'v':
			debug = 1;
			break;

		case 'd':
			debug = 1;
			break;

		case 'l':
			logging = 1;
			break;

		case 't':
			timeout = atoi(++cp);
			if (maxtimeout < timeout)
				maxtimeout = timeout;
			goto nextopt;

		case 'T':
			maxtimeout = atoi(++cp);
			if (timeout > maxtimeout)
				timeout = maxtimeout;
			goto nextopt;

		case 'u':
		    {
			int val = 0;

			while (*++cp && *cp >= '0' && *cp <= '9')
				val = val*8 + *cp - '0';
			if (*cp)
				fprintf(stderr, "ftpd: Bad value for -u\n");
			else
				defumask = val;
			goto nextopt;
		    }

#ifdef USE_SSL
                case 'z':
		        if (strcmp(optarg, "debug") == 0 ) {
			    ssl_debug_flag=1;
			}
		        if (strcmp(optarg, "ssl") == 0 ) {
			    ssl_only_flag=1;
			}
		        if (strcmp(optarg, "secure") == 0 ) {
			    ssl_secure_flag=1;
			}
                        if (strcmp(optarg, "certsok") == 0) {
                            ssl_certsok_flag=1;
                        }
		        if (strncmp(optarg, "verify=", strlen("verify=")) == 0 ) {
			    ssl_verify_flag=atoi(optarg+strlen("verify="));

			}
		        if (strncmp(optarg, "cert=", strlen("cert=")) == 0 ) {
			    my_ssl_cert_file=optarg+strlen("cert=");
			}
		        if (strncmp(optarg, "key=", strlen("key=")) == 0 ) {
			    my_ssl_key_file=optarg+strlen("key=");
			}
			/* we have swallowed an extra arg */
			argc--;
			argv++;
			break;
#endif /* USE_SSL */

		default:
			fprintf(stderr, "ftpd: Unknown flag -%c ignored.\n",
			     *cp);
			break;
		}
nextopt:
		argc--, argv++;
	}

#ifdef USE_SSL
        /* make sure we have access to the required certificate
	 * and key files now ... before we perhaps chroot and 
	 * do the other "muck" for anon-ftp style setup ... though
	 * why we want to run SSL for anon I don't know
	 */

        {
            int i;
	    FILE *fp;
            char *filename;

            /* if we are not running in debug then any error
             * stuff from SSL debug *must* not go down
             * the socket (which 0,1,2 are all pointing to by
             * default)
             */
            if (ssl_debug_flag) {
		(void)freopen("ftpd.err","w",stderr);
		SSL_ERR=stderr;
		SSL_LOG=NULL;
                SSL_debug("ftpd.log");
		if (SSL_LOG==NULL) {
		    SSL_LOG=fopen("ftpd.log","w");
		    if (SSL_LOG==NULL)
			SSL_LOG=stderr;
		}
            } else {
                /* disable all the debug and trace */
		SSL_LOG=SSL_ERR=NULL; /**/
            }

	    if (ssl_debug_flag) {
		if (SSL_LOG!=NULL) {
		    fprintf(SSL_LOG,"SSL_LOG started\n");
		    fflush(SSL_LOG);
		}
		if (SSL_ERR!=NULL) {
		    fprintf(SSL_ERR,"SSL_ERR started\n");
		    fflush(SSL_ERR);
		}
	    }

	    SSL_load_error_strings();

	    ssl_ctx=SSL_CTX_new();

	    /* I really should syslog any of the following
	     * errors but I haven't bothered at this stage
	     * as that can wait
	     */
            if (!X509_set_default_verify_paths(ssl_ctx->cert)) {
		fprintf(stderr,"ftpd: cannot set default path via X509_set_default_verify_paths\n");
		fflush(stderr);
		sleep(1);
		exit(1);
            }

#if 0
            sprintf(ssl_file_path,"%s/%s",X509_get_default_cert_dir(),
                        "ftpd.cert");
#endif

            sprintf(ssl_file_path,"%s/%s",X509_get_default_cert_dir(),
                        "ftpd.pem");

	    filename=my_ssl_cert_file==NULL?ssl_file_path:my_ssl_cert_file;
	    fp=fopen(filename,"r");
	    if (fp==NULL) {
		fprintf(stderr,"ftpd: cannot open public cert file \"%s\"\n",filename);
		fflush(stderr);
		exit(1);
	    }

	    ssl_public_cert=X509_new();
	    if (PEM_read_X509(fp,&ssl_public_cert,NULL)==NULL) {
		fprintf(stderr,"ftpd: error reading public cert - %s\n",
                                ERR_error_string(ERR_get_error(),NULL));
		fflush(stderr);
		exit(1);
	    }
	    fclose(fp);

	    if (ssl_debug_flag) {
		fprintf(SSL_LOG,"ftpd: got public cert\n");
		fflush(SSL_LOG);
	    }

#if 0
            sprintf(ssl_file_path,"%s/private/%s",X509_get_default_cert_area(),
                        "ftpd.key");
#endif

            sprintf(ssl_file_path,"%s/%s",X509_get_default_cert_dir(),
                        "ftpd.pem");

	    filename=my_ssl_key_file==NULL?ssl_file_path:my_ssl_key_file;
	    fp=fopen(filename,"r");
	    if (fp==NULL) {
		fprintf(stderr,"ftpd: cannot open private key file \"%s\"\n",filename);
		fflush(stderr);
		exit(1);
	    }

	    ssl_private_key=RSA_new();
	    if (PEM_read_RSAPrivateKey(fp,&ssl_private_key,NULL)==0) {
		fprintf(stderr,"ftpd: error reading private key - %s\n",
			ERR_error_string(ERR_get_error(),NULL));
		fflush(stderr);
		exit(1);
	    }
	    fclose(fp);

	    if (ssl_debug_flag) {
		fprintf(SSL_LOG,"ftpd: got private key\n");
		fflush(SSL_LOG);
	    }

        }
#endif /* USE_SSL */

	(void) freopen("/dev/null", "w", stderr);
	(void) signal(SIGPIPE, lostconn);
	(void) signal(SIGCHLD, SIG_IGN);
	if ((int)signal(SIGURG, myoob) < 0)
		syslog(LOG_ERR, "signal: %m");

	/* Try to handle urgent data inline */
#ifdef SO_OOBINLINE
	if (setsockopt(0, SOL_SOCKET, SO_OOBINLINE, (char *)&on, sizeof(on)) < 0)
		syslog(LOG_ERR, "setsockopt: %m");
#endif

#ifdef	F_SETOWN
	if (fcntl(fileno(stdin), F_SETOWN, getpid()) == -1)
		syslog(LOG_ERR, "fcntl F_SETOWN: %m");
#endif
	dolog(&his_addr);
	/*
	 * Set up default state
	 */
	data = -1;
	type = TYPE_A;
	form = FORM_N;
	stru = STRU_F;
	mode = MODE_S;
	tmpline[0] = '\0';
	(void) gethostname(hostname, sizeof (hostname));
	reply(220, "%s FTP server (%s) ready.", (char *)hostname, (char *)version);
	(void) setjmp(errcatch);
	for (;;)
		(void) yyparse();
	/* NOTREACHED */
}

void
lostconn()
{
	if (debug)
		syslog(LOG_DEBUG, "lost connection");
	dologout(-1);
}

static char ttyline[20];

/*
 * Helper function for sgetpwnam().
 */
char *
sgetsave(s)
	char *s;
{
	char *new = malloc((unsigned) strlen(s) + 1);

	if (new == NULL) {
		perror_reply(421, "Local resource failure: malloc");
		dologout(1);
		/* NOTREACHED */
	}
	(void) strcpy(new, s);
	return (new);
}

/*
 * Save the result of a getpwnam.  Used for USER command, since
 * the data returned must not be clobbered by any other command
 * (e.g., globbing).
 */
#ifdef USE_SHADOW
#include <shadow.h>
#endif

struct passwd *
sgetpwnam(name)
	char *name;
{
	static struct passwd save;
	register struct passwd *p;
	char *sgetsave();

	if ((p = getpwnam(name)) == NULL)
		return (p);
	if (save.pw_name) {
		free(save.pw_name);
		free(save.pw_passwd);
		free(save.pw_gecos);
		free(save.pw_dir);
		free(save.pw_shell);
	}
	save = *p;
	save.pw_name = sgetsave(p->pw_name);
	save.pw_passwd = sgetsave(p->pw_passwd);
	save.pw_gecos = sgetsave(p->pw_gecos);
	save.pw_dir = sgetsave(p->pw_dir);
	save.pw_shell = sgetsave(p->pw_shell);
#ifdef USE_SHADOW
        {
                struct spwd *sp;
                sp = getspnam(name);
                free(save.pw_passwd);
                save.pw_passwd  = sgetsave(sp->sp_pwdp);
        }
#endif 

	return (&save);
}

int login_attempts;		/* number of failed login attempts */
int askpasswd;			/* had user command, ask for passwd */

/*
 * USER command.
 * Sets global passwd pointer pw if named account exists and is acceptable;
 * sets askpasswd if a PASS command is expected.  If logged in previously,
 * need to reset state.  If name is "ftp" or "anonymous", the name is not in
 * _PATH_FTPUSERS, and ftp account exists, set guest and pw, then just return.
 * If account doesn't exist, ask for passwd anyway.  Otherwise, check user
 * requesting login privileges.  Disallow anyone who does not have a standard
 * shell as returned by getusershell().  Disallow anyone mentioned in the file
 * _PATH_FTPUSERS to allow people such as root and uucp to be avoided.
 */
user(name)
	char *name;
{
	register char *cp;
	char *shell;
	char *getusershell();

	if (logged_in) {
		if (guest) {
			reply(530, "Can't change user from guest login.");
			return;
		}
		end_login();
	}

	guest = 0;
	askpasswd = 0;
	if (strcmp(name, "ftp") == 0 || strcmp(name, "anonymous") == 0) {
		if (checkuser("ftp") || checkuser("anonymous"))
			reply(530, "User %s access denied.", name);
		else if ((pw = sgetpwnam("ftp")) != NULL) {
			guest = 1;
			askpasswd = 1;
			reply(331, "Guest login ok, send ident as password.");
		} else
			reply(530, "User unknown.");
		return;
	}
	if (pw = sgetpwnam(name)) {
		if ((shell = pw->pw_shell) == NULL || *shell == 0)
			shell = "/bin/sh";
		while ((cp = getusershell()) != NULL)
			if (strcmp(cp, shell) == 0)
				break;
		endusershell();
		if (cp == NULL || checkuser(name)) {
			reply(530, "User access denied. shell=%s",shell);
			if (logging)
				syslog(LOG_NOTICE,
				    "FTP LOGIN REFUSED FROM %s, %s",
				    remotehost, name);
			pw = (struct passwd *) NULL;
			return;
		}
	}
#ifdef USE_SSL
        if (pw && good_ssl_user(name)) {
                reply(331, "Send dummy password to login.");
                ssl_auto_login = 1;
        } else
#endif
	reply(331, "Password required.");
	askpasswd = 1;
	/*
	 * Delay before reading passwd after first failed
	 * attempt to slow down passwd-guessing programs.
	 */
	if (login_attempts)
		sleep((unsigned) login_attempts);
}

/*
 * Check if a user is in the file _PATH_FTPUSERS
 */
checkuser(name)
	char *name;
{
	register FILE *fd;
	register char *p;
	char line[BUFSIZ];

	if ((fd = fopen("/etc/ftpusers", "r")) != NULL) {
		while (fgets(line, sizeof(line), fd) != NULL)
			if ((p = strchr(line, '\n')) != NULL) {
				*p = '\0';
				if (line[0] == '#')
					continue;
				if (strcmp(line, name) == 0)
					return (1);
			}
		(void) fclose(fd);
	}
	return (0);
}

/*
 * Terminate login as previous user, if any, resetting state;
 * used when USER command is given or login fails.
 */
end_login()
{

	(void) seteuid((uid_t)0);
	if (logged_in)
		logwtmp(ttyline, "", "");
	pw = NULL;
	logged_in = 0;
	guest = 0;
}

pass(passwd)
	char *passwd;
{
	char *xpasswd, *salt;

	if (logged_in || askpasswd == 0) {
		reply(503, "Login with USER first.");
		return;
	}
	askpasswd = 0;
	if (!guest
#ifdef USE_SSL
             && !ssl_auto_login
#endif
	   ) {		/* "ftp" is only account allowed no password */
		if (pw == NULL)
			salt = "xx";
		else
			salt = pw->pw_passwd;
		xpasswd = crypt(passwd, salt);
		/* The strcmp does not catch null passwords! */
		if (pw == NULL || *pw->pw_passwd == '\0' ||
		    strcmp(xpasswd, pw->pw_passwd)) {
			reply(530, "Login incorrect.");
			pw = NULL;
			if (login_attempts++ >= 5) {
				syslog(LOG_NOTICE,
				    "repeated login failures from %s",
				    remotehost);
				exit(0);
			}
			return;
		}
	}
	login_attempts = 0;		/* this time successful */
	(void) setegid((gid_t)pw->pw_gid);
	(void) initgroups(pw->pw_name, pw->pw_gid);

	/* open wtmp before chroot */
	(void)sprintf(ttyline, "ftp%d", getpid());
	logwtmp(ttyline, pw->pw_name, remotehost);
	logged_in = 1;

	if (guest) {
		/*
		 * We MUST do a chdir() after the chroot. Otherwise
		 * the old current directory will be accessible as "."
		 * outside the new root!
		 */
		if (chroot(pw->pw_dir) < 0 || chdir("/") < 0) {
			reply(550, "Can't set guest privileges.");
			goto bad;
		}
	} else if (chdir(pw->pw_dir) < 0) {
		if (chdir("/") < 0) {
			reply(530, "User can't change directory to %s.",
			    pw->pw_dir);
			goto bad;
		} else
			lreply(230, "No directory! Logging in with home=/");
	}
	if (seteuid((uid_t)pw->pw_uid) < 0) {
		reply(550, "Can't set uid.");
		goto bad;
	}
	if (guest) {
		reply(230, "Guest login ok, access restrictions apply.");
#ifdef SETPROCTITLE
		sprintf(proctitle, "%s: anonymous/%.*s", remotehost,
		    sizeof(proctitle) - sizeof(remotehost) -
		    sizeof(": anonymous/"), passwd);
		setproctitle(proctitle);
#endif /* SETPROCTITLE */
		if (logging)
			syslog(LOG_INFO, "ANONYMOUS FTP LOGIN FROM %s, %s",
			    remotehost, passwd);
	} else {
		reply(230, "User logged in.");
#ifdef SETPROCTITLE
		sprintf(proctitle, "%s: %s", remotehost, pw->pw_name);
		setproctitle(proctitle);
#endif /* SETPROCTITLE */
		if (logging)
			syslog(LOG_INFO, "FTP LOGIN FROM %s, %s",
			    remotehost, pw->pw_name);
	}
	home = pw->pw_dir;		/* home dir for globbing */
	(void) umask(defumask);
	return;
bad:
	/* Forget all about it... */
	end_login();
}

retrieve(cmd, name)
	char *cmd, *name;
{
	FILE *fin, *dout;
	struct stat st;
	int (*closefunc)();

	if (cmd == 0) {
		fin = fopen(name, "r"), closefunc = fclose;
		st.st_size = 0;
	} else {
		char line[BUFSIZ];

		(void) sprintf(line, cmd, name), name = line;
		fin = ftpd_popen(line, "r"), closefunc = ftpd_pclose;
		st.st_size = -1;
		st.st_blksize = BUFSIZ;
	}
	if (fin == NULL) {
		if (errno != 0)
			perror_reply(550, name);
		return;
	}
	if (cmd == 0 &&
	    (fstat(fileno(fin), &st) < 0 || (st.st_mode&S_IFMT) != S_IFREG)) {
		reply(550, "%s: not a plain file.", name);
		goto done;
	}
	if (restart_point) {
		if (type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c=getc(fin)) == EOF) {
					perror_reply(550, name);
					goto done;
				}
				if (c == '\n')
					i++;
			}	
		} else if (lseek(fileno(fin), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}
	dout = dataconn(name, st.st_size, "w");
	if (dout == NULL) {
#ifdef TJH
		syslog(LOG_WARNING, "dataconn null");
#endif /* TJH */
		goto done;
	}
	send_data(fin, dout, st.st_blksize);
#ifdef TJH
	syslog(LOG_WARNING, "send_data done");
#endif /* TJH */

#ifdef USE_SSL
	if (ssl_data_active_flag && (ssl_data_con!=NULL)) {
	    SSL_free(ssl_data_con);
	    ssl_data_active_flag=0;
	    ssl_data_con=NULL;
	}
#endif /* USE_SSL */

	(void) fclose(dout);
	data = -1;
	pdata = -1;
done:
	(*closefunc)(fin);
}

store(name, mode, unique)
	char *name, *mode;
	int unique;
{
	FILE *fout, *din;
	struct stat st;
	int (*closefunc)();
	char *gunique();

	if (unique && stat(name, &st) == 0 &&
	    (name = gunique(name)) == NULL)
		return;

	if (restart_point)
		mode = "r+w";
	fout = fopen(name, mode);
	closefunc = fclose;
	if (fout == NULL) {
		perror_reply(553, name);
		return;
	}
	if (restart_point) {
		if (type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c=getc(fout)) == EOF) {
					perror_reply(550, name);
					goto done;
				}
				if (c == '\n')
					i++;
			}	
			/*
			 * We must do this seek to "current" position
			 * because we are changing from reading to
			 * writing.
			 */
			if (fseek(fout, 0L, L_INCR) < 0) {
				perror_reply(550, name);
				goto done;
			}
		} else if (lseek(fileno(fout), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}
	din = dataconn(name, (off_t)-1, "r");
	if (din == NULL)
		goto done;
	if (receive_data(din, fout) == 0) {
		if (unique)
			reply(226, "Transfer complete (unique file name:%s).",
			    name);
		else
			reply(226, "Transfer complete.");
	}
	(void) fclose(din);
	data = -1;
	pdata = -1;
done:
	(*closefunc)(fout);
}

FILE *
getdatasock(mode)
	char *mode;
{
	int s, on = 1, tries;

	if (data >= 0)
		return (fdopen(data, mode));
	(void) seteuid((uid_t)0);
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0)
		goto bad;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
	    (char *) &on, sizeof (on)) < 0)
		goto bad;

	/* it is *very* important to wipe this out before 
	 * starting to put things into it --tjh
	 * tjh@mincom.oz.au
	 */
	memset(&data_source,'\0',sizeof(data_source));

	/* anchor socket to avoid multi-homing problems */
	data_source.sin_family = AF_INET;
	data_source.sin_addr = ctrl_addr.sin_addr;
	for (tries = 1; ; tries++) {
		if (bind(s, (struct sockaddr *)&data_source,
		    sizeof (data_source)) >= 0)
			break;
#ifdef TJH
                /* make this quicker for local debug testing ... */
		if (errno != EADDRINUSE || tries > 2)
#else
		if (errno != EADDRINUSE || tries > 10)
#endif
			goto bad;
		sleep(tries);
	}
	(void) seteuid((uid_t)pw->pw_uid);
#ifdef IP_TOS
#ifdef IPTOS_THROUGHPUT
	on = IPTOS_THROUGHPUT;
	if (setsockopt(s, IPPROTO_IP, IP_TOS, (char *)&on, sizeof(int)) < 0)
		syslog(LOG_WARNING, "setsockopt (IP_TOS): %m");
#endif
#endif
	return (fdopen(s, mode));
bad:
	(void) seteuid((uid_t)pw->pw_uid);
	(void) close(s);
	return (NULL);
}

FILE *
dataconn(name, size, mode)
	char *name;
	off_t size;
	char *mode;
{
	char sizebuf[32];
	FILE *file;
	int retry = 0, tos;

	file_size = size;
	byte_count = 0;
	if (size != (off_t) -1)
		(void) sprintf (sizebuf, " (%ld bytes)", size);
	else
		(void) strcpy(sizebuf, "");
	if (pdata >= 0) {
		struct sockaddr_in from;
		int s, fromlen = sizeof(from);

		s = accept(pdata, (struct sockaddr *)&from, &fromlen);
		if (s < 0) {
			reply(425, "Can't open data connection.");
			(void) close(pdata);
			pdata = -1;
			return(NULL);
		}
		(void) close(pdata);
		pdata = s;
#ifdef IP_TOS
#ifdef IPTOS_LOWDELAY
		tos = IPTOS_LOWDELAY;
		(void) setsockopt(s, IPPROTO_IP, IP_TOS, (char *)&tos,
		    sizeof(int));
#endif
#endif
		reply(150, "Opening %s mode data connection for %s%s.",
		     type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);
		return(fdopen(pdata, mode));
	}
	if (data >= 0) {
		reply(125, "Using existing data connection for %s%s.",
		    name, sizebuf);
		usedefault = 1;
		return (fdopen(data, mode));
	}
	if (usedefault)
		data_dest = his_addr;
	usedefault = 1;
	file = getdatasock(mode);
	if (file == NULL) {
		reply(425, "Can't create data socket (%s,%d): %s.",
		    inet_ntoa(data_source.sin_addr),
		    ntohs(data_source.sin_port), strerror(errno));
		return (NULL);
	}
	data = fileno(file);
	while (connect(data, (struct sockaddr *)&data_dest,
	    sizeof (data_dest)) < 0) {
		if (errno == EADDRINUSE && retry < swaitmax) {
			sleep((unsigned) swaitint);
			retry += swaitint;
			continue;
		}
		perror_reply(425, "Can't build data connection");
		(void) fclose(file);
		data = -1;
		return (NULL);
	}
#ifdef USE_SSL
        /* time to negotiate SSL on the data connection ...
	 * do this via SSL_accept (as we are still the server
	 * even though things are started around the other way)
	 * 
	 * note: we really *must* make sure the session stuff
	 *       is copied correctly as we cannot afford a full
	 *       SSL negotiation for each data socket!
	 */
	/* TODO XXXX fill in the blanks :-)
	 */
	ssl_data_active_flag=0;
	if (ssl_active_flag && ssl_encrypt_data) {
	    /* do SSL */

	    reply(150, "Opening %s mode SSL data connection for %s%s.",
		 type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);

	    if (ssl_data_con!=NULL) {
	      SSL_free(ssl_data_con);
	      ssl_data_con=NULL;
	    }
	    ssl_data_con=(SSL *)SSL_new(ssl_ctx);

            /* copy session details ... */
	    SSL_copy_session_id(ssl_data_con,ssl_con);

	    /* for 0.5.2 - want to change the timeout value etc ... */

	    SSL_set_fd(ssl_data_con,data);
	    SSL_set_verify(ssl_data_con,ssl_verify_flag,NULL);

	    /* if is "safe" to read ahead */
            /* SSL_set_read_ahead(ssl_data_con,1); /**/

	    if (ssl_debug_flag && (SSL_LOG!=NULL)) {
		fprintf(SSL_LOG,"===>START SSL_accept on DATA\n");
		fflush(SSL_LOG);
	    }

	    if (SSL_accept(ssl_data_con)<=0) {
                static char errbuf[1024];

	        sprintf(errbuf,"ftpd: SSL_accept DATA error %s\n",
			    ERR_error_string(ERR_get_error(),NULL));
		perror_reply(425, errbuf);
		/* abort time methinks ... */
		fclose(file);
		return NULL;
	    } else {
		if (ssl_debug_flag && (SSL_LOG!=NULL)) {
		    fprintf(SSL_LOG,"[SSL DATA Cipher %s]\n",
			            SSL_get_cipher(ssl_con));
		    fflush(SSL_LOG);
		}
		ssl_data_active_flag=1;
	    }

	    if (ssl_debug_flag && (SSL_LOG!=NULL)) {
		fprintf(SSL_LOG,"===>DONE SSL_accept on DATA\n");
		fflush(SSL_LOG);
	    }

	} else {
	    reply(150, "Opening %s mode data connection for %s%s.",
		 type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);
	}
#else /* !USE_SSL */
	reply(150, "Opening %s mode data connection for %s%s.",
	     type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);
#endif /* USE_SSL */
	return (file);
}

/*
 * Tranfer the contents of "instr" to
 * "outstr" peer using the appropriate
 * encapsulation of the data subject
 * to Mode, Structure, and Type.
 *
 * NB: Form isn't handled.
 */
send_data(instr, outstr, blksize)
	FILE *instr, *outstr;
	off_t blksize;
{
	register int c, cnt;
	register char *buf;
	int netfd, filefd;

	transflag++;
	if (setjmp(urgcatch)) {
		transflag = 0;
		return;
	}
	switch (type) {

	case TYPE_A:
		while ((c = getc(instr)) != EOF) {
			byte_count++;
			if (c == '\n') {
				if (ferror(outstr))
					goto data_err;
				(void) DATAPUTC('\r', outstr);
			}
			(void) DATAPUTC(c, outstr);
		}
		DATAFLUSH(outstr);
		transflag = 0;
		if (ferror(instr))
			goto file_err;
		if (ferror(outstr))
			goto data_err;
		reply(226, "Transfer complete.");
		return;

	case TYPE_I:
	case TYPE_L:
		if ((buf = malloc((u_int)blksize)) == NULL) {
			transflag = 0;
			perror_reply(451, "Local resource failure: malloc");
			return;
		}
		netfd = fileno(outstr);
		filefd = fileno(instr);
#ifdef USE_SSL
                if (ssl_data_active_flag) {
		    while ((cnt = read(filefd, buf, (u_int)blksize)) > 0 &&
			SSL_write(ssl_data_con, buf, cnt) == cnt)
			    byte_count += cnt;
		} else
#endif /* USE_SSL */
                {
		while ((cnt = read(filefd, buf, (u_int)blksize)) > 0 &&
		    write(netfd, buf, cnt) == cnt)
			byte_count += cnt;
		}
		transflag = 0;
		(void)free(buf);
		if (cnt != 0) {
			if (cnt < 0)
				goto file_err;
			goto data_err;
		}
		reply(226, "Transfer complete.");
		return;
	default:
		transflag = 0;
		reply(550, "Unimplemented TYPE %d in send_data", type);
		return;
	}

data_err:
	transflag = 0;
	perror_reply(426, "Data connection");
	return;

file_err:
	transflag = 0;
	perror_reply(551, "Error on input file");
}

/*
 * Transfer data from peer to
 * "outstr" using the appropriate
 * encapulation of the data subject
 * to Mode, Structure, and Type.
 *
 * N.B.: Form isn't handled.
 */
receive_data(instr, outstr)
	FILE *instr, *outstr;
{
	register int c;
	int cnt, bare_lfs = 0;
	char buf[BUFSIZ];

	transflag++;
	if (setjmp(urgcatch)) {
		transflag = 0;
		return (-1);
	}
	switch (type) {

	case TYPE_I:
	case TYPE_L:
#ifdef USE_SSL
                if (ssl_data_active_flag) {
		    while ((cnt = SSL_read(ssl_data_con,buf,sizeof buf)) > 0) {
			    if (write(fileno(outstr), buf, cnt) != cnt)
				    goto file_err;
			    byte_count += cnt;
		    }
		} else 
#endif /* !USE_SSL */
                {
		while ((cnt = read(fileno(instr), buf, sizeof buf)) > 0) {
			if (write(fileno(outstr), buf, cnt) != cnt)
				goto file_err;
			byte_count += cnt;
		}
		}
		if (cnt < 0)
			goto data_err;
		transflag = 0;
		return (0);

	case TYPE_E:
		reply(553, "TYPE E not implemented.");
		transflag = 0;
		return (-1);

	case TYPE_A:
		while ((c = DATAGETC(instr)) != EOF) {
			byte_count++;
			if (c == '\n')
				bare_lfs++;
			while (c == '\r') {
				if (ferror(outstr))
					goto data_err;
				if ((c = DATAGETC(instr)) != '\n') {
					(void) putc ('\r', outstr);
					if (c == '\0' || c == EOF)
						goto contin2;
				}
			}
			(void) putc(c, outstr);
	contin2:	;
		}
		fflush(outstr);
		if (ferror(instr))
			goto data_err;
		if (ferror(outstr))
			goto file_err;
		transflag = 0;
		if (bare_lfs) {
			lreply(230, "WARNING! %d bare linefeeds received in ASCII mode", bare_lfs);
			printf("   File may not have transferred correctly.\r\n");
		}
		return (0);
	default:
		reply(550, "Unimplemented TYPE %d in receive_data", type);
		transflag = 0;
		return (-1);
	}

data_err:
	transflag = 0;
	perror_reply(426, "Data Connection");
	return (-1);

file_err:
	transflag = 0;
	perror_reply(452, "Error writing file");
	return (-1);
}

statfilecmd(filename)
	char *filename;
{
	char line[BUFSIZ];
	FILE *fin;
	int c;

	(void) sprintf(line, "/bin/ls -lgA %s", filename);
	fin = ftpd_popen(line, "r");
	lreply(211, "status of %s:", filename);
	while ((c = getc(fin)) != EOF) {
		if (c == '\n') {
			if (ferror(stdout)){
				perror_reply(421, "control connection");
				(void) ftpd_pclose(fin);
				dologout(1);
				/* NOTREACHED */
			}
			if (ferror(fin)) {
				perror_reply(551, filename);
				(void) ftpd_pclose(fin);
				return;
			}
			(void) putc('\r', stdout);
		}
		(void) putc(c, stdout);
	}
	(void) ftpd_pclose(fin);
	reply(211, "End of Status");
}

statcmd()
{
	struct sockaddr_in *sin;
	u_char *a, *p;

	lreply(211, "%s FTP server status:", hostname, version);
	printf("     %s\r\n", version);
	printf("     Connected to %s", remotehost);
	if (!isdigit(remotehost[0]))
		printf(" (%s)", inet_ntoa(his_addr.sin_addr));
	printf("\r\n");
	if (logged_in) {
		if (guest)
			printf("     Logged in anonymously\r\n");
		else
			printf("     Logged in as %s\r\n", pw->pw_name);
	} else if (askpasswd)
		printf("     Waiting for password\r\n");
	else
		printf("     Waiting for user name\r\n");
	if (data != -1)
		printf("     Data connection open\r\n");
	else if (pdata != -1) {
		printf("     in Passive mode");
		sin = &pasv_addr;
		goto printaddr;
	} else if (usedefault == 0) {
		printf("     PORT");
		sin = &data_dest;
printaddr:
		a = (u_char *) &sin->sin_addr;
		p = (u_char *) &sin->sin_port;
#define UC(b) (((int) b) & 0xff)
		printf(" (%d,%d,%d,%d,%d,%d)\r\n", UC(a[0]),
			UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]));
#undef UC
	} else
		printf("     No data connection\r\n");
	reply(211, "End of status");
}

fatal(s)
	char *s;
{
	reply(451, "Error in server: %s\n", s);
	reply(221, "Closing connection due to server error.");
	dologout(0);
	/* NOTREACHED */
}

#ifdef USE_STDARG
reply(int n,...)
#else
/*VARARGS*/
reply(va_alist)
va_dcl
#endif
{
#ifdef USE_SSL
        char outputbuf[2048];        /* allow for a 2k command string */
#endif /* USE_SSL */
#ifdef USE_STDARG
	va_list ap;
	char *fmt;

        va_start(ap,n);
	fmt = va_arg(ap, char *);
#else
	va_list ap;
	int n;
	char *fmt;

        va_start(ap);

	n = va_arg(ap, int);
	fmt = va_arg(ap, char *);
#endif

#ifdef USE_SSL
        /* assemble the output into a buffer */
	sprintf(outputbuf,"%d ",n);
	vsprintf(outputbuf+strlen(outputbuf),fmt,ap);
	strcat(outputbuf,"\r\n");

	if (ssl_debug_flag && (SSL_LOG!=NULL) ) {
	    fprintf(SSL_LOG,"\n<--- %s",outputbuf);
	    fflush(SSL_LOG);
	}

	if (ssl_active_flag) {
	    SSL_write(ssl_con,outputbuf,strlen(outputbuf));
        } else {
	    fprintf(stdout,"%s",outputbuf);
	    fflush(stdout);
	}
	if (debug)
	    syslog(LOG_DEBUG, "<--- %s ", outputbuf);
#else /* !USE_SSL */
	/* this is sort of the old way of doing things ...
	 * and it is a little messy ... 
	 */
	fprintf(stdout,"%d ",n);
	vfprintf(stdout, fmt, ap);
	fprintf(stdout,"\r\n");
	(void)fflush(stdout);

	/* I've taken the loggin out here ... as it was
	 * "wrong" 
	 */
#endif /* USE_SSL */
	va_end(ap);
}

#ifdef USE_STDARG
lreply(int n, ...)
#else
/*VARARGS*/
lreply(va_alist)
va_dcl
#endif
{
#ifdef USE_SSL
        char outputbuf[2048];        /* allow for a 2k command string */
#endif /* USE_SSL */
#ifdef USE_STDARG
	va_list ap;
	char *fmt;

        va_start(ap,fmt);
	fmt = va_arg(ap, char *);
#else
	va_list ap;
	int n;
	char *fmt;

        va_start(ap);
	n = va_arg(ap, int);
	fmt = va_arg(ap, char *);
#endif

#ifdef USE_SSL
        /* assemble the output into a buffer */
	sprintf(outputbuf,"%d- ",n);
	vsprintf(outputbuf+strlen(outputbuf),fmt,ap);
	strcat(outputbuf,"\r\n");

	if (ssl_debug_flag && (SSL_LOG!=NULL) ) {
	    fprintf(SSL_LOG,"\n<--- %s",outputbuf);
	    fflush(SSL_LOG);
	}

	if (ssl_active_flag) {
	    SSL_write(ssl_con,outputbuf,strlen(outputbuf));
        } else {
	    fprintf(stdout,"%s",outputbuf);
	    fflush(stdout);
	}
	if (debug)
	    syslog(LOG_DEBUG, "<--- %s ", outputbuf);
#else /* !USE_SSL */
	/* this is sort of the old way of doing things ...
	 * and it is a little messy ... 
	 */
	fprintf(stdout,"%d- ",n);
	vfprintf(stdout, fmt, ap);
	fprintf(stdout,"\r\n");
	(void)fflush(stdout);

	/* I've taken the loggin out here ... as it was
	 * "wrong" 
	 */
#endif /* USE_SSL */
	va_end(ap);
}

ack(s)
	char *s;
{
	reply(250, "%s command successful.", s);
}

nack(s)
	char *s;
{
	reply(502, "%s command not implemented.", s);
}

/* ARGSUSED */
yyerror(s)
	char *s;
{
	char *cp;

	if (cp = strchr(cbuf,'\n'))
		*cp = '\0';
	reply(500, "'%s': command not understood.", cbuf);
}

delete(name)
	char *name;
{
	struct stat st;

	if (stat(name, &st) < 0) {
		perror_reply(550, name);
		return;
	}
	if ((st.st_mode&S_IFMT) == S_IFDIR) {
		if (rmdir(name) < 0) {
			perror_reply(550, name);
			return;
		}
		goto done;
	}
	if (unlink(name) < 0) {
		perror_reply(550, name);
		return;
	}
done:
	ack("DELE");
}

cwd(path)
	char *path;
{
	if (chdir(path) < 0)
		perror_reply(550, path);
	else
		ack("CWD");
}

makedir(name)
	char *name;
{
	if (mkdir(name, 0777) < 0)
		perror_reply(550, name);
	else
		reply(257, "MKD command successful.");
}

removedir(name)
	char *name;
{
	if (rmdir(name) < 0)
		perror_reply(550, name);
	else
		ack("RMD");
}

pwd()
{
	char path[MAXPATHLEN + 1];

	if (getcwd(path,sizeof(path)) == (char *)NULL)
		reply(550, "%s.", path);
	else
		reply(257, "\"%s\" is current directory.", path);
}

char *
renamefrom(name)
	char *name;
{
	struct stat st;

	if (stat(name, &st) < 0) {
		perror_reply(550, name);
		return ((char *)0);
	}
	reply(350, "File exists, ready for destination name");
	return (name);
}

renamecmd(from, to)
	char *from, *to;
{
	if (rename(from, to) < 0)
		perror_reply(550, "rename");
	else
		ack("RNTO");
}

dolog(sin)
	struct sockaddr_in *sin;
{
	struct hostent *hp = gethostbyaddr((char *)&sin->sin_addr,
		sizeof (struct in_addr), AF_INET);
	time_t t, time();
	extern char *ctime();

	if (hp)
		(void) strncpy(remotehost, hp->h_name, sizeof (remotehost));
	else
		(void) strncpy(remotehost, inet_ntoa(sin->sin_addr),
		    sizeof (remotehost));
#ifdef SETPROCTITLE
	sprintf(proctitle, "%s: connected", remotehost);
	setproctitle(proctitle);
#endif /* SETPROCTITLE */

	if (logging) {
		t = time((time_t *) 0);
		syslog(LOG_INFO, "connection from %s at %s",
		    remotehost, ctime(&t));
	}
}

/*
 * Record logout in wtmp file
 * and exit with supplied status.
 */
dologout(status)
	int status;
{
	if (logged_in) {
		(void) seteuid((uid_t)0);
		logwtmp(ttyline, "", "");
	}
	/* beware of flushing buffers after a SIGPIPE */
	_exit(status);
}

void
myoob()
{
	char *cp;

	/* only process if transfer occurring */
	if (!transflag)
		return;
	cp = tmpline;
	if (getline(cp, 7, stdin) == NULL) {
		reply(221, "You could at least say goodbye.");
		dologout(0);
	}
	upper(cp);
	if (strcmp(cp, "ABOR\r\n") == 0) {
		tmpline[0] = '\0';
		reply(426, "Transfer aborted. Data connection closed.");
		reply(226, "Abort successful");
		longjmp(urgcatch, 1);
	}
	if (strcmp(cp, "STAT\r\n") == 0) {
		if (file_size != (off_t) -1)
			reply(213, "Status: %lu of %lu bytes transferred",
			    byte_count, file_size);
		else
			reply(213, "Status: %lu bytes transferred", byte_count);
	}
}

/*
 * Note: a response of 425 is not mentioned as a possible response to
 * 	the PASV command in RFC959. However, it has been blessed as
 * 	a legitimate response by Jon Postel in a telephone conversation
 *	with Rick Adams on 25 Jan 89.
 */
passive()
{
	int len;
	register char *p, *a;

	pdata = socket(AF_INET, SOCK_STREAM, 0);
	if (pdata < 0) {
		perror_reply(425, "Can't open passive connection");
		return;
	}
	pasv_addr = ctrl_addr;
	pasv_addr.sin_port = 0;
	(void) seteuid((uid_t)0);
	if (bind(pdata, (struct sockaddr *)&pasv_addr, sizeof(pasv_addr)) < 0) {
		(void) seteuid((uid_t)pw->pw_uid);
		goto pasv_error;
	}
	(void) seteuid((uid_t)pw->pw_uid);
	len = sizeof(pasv_addr);
	if (getsockname(pdata, (struct sockaddr *) &pasv_addr, &len) < 0)
		goto pasv_error;
	if (listen(pdata, 1) < 0)
		goto pasv_error;
	a = (char *) &pasv_addr.sin_addr;
	p = (char *) &pasv_addr.sin_port;

#define UC(b) (((int) b) & 0xff)

	reply(227, "Entering Passive Mode (%d,%d,%d,%d,%d,%d)", UC(a[0]),
		UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]));
	return;

pasv_error:
	(void) close(pdata);
	pdata = -1;
	perror_reply(425, "Can't open passive connection");
	return;
}

/*
 * Generate unique name for file with basename "local".
 * The file named "local" is already known to exist.
 * Generates failure reply on error.
 */
char *
gunique(local)
	char *local;
{
	static char new[MAXPATHLEN];
	struct stat st;
	char *cp = strrchr(local, '/');
	int count = 0;

	if (cp)
		*cp = '\0';
	if (stat(cp ? local : ".", &st) < 0) {
		perror_reply(553, cp ? local : ".");
		return((char *) 0);
	}
	if (cp)
		*cp = '/';
	(void) strcpy(new, local);
	cp = new + strlen(new);
	*cp++ = '.';
	for (count = 1; count < 100; count++) {
		(void) sprintf(cp, "%d", count);
		if (stat(new, &st) < 0)
			return(new);
	}
	reply(452, "Unique file name cannot be created.");
	return((char *) 0);
}

/*
 * Format and send reply containing system error number.
 */
perror_reply(code, string)
	int code;
	char *string;
{
	reply(code, "%s: %s.", string, strerror(errno));
}

static char *onefile[] = {
	"",
	0
};

send_file_list(whichfiles)
	char *whichfiles;
{
	struct stat st;
	DIR *dirp = NULL;
	struct dirent *dir;
	FILE *dout = NULL;
	register char **dirlist, *dirname;
	int simple = 0;
	char *strpbrk();

	if (strpbrk(whichfiles, "~{[*?") != NULL) {
		extern char **ftpglob(), *globerr;

		globerr = NULL;
		dirlist = ftpglob(whichfiles);
		if (globerr != NULL) {
			reply(550, globerr);
			return;
		} else if (dirlist == NULL) {
			errno = ENOENT;
			perror_reply(550, whichfiles);
			return;
		}
	} else {
		onefile[0] = whichfiles;
		dirlist = onefile;
		simple = 1;
	}

	if (setjmp(urgcatch)) {
		transflag = 0;
		return;
	}
	while (dirname = *dirlist++) {
		if (stat(dirname, &st) < 0) {
			/*
			 * If user typed "ls -l", etc, and the client
			 * used NLST, do what the user meant.
			 */
			if (dirname[0] == '-' && *dirlist == NULL &&
			    transflag == 0) {
				retrieve("/bin/ls %s", dirname);
				return;
			}
			perror_reply(550, whichfiles);
			if (dout != NULL) {
				(void) fclose(dout);
				transflag = 0;
				data = -1;
				pdata = -1;
			}
			return;
		}

		if ((st.st_mode&S_IFMT) == S_IFREG) {
			if (dout == NULL) {
				dout = dataconn("file list", (off_t)-1, "w");
				if (dout == NULL)
					return;
				transflag++;
			}
			FPRINTF(ssl_data_con,dout, "%s%s\n", dirname,
				type == TYPE_A ? "\r" : "");
			byte_count += strlen(dirname) + 1;
			continue;
		} else if ((st.st_mode&S_IFMT) != S_IFDIR)
			continue;

		if ((dirp = opendir(dirname)) == NULL)
			continue;

		while ((dir = readdir(dirp)) != NULL) {
			char nbuf[MAXPATHLEN];

			if (dir->d_name[0] == '.' && dir->d_name[1] == '\0')
				continue;
			if (dir->d_name[0] == '.' && dir->d_name[1] == '.' &&
			    dir->d_name[2] == '\0')
				continue;

			sprintf(nbuf, "%s/%s", dirname, dir->d_name);

			/*
			 * We have to do a stat to insure it's
			 * not a directory or special file.
			 */
			if (simple || (stat(nbuf, &st) == 0 &&
			    (st.st_mode&S_IFMT) == S_IFREG)) {
				if (dout == NULL) {
					dout = dataconn("file list", (off_t)-1,
						"w");
					if (dout == NULL)
						return;
					transflag++;
				}
				if (nbuf[0] == '.' && nbuf[1] == '/')
					FPRINTF(ssl_data_con,dout, "%s%s\n", &nbuf[2],
						type == TYPE_A ? "\r" : "");
				else
					FPRINTF(ssl_data_con,dout, "%s%s\n", nbuf,
						type == TYPE_A ? "\r" : "");
				byte_count += strlen(nbuf) + 1;
			}
		}
		(void) closedir(dirp);
	}

	if (dout == NULL)
		reply(550, "No files found.");
	else if (ferror(dout) != 0)
		perror_reply(550, "Data connection");
	else
		reply(226, "Transfer complete.");

	transflag = 0;
	if (dout != NULL) {
#ifdef USE_SSL
                if (ssl_data_active_flag && (ssl_data_con!=NULL)) {
		    SSL_free(ssl_data_con);
		    ssl_data_active_flag=0;
		    ssl_data_con=NULL;
		}
#endif /* USE_SSL */
		(void) fclose(dout);
	}
	data = -1;
	pdata = -1;
}

#ifdef SETPROCTITLE
/*
 * clobber argv so ps will show what we're doing.
 * (stolen from sendmail)
 * warning, since this is usually started from inetd.conf, it
 * often doesn't have much of an environment or arglist to overwrite.
 */

/*VARARGS1*/
setproctitle(fmt, a, b, c)
char *fmt;
{
	register char *p, *bp, ch;
	register int i;
	char buf[BUFSIZ];

	(void) sprintf(buf, fmt, a, b, c);

	/* make ps print our process name */
	p = Argv[0];
	*p++ = '-';

	i = strlen(buf);
	if (i > LastArgv - p - 2) {
		i = LastArgv - p - 2;
		buf[i] = '\0';
	}
	bp = buf;
	while (ch = *bp++)
		if (ch != '\n' && ch != '\r')
			*p++ = ch;
	while (p < LastArgv)
		*p++ = ' ';
}
#endif /* SETPROCTITLE */


#if defined(__sgi) || defined(DGUX)
static FILE *fpShell;
#define SHELL_FILE "/etc/shells"

/* no getusershell or endusershell ... */
char *getusershell()
{
  static char buf[BUFSIZ];
  char *p;
  int len;

  if (fpShell==NULL) {
    fpShell=fopen(SHELL_FILE,"r");
    if (fpShell==NULL)
	return (NULL);
  }
  p=fgets(buf,BUFSIZ-1,fpShell);

  /* strip off the trailing newline ... --tjh */
  if (p!=NULL) {
    len=strlen(p);
    if (len>0) {
	if (p[len-1]=='\n')
	    p[len-1]='\0';
    }
  }
    
  return p;
}

int endusershell()
{
  if (fpShell!=NULL) {
    fclose(fpShell);
    fpShell=NULL;
  }
}

#endif /* __sgi || DGUX */


#ifdef USE_SSL

static int verify_callback();

do_ssl_start()
{
    static char errstr[1024];

    if (ssl_debug_flag && (SSL_LOG!=NULL)) {
	fprintf(SSL_LOG,"do_ssl_start triggered\n");
	fflush(SSL_LOG);
    }

    /* do the SSL stuff now ... before we play with pty's */
    ssl_con=(SSL *)SSL_new(ssl_ctx);

    /* we are working with stdin (inetd based) by default */
    SSL_set_fd(ssl_con,0);

    if (SSL_use_RSAPrivateKey(ssl_con,ssl_private_key)==0) {
        sprintf(errstr,"ftpd: SSL_use_RSAPrivateKey %s",ERR_error_string(ERR_get_error(),NULL));
	perror_reply(421, errstr);
	dologout(1);
    }

    if (SSL_use_certificate(ssl_con,ssl_public_cert)==0) {
        sprintf(errstr,"ftpd: SSL_use_certificate %s",ERR_error_string(ERR_get_error(),NULL));
	perror_reply(421, errstr);
	dologout(1);
    }

    SSL_set_verify(ssl_con,ssl_verify_flag,
	    ssl_certsok_flag ? verify_callback : NULL);

    if (SSL_accept(ssl_con)<=0) {
	sprintf(errstr,"ftpd: SSL_accept %s",ERR_error_string(ERR_get_error(),NULL));

	perror_reply(421, errstr);
	dologout(1);

	SSL_free(ssl_con);
	ssl_con=NULL;

	/* we will probably want to know this sort of stuff ...
	 * at least for the moment I'd like to keep track of
	 * who is using SSL - later I will probably make this
	 * just a debug option and only log after the user has
	 * actually connected --tjh
	 */
	if (logging)
	    syslog(LOG_NOTICE, "SSL FAILED WITH %s", remotehost);

    } else {
	ssl_active_flag=1;

	if (logging)
            if (auth_ssl_name)
                syslog(LOG_NOTICE, "SSL SUCCEEDED WITH %s as %s", remotehost,
                    auth_ssl_name);
            else
                syslog(LOG_NOTICE, "SSL SUCCEEDED WITH %s", remotehost);
    }

    /* ssl_fprintf calls require that this be null to test
     * for being an ssl stream
     */
    if (!ssl_active_flag) {
	if (ssl_con!=NULL)
	  SSL_free(ssl_con);
	ssl_con=NULL;
    }

    return 0;

}

/* we really shouldn't have code like this! --tjh */
int 
ssl_getc(SSL *ssl_con)
{
    char onebyte;

    if (SSL_read(ssl_con,&onebyte,1)!=1)
      return -1;
    else {
	if (ssl_debug_flag && (SSL_LOG!=NULL)) {
	    fprintf(SSL_LOG,"ssl_getc: SSL_read %d (%c) ",onebyte & 0xff,isprint(onebyte)?onebyte:'.');
	    fflush(SSL_LOG);
	}
	return onebyte & 0xff;
    }
}


/* got back to this an implemented some rather "simple" buffering */
static char putc_buf[BUFSIZ];
static int putc_buf_pos=0;

int ssl_putc_flush(SSL *ssl_con)
{
    if (putc_buf_pos>0) {
	if (SSL_write(ssl_con,putc_buf,putc_buf_pos)!=putc_buf_pos) {
	    if (ssl_debug_flag && (SSL_LOG!=NULL)) {
		fprintf(SSL_LOG,"ssl_putc_flush: WRITE FAILED\n");
		fflush(SSL_LOG);
	    }
	    putc_buf_pos=0;
	    return -1;
	}
    }
    putc_buf_pos=0;
    return 0;
}

int 
ssl_putc(SSL *ssl_con,int oneint)
{
    char onebyte;

    onebyte = oneint & 0xff;

    /* make sure there is space */
    if (putc_buf_pos>=BUFSIZ) 
	if (ssl_putc_flush(ssl_con)!=0)
	  return EOF;
    putc_buf[putc_buf_pos++]=onebyte;

    return onebyte;
}

/* we really shouldn't have code like this! --tjh */
int 
old_ssl_putc(SSL *ssl_con,int oneint)
{
    char onebyte;

    onebyte = oneint & 0xff;

    if (SSL_write(ssl_con,&onebyte,1)!=1)
      return -1;
    else {
	if (ssl_debug_flag && (SSL_LOG!=NULL)) {
	    fprintf(SSL_LOG,"ssl_putc: SSL_write %d (%c) ",onebyte & 0xff,isprint(onebyte)?onebyte:'.');
	    fflush(SSL_LOG);
	}
	return onebyte & 0xff;
    }
}

static int
verify_callback(ok, xs, xi, depth, error)
int ok;
char *xs, *xi;
int depth, error;
{
    /*
     * If the verification fails, then don't remember the name.  However,
     * if we don't require a certificate, then return success which will
     * still allow us to set up an encrypted session.
     *
     */
    if (!ok) {
	/* If we can't verify the issuer, then don't accept the name. */
    if (depth != 0 && auth_ssl_name) {
		free(auth_ssl_name);
 		auth_ssl_name = 0;
 	}
 	return ssl_verify_flag & SSL_VERIFY_FAIL_IF_NO_PEER_CERT ? 0 : 1;
     }
     if (depth == 0)
 	auth_ssl_name =
 	    (char *)X509_NAME_oneline(X509_get_subject_name(xs));
     return ok;
}

/* return true if this auth_ssl_name is authorized to use name. */
int
good_ssl_user(name)
char *name;
{
   FILE *user_fp;
   char buf[2048];

   if (!auth_ssl_name)
      return 0;
   if (!ssl_certsok_flag)
      return 0;	/* can't happen */
   user_fp = fopen("/etc/ssl.users", "r");
   if (!user_fp)
      return 0;
   while (fgets(buf, sizeof buf, user_fp)) {
      char *cp;
      char *n;

      /* allow for comments in the file ... always nice
       * to be able to add a little novel in files and
       * also disable easily --tjh
       */
      if (buf[0]=='#')
	  continue;

      if (cp = strchr(buf, '\n'))
	  *cp = '\0';
      cp = strchr(buf, ':');
      if (!cp)
	  continue;
      *cp++ = '\0';
      if (strcasecmp(cp, auth_ssl_name) == 0) {
	  n = buf;
	  while (n) {
	      cp = strchr(n, ',');
	      if (cp)
		  *cp++ = '\0';
	      if (!strcmp(name, n)) {
		  fclose(user_fp);
		  return 1;
	      }
	      n = cp;
	  }
      }
   }
   fclose(user_fp);
   return 0;
}

#endif /* USE_SSL */

