/*
 * aux_conf.h:
 * This file gets "filled in" for each architecture.
 * aux_conf.h.  Generated from aux_conf.h.in by configure.
 */

#ifndef _AUX_CONF_H
#define _AUX_CONF_H

/*
 * The next line is a literal inclusion of a file which includes a
 * definition for the MOUNT_TRAP macro for a particular architecture.
 * If it defines the wrong entry, check the AC_CHECK_MOUNT_TRAP m4 macro
 * in $srcdir/m4/macros.
 */

/* $srcdir/conf/trap/trap_linux.h */
extern int mount_linux(MTYPE_TYPE type, mntent_t *mnt, int flags, caddr_t data);
#define	MOUNT_TRAP(type, mnt, flags, mnt_data) 	mount_linux(type, mnt, flags, mnt_data)
/* End of included MOUNT_TRAP macro definition file */

/*
 * The next line is a literal replacement of a variable which defines the
 * the UNMOUNT_TRAP macro for a particular architecture.
 * If it defines the wrong entry, check the AC_CHECK_UNMOUNT_CALL m4 macro
 * in $srcdir/aclocal.m4.  If the arguments are being defined wrong, check
 * the macro AC_CHECK_UNMOUNT_ARGS in $srcdir/m4/macros.
 */
#define UNMOUNT_TRAP(mnt)	umount(mnt->mnt_dir)
/* End of replaced UNMOUNT_TRAP macro definition */

/*
 * The next line is a literal inclusion of a file which includes a
 * definition for the NFS_FH_DREF macro for a particular architecture.
 * If it defines the wrong entry, check the AC_CHECK_NFS_FH_DREF m4 macro
 * in $srcdir/m4/macros.
 */

/* $srcdir/conf/fh_dref/fh_dref_linux.h */
#define	NFS_FH_DREF(dst, src) memcpy((char *) &(dst.data), (char *) src, sizeof(struct nfs_fh))
/* End of included NFS_FH_DREF macro definition file */

/*
 * The next line is a literal inclusion of a file which includes a
 * definition for the NFS_SA_DREF macro for a particular architecture.
 * If it defines the wrong entry, check the AC_CHECK_NFS_SA_DREF m4 macro
 * in $srcdir/m4/macros.
 */

/* $srcdir/conf/sa_dref/sa_dref_linux.h */
#define	NFS_SA_DREF(dst, src) memmove((char *)&dst->addr, (char *) src, sizeof(struct sockaddr_in))
/* End of included NFS_SA_DREF macro definition file */

/*
 * The next line is a literal inclusion of a file which includes a
 * definition for the NFS_HN_DREF macro for a particular architecture.
 * If it defines the wrong entry, check the AC_CHECK_NFS_HN_DREF m4 macro
 * in $srcdir/m4/macros.
 */

/* $srcdir/conf/hn_dref/hn_dref_linux.h */
#define NFS_HN_DREF(dst, src) strncpy((dst), (src), MAXHOSTNAMELEN)
/* End of included NFS_HN_DREF macro definition file */

/*
 * The next line is a literal inclusion of a file which defines
 * necessary structures and functions for this system's flavor
 * of kernel-based autofs.
 * If it defines the wrong entry, check the AC_CHECK_AUTOFS_STYLE m4 macro
 * in $srcdir/m4/macros.
 */

#ifdef HAVE_FS_AUTOFS

struct autofs_pending_mount {
  unsigned long wait_queue_token;	/* Associated kernel wait token */
  char *name;
  struct autofs_pending_mount *next;
};

struct autofs_pending_umount {
  unsigned long wait_queue_token;	/* Associated kernel wait token */
  char *name;
  struct autofs_pending_umount *next;
};

typedef struct {
  int fd;
  int kernelfd;
  int ioctlfd;
  int version;
  struct autofs_pending_mount *pending_mounts;
  struct autofs_pending_umount *pending_umounts;
} autofs_fh_t;

#ifndef HAVE_LINUX_AUTO_FS4_H
union autofs_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_packet_missing missing;
	struct autofs_packet_expire expire;
};
#endif /* not HAVE_LINUX_AUTO_FS4_H */

#define AUTOFS_AUTO_FS_FLAGS	(FS_MKMNT | FS_AMQINFO | FS_DIRECTORY | FS_AUTOFS)
#define AUTOFS_DIRECT_FS_FLAGS	(FS_DIRECT | FS_MKMNT | FS_NOTIMEOUT | FS_BACKGROUND | FS_AMQINFO | FS_AUTOFS)
#define AUTOFS_ERROR_FS_FLAGS	(FS_DISCARD)
#define AUTOFS_HOST_FS_FLAGS	(FS_MKMNT | FS_BACKGROUND | FS_AMQINFO | FS_AUTOFS)
#define AUTOFS_INHERIT_FS_FLAGS	(FS_DISCARD)
#define AUTOFS_LINK_FS_FLAGS	(FS_MBACKGROUND)
#define AUTOFS_LINKX_FS_FLAGS	(FS_MBACKGROUND)
#define AUTOFS_NFSL_FS_FLAGS	(FS_MKMNT | FS_BACKGROUND | FS_AMQINFO)
#define AUTOFS_NFSX_FS_FLAGS	(/* FS_UBACKGROUND| */ FS_AMQINFO)
#define AUTOFS_PROGRAM_FS_FLAGS	(FS_BACKGROUND | FS_AMQINFO)
#define AUTOFS_ROOT_FS_FLAGS	(FS_NOTIMEOUT | FS_AMQINFO | FS_DIRECTORY)
#define AUTOFS_TOPLVL_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_BACKGROUND | FS_AMQINFO | FS_DIRECTORY | FS_AUTOFS)
#define AUTOFS_UNION_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_BACKGROUND | FS_AMQINFO | FS_DIRECTORY)

#define AUTOFS_CACHEFS_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_CDFS_FS_FLAGS	(FS_MKMNT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_EFS_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_LOFS_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_NFS_FS_FLAGS	(FS_MKMNT | FS_BACKGROUND | FS_AMQINFO)
#define AUTOFS_PCFS_FS_FLAGS	(FS_MKMNT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_UFS_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_UBACKGROUND | FS_AMQINFO)
#define AUTOFS_XFS_FS_FLAGS	(FS_MKMNT | FS_NOTIMEOUT | FS_UBACKGROUND | FS_AMQINFO)
#endif /* HAVE_FS_AUTOFS */
/* End of included AUTOFS_STYLE macro definition file */

#endif /* not _AUX_CONF_H */
