/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuditMessageIT
extends ConfigurableMacBase {
    private static final String AUDIT_USER_1 = "AuditUser1";
    private static final String AUDIT_USER_2 = "AuditUser2";
    private static final String PASSWORD = "password";
    private static final String OLD_TEST_TABLE_NAME = "apples";
    private static final String NEW_TEST_TABLE_NAME = "oranges";
    private static final String THIRD_TEST_TABLE_NAME = "pears";
    private static final Authorizations auths = new Authorizations(new String[]{"private", "public"});
    private static String lastAuditTimestamp;
    private Connector auditConnector;
    private Connector conn;

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) throws Exception {
        File f = new File(cfg.getConfDir(), "auditLog.xml");
        if (f.delete()) {
            log.debug("Deleted " + f);
        }
        cfg.setNumTservers(1);
    }

    private static ArrayList<String> findAuditMessage(ArrayList<String> input, String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : input) {
            if (!s.matches(".*" + pattern + ".*")) continue;
            result.add(s);
        }
        return result;
    }

    private ArrayList<String> getAuditMessages(String stepName) throws IOException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted waiting for data to be flushed to output streams");
        }
        for (MiniAccumuloClusterImpl.LogWriter lw : this.getCluster().getLogWriters()) {
            lw.flush();
        }
        System.out.println("Start of captured audit messages for step " + stepName);
        ArrayList<String> result = new ArrayList<String>();
        File[] files = this.getCluster().getConfig().getLogDir().listFiles();
        Assert.assertNotNull((Object)files);
        for (File file : files) {
            if (!file.getName().contains(".out") || !file.isFile() || !file.canRead()) continue;
            try (java.util.Scanner it = new java.util.Scanner(file, StandardCharsets.UTF_8.name());){
                while (it.hasNext()) {
                    String line = it.nextLine();
                    if (!line.matches(".* \\[Audit\\s*\\].*") || lastAuditTimestamp != null && line.substring(0, 23).compareTo(lastAuditTimestamp) <= 0) continue;
                    result.add(line);
                }
            }
        }
        Collections.sort(result);
        for (String s : result) {
            System.out.println(s);
        }
        System.out.println("End of captured audit messages for step " + stepName);
        if (result.size() > 0) {
            lastAuditTimestamp = result.get(result.size() - 1).substring(0, 23);
        }
        return result;
    }

    private void grantEverySystemPriv(Connector conn, String user) throws AccumuloSecurityException, AccumuloException {
        SystemPermission[] arrayOfP;
        for (SystemPermission p : arrayOfP = new SystemPermission[]{SystemPermission.SYSTEM, SystemPermission.ALTER_TABLE, SystemPermission.ALTER_USER, SystemPermission.CREATE_TABLE, SystemPermission.CREATE_USER, SystemPermission.DROP_TABLE, SystemPermission.DROP_USER}) {
            conn.securityOperations().grantSystemPermission(user, p);
        }
    }

    @Before
    public void resetInstance() throws Exception {
        this.conn = this.getConnector();
        this.removeUsersAndTables();
        this.getAuditMessages("setup");
    }

    @After
    public void removeUsersAndTables() throws Exception {
        for (String user : Arrays.asList(AUDIT_USER_1, AUDIT_USER_2)) {
            if (!this.conn.securityOperations().listLocalUsers().contains(user)) continue;
            this.conn.securityOperations().dropLocalUser(user);
        }
        TableOperations tops = this.conn.tableOperations();
        for (String table : Arrays.asList(THIRD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME)) {
            if (!tops.exists(table)) continue;
            tops.delete(table);
        }
    }

    @Test
    public void testTableOperationsAudits() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, InterruptedException {
        this.conn.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_TABLE);
        this.auditConnector = this.getCluster().getConnector(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditConnector.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditConnector.tableOperations().rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME);
        Map emptyMap = Collections.emptyMap();
        Set emptySet = Collections.emptySet();
        this.auditConnector.tableOperations().clone(NEW_TEST_TABLE_NAME, OLD_TEST_TABLE_NAME, true, emptyMap, emptySet);
        this.auditConnector.tableOperations().delete(OLD_TEST_TABLE_NAME);
        this.auditConnector.tableOperations().offline(NEW_TEST_TABLE_NAME);
        this.auditConnector.tableOperations().delete(NEW_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testTableOperationsAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createTable; targetTable: apples").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: renameTable; targetTable: apples").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: cloneTable; targetTable: oranges").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: apples").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: offlineTable; targetTable: oranges").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: deleteTable; targetTable: oranges").size());
    }

    @Test
    public void testUserOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, InterruptedException, IOException {
        this.conn.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.CREATE_USER);
        this.grantEverySystemPriv(this.conn, AUDIT_USER_1);
        this.auditConnector = this.getCluster().getConnector(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditConnector.securityOperations().createLocalUser(AUDIT_USER_2, new PasswordToken((CharSequence)PASSWORD));
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.conn.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        this.auditConnector.tableOperations().create(NEW_TEST_TABLE_NAME);
        this.conn.securityOperations().grantTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.conn.securityOperations().revokeTablePermission(AUDIT_USER_2, NEW_TEST_TABLE_NAME, TablePermission.READ);
        this.auditConnector.securityOperations().changeLocalUserPassword(AUDIT_USER_2, new PasswordToken((CharSequence)"anything"));
        this.auditConnector.securityOperations().changeUserAuthorizations(AUDIT_USER_2, auths);
        this.auditConnector.securityOperations().dropLocalUser(AUDIT_USER_2);
        ArrayList<String> auditMessages = this.getAuditMessages("testUserOperationsAudits");
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: createUser; targetUser: AuditUser2").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantSystemPermission; permission: " + SystemPermission.ALTER_TABLE.toString() + "; targetUser: " + AUDIT_USER_2).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeSystemPermission; permission: " + SystemPermission.ALTER_TABLE.toString() + "; targetUser: " + AUDIT_USER_2).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: grantTablePermission; permission: " + TablePermission.READ.toString() + "; targetTable: " + NEW_TEST_TABLE_NAME).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: revokeTablePermission; permission: " + TablePermission.READ.toString() + "; targetTable: " + NEW_TEST_TABLE_NAME).size());
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changePassword; targetUser: AuditUser2").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: changeAuthorizations; targetUser: AuditUser2; authorizations: " + auths.toString()).size());
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, "action: dropUser; targetUser: AuditUser2").size());
    }

    @Test
    public void testImportExportOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException, InterruptedException {
        this.conn.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.conn.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.conn, AUDIT_USER_1);
        this.auditConnector = this.getCluster().getConnector(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditConnector.tableOperations().create(OLD_TEST_TABLE_NAME);
        BatchWriter bw = this.auditConnector.createBatchWriter(OLD_TEST_TABLE_NAME, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"myRow");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
        bw.addMutation(m);
        bw.close();
        File exportDir = new File(this.getCluster().getConfig().getDir().toString() + "/export");
        this.auditConnector.tableOperations().offline(OLD_TEST_TABLE_NAME);
        this.auditConnector.tableOperations().exportTable(OLD_TEST_TABLE_NAME, exportDir.toString());
        File distCpTxt = new File(exportDir.toString() + "/distcp.txt");
        File importFile = null;
        String filePrefix = "file:";
        try (java.util.Scanner it = new java.util.Scanner(distCpTxt, StandardCharsets.UTF_8.name());){
            while (it.hasNext() && importFile == null) {
                String line = it.nextLine();
                if (!line.matches(".*\\.rf")) continue;
                importFile = new File(line.replaceFirst(filePrefix, ""));
            }
        }
        FileUtils.copyFileToDirectory(importFile, (File)exportDir);
        this.auditConnector.tableOperations().importTable(NEW_TEST_TABLE_NAME, exportDir.toString());
        this.auditConnector.tableOperations().create(THIRD_TEST_TABLE_NAME);
        File failDir = new File(exportDir + "/tmp");
        Assert.assertTrue((failDir.mkdirs() || failDir.isDirectory() ? 1 : 0) != 0);
        this.auditConnector.tableOperations().importDirectory(THIRD_TEST_TABLE_NAME, exportDir.toString(), failDir.toString(), false);
        this.auditConnector.tableOperations().online(OLD_TEST_TABLE_NAME);
        ArrayList<String> auditMessages = this.getAuditMessages("testImportExportOperationsAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", OLD_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s;", "offlineTable", OLD_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: export; targetTable: %s; dataDir: %s;", OLD_TEST_TABLE_NAME, exportDir.toString())).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: import; targetTable: %s; dataDir: %s;", NEW_TEST_TABLE_NAME, filePrefix + exportDir.toString())).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createTable; targetTable: %s;", THIRD_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: bulkImport; targetTable: %s; dataDir: %s; failDir: %s;", THIRD_TEST_TABLE_NAME, filePrefix + exportDir.toString(), filePrefix + failDir.toString())).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: %s; targetTable: %s;", "onlineTable", OLD_TEST_TABLE_NAME)).size());
    }

    @Test
    public void testDataOperationsAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException, InterruptedException {
        this.conn.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.conn.securityOperations().grantSystemPermission(AUDIT_USER_1, SystemPermission.SYSTEM);
        this.conn.securityOperations().changeUserAuthorizations(AUDIT_USER_1, auths);
        this.grantEverySystemPriv(this.conn, AUDIT_USER_1);
        this.auditConnector = this.getCluster().getConnector(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        this.auditConnector.tableOperations().create(OLD_TEST_TABLE_NAME);
        BatchWriter bw = this.auditConnector.createBatchWriter(OLD_TEST_TABLE_NAME, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"myRow");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v3");
        bw.addMutation(m);
        bw.close();
        Scanner scanner = this.auditConnector.createScanner(OLD_TEST_TABLE_NAME, auths);
        for (Object entry : scanner) {
            System.out.println("Scanner row: " + entry.getKey() + " " + entry.getValue());
        }
        scanner.close();
        BatchScanner bs = this.auditConnector.createBatchScanner(OLD_TEST_TABLE_NAME, auths, 1);
        bs.fetchColumn(new Text("cf1"), new Text("cq1"));
        bs.setRanges(Arrays.asList(new Range((CharSequence)"myRow", (CharSequence)"myRow~")));
        for (Map.Entry entry : bs) {
            System.out.println("BatchScanner row: " + entry.getKey() + " " + entry.getValue());
        }
        bs.close();
        this.auditConnector.tableOperations().deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"));
        ArrayList<String> auditMessages = this.getAuditMessages("testDataOperationsAudits");
        Assert.assertTrue((1 <= AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples").size() ? 1 : 0) != 0);
        Assert.assertTrue((1 <= AuditMessageIT.findAuditMessage(auditMessages, "action: scan; targetTable: apples").size() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")).size());
    }

    @Test
    public void testDeniedAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException, InterruptedException {
        this.conn.securityOperations().createLocalUser(AUDIT_USER_1, new PasswordToken((CharSequence)PASSWORD));
        this.conn.tableOperations().create(OLD_TEST_TABLE_NAME);
        this.auditConnector = this.getCluster().getConnector(AUDIT_USER_1, (AuthenticationToken)new PasswordToken((CharSequence)PASSWORD));
        try {
            this.auditConnector.tableOperations().create(NEW_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().rename(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().clone(OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME, false, Collections.emptyMap(), Collections.emptySet());
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().delete(OLD_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().offline(OLD_TEST_TABLE_NAME);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            Scanner scanner = this.auditConnector.createScanner(OLD_TEST_TABLE_NAME, auths);
            ((Map.Entry)scanner.iterator().next()).getKey();
        }
        catch (RuntimeException scanner) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().deleteRows(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"));
        }
        catch (AccumuloSecurityException scanner) {
            // empty catch block
        }
        try {
            this.auditConnector.tableOperations().flush(OLD_TEST_TABLE_NAME, new Text("myRow"), new Text("myRow~"), false);
        }
        catch (AccumuloSecurityException scanner) {
            // empty catch block
        }
        ArrayList<String> auditMessages = this.getAuditMessages("testDeniedAudits");
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: createTable; targetTable: %s;", NEW_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: renameTable; targetTable: %s; newTableName: %s;", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: cloneTable; targetTable: %s; newTableName: %s", OLD_TEST_TABLE_NAME, NEW_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteTable; targetTable: %s;", OLD_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: %s; targetTable: %s;", "offlineTable", OLD_TEST_TABLE_NAME)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*action: scan; targetTable: apples").size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: deleteData; targetTable: %s; startRange: %s; endRange: %s;", OLD_TEST_TABLE_NAME, "myRow", "myRow~")).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, "operation: denied;.*" + String.format("action: flushTable; targetTable: %s; targetNamespace: %s;", "1", "\\+default")).size());
    }

    @Test
    public void testFailedAudits() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException, IOException, InterruptedException {
        try {
            this.conn.securityOperations().dropLocalUser(AUDIT_USER_2);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.conn.securityOperations().revokeSystemPermission(AUDIT_USER_2, SystemPermission.ALTER_TABLE);
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        try {
            this.conn.securityOperations().createLocalUser("root", new PasswordToken((CharSequence)"super secret"));
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        ArrayList<String> auditMessages = this.getAuditMessages("testFailedAudits");
        Assert.assertEquals((long)2L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: dropUser; targetUser: %s;", AUDIT_USER_2)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: revokeSystemPermission; permission: %s; targetUser: %s;", SystemPermission.ALTER_TABLE, AUDIT_USER_2)).size());
        Assert.assertEquals((long)1L, (long)AuditMessageIT.findAuditMessage(auditMessages, String.format("action: createUser; targetUser: %s; Authorizations: %s;", "root", "")).size());
    }
}

