/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.BatchWriterIterator;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class BatchWriterInTabletServerIT
extends AccumuloClusterHarness {
    private static final Logger log = Logger.getLogger(BatchWriterInTabletServerIT.class);

    @Override
    public boolean canRunTest(AccumuloClusterHarness.ClusterType type) {
        return AccumuloClusterHarness.ClusterType.MINI == type;
    }

    @Test
    public void testNormalWrite() throws Exception {
        String[] uniqueNames = this.getUniqueNames(2);
        String t1 = uniqueNames[0];
        String t2 = uniqueNames[1];
        Connector c = this.getConnector();
        int numEntriesToWritePerEntry = 50;
        IteratorSetting itset = BatchWriterIterator.iteratorSetting(6, 0, 15L, 1000L, numEntriesToWritePerEntry, t2, c, BatchWriterInTabletServerIT.getAdminToken(), false, false);
        this.test(t1, t2, c, itset, numEntriesToWritePerEntry);
    }

    @Test
    public void testClearLocatorAndSplitWrite() throws Exception {
        String[] uniqueNames = this.getUniqueNames(2);
        String t1 = uniqueNames[0];
        String t2 = uniqueNames[1];
        Connector c = this.getConnector();
        int numEntriesToWritePerEntry = 50;
        IteratorSetting itset = BatchWriterIterator.iteratorSetting(6, 0, 15L, 1000L, numEntriesToWritePerEntry, t2, c, BatchWriterInTabletServerIT.getAdminToken(), true, true);
        this.test(t1, t2, c, itset, numEntriesToWritePerEntry);
    }

    private void test(String t1, String t2, Connector c, IteratorSetting itset, int numEntriesToWritePerEntry) throws Exception {
        c.tableOperations().create(t1);
        Key k = new Key(new Text("row"), new Text("cf"), new Text("cq"));
        Value v = new Value("1".getBytes());
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(0L);
        BatchWriter writer = c.createBatchWriter(t1, config);
        Mutation m = new Mutation(k.getRow());
        m.put(k.getColumnFamily(), k.getColumnQualifier(), v);
        writer.addMutation(m);
        writer.close();
        c.tableOperations().create(t2);
        IteratorSetting summer = new IteratorSetting(2, "summer", SummingCombiner.class);
        LongCombiner.setEncodingType((IteratorSetting)summer, (LongCombiner.Type)LongCombiner.Type.STRING);
        LongCombiner.setCombineAllColumns((IteratorSetting)summer, (boolean)true);
        c.tableOperations().attachIterator(t2, summer);
        Scanner scanner = c.createScanner(t1, Authorizations.EMPTY);
        scanner.addScanIterator(itset);
        Map.Entry actual = (Map.Entry)Iterators.getOnlyElement((Iterator)scanner.iterator());
        Assert.assertTrue((boolean)((Key)actual.getKey()).equals(k, PartialKey.ROW_COLFAM_COLQUAL));
        Assert.assertEquals((Object)BatchWriterIterator.SUCCESS_VALUE, actual.getValue());
        scanner.close();
        scanner = c.createScanner(t2, Authorizations.EMPTY);
        actual = (Map.Entry)Iterators.getOnlyElement((Iterator)scanner.iterator());
        log.debug((Object)("t2 entry is " + ((Key)actual.getKey()).toStringNoTime() + " -> " + actual.getValue()));
        Assert.assertTrue((boolean)((Key)actual.getKey()).equals(k, PartialKey.ROW_COLFAM_COLQUAL));
        Assert.assertEquals((long)numEntriesToWritePerEntry, (long)Integer.parseInt(((Value)actual.getValue()).toString()));
        scanner.close();
        c.tableOperations().delete(t1);
        c.tableOperations().delete(t2);
    }
}

