/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.examples.simple.filedata;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.examples.simple.filedata.ChunkInputFormat;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.examples.simple.filedata.ChunkInputStreamIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChunkInputFormatIT
extends AccumuloClusterHarness {
    private static Multimap<String, AssertionError> assertionErrors = ArrayListMultimap.create();
    private static final Authorizations AUTHS = new Authorizations(new String[]{"A", "B", "C", "D"});
    private static List<Map.Entry<Key, Value>> data;
    private static List<Map.Entry<Key, Value>> baddata;
    private Connector conn;
    private String tableName;

    @Before
    public void setupInstance() throws Exception {
        this.conn = this.getConnector();
        this.tableName = this.getUniqueNames(1)[0];
        this.conn.securityOperations().changeUserAuthorizations(this.conn.whoami(), AUTHS);
    }

    @BeforeClass
    public static void setupClass() {
        System.setProperty("hadoop.tmp.dir", System.getProperty("user.dir") + "/target/hadoop-tmp");
        data = new ArrayList<Map.Entry<Key, Value>>();
        ChunkInputStreamIT.addData(data, "a", "refs", "ida\u0000ext", "A&B", "ext");
        ChunkInputStreamIT.addData(data, "a", "refs", "ida\u0000name", "A&B", "name");
        ChunkInputStreamIT.addData(data, "a", "~chunk", 100, 0, "A&B", "asdfjkl;");
        ChunkInputStreamIT.addData(data, "a", "~chunk", 100, 1, "A&B", "");
        ChunkInputStreamIT.addData(data, "b", "refs", "ida\u0000ext", "A&B", "ext");
        ChunkInputStreamIT.addData(data, "b", "refs", "ida\u0000name", "A&B", "name");
        ChunkInputStreamIT.addData(data, "b", "~chunk", 100, 0, "A&B", "qwertyuiop");
        ChunkInputStreamIT.addData(data, "b", "~chunk", 100, 0, "B&C", "qwertyuiop");
        ChunkInputStreamIT.addData(data, "b", "~chunk", 100, 1, "A&B", "");
        ChunkInputStreamIT.addData(data, "b", "~chunk", 100, 1, "B&C", "");
        ChunkInputStreamIT.addData(data, "b", "~chunk", 100, 1, "D", "");
        baddata = new ArrayList<Map.Entry<Key, Value>>();
        ChunkInputStreamIT.addData(baddata, "c", "refs", "ida\u0000ext", "A&B", "ext");
        ChunkInputStreamIT.addData(baddata, "c", "refs", "ida\u0000name", "A&B", "name");
    }

    public static void entryEquals(Map.Entry<Key, Value> e1, Map.Entry<Key, Value> e2) {
        Assert.assertEquals((Object)e1.getKey(), (Object)e2.getKey());
        Assert.assertEquals((Object)e1.getValue(), (Object)e2.getValue());
    }

    @Test
    public void test() throws Exception {
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        for (Map.Entry<Key, Value> e : data) {
            Key k = e.getKey();
            Mutation m = new Mutation(k.getRow());
            m.put(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), k.getTimestamp(), e.getValue());
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)CIFTester.main(this.tableName, CIFTester.TestMapper.class.getName()));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)this.tableName).size());
    }

    @Test
    public void testErrorOnNextWithoutClose() throws Exception {
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        for (Map.Entry<Key, Value> e : data) {
            Key k = e.getKey();
            Mutation m = new Mutation(k.getRow());
            m.put(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), k.getTimestamp(), e.getValue());
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)1L, (long)CIFTester.main(this.tableName, CIFTester.TestNoClose.class.getName()));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)this.tableName).size());
        Assert.assertEquals((long)2L, (long)assertionErrors.get((Object)(this.tableName + "_map_ioexception")).size());
    }

    @Test
    public void testInfoWithoutChunks() throws Exception {
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        for (Map.Entry<Key, Value> e : baddata) {
            Key k = e.getKey();
            Mutation m = new Mutation(k.getRow());
            m.put(k.getColumnFamily(), k.getColumnQualifier(), new ColumnVisibility(k.getColumnVisibility()), k.getTimestamp(), e.getValue());
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)CIFTester.main(this.tableName, CIFTester.TestBadData.class.getName()));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)this.tableName).size());
    }

    static /* synthetic */ List access$000() {
        return data;
    }

    public static class CIFTester
    extends Configured
    implements Tool {
        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + CIFTester.class.getName() + " <table> <mapperClass>");
            }
            String table = args[0];
            assertionErrors.put((Object)table, (Object)new AssertionError((Object)"Dummy"));
            assertionErrors.put((Object)(table + "_map_ioexception"), (Object)new AssertionError((Object)"Dummy_ioexception"));
            this.getConf().set("MRTester_tableName", table);
            Job job = Job.getInstance((Configuration)this.getConf());
            job.setJobName(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(ChunkInputFormat.class);
            ChunkInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            ChunkInputFormat.setConnectorInfo((Job)job, (String)AccumuloClusterHarness.getAdminPrincipal(), (AuthenticationToken)AccumuloClusterHarness.getAdminToken());
            ChunkInputFormat.setInputTableName((Job)job, (String)table);
            ChunkInputFormat.setScanAuthorizations((Job)job, (Authorizations)AUTHS);
            Class<?> forName = Class.forName(args[1]);
            job.setMapperClass(forName);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static int main(String ... args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            return ToolRunner.run((Configuration)conf, (Tool)new CIFTester(), (String[])args);
        }

        public static class TestBadData
        extends Mapper<List<Map.Entry<Key, Value>>, InputStream, List<Map.Entry<Key, Value>>, InputStream> {
            protected void map(List<Map.Entry<Key, Value>> key, InputStream value, Mapper.Context context) throws IOException, InterruptedException {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                byte[] b = new byte[20];
                try {
                    Assert.assertEquals((long)key.size(), (long)2L);
                    ChunkInputFormatIT.entryEquals(key.get(0), (Map.Entry)baddata.get(0));
                    ChunkInputFormatIT.entryEquals(key.get(1), (Map.Entry)baddata.get(1));
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)table, (Object)e);
                }
                try {
                    Assert.assertFalse((value.read(b) > 0 ? 1 : 0) != 0);
                    try {
                        Assert.fail();
                    }
                    catch (AssertionError e) {
                        assertionErrors.put((Object)table, (Object)e);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    value.close();
                    try {
                        Assert.fail();
                    }
                    catch (AssertionError e) {
                        assertionErrors.put((Object)table, (Object)e);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static class TestNoClose
        extends Mapper<List<Map.Entry<Key, Value>>, InputStream, List<Map.Entry<Key, Value>>, InputStream> {
            int count = 0;

            protected void map(List<Map.Entry<Key, Value>> key, InputStream value, Mapper.Context context) throws IOException, InterruptedException {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                byte[] b = new byte[5];
                try {
                    switch (this.count) {
                        case 0: {
                            int read = value.read(b);
                            Assert.assertEquals((long)read, (long)5L);
                            Assert.assertEquals((Object)new String(b, 0, read), (Object)"asdfj");
                            break;
                        }
                        default: {
                            Assert.fail();
                            break;
                        }
                    }
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)table, (Object)e);
                }
                ++this.count;
                try {
                    context.nextKeyValue();
                    Assert.fail();
                }
                catch (IOException ioe) {
                    assertionErrors.put((Object)(table + "_map_ioexception"), (Object)new AssertionError(((Object)((Object)this)).toString(), ioe));
                }
            }
        }

        public static class TestMapper
        extends Mapper<List<Map.Entry<Key, Value>>, InputStream, List<Map.Entry<Key, Value>>, InputStream> {
            int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected void map(List<Map.Entry<Key, Value>> key, InputStream value, Mapper.Context context) throws IOException, InterruptedException {
                table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                b = new byte[20];
                try {
                    switch (this.count) {
                        case 0: {
                            Assert.assertEquals((long)key.size(), (long)2L);
                            ChunkInputFormatIT.entryEquals(key.get(0), (Map.Entry)ChunkInputFormatIT.access$000().get(0));
                            ChunkInputFormatIT.entryEquals(key.get(1), (Map.Entry)ChunkInputFormatIT.access$000().get(1));
                            read = value.read(b);
                            Assert.assertEquals((long)read, (long)8L);
                            Assert.assertEquals((Object)new String(b, 0, read), (Object)"asdfjkl;");
                            read = value.read(b);
                            Assert.assertEquals((long)read, (long)-1L);
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            Assert.assertEquals((long)key.size(), (long)2L);
                            ChunkInputFormatIT.entryEquals(key.get(0), (Map.Entry)ChunkInputFormatIT.access$000().get(4));
                            ChunkInputFormatIT.entryEquals(key.get(1), (Map.Entry)ChunkInputFormatIT.access$000().get(5));
                            read = value.read(b);
                            Assert.assertEquals((long)read, (long)10L);
                            Assert.assertEquals((Object)new String(b, 0, read), (Object)"qwertyuiop");
                            read = value.read(b);
                            Assert.assertEquals((long)read, (long)-1L);
                            ** break;
lbl27:
                            // 1 sources

                            break;
                        }
                        default: {
                            Assert.fail();
                            break;
                        }
                    }
                }
                catch (AssertionError e) {
                    ChunkInputFormatIT.access$100().put((Object)table, (Object)e);
                }
                finally {
                    value.close();
                }
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                try {
                    Assert.assertEquals((long)2L, (long)this.count);
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)table, (Object)e);
                }
            }
        }
    }
}

