/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.master.tableOps.BulkImport;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TServiceClient;
import org.junit.Assert;
import org.junit.Test;

public class BulkFailureIT
extends AccumuloClusterHarness {
    @Test
    public void testImportCompactionImport() throws Exception {
        Connector c = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        SortedMap<Key, Value> testData = this.createTestData();
        FileSystem fs = BulkFailureIT.getCluster().getFileSystem();
        String testFile = this.createTestFile(testData, fs);
        c.tableOperations().create(table);
        String tableId = (String)c.tableOperations().tableIdMap().get(table);
        KeyExtent extent = new KeyExtent(tableId.toString(), null, null);
        this.setupSiteConfig();
        long fateTxid = 99999999L;
        AccumuloServerContext asCtx = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
        TransactionWatcher.ZooArbitrator.start((String)"bulkTx", (long)fateTxid);
        VolumeManager vm = VolumeManagerImpl.get();
        String bulkDir = BulkImport.prepareBulkImport((AccumuloServerContext)asCtx, (VolumeManager)vm, (String)testFile, (String)tableId);
        FileStatus status = fs.listStatus(new Path(bulkDir))[0];
        Path bulkLoadPath = fs.makeQualified(status.getPath());
        this.assignMapFiles(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath.toString(), status.getLen());
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getFiles(c, extent));
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getLoaded(c, extent));
        Assert.assertEquals(testData, this.readTable(table, c));
        c.tableOperations().compact(table, new CompactionConfig().setWait(true));
        Set<Path> tabletFiles = this.getFiles(c, extent);
        Assert.assertFalse((boolean)tabletFiles.contains(bulkLoadPath));
        Assert.assertEquals((long)1L, (long)tabletFiles.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getLoaded(c, extent));
        Assert.assertEquals(testData, this.readTable(table, c));
        this.assignMapFiles(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath.toString(), status.getLen());
        Assert.assertEquals(tabletFiles, this.getFiles(c, extent));
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getLoaded(c, extent));
        Assert.assertEquals(testData, this.readTable(table, c));
        c.tableOperations().offline(table, true);
        c.tableOperations().online(table, true);
        this.assignMapFiles(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath.toString(), status.getLen());
        Assert.assertEquals(tabletFiles, this.getFiles(c, extent));
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getLoaded(c, extent));
        Assert.assertEquals(testData, this.readTable(table, c));
        TransactionWatcher.ZooArbitrator.stop((String)"bulkTx", (long)fateTxid);
        try {
            this.assignMapFiles(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath.toString(), status.getLen());
            Assert.fail();
        }
        catch (TApplicationException tApplicationException) {
            // empty catch block
        }
        Assert.assertEquals(tabletFiles, this.getFiles(c, extent));
        Assert.assertEquals((Object)ImmutableSet.of((Object)bulkLoadPath), this.getLoaded(c, extent));
        Assert.assertEquals(testData, this.readTable(table, c));
    }

    private SortedMap<Key, Value> createTestData() {
        TreeMap<Key, Value> testData = new TreeMap<Key, Value>();
        testData.put(new Key((CharSequence)"r001", (CharSequence)"f002", (CharSequence)"q009", 56L), new Value((CharSequence)"v001"));
        testData.put(new Key((CharSequence)"r001", (CharSequence)"f002", (CharSequence)"q019", 56L), new Value((CharSequence)"v002"));
        testData.put(new Key((CharSequence)"r002", (CharSequence)"f002", (CharSequence)"q009", 57L), new Value((CharSequence)"v003"));
        testData.put(new Key((CharSequence)"r002", (CharSequence)"f002", (CharSequence)"q019", 57L), new Value((CharSequence)"v004"));
        return testData;
    }

    private String createTestFile(SortedMap<Key, Value> testData, FileSystem fs) throws IOException {
        Path base = new Path(BulkFailureIT.getCluster().getTemporaryPath(), "testBulk_ICI");
        fs.delete(base, true);
        fs.mkdirs(base);
        Path files = new Path(base, "files");
        try (RFileWriter writer = RFile.newWriter().to(new Path(files, "ici_01.rf").toString()).withFileSystem(fs).build();){
            writer.append(testData.entrySet());
        }
        String filesStr = fs.makeQualified(files).toString();
        return filesStr;
    }

    private SortedMap<Key, Value> readTable(String table, Connector connector) throws TableNotFoundException {
        Scanner scanner = connector.createScanner(table, Authorizations.EMPTY);
        TreeMap<Key, Value> actual = new TreeMap<Key, Value>();
        for (Map.Entry entry : scanner) {
            actual.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        return actual;
    }

    public Set<Path> getLoaded(Connector connector, KeyExtent extent) throws TableNotFoundException {
        return this.getPaths(connector, extent, MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
    }

    public Set<Path> getFiles(Connector connector, KeyExtent extent) throws TableNotFoundException {
        return this.getPaths(connector, extent, MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
    }

    private Set<Path> getPaths(Connector connector, KeyExtent extent, Text fam) throws TableNotFoundException {
        HashSet<Path> files = new HashSet<Path>();
        Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(extent.toMetadataRange());
        scanner.fetchColumnFamily(fam);
        for (Map.Entry entry : scanner) {
            files.add(new Path(((Key)entry.getKey()).getColumnQualifierData().toString()));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyExtent> assignMapFiles(long txid, ClientContext context, KeyExtent extent, String path, long size) throws Exception {
        TabletLocator locator = TabletLocator.getLocator((ClientContext)context, (String)extent.getTableId());
        locator.invalidateCache(extent);
        HostAndPort location = HostAndPort.fromString((String)locator.locateTablet((ClientContext)context, (Text)new Text((String)""), (boolean)false, (boolean)true).tablet_location);
        long timeInMillis = context.getConfiguration().getTimeInMillis(Property.TSERV_BULK_TIMEOUT);
        TabletClientService.Client client = ThriftUtil.getTServerClient((HostAndPort)location, (ClientContext)context, (long)timeInMillis);
        try {
            ImmutableMap val = ImmutableMap.of((Object)path, (Object)new MapFileInfo(size));
            ImmutableMap files = ImmutableMap.of((Object)extent, (Object)val);
            List failures = client.bulkImport(Tracer.traceInfo(), context.rpcCreds(), txid, Translator.translate((Map)files, (Translator)Translators.KET), false);
            List list = Translator.translate((Collection)failures, (Translator)Translators.TKET);
            return list;
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)((TServiceClient)client));
        }
    }

    private void setupSiteConfig() throws AccumuloException, AccumuloSecurityException {
        for (Map.Entry entry : BulkFailureIT.getCluster().getSiteConfiguration()) {
            SiteConfiguration.getInstance().set((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

