/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SessionDurabilityIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 180;
    }

    @Test
    public void nondurableTableHasDurableWrites() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "none");
        BatchWriterConfig cfg = new BatchWriterConfig();
        cfg.setDurability(Durability.SYNC);
        this.writeSome(tableName, 10, cfg);
        Assert.assertEquals((long)10L, (long)this.count(tableName));
        this.restartTServer();
        Assert.assertEquals((long)10L, (long)this.count(tableName));
    }

    @Test
    public void durableTableLosesNonDurableWrites() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "sync");
        BatchWriterConfig cfg = new BatchWriterConfig();
        cfg.setDurability(Durability.NONE);
        this.writeSome(tableName, 10, cfg);
        this.restartTServer();
        Assert.assertTrue((10 > this.count(tableName) ? 1 : 0) != 0);
    }

    private int count(String tableName) throws Exception {
        return Iterators.size((Iterator)this.getConnector().createScanner(tableName, Authorizations.EMPTY).iterator());
    }

    private void writeSome(String tableName, int n, BatchWriterConfig cfg) throws Exception {
        Connector c = this.getConnector();
        BatchWriter bw = c.createBatchWriter(tableName, cfg);
        for (int i = 0; i < n; ++i) {
            Mutation m = new Mutation((CharSequence)(i + ""));
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        bw.close();
    }

    @Test
    public void testConditionDurability() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "sync");
        ConditionalWriterConfig cfg = new ConditionalWriterConfig();
        cfg.setDurability(Durability.NONE);
        this.conditionWriteSome(tableName, 10, cfg);
        Assert.assertEquals((long)10L, (long)this.count(tableName));
        this.restartTServer();
        Assert.assertEquals((long)0L, (long)this.count(tableName));
    }

    @Test
    public void testConditionDurability2() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "none");
        ConditionalWriterConfig cfg = new ConditionalWriterConfig();
        cfg.setDurability(Durability.SYNC);
        this.conditionWriteSome(tableName, 10, cfg);
        Assert.assertEquals((long)10L, (long)this.count(tableName));
        this.restartTServer();
        Assert.assertEquals((long)10L, (long)this.count(tableName));
    }

    private void conditionWriteSome(String tableName, int n, ConditionalWriterConfig cfg) throws Exception {
        Connector c = this.getConnector();
        ConditionalWriter cw = c.createConditionalWriter(tableName, cfg);
        for (int i = 0; i < n; ++i) {
            ConditionalMutation m = new ConditionalMutation((CharSequence)(i + ""), new Condition[]{new Condition((CharSequence)"", (CharSequence)"")});
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"X");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(m).getStatus());
        }
    }

    private void restartTServer() throws Exception {
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.start();
    }
}

