/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.junit.Test;

public class WriteLotsIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 90;
    }

    @Test
    public void writeLots() throws Exception {
        final Connector c = this.getConnector();
        final String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        final AtomicReference ref = new AtomicReference();
        final ClientConfiguration clientConfig = WriteLotsIT.getCluster().getClientConfig();
        int THREADS = 5;
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int i = 0;
        while (i < 5) {
            final int index = i++;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        TestIngest.Opts opts = new TestIngest.Opts();
                        opts.startRow = index * 10000;
                        opts.rows = 10000;
                        opts.setTableName(tableName);
                        if (clientConfig.hasSasl()) {
                            opts.updateKerberosCredentials(clientConfig);
                        } else {
                            opts.setPrincipal(AccumuloClusterHarness.getAdminPrincipal());
                        }
                        BatchWriterOpts bwOpts = new BatchWriterOpts();
                        bwOpts.batchMemory = 0x100000L;
                        bwOpts.batchThreads = 2;
                        TestIngest.ingest(c, opts, new BatchWriterOpts());
                    }
                    catch (Exception ex) {
                        ref.set(ex);
                    }
                }
            };
            tpe.execute(r);
        }
        tpe.shutdown();
        tpe.awaitTermination(90L, TimeUnit.SECONDS);
        if (ref.get() != null) {
            throw (Exception)ref.get();
        }
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        vopts.rows = 50000;
        vopts.setTableName(tableName);
        if (clientConfig.hasSasl()) {
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            vopts.setPrincipal(WriteLotsIT.getAdminPrincipal());
        }
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
    }
}

