/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AccumuloInputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    private static int e1Count = 0;
    private static AssertionError e2 = null;
    private static int e2Count = 0;
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");

    @BeforeClass
    public static void setupClass() {
        System.setProperty("hadoop.tmp.dir", System.getProperty("user.dir") + "/target/hadoop-tmp");
    }

    @Test
    public void testMap() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(table);
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        e1 = null;
        e2 = null;
        MRTester.main(table);
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
    }

    @Test
    public void testSample() throws Exception {
        String TEST_TABLE_3 = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(TEST_TABLE_3, new NewTableConfiguration().enableSampling(SAMPLER_CONFIG));
        BatchWriter bw = c.createBatchWriter(TEST_TABLE_3, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        MRTester.main(TEST_TABLE_3, "False", "True");
        Assert.assertEquals((long)38L, (long)e1Count);
        Assert.assertEquals((long)1L, (long)e2Count);
        e1Count = 0;
        e2Count = 0;
        MRTester.main(TEST_TABLE_3, "False", "False");
        Assert.assertEquals((long)0L, (long)e1Count);
        Assert.assertEquals((long)0L, (long)e2Count);
        e1Count = 0;
        e2Count = 0;
        MRTester.main(TEST_TABLE_3, "True", "True");
        Assert.assertEquals((long)38L, (long)e1Count);
        Assert.assertEquals((long)1L, (long)e2Count);
    }

    @Test
    public void testCorrectRangeInputSplits() throws Exception {
        JobConf job = new JobConf();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        Connector connector = this.getConnector();
        connector.tableOperations().create(table);
        AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
        AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
        AccumuloInputFormat.setScanAuthorizations((JobConf)job, (Authorizations)auths);
        AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (ClientConfiguration)AccumuloInputFormatIT.getCluster().getClientConfig());
        AccumuloInputFormat.setScanIsolation((JobConf)job, (boolean)isolated);
        AccumuloInputFormat.setLocalIterators((JobConf)job, (boolean)localIters);
        AccumuloInputFormat.fetchColumns((JobConf)job, fetchColumns);
        AccumuloInputFormat.setLogLevel((JobConf)job, (Level)level);
        AccumuloInputFormat aif = new AccumuloInputFormat();
        InputSplit[] splits = aif.getSplits(job, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        InputSplit split = splits[0];
        Assert.assertEquals(RangeInputSplit.class, split.getClass());
        RangeInputSplit risplit = (RangeInputSplit)split;
        Assert.assertEquals((Object)AccumuloInputFormatIT.getAdminPrincipal(), (Object)risplit.getPrincipal());
        Assert.assertEquals((Object)table, (Object)risplit.getTableName());
        Assert.assertEquals((Object)AccumuloInputFormatIT.getAdminToken(), (Object)risplit.getToken());
        Assert.assertEquals((Object)auths, (Object)risplit.getAuths());
        Assert.assertEquals((Object)this.getConnector().getInstance().getInstanceName(), (Object)risplit.getInstanceName());
        Assert.assertEquals((Object)isolated, (Object)risplit.isIsolatedScan());
        Assert.assertEquals((Object)localIters, (Object)risplit.usesLocalIterators());
        Assert.assertEquals(fetchColumns, (Object)risplit.getFetchedColumns());
        Assert.assertEquals((Object)level, (Object)risplit.getLogLevel());
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1 && args.length != 3) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> [<batchScan> <scan sample>]");
            }
            String table = args[0];
            Boolean batchScan = false;
            boolean sample = false;
            if (args.length == 3) {
                batchScan = Boolean.parseBoolean(args[1]);
                sample = Boolean.parseBoolean(args[2]);
            }
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloInputFormat.class);
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)AccumuloClusterHarness.getAdminPrincipal(), (AuthenticationToken)AccumuloClusterHarness.getAdminToken());
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
            AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            AccumuloInputFormat.setBatchScan((JobConf)job, (boolean)batchScan);
            if (sample) {
                AccumuloInputFormat.setSamplerConfiguration((JobConf)job, (SamplerConfiguration)SAMPLER_CONFIG);
            }
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String ... args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        implements Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            public void map(Key k, Value v, OutputCollector<Key, Value> output, Reporter reporter) throws IOException {
                try {
                    if (this.key != null) {
                        Assert.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assert.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assert.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                    e1Count++;
                }
                this.key = new Key(k);
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() throws IOException {
                try {
                    Assert.assertEquals((long)100L, (long)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                    e2Count++;
                }
            }
        }
    }
}

