/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapreduce.AccumuloMultiTableInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class AccumuloMultiTableInputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    private static AssertionError e2 = null;

    @Test
    public void testMap() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        Connector c = this.getConnector();
        c.tableOperations().create(table1);
        c.tableOperations().create(table2);
        BatchWriter bw = c.createBatchWriter(table1, new BatchWriterConfig());
        BatchWriter bw2 = c.createBatchWriter(table2, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation t1m = new Mutation(new Text(String.format("%s_%09x", table1, i + 1)));
            t1m.put(new Text(), new Text(), new Value(String.format("%s_%09x", table1, i).getBytes()));
            bw.addMutation(t1m);
            Mutation t2m = new Mutation(new Text(String.format("%s_%09x", table2, i + 1)));
            t2m.put(new Text(), new Text(), new Value(String.format("%s_%09x", table2, i).getBytes()));
            bw2.addMutation(t2m);
        }
        bw.close();
        bw2.close();
        MRTester.main(new String[]{table1, table2});
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table1> <table2>");
            }
            String user = AccumuloClusterHarness.getAdminPrincipal();
            AuthenticationToken pass = AccumuloClusterHarness.getAdminToken();
            String table1 = args[0];
            String table2 = args[1];
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloMultiTableInputFormat.class);
            AccumuloMultiTableInputFormat.setConnectorInfo((Job)job, (String)user, (AuthenticationToken)pass);
            InputTableConfig tableConfig1 = new InputTableConfig();
            InputTableConfig tableConfig2 = new InputTableConfig();
            HashMap<String, InputTableConfig> configMap = new HashMap<String, InputTableConfig>();
            configMap.put(table1, tableConfig1);
            configMap.put(table2, tableConfig2);
            AccumuloMultiTableInputFormat.setInputTableConfigs((Job)job, configMap);
            AccumuloMultiTableInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        extends Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) throws IOException, InterruptedException {
                try {
                    String tableName = ((RangeInputSplit)context.getInputSplit()).getTableName();
                    if (this.key != null) {
                        Assert.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assert.assertEquals((Object)new Text(String.format("%s_%09x", tableName, this.count + 1)), (Object)k.getRow());
                    Assert.assertEquals((Object)String.format("%s_%09x", tableName, this.count), (Object)new String(v.get()));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                try {
                    Assert.assertEquals((long)100L, (long)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

