/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.metrics;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFileTailer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MetricsFileTailer.class);
    private static final int BUFFER_SIZE = 4;
    private final String metricsPrefix;
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean running = new AtomicBoolean(Boolean.FALSE);
    private final AtomicLong lastUpdate = new AtomicLong(0L);
    private final long startTime = System.nanoTime();
    private int lineCounter = 0;
    private final String[] lineBuffer = new String[4];
    private final String metricsFilename;

    public MetricsFileTailer(String metricsPrefix) {
        this.metricsPrefix = metricsPrefix;
        Configuration sub = this.loadMetricsConfig();
        if (log.isTraceEnabled()) {
            Iterator keys = sub.getKeys();
            while (keys.hasNext()) {
                log.trace("configuration key:{}", keys.next());
            }
        }
        this.metricsFilename = sub.containsKey("filename") ? sub.getString("filename") : "";
    }

    MetricsFileTailer(String metricsPrefix, String filename) {
        this.metricsPrefix = metricsPrefix;
        this.metricsFilename = filename;
    }

    private Configuration loadMetricsConfig() {
        try {
            URL propUrl = this.getClass().getClassLoader().getResource("hadoop-metrics2-accumulo.properties");
            if (propUrl == null) {
                throw new IllegalStateException("Could not find hadoop-metrics2-accumulo.properties on classpath");
            }
            String filename = propUrl.getFile();
            PropertiesConfiguration config = new PropertiesConfiguration(filename);
            Configuration sub = config.subset(this.metricsPrefix);
            if (log.isTraceEnabled()) {
                log.trace("Config {}", (Object)config);
                Iterator iterator = sub.getKeys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    log.trace("'{}'='{}'", (Object)key, sub.getProperty(key));
                }
            }
            return sub;
        }
        catch (ConfigurationException ex) {
            throw new IllegalStateException(String.format("Could not find configuration file '%s' on classpath", "hadoop-metrics2-accumulo.properties"));
        }
    }

    public long getLastUpdate() {
        return this.lastUpdate.get();
    }

    public String getLast() {
        this.lock.lock();
        try {
            int last = this.lineCounter % 4 - 1;
            if (last < 0) {
                last = 3;
            }
            String string = this.lineBuffer[last];
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, String> parseLine(String prefix) {
        String[] csvTokens;
        String line = this.getLast();
        if (line == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (String token : csvTokens = line.split(",")) {
            if (!this.filter(prefix, token = token.trim())) continue;
            String[] parts = token.split("=");
            m.put(parts[0], parts[1]);
        }
        return m;
    }

    private boolean filter(String prefix, String candidate) {
        if (candidate == null) {
            return false;
        }
        if (prefix == null || prefix.isEmpty()) {
            return true;
        }
        return candidate.startsWith(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        long filePos = 0L;
        File f = new File(this.metricsFilename);
        while (this.running.get()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                this.running.set(Boolean.FALSE);
                Thread.currentThread().interrupt();
                return;
            }
            long len = f.length();
            try {
                if (len < filePos) {
                    filePos = 0L;
                    this.lock.lock();
                    try {
                        for (int i = 0; i < 4; ++i) {
                            this.lineBuffer[i] = "";
                        }
                        this.lineCounter = 0;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if (len <= filePos) continue;
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                raf.seek(filePos);
                this.lock.lock();
                try {
                    String line;
                    while ((line = raf.readLine()) != null) {
                        this.lineBuffer[this.lineCounter++ % 4] = line;
                    }
                    this.lastUpdate.set(System.nanoTime() - this.startTime);
                }
                finally {
                    this.lock.unlock();
                }
                filePos = raf.getFilePointer();
                raf.close();
            }
            catch (Exception ex) {
                log.info("Error processing metrics file {}", (Object)this.metricsFilename, (Object)ex);
            }
        }
    }

    public void startDaemonThread() {
        if (this.running.compareAndSet(false, true)) {
            Thread t = new Thread(() -> this.run());
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void close() {
        this.running.set(Boolean.FALSE);
    }

    public LineUpdate waitForUpdate(long prevUpdate, int maxAttempts, long delay) {
        for (int count = 0; count < maxAttempts; ++count) {
            String line = this.getLast();
            long currUpdate = this.getLastUpdate();
            if (line != null && currUpdate != prevUpdate) {
                return new LineUpdate(this.getLastUpdate(), line);
            }
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
        throw new IllegalStateException(String.format("File source update not received after %d tries in %d sec", maxAttempts, TimeUnit.MILLISECONDS.toSeconds(delay * (long)maxAttempts)));
    }

    public static class LineUpdate {
        private final long lastUpdate;
        private final String line;

        public LineUpdate(long lastUpdate, String line) {
            this.lastUpdate = lastUpdate;
            this.line = line;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public String getLine() {
            return this.line;
        }

        public String toString() {
            return "LineUpdate{lastUpdate=" + this.lastUpdate + ", line='" + this.line + '\'' + '}';
        }
    }
}

