/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProxyInstanceOperations {
    private static final Logger log = LoggerFactory.getLogger(TestProxyInstanceOperations.class);
    protected static TServer proxy;
    protected static TestProxyClient tpc;
    protected static ByteBuffer userpass;
    protected static final int port = 10197;

    @BeforeClass
    public static void setup() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("useMockInstance", "true");
        prop.put("tokenClass", PasswordToken.class.getName());
        proxy = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)10197), (TProtocolFactory)new TCompactProtocol.Factory(), (Properties)prop).server;
        log.info("Waiting for proxy to start");
        while (!proxy.isServing()) {
            Thread.sleep(500L);
        }
        log.info("Proxy started");
        tpc = new TestProxyClient("localhost", 10197);
        userpass = TestProxyInstanceOperations.tpc.proxy.login("root", Collections.singletonMap("password", ""));
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        proxy.stop();
    }

    @Test
    public void properties() throws TException {
        tpc.proxy().setProperty(userpass, "test.systemprop", "whistletips");
        Assert.assertEquals(tpc.proxy().getSystemConfiguration(userpass).get("test.systemprop"), (Object)"whistletips");
        tpc.proxy().removeProperty(userpass, "test.systemprop");
        Assert.assertNull(tpc.proxy().getSystemConfiguration(userpass).get("test.systemprop"));
    }

    @Test
    public void testClassLoad() throws TException {
        Assert.assertTrue((boolean)tpc.proxy().testClassLoad(userpass, "org.apache.accumulo.core.iterators.user.RegExFilter", "org.apache.accumulo.core.iterators.Filter"));
    }
}

