/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveQueueing {
    private static final Logger log = LoggerFactory.getLogger(SelectiveQueueing.class);

    public static boolean shouldQueueOperation(State state, Environment env) throws Exception {
        Connector conn;
        int numTservers;
        ThreadPoolExecutor pool = (ThreadPoolExecutor)state.get("pool");
        long queuedThreads = pool.getTaskCount() - (long)pool.getActiveCount() - pool.getCompletedTaskCount();
        if (!SelectiveQueueing.shouldQueue(queuedThreads, numTservers = (conn = env.getConnector()).instanceOperations().getTabletServers().size())) {
            log.info("Not queueing because of " + queuedThreads + " outstanding tasks");
            return false;
        }
        return true;
    }

    private static boolean shouldQueue(long queuedThreads, int numTservers) {
        return queuedThreads < (long)(numTservers * 50);
    }
}

