/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class RenameNamespace
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List namespaces = (List)state.get("namespaces");
        String srcName = (String)namespaces.get(rand.nextInt(namespaces.size()));
        String newName = (String)namespaces.get(rand.nextInt(namespaces.size()));
        try {
            conn.namespaceOperations().rename(srcName, newName);
            this.log.debug((Object)("Renamed namespace " + srcName + " " + newName));
        }
        catch (NamespaceExistsException e) {
            this.log.debug((Object)("Rename namespace " + srcName + " failed, " + newName + " exists"));
        }
        catch (NamespaceNotFoundException e) {
            this.log.debug((Object)("Rename namespace " + srcName + " failed, doesn't exist"));
        }
    }
}

