/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.conditional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.conditional.Utils;
import org.apache.hadoop.io.Text;

public class Init
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        int numBanks = (Integer)state.get("numBanks");
        int numAccts = (Integer)state.get("numAccts");
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 10; ++i) {
            splits.add(new Text(Utils.getBank((int)((double)numBanks * 0.1 * (double)i))));
        }
        env.getConnector().tableOperations().addSplits((String)state.get("tableName"), splits);
        this.log.debug((Object)("Added splits " + splits));
        ArrayList<Integer> banks = new ArrayList<Integer>();
        for (int i = 0; i < numBanks; ++i) {
            banks.add(i);
        }
        Collections.shuffle(banks, (Random)state.get("rand"));
        ConditionalWriter cw = (ConditionalWriter)state.get("cw");
        Iterator iterator = banks.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ConditionalMutation m = new ConditionalMutation((CharSequence)Utils.getBank(i), new Condition[0]);
            int acceptedCount = 0;
            for (int j = 0; j < numAccts; ++j) {
                String cf = Utils.getAccount(j);
                m.addCondition(new Condition((CharSequence)cf, (CharSequence)"seq"));
                m.put((CharSequence)cf, (CharSequence)"bal", (CharSequence)"100");
                m.put((CharSequence)cf, (CharSequence)"seq", (CharSequence)Utils.getSeq(0));
                if (j % 1000 != 0 || j <= 0) continue;
                ConditionalWriter.Status status = cw.write(m).getStatus();
                while (status == ConditionalWriter.Status.UNKNOWN) {
                    status = cw.write(m).getStatus();
                }
                if (status == ConditionalWriter.Status.ACCEPTED) {
                    ++acceptedCount;
                }
                m = new ConditionalMutation((CharSequence)Utils.getBank(i), new Condition[0]);
            }
            if (m.getConditions().size() > 0) {
                ConditionalWriter.Status status = cw.write(m).getStatus();
                while (status == ConditionalWriter.Status.UNKNOWN) {
                    status = cw.write(m).getStatus();
                }
                if (status == ConditionalWriter.Status.ACCEPTED) {
                    ++acceptedCount;
                }
            }
            this.log.debug((Object)("Added bank " + Utils.getBank(i) + " " + acceptedCount));
        }
    }
}

