/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.image;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.image.Write;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class Verify
extends Test {
    String indexTableName;
    String imageTableName;

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Text lastRow;
        Random rand = new Random();
        int maxVerify = Integer.parseInt(props.getProperty("maxVerify"));
        int numVerifications = rand.nextInt(maxVerify - 1) + 1;
        this.indexTableName = state.getString("indexTableName");
        this.imageTableName = state.getString("imageTableName");
        Connector conn = env.getConnector();
        Scanner indexScanner = conn.createScanner(this.indexTableName, new Authorizations());
        Scanner imageScanner = conn.createScanner(this.imageTableName, new Authorizations());
        String uuid = UUID.randomUUID().toString();
        MessageDigest alg = MessageDigest.getInstance("SHA-1");
        alg.update(uuid.getBytes(StandardCharsets.UTF_8));
        indexScanner.setRange(new Range(new Text(alg.digest()), null));
        indexScanner.setBatchSize(numVerifications);
        Text curRow = null;
        int count = 0;
        for (Map.Entry entry : indexScanner) {
            curRow = ((Key)entry.getKey()).getRow();
            String rowToVerify = ((Value)entry.getValue()).toString();
            this.verifyRow(imageScanner, rowToVerify);
            if (++count != numVerifications) continue;
            break;
        }
        if (count != numVerifications && curRow != null && (lastRow = (Text)state.get("lastIndexRow")).compareTo((BinaryComparable)curRow) != 0) {
            this.log.error((Object)("Verified only " + count + " of " + numVerifications + " - curRow " + curRow + " lastKey " + lastRow));
        }
        int verified = (Integer)state.get("verified") + numVerifications;
        this.log.debug((Object)("Verified " + numVerifications + " - Total " + verified));
        state.set("verified", verified);
    }

    public void verifyRow(Scanner scanner, String row) throws Exception {
        scanner.setRange(new Range(new Text(row)));
        scanner.clearColumns();
        scanner.fetchColumnFamily(Write.CONTENT_COLUMN_FAMILY);
        scanner.fetchColumn(Write.META_COLUMN_FAMILY, Write.SHA1_COLUMN_QUALIFIER);
        Iterator scanIter = scanner.iterator();
        if (!scanIter.hasNext()) {
            this.log.error((Object)("Found row(" + row + ") in " + this.indexTableName + " but not " + this.imageTableName));
            return;
        }
        Map.Entry entry = (Map.Entry)scanIter.next();
        byte[] imageBytes = ((Value)entry.getValue()).get();
        MessageDigest alg = MessageDigest.getInstance("SHA-1");
        alg.update(imageBytes);
        byte[] localHash = alg.digest();
        entry = (Map.Entry)scanIter.next();
        byte[] storedHash = ((Value)entry.getValue()).get();
        if (localHash.length != storedHash.length) {
            throw new Exception("Hash lens do not match for " + row);
        }
        for (int i = 0; i < localHash.length; ++i) {
            if (localHash[i] == storedHash[i]) continue;
            throw new Exception("Hashes do not match for " + row);
        }
    }
}

