/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class DropTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        DropTable.dropTable(state, env, props);
    }

    public static void dropTable(State state, Environment env, Properties props) throws Exception {
        AuthenticationToken token;
        String principal;
        String sourceUser = props.getProperty("source", "system");
        if (sourceUser.equals("table")) {
            principal = WalkingSecurity.get(state, env).getTabUserName();
            token = WalkingSecurity.get(state, env).getTabToken();
        } else {
            principal = WalkingSecurity.get(state, env).getSysUserName();
            token = WalkingSecurity.get(state, env).getSysToken();
        }
        Connector conn = env.getInstance().getConnector(principal, token);
        String tableName = WalkingSecurity.get(state, env).getTableName();
        String namespaceName = WalkingSecurity.get(state, env).getNamespaceName();
        boolean exists = WalkingSecurity.get(state, env).getTableExists();
        boolean hasPermission = WalkingSecurity.get(state, env).canDeleteTable(new Credentials(principal, token).toThrift(env.getInstance()), tableName, namespaceName);
        try {
            conn.tableOperations().delete(tableName);
        }
        catch (AccumuloSecurityException ae) {
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                if (hasPermission) {
                    throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                }
                env.getConnector().tableOperations().delete(tableName);
                WalkingSecurity.get(state, env).cleanTablePermissions(tableName);
                return;
            }
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_CREDENTIALS) && WalkingSecurity.get(state, env).userPassTransient(conn.whoami())) {
                return;
            }
            throw new AccumuloException("Got unexpected ae error code", (Throwable)ae);
        }
        catch (TableNotFoundException tnfe) {
            if (exists) {
                throw new TableExistsException(null, tableName, "Got a TableNotFOundException but it should have existed", (Throwable)tnfe);
            }
            return;
        }
        WalkingSecurity.get(state, env).cleanTablePermissions(tableName);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

