/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.master.replication.FinishedWorkUpdater;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class FinishedWorkUpdaterIT
extends ConfigurableMacBase {
    private Connector conn;
    private FinishedWorkUpdater updater;

    @Before
    public void configureUpdater() throws Exception {
        this.conn = this.getConnector();
        this.updater = new FinishedWorkUpdater(this.conn);
    }

    @Test
    public void offlineReplicationTableFailsGracefully() {
        this.updater.run();
    }

    @Test
    public void recordsWithProgressUpdateBothTables() throws Exception {
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(100L).setEnd(200L).setClosed(true).setInfiniteEnd(false).build();
        ReplicationTarget target = new ReplicationTarget("peer", "table1", "1");
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        s.setRange(Range.exact((CharSequence)file));
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnQualifier().toString(), (Object)target.getSourceTableId());
        Replication.Status actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertEquals((long)stat.getBegin(), (long)actual.getBegin());
    }

    @Test
    public void chooseMinimumBeginOffset() throws Exception {
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(100L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(500L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        Replication.Status stat3 = Replication.Status.newBuilder().setBegin(1L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        ReplicationTarget target1 = new ReplicationTarget("peer1", "table1", "1");
        ReplicationTarget target2 = new ReplicationTarget("peer2", "table2", "1");
        ReplicationTarget target3 = new ReplicationTarget("peer3", "table3", "1");
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target1.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target2.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target3.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat3));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        s.setRange(Range.exact((CharSequence)file));
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnQualifier().toString(), (Object)target1.getSourceTableId());
        Replication.Status actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertEquals((long)1L, (long)actual.getBegin());
    }

    @Test
    public void chooseMinimumBeginOffsetInfiniteEnd() throws Exception {
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(100L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(1L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        Replication.Status stat3 = Replication.Status.newBuilder().setBegin(500L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        ReplicationTarget target1 = new ReplicationTarget("peer1", "table1", "1");
        ReplicationTarget target2 = new ReplicationTarget("peer2", "table2", "1");
        ReplicationTarget target3 = new ReplicationTarget("peer3", "table3", "1");
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target1.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target2.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target3.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat3));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        s.setRange(Range.exact((CharSequence)file));
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
        Assert.assertEquals((Object)((Key)entry.getKey()).getColumnQualifier().toString(), (Object)target1.getSourceTableId());
        Replication.Status actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertEquals((long)1L, (long)actual.getBegin());
    }
}

