/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.cli;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.replication.merkle.RangeSerialization;
import org.apache.accumulo.test.replication.merkle.skvi.DigestIterator;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateHashes {
    private static final Logger log = LoggerFactory.getLogger(GenerateHashes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Range> getRanges(Connector conn, String tableName, String splitsFile) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, FileNotFoundException {
        if (null == splitsFile) {
            log.info("Using table split points");
            Collection endRows = conn.tableOperations().listSplits(tableName);
            return this.endRowsToRanges(endRows);
        }
        log.info("Using provided split points");
        ArrayList<Text> splits = new ArrayList<Text>();
        try (java.util.Scanner file = new java.util.Scanner(new File(splitsFile), StandardCharsets.UTF_8.name());){
            while (file.hasNextLine()) {
                String line = file.nextLine();
                if (line.isEmpty()) continue;
                splits.add(new Text(line));
            }
        }
        Collections.sort(splits);
        return this.endRowsToRanges(splits);
    }

    public void run(GenerateHashesOpts opts) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, NoSuchAlgorithmException, FileNotFoundException {
        Collection<Range> ranges = this.getRanges(opts.getConnector(), opts.getTableName(), opts.getSplitsFile());
        this.run(opts.getConnector(), opts.getTableName(), opts.getOutputTableName(), opts.getHashName(), opts.getNumThreads(), opts.isIteratorPushdown(), ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(final Connector conn, final String inputTableName, String outputTableName, final String digestName, int numThreads, final boolean iteratorPushdown, Collection<Range> ranges) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, NoSuchAlgorithmException {
        if (!conn.tableOperations().exists(outputTableName)) {
            throw new IllegalArgumentException(outputTableName + " does not exist, please create it");
        }
        ExecutorService svc = Executors.newFixedThreadPool(numThreads);
        try (final BatchWriter bw = conn.createBatchWriter(outputTableName, new BatchWriterConfig());){
            for (final Range range : ranges) {
                final MessageDigest digest = this.getDigestAlgorithm(digestName);
                svc.execute(new Runnable(){

                    @Override
                    public void run() {
                        Scanner s;
                        try {
                            s = conn.createScanner(inputTableName, Authorizations.EMPTY);
                        }
                        catch (Exception e) {
                            log.error("Could not get scanner for " + inputTableName, (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        s.setRange(range);
                        Value v = null;
                        Mutation m = null;
                        if (iteratorPushdown) {
                            IteratorSetting cfg = new IteratorSetting(50, DigestIterator.class);
                            cfg.addOption("hash.name", digestName);
                            s.addScanIterator(cfg);
                            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                            v = (Value)entry.getValue();
                            m = RangeSerialization.toMutation(range, v);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            for (Map.Entry entry : s) {
                                DataOutputStream out = new DataOutputStream(baos);
                                try {
                                    ((Key)entry.getKey()).write((DataOutput)out);
                                    ((Value)entry.getValue()).write((DataOutput)out);
                                }
                                catch (Exception e) {
                                    log.error("Error writing {}", (Object)entry, (Object)e);
                                    throw new RuntimeException(e);
                                }
                                digest.update(baos.toByteArray());
                                baos.reset();
                            }
                            v = new Value(digest.digest());
                            m = RangeSerialization.toMutation(range, v);
                        }
                        log.info("{} computed digest for {} of {}", new Object[]{Thread.currentThread().getName(), range, Hex.encodeHexString((byte[])v.get())});
                        try {
                            bw.addMutation(m);
                        }
                        catch (MutationsRejectedException e) {
                            log.error("Could not write mutation", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            svc.shutdown();
            while (!svc.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("Interrupted while waiting for executor service to gracefully complete. Exiting now");
                    svc.shutdownNow();
                    bw.close();
                    return;
                }
            }
        }
    }

    public TreeSet<Range> endRowsToRanges(Collection<Text> endRows) {
        ArrayList<Text> sortedEndRows = new ArrayList<Text>(endRows);
        Collections.sort(sortedEndRows);
        Text prevEndRow = null;
        TreeSet<Range> ranges = new TreeSet<Range>();
        for (Text endRow : sortedEndRows) {
            if (null == prevEndRow) {
                ranges.add(new Range(null, false, endRow, true));
            } else {
                ranges.add(new Range(prevEndRow, false, endRow, true));
            }
            prevEndRow = endRow;
        }
        ranges.add(new Range(prevEndRow, false, null, false));
        return ranges;
    }

    protected MessageDigest getDigestAlgorithm(String digestName) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(digestName);
    }

    public static void main(String[] args) throws Exception {
        GenerateHashesOpts opts = new GenerateHashesOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(GenerateHashes.class.getName(), args, new Object[]{bwOpts});
        if (opts.isIteratorPushdown() && null != opts.getSplitsFile()) {
            throw new IllegalArgumentException("Cannot use iterator pushdown with anything other than table split points");
        }
        GenerateHashes generate = new GenerateHashes();
        generate.run(opts);
    }

    public static class GenerateHashesOpts
    extends ClientOnRequiredTable {
        @Parameter(names={"-hash", "--hash"}, required=true, description="type of hash to use")
        private String hashName;
        @Parameter(names={"-o", "--output"}, required=true, description="output table name, expected to exist and be writable")
        private String outputTableName;
        @Parameter(names={"-nt", "--numThreads"}, required=false, description="number of concurrent threads calculating digests")
        private int numThreads = 4;
        @Parameter(names={"-iter", "--iterator"}, required=false, description="Should we push down logic with an iterator")
        private boolean iteratorPushdown = false;
        @Parameter(names={"-s", "--splits"}, required=false, description="File of splits to use for merkle tree")
        private String splitsFile = null;

        public String getHashName() {
            return this.hashName;
        }

        public void setHashName(String hashName) {
            this.hashName = hashName;
        }

        public String getOutputTableName() {
            return this.outputTableName;
        }

        public void setOutputTableName(String outputTableName) {
            this.outputTableName = outputTableName;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public boolean isIteratorPushdown() {
            return this.iteratorPushdown;
        }

        public void setIteratorPushdown(boolean iteratorPushdown) {
            this.iteratorPushdown = iteratorPushdown;
        }

        public String getSplitsFile() {
            return this.splitsFile;
        }

        public void setSplitsFile(String splitsFile) {
            this.splitsFile = splitsFile;
        }
    }
}

