/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.metrics.Metrics2ReplicationMetrics;
import org.apache.accumulo.master.metrics.ReplicationMetrics;
import org.apache.accumulo.master.metrics.fate.FateHadoop2Metrics;
import org.apache.accumulo.master.metrics.fate.FateLegacyJMXMetrics;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMetricsFactory {
    private static final Logger log = LoggerFactory.getLogger(MasterMetricsFactory.class);
    private final boolean useOldMetrics;
    private final boolean enableFateMetrics;
    private final long fateMinUpdateInterval;
    private final MetricsSystem metricsSystem;
    private final Master master;

    public MasterMetricsFactory(AccumuloConfiguration conf, Master master) {
        Objects.requireNonNull(conf, "AccumuloConfiguration must not be null");
        this.useOldMetrics = conf.getBoolean(Property.GENERAL_LEGACY_METRICS);
        this.enableFateMetrics = conf.getBoolean(Property.MASTER_FATE_METRICS_ENABLED);
        this.fateMinUpdateInterval = conf.getTimeInMillis(Property.MASTER_FATE_METRICS_MIN_UPDATE_INTERVAL);
        this.master = master;
        this.metricsSystem = this.useOldMetrics ? null : MetricsSystemHelper.getInstance();
    }

    public int register() {
        int failureCount = 0;
        try {
            Metrics replicationMetrics = this.createReplicationMetrics();
            replicationMetrics.register();
            log.info("Registered replication metrics module");
        }
        catch (Exception ex) {
            ++failureCount;
            log.error("Failed to register replication metrics", (Throwable)ex);
        }
        try {
            if (this.enableFateMetrics) {
                Metrics fateMetrics = this.createFateMetrics();
                fateMetrics.register();
                log.info("Registered FATE metrics module");
            }
        }
        catch (Exception ex) {
            ++failureCount;
            log.error("Failed to register fate metrics", (Throwable)ex);
        }
        return failureCount;
    }

    private Metrics createReplicationMetrics() {
        if (this.useOldMetrics) {
            return new ReplicationMetrics(this.master);
        }
        return new Metrics2ReplicationMetrics(this.master, this.metricsSystem);
    }

    private Metrics createFateMetrics() {
        String id = this.master.getInstance().getInstanceID();
        if (this.useOldMetrics) {
            if (this.enableFateMetrics) {
                log.warn("Enhanced FATE metrics (Transaction and OpType counts) unavailable when using legacy metrics.");
            }
            return new FateLegacyJMXMetrics(id, this.fateMinUpdateInterval);
        }
        return new FateHadoop2Metrics(id, this.metricsSystem, this.fateMinUpdateInterval);
    }
}

