/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.util.DeprecationUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;

public class AccumuloServerContext
extends ClientContext {
    private final ServerConfigurationFactory confFactory;
    private AuthenticationTokenSecretManager secretManager;

    public AccumuloServerContext(ServerConfigurationFactory confFactory) {
        this(confFactory, null);
    }

    public AccumuloServerContext(ServerConfigurationFactory confFactory, AuthenticationTokenSecretManager secretManager) {
        super(confFactory.getInstance(), AccumuloServerContext.getCredentials(confFactory.getInstance()), confFactory.getConfiguration());
        this.confFactory = confFactory;
        this.secretManager = secretManager;
        if (null != this.getSaslParams()) {
            this.enforceKerberosLogin();
        }
    }

    void enforceKerberosLogin() {
        UserGroupInformation loginUser;
        SiteConfiguration conf = this.confFactory.getSiteConfiguration();
        String kerberosPrincipal = SecurityUtil.getServerPrincipal(conf.get(Property.GENERAL_KERBEROS_PRINCIPAL));
        try {
            loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get login user", e);
        }
        Preconditions.checkArgument((boolean)loginUser.hasKerberosCredentials(), (Object)"Server does not have Kerberos credentials");
        Preconditions.checkArgument((boolean)kerberosPrincipal.equals(loginUser.getUserName()), (Object)("Expected login user to be " + kerberosPrincipal + " but was " + loginUser.getUserName()));
    }

    private static Credentials getCredentials(Instance instance) {
        if (DeprecationUtil.isMockInstance((Instance)instance)) {
            return new Credentials("mockSystemUser", (AuthenticationToken)new PasswordToken((CharSequence)"mockSystemPassword"));
        }
        return SystemCredentials.get(instance);
    }

    public ServerConfigurationFactory getServerConfigurationFactory() {
        return this.confFactory;
    }

    public SslConnectionParams getServerSslParams() {
        return SslConnectionParams.forServer((AccumuloConfiguration)this.getConfiguration());
    }

    public SaslServerConnectionParams getSaslParams() {
        SiteConfiguration conf = this.getServerConfigurationFactory().getSiteConfiguration();
        if (!conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return null;
        }
        return new SaslServerConnectionParams((AccumuloConfiguration)conf, this.getCredentials().getToken(), this.secretManager);
    }

    public ThriftServerType getThriftServerType() {
        AccumuloConfiguration conf = this.getConfiguration();
        if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SSL;
        }
        if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SASL;
        }
        String serverTypeName = conf.get(Property.GENERAL_RPC_SERVER_TYPE);
        return ThriftServerType.get(serverTypeName);
    }

    public void setSecretManager(AuthenticationTokenSecretManager secretManager) {
        this.secretManager = secretManager;
    }

    public AuthenticationTokenSecretManager getSecretManager() {
        return this.secretManager;
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        if (this.conn == null) {
            if (this.inst instanceof ZooKeeperInstance || this.inst instanceof HdfsZooInstance) {
                this.conn = new ConnectorImpl((ClientContext)this);
            } else {
                Credentials c = this.getCredentials();
                this.conn = this.getInstance().getConnector(c.getPrincipal(), c.getToken());
            }
        }
        return this.conn;
    }
}

