/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemPropUtil.class);

    public static boolean setSystemProperty(String property, String value) throws KeeperException, InterruptedException {
        if (!Property.isValidZooPropertyKey((String)property)) {
            IllegalArgumentException iae = new IllegalArgumentException("Zookeeper property is not mutable: " + property);
            log.debug("Attempted to set zookeeper property.  It is not mutable", (Throwable)iae);
            throw iae;
        }
        Property foundProp = null;
        for (Property prop : Property.values()) {
            if ((PropertyType.PREFIX != prop.getType() || !property.startsWith(prop.getKey())) && !prop.getKey().equals(property)) continue;
            foundProp = prop;
            break;
        }
        if (foundProp == null || foundProp.getType() != PropertyType.PREFIX && !foundProp.getType().isValidFormat(value)) {
            IllegalArgumentException iae = new IllegalArgumentException("Ignoring property " + property + " it is either null or in an invalid format");
            log.debug("Attempted to set zookeeper property.  Value is either null or invalid", (Throwable)iae);
            throw iae;
        }
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        boolean result = ZooReaderWriter.getInstance().putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return result;
    }

    public static void removeSystemProperty(String property) throws InterruptedException, KeeperException {
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        ZooReaderWriter.getInstance().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.FAIL);
    }
}

