/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.Duration;

public class BulkImportListIterator
implements Iterator<String> {
    private final Iterator<String> iter;

    public BulkImportListIterator(List<String> tservers, MasterMonitorInfo stats) {
        ArrayList<String> result = new ArrayList<String>();
        for (BulkImportStatus status : stats.bulkImports) {
            result.add(this.format(status));
        }
        if (!tservers.isEmpty()) {
            for (TabletServerStatus tserver : stats.tServerInfo) {
                if (!tservers.contains(tserver.name)) continue;
                result.add(tserver.name + ":");
                for (BulkImportStatus status : tserver.bulkImports) {
                    result.add(this.format(status));
                }
            }
        }
        this.iter = result.iterator();
    }

    private String format(BulkImportStatus status) {
        long diff = System.currentTimeMillis() - status.startTime;
        return String.format("%25s | %4s | %s", status.filename, Duration.format((long)diff, (String)" ", (String)"-"), status.state);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public String next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

