/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.util.PreAllocatedArray;
import org.apache.accumulo.tserver.MemKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMap
implements Iterable<Map.Entry<Key, Value>> {
    private static final Logger log = LoggerFactory.getLogger(NativeMap.class);
    private static AtomicBoolean loadedNativeLibraries = new AtomicBoolean(false);
    private long nmPointer = NativeMap.createNativeMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rlock = this.rwLock.readLock();
    private final Lock wlock = this.rwLock.writeLock();
    int modCount = 0;
    private static boolean init;
    private static long totalAllocations;
    private static HashSet<Long> allocatedNativeMaps;

    public static void loadNativeLib(List<File> searchPath) {
        block4: {
            if (NativeMap.isLoaded()) break block4;
            List<String> names = NativeMap.getValidLibraryNames();
            ArrayList<File> tryList = new ArrayList<File>(searchPath.size() * names.size());
            for (File p : searchPath) {
                if (p.exists() && p.isDirectory()) {
                    for (String name : names) {
                        tryList.add(new File(p, name));
                    }
                    continue;
                }
                tryList.add(p);
            }
            for (File f : tryList) {
                if (NativeMap.loadNativeLib(f)) break;
            }
        }
    }

    public static boolean isLoaded() {
        return loadedNativeLibraries.get();
    }

    private static List<String> getValidLibraryNames() {
        String prefix;
        ArrayList<String> names = new ArrayList<String>(3);
        String libname = System.mapLibraryName("accumulo");
        names.add(libname);
        int dot = libname.lastIndexOf(".");
        String string = prefix = dot < 0 ? libname : libname.substring(0, dot);
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            for (String ext : new String[]{".dylib", ".jnilib"}) {
                if (libname.endsWith(ext)) continue;
                names.add(prefix + ext);
            }
        }
        return names;
    }

    private static boolean loadNativeLib(File libFile) {
        log.debug("Trying to load native map library " + libFile);
        if (libFile.exists() && libFile.isFile()) {
            String errMsg = "Tried and failed to load native map library " + libFile;
            try {
                System.load(libFile.getAbsolutePath());
                loadedNativeLibraries.set(true);
                log.info("Loaded native map shared library " + libFile);
                return true;
            }
            catch (Exception e) {
                log.error(errMsg, (Throwable)e);
            }
            catch (UnsatisfiedLinkError e) {
                log.error(errMsg, (Throwable)e);
            }
        } else {
            log.debug("Native map library " + libFile + " not found or is not a file.");
        }
        return false;
    }

    private static native long createNM();

    private static native void singleUpdate(long var0, byte[] var2, byte[] var3, byte[] var4, byte[] var5, long var6, boolean var8, byte[] var9, int var10);

    private static native long startUpdate(long var0, byte[] var2);

    private static native void update(long var0, long var2, byte[] var4, byte[] var5, byte[] var6, long var7, boolean var9, byte[] var10, int var11);

    private static native int sizeNM(long var0);

    private static native long memoryUsedNM(long var0);

    private static native long deleteNM(long var0);

    private static synchronized long createNativeMap() {
        long nmPtr;
        if (!init) {
            allocatedNativeMaps = new HashSet();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (allocatedNativeMaps.size() > 0) {
                        log.info("There are " + allocatedNativeMaps.size() + " allocated native maps");
                    }
                    log.debug(totalAllocations + " native maps were allocated");
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(r));
            init = true;
        }
        if (allocatedNativeMaps.contains(nmPtr = NativeMap.createNM())) {
            throw new RuntimeException(String.format("Duplicate native map pointer 0x%016x ", nmPtr));
        }
        ++totalAllocations;
        allocatedNativeMaps.add(nmPtr);
        return nmPtr;
    }

    private static synchronized void deleteNativeMap(long nmPtr) {
        if (!allocatedNativeMaps.contains(nmPtr)) {
            throw new RuntimeException(String.format("Attempt to delete native map that is not allocated 0x%016x ", nmPtr));
        }
        NativeMap.deleteNM(nmPtr);
        allocatedNativeMaps.remove(nmPtr);
    }

    private static native long createNMI(long var0, int[] var2);

    private static native long createNMI(long var0, byte[] var2, byte[] var3, byte[] var4, byte[] var5, long var6, boolean var8, int[] var9);

    private static native boolean nmiNext(long var0, int[] var2);

    private static native void nmiGetData(long var0, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6);

    private static native long nmiGetTS(long var0);

    private static native void deleteNMI(long var0);

    public NativeMap() {
        log.debug(String.format("Allocated native map 0x%016x", this.nmPointer));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.nmPointer != 0L) {
            log.warn(String.format("Deallocating native map 0x%016x in finalize", this.nmPointer));
            NativeMap.deleteNativeMap(this.nmPointer);
        }
    }

    private int _mutate(Mutation mutation, int mutationCount) {
        List updates = mutation.getUpdates();
        if (updates.size() == 1) {
            ColumnUpdate update = (ColumnUpdate)updates.get(0);
            NativeMap.singleUpdate(this.nmPointer, mutation.getRow(), update.getColumnFamily(), update.getColumnQualifier(), update.getColumnVisibility(), update.getTimestamp(), update.isDeleted(), update.getValue(), mutationCount++);
        } else if (updates.size() > 1) {
            long uid = NativeMap.startUpdate(this.nmPointer, mutation.getRow());
            for (ColumnUpdate update : updates) {
                NativeMap.update(this.nmPointer, uid, update.getColumnFamily(), update.getColumnQualifier(), update.getColumnVisibility(), update.getTimestamp(), update.isDeleted(), update.getValue(), mutationCount++);
            }
        }
        return mutationCount;
    }

    @VisibleForTesting
    public void mutate(Mutation mutation, int mutationCount) {
        this.mutate(Collections.singletonList(mutation), mutationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mutate(List<Mutation> mutations, int mutationCount) {
        Iterator<Mutation> iter = mutations.iterator();
        while (iter.hasNext()) {
            this.wlock.lock();
            try {
                Mutation mutation;
                if (this.nmPointer == 0L) {
                    throw new IllegalStateException("Native Map Deleted");
                }
                ++this.modCount;
                for (int count = 0; iter.hasNext() && count < 10; count += mutation.size()) {
                    mutation = iter.next();
                    mutationCount = this._mutate(mutation, mutationCount);
                }
            }
            finally {
                this.wlock.unlock();
            }
        }
    }

    @VisibleForTesting
    public void put(Key key, Value value) {
        this.wlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            ++this.modCount;
            NativeMap.singleUpdate(this.nmPointer, key.getRowData().toArray(), key.getColumnFamilyData().toArray(), key.getColumnQualifierData().toArray(), key.getColumnVisibilityData().toArray(), key.getTimestamp(), key.isDeleted(), value.get(), 0);
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value get(Key key) {
        this.rlock.lock();
        try {
            Object entry;
            Value ret = null;
            NMIterator nmi = new NMIterator(key);
            if (nmi.hasNext() && ((Key)(entry = nmi.next()).getKey()).equals((Object)key)) {
                ret = (Value)entry.getValue();
            }
            nmi.delete();
            Value value = ret;
            return value;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public int size() {
        this.rlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            int n = NativeMap.sizeNM(this.nmPointer);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public long getMemoryUsed() {
        this.rlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            long l = NativeMap.memoryUsedNM(this.nmPointer);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        this.rlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            ConcurrentIterator concurrentIterator = new ConcurrentIterator();
            return concurrentIterator;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public Iterator<Map.Entry<Key, Value>> iterator(Key startKey) {
        this.rlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            ConcurrentIterator concurrentIterator = new ConcurrentIterator(startKey);
            return concurrentIterator;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public void delete() {
        this.wlock.lock();
        try {
            if (this.nmPointer == 0L) {
                throw new IllegalStateException("Native Map Deleted");
            }
            log.debug(String.format("Deallocating native map 0x%016x", this.nmPointer));
            NativeMap.deleteNativeMap(this.nmPointer);
            this.nmPointer = 0L;
        }
        finally {
            this.wlock.unlock();
        }
    }

    public SortedKeyValueIterator<Key, Value> skvIterator() {
        return new NMSKVIter(this);
    }

    static {
        ArrayList<File> directories = new ArrayList<File>(Arrays.asList(new File("/usr/lib64"), new File("/usr/lib")));
        String envAccumuloHome = System.getenv("ACCUMULO_HOME");
        if (envAccumuloHome != null) {
            directories.add(new File(envAccumuloHome + "/lib/native"));
            directories.add(new File(envAccumuloHome + "/lib/native/map"));
        }
        NativeMap.loadNativeLib(directories);
        if (!NativeMap.isLoaded()) {
            String ldLibraryPath = System.getProperty("java.library.path");
            String errMsg = "Tried and failed to load native map library from " + ldLibraryPath;
            try {
                System.loadLibrary("accumulo");
                loadedNativeLibraries.set(true);
                log.info("Loaded native map shared library from " + ldLibraryPath);
            }
            catch (Exception e) {
                log.error(errMsg, (Throwable)e);
            }
            catch (UnsatisfiedLinkError e) {
                log.error(errMsg, (Throwable)e);
            }
        }
        init = false;
    }

    private static class NMSKVIter
    implements InterruptibleIterator {
        private ConcurrentIterator iter;
        private Map.Entry<Key, Value> entry;
        private NativeMap map;
        private Range range;
        private AtomicBoolean interruptFlag;
        private int interruptCheckCount = 0;

        private NMSKVIter(NativeMap map, AtomicBoolean interruptFlag) {
            this.map = map;
            this.range = new Range();
            this.iter = map.new ConcurrentIterator();
            this.entry = this.iter.hasNext() ? this.iter.next() : null;
            this.interruptFlag = interruptFlag;
        }

        public NMSKVIter(NativeMap map) {
            this(map, null);
        }

        public Key getTopKey() {
            return this.entry.getKey();
        }

        public Value getTopValue() {
            return this.entry.getValue();
        }

        public boolean hasTop() {
            return this.entry != null;
        }

        public void next() throws IOException {
            if (this.entry == null) {
                throw new IllegalStateException();
            }
            if (this.interruptFlag != null && this.interruptCheckCount++ % 100 == 0 && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            if (this.iter.hasNext()) {
                this.entry = this.iter.next();
                if (this.range.afterEndKey(this.entry.getKey())) {
                    this.entry = null;
                }
            } else {
                this.entry = null;
            }
        }

        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if (this.interruptFlag != null && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            this.iter.delete();
            this.range = range;
            Key key = range.getStartKey();
            if (key == null) {
                key = new MemKey();
            }
            NativeMap nativeMap = this.map;
            Objects.requireNonNull(nativeMap);
            this.iter = nativeMap.new ConcurrentIterator(key);
            if (this.iter.hasNext()) {
                this.entry = this.iter.next();
                if (range.afterEndKey(this.entry.getKey())) {
                    this.entry = null;
                }
            } else {
                this.entry = null;
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            if (env != null && env.isSamplingEnabled()) {
                throw new SampleNotPresentException();
            }
            return new NMSKVIter(this.map, this.interruptFlag);
        }

        public void setInterruptFlag(AtomicBoolean flag) {
            this.interruptFlag = flag;
        }
    }

    private class NMIterator
    implements Iterator<Map.Entry<Key, Value>> {
        private long nmiPointer;
        private boolean hasNext;
        private int expectedModCount;
        private int[] fieldsLens = new int[7];
        private byte[] lastRow;

        NMIterator(Key key) {
            if (NativeMap.this.nmPointer == 0L) {
                throw new IllegalStateException();
            }
            this.expectedModCount = NativeMap.this.modCount;
            this.nmiPointer = NativeMap.createNMI(NativeMap.this.nmPointer, key.getRowData().toArray(), key.getColumnFamilyData().toArray(), key.getColumnQualifierData().toArray(), key.getColumnVisibilityData().toArray(), key.getTimestamp(), key.isDeleted(), this.fieldsLens);
            this.hasNext = this.nmiPointer != 0L;
        }

        public synchronized void delete() {
            if (this.nmiPointer == 0L) {
                return;
            }
            NativeMap.deleteNMI(this.nmiPointer);
            this.nmiPointer = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        private void doNextPreCheck() {
            if (NativeMap.this.nmPointer == 0L) {
                throw new IllegalStateException();
            }
            if (NativeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public synchronized Map.Entry<Key, Value> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (this.nmiPointer == 0L) {
                throw new IllegalStateException("Native Map Iterator Deleted");
            }
            byte[] row = null;
            if (this.fieldsLens[0] >= 0) {
                row = new byte[this.fieldsLens[0]];
                this.lastRow = row;
            }
            byte[] cf = new byte[this.fieldsLens[1]];
            byte[] cq = new byte[this.fieldsLens[2]];
            byte[] cv = new byte[this.fieldsLens[3]];
            boolean deleted = this.fieldsLens[4] != 0;
            byte[] val = new byte[this.fieldsLens[5]];
            NativeMap.nmiGetData(this.nmiPointer, row, cf, cq, cv, val);
            long ts = NativeMap.nmiGetTS(this.nmiPointer);
            MemKey k = new MemKey(this.lastRow, cf, cq, cv, ts, deleted, false, this.fieldsLens[6]);
            Value v = new Value(val, false);
            this.hasNext = NativeMap.nmiNext(this.nmiPointer, this.fieldsLens);
            return new AbstractMap.SimpleImmutableEntry<Key, Value>(k, v);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.nmiPointer != 0L) {
                NativeMap.deleteNMI(this.nmiPointer);
            }
        }
    }

    private class ConcurrentIterator
    implements Iterator<Map.Entry<Key, Value>> {
        private static final int MAX_READ_AHEAD_ENTRIES = 16;
        private static final int READ_AHEAD_BYTES = 4096;
        private NMIterator source;
        private PreAllocatedArray<Map.Entry<Key, Value>> nextEntries = new PreAllocatedArray(1);
        private int index;
        private int end;

        ConcurrentIterator() {
            this(new MemKey());
        }

        ConcurrentIterator(Key key) {
            NativeMap.this.rlock.lock();
            try {
                this.source = new NMIterator(key);
                this.fill();
            }
            finally {
                NativeMap.this.rlock.unlock();
            }
        }

        private void fill() {
            this.end = 0;
            this.index = 0;
            if (this.source.hasNext()) {
                this.source.doNextPreCheck();
            }
            int amountRead = 0;
            if (this.nextEntries.length < 16) {
                this.nextEntries = new PreAllocatedArray(Math.min(this.nextEntries.length * 2, 16));
            }
            while (this.source.hasNext() && this.end < this.nextEntries.length) {
                Object ne = this.source.next();
                this.nextEntries.set(this.end++, ne);
                if ((amountRead += ((Key)ne.getKey()).getSize() + ((Value)ne.getValue()).getSize()) <= 4096) continue;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.end != 0;
        }

        @Override
        public Map.Entry<Key, Value> next() {
            if (this.end == 0) {
                throw new NoSuchElementException();
            }
            Map.Entry ret = (Map.Entry)this.nextEntries.get(this.index++);
            if (this.index == this.end) {
                NativeMap.this.rlock.lock();
                try {
                    this.fill();
                }
                catch (ConcurrentModificationException cme) {
                    this.source.delete();
                    this.source = new NMIterator((Key)ret.getKey());
                    this.fill();
                    if (0 < this.end && ((Key)((Map.Entry)this.nextEntries.get(0)).getKey()).equals(ret.getKey())) {
                        ++this.index;
                        if (this.index == this.end) {
                            this.fill();
                        }
                    }
                }
                finally {
                    NativeMap.this.rlock.unlock();
                }
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void delete() {
            this.source.delete();
        }
    }
}

