/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.tserver.MemKey;

class PartialMutationSkippingIterator
extends SkippingIterator
implements InterruptibleIterator {
    private int kvCount;

    public PartialMutationSkippingIterator(SortedKeyValueIterator<Key, Value> source, int maxKVCount) {
        this.setSource(source);
        this.kvCount = maxKVCount;
    }

    protected void consume() throws IOException {
        while (this.getSource().hasTop() && ((MemKey)this.getSource().getTopKey()).getKVCount() > this.kvCount) {
            this.getSource().next();
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new PartialMutationSkippingIterator((SortedKeyValueIterator<Key, Value>)this.getSource().deepCopy(env), this.kvCount);
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        ((InterruptibleIterator)this.getSource()).setInterruptFlag(flag);
    }
}

