/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.rename;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.slf4j.LoggerFactory;

public class RenameTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final NamespaceId namespaceId;
    private final String oldTableName;
    private final String newTableName;

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.RENAME) + Utils.reserveTable(env, this.tableId, tid, true, true, TableOperation.RENAME);
    }

    public RenameTable(NamespaceId namespaceId, TableId tableId, String oldTableName, String newTableName) throws NamespaceNotFoundException {
        this.namespaceId = namespaceId;
        this.tableId = tableId;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Pair qualifiedOldTableName = TableNameUtil.qualify((String)this.oldTableName);
        Pair qualifiedNewTableName = TableNameUtil.qualify((String)this.newTableName);
        if (this.newTableName.contains(".") && !this.namespaceId.equals((Object)Namespaces.getNamespaceId((ClientContext)manager.getContext(), (String)((String)qualifiedNewTableName.getFirst())))) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.INVALID_NAME, "Namespace in new table name does not match the old table name");
        }
        ZooReaderWriter zoo = manager.getContext().getZooReaderWriter();
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableNameDoesNotExist(manager.getContext(), this.newTableName, this.namespaceId, this.tableId, TableOperation.RENAME);
            String newName = (String)qualifiedNewTableName.getSecond();
            String oldName = (String)qualifiedOldTableName.getSecond();
            String tap = manager.getZooKeeperRoot() + "/tables/" + String.valueOf(this.tableId) + "/name";
            zoo.mutateExisting(tap, current -> {
                String currentName = new String(current, StandardCharsets.UTF_8);
                if (currentName.equals(newName)) {
                    return null;
                }
                if (!currentName.equals(oldName)) {
                    throw new AcceptableThriftTableOperationException(null, this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.NOTFOUND, "Name changed while processing");
                }
                return newName.getBytes(StandardCharsets.UTF_8);
            });
            manager.getContext().clearTableListCache();
        }
        finally {
            Utils.getTableNameLock().unlock();
            Utils.unreserveTable(manager, this.tableId, tid, true);
            Utils.unreserveNamespace(manager, this.namespaceId, tid, false);
        }
        LoggerFactory.getLogger(RenameTable.class).debug("Renamed table {} {} {}", new Object[]{this.tableId, this.oldTableName, this.newTableName});
        return null;
    }

    @Override
    public void undo(long tid, Manager env) {
        Utils.unreserveTable(env, this.tableId, tid, true);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }
}

