/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.Objects;
import org.apache.accumulo.core.dataImpl.KeyExtent;

public class MetadataUpdateCount {
    private final KeyExtent extent;
    private final long startedCount;
    private final long finishedCount;

    MetadataUpdateCount(KeyExtent extent, long startedCount, long finishedCount) {
        this.extent = Objects.requireNonNull(extent);
        this.startedCount = startedCount;
        this.finishedCount = finishedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataUpdateCount that = (MetadataUpdateCount)o;
        return this.startedCount == that.startedCount && this.finishedCount == that.finishedCount;
    }

    public int hashCode() {
        return Objects.hash(this.startedCount, this.finishedCount);
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public boolean overlapsUpdate() {
        return this.startedCount != this.finishedCount;
    }

    public MetadataUpdateCount incrementStart() {
        return new MetadataUpdateCount(this.extent, this.startedCount + 1L, this.finishedCount);
    }

    public MetadataUpdateCount incrementFinish() {
        return new MetadataUpdateCount(this.extent, this.startedCount, this.finishedCount + 1L);
    }

    public String toString() {
        return "[startedCount:" + this.startedCount + ",finishedCount:" + this.finishedCount + "]";
    }
}

