/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.sample;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.sample.AbstractHashSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;

public class RowColumnSampler
extends AbstractHashSampler {
    private boolean row = true;
    private boolean family = true;
    private boolean qualifier = true;
    private boolean visibility = true;
    private static final Set<String> VALID_OPTIONS = Set.of("row", "family", "qualifier", "visibility");

    private boolean hashField(SamplerConfiguration config, String field) {
        String optValue = config.getOptions().get(field);
        if (optValue != null) {
            return Boolean.parseBoolean(optValue);
        }
        return false;
    }

    @Override
    public void validateOptions(Map<String, String> config) {
        super.validateOptions(config);
        for (String option : config.keySet()) {
            Preconditions.checkArgument((VALID_OPTIONS.contains(option) || REQUIRED_SAMPLER_OPTIONS.contains(option) ? 1 : 0) != 0, (String)"Unknown option : %s", (Object)option);
        }
    }

    @Override
    public void init(SamplerConfiguration config) {
        super.init(config);
        this.row = this.hashField(config, "row");
        this.family = this.hashField(config, "family");
        this.qualifier = this.hashField(config, "qualifier");
        this.visibility = this.hashField(config, "visibility");
        if (!(this.row || this.family || this.qualifier || this.visibility)) {
            throw new IllegalStateException("Must hash at least one key field");
        }
    }

    private void putByteSequence(ByteSequence data, DataOutput hasher) throws IOException {
        hasher.write(data.getBackingArray(), data.offset(), data.length());
    }

    @Override
    protected void hash(DataOutput hasher, Key k) throws IOException {
        if (this.row) {
            this.putByteSequence(k.getRowData(), hasher);
        }
        if (this.family) {
            this.putByteSequence(k.getColumnFamilyData(), hasher);
        }
        if (this.qualifier) {
            this.putByteSequence(k.getColumnQualifierData(), hasher);
        }
        if (this.visibility) {
            this.putByteSequence(k.getColumnVisibilityData(), hasher);
        }
    }
}

