/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.dataImpl.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummarizerConfiguration;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TSummaryRequest
implements TBase<TSummaryRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TSummaryRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TSummaryRequest");
    private static final TField TABLE_ID_FIELD_DESC = new TField("tableId", 11, 1);
    private static final TField BOUNDS_FIELD_DESC = new TField("bounds", 12, 2);
    private static final TField SUMMARIZERS_FIELD_DESC = new TField("summarizers", 15, 3);
    private static final TField SUMMARIZER_PATTERN_FIELD_DESC = new TField("summarizerPattern", 11, 4);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSummaryRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSummaryRequestTupleSchemeFactory();
    @Nullable
    public String tableId;
    @Nullable
    public TRowRange bounds;
    @Nullable
    public List<TSummarizerConfiguration> summarizers;
    @Nullable
    public String summarizerPattern;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSummaryRequest() {
    }

    public TSummaryRequest(String tableId, TRowRange bounds, List<TSummarizerConfiguration> summarizers, String summarizerPattern) {
        this();
        this.tableId = tableId;
        this.bounds = bounds;
        this.summarizers = summarizers;
        this.summarizerPattern = summarizerPattern;
    }

    public TSummaryRequest(TSummaryRequest other) {
        if (other.isSetTableId()) {
            this.tableId = other.tableId;
        }
        if (other.isSetBounds()) {
            this.bounds = new TRowRange(other.bounds);
        }
        if (other.isSetSummarizers()) {
            ArrayList<TSummarizerConfiguration> __this__summarizers = new ArrayList<TSummarizerConfiguration>(other.summarizers.size());
            for (TSummarizerConfiguration other_element : other.summarizers) {
                __this__summarizers.add(new TSummarizerConfiguration(other_element));
            }
            this.summarizers = __this__summarizers;
        }
        if (other.isSetSummarizerPattern()) {
            this.summarizerPattern = other.summarizerPattern;
        }
    }

    public TSummaryRequest deepCopy() {
        return new TSummaryRequest(this);
    }

    public void clear() {
        this.tableId = null;
        this.bounds = null;
        this.summarizers = null;
        this.summarizerPattern = null;
    }

    @Nullable
    public String getTableId() {
        return this.tableId;
    }

    public TSummaryRequest setTableId(@Nullable String tableId) {
        this.tableId = tableId;
        return this;
    }

    public void unsetTableId() {
        this.tableId = null;
    }

    public boolean isSetTableId() {
        return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
        if (!value) {
            this.tableId = null;
        }
    }

    @Nullable
    public TRowRange getBounds() {
        return this.bounds;
    }

    public TSummaryRequest setBounds(@Nullable TRowRange bounds) {
        this.bounds = bounds;
        return this;
    }

    public void unsetBounds() {
        this.bounds = null;
    }

    public boolean isSetBounds() {
        return this.bounds != null;
    }

    public void setBoundsIsSet(boolean value) {
        if (!value) {
            this.bounds = null;
        }
    }

    public int getSummarizersSize() {
        return this.summarizers == null ? 0 : this.summarizers.size();
    }

    @Nullable
    public Iterator<TSummarizerConfiguration> getSummarizersIterator() {
        return this.summarizers == null ? null : this.summarizers.iterator();
    }

    public void addToSummarizers(TSummarizerConfiguration elem) {
        if (this.summarizers == null) {
            this.summarizers = new ArrayList<TSummarizerConfiguration>();
        }
        this.summarizers.add(elem);
    }

    @Nullable
    public List<TSummarizerConfiguration> getSummarizers() {
        return this.summarizers;
    }

    public TSummaryRequest setSummarizers(@Nullable List<TSummarizerConfiguration> summarizers) {
        this.summarizers = summarizers;
        return this;
    }

    public void unsetSummarizers() {
        this.summarizers = null;
    }

    public boolean isSetSummarizers() {
        return this.summarizers != null;
    }

    public void setSummarizersIsSet(boolean value) {
        if (!value) {
            this.summarizers = null;
        }
    }

    @Nullable
    public String getSummarizerPattern() {
        return this.summarizerPattern;
    }

    public TSummaryRequest setSummarizerPattern(@Nullable String summarizerPattern) {
        this.summarizerPattern = summarizerPattern;
        return this;
    }

    public void unsetSummarizerPattern() {
        this.summarizerPattern = null;
    }

    public boolean isSetSummarizerPattern() {
        return this.summarizerPattern != null;
    }

    public void setSummarizerPatternIsSet(boolean value) {
        if (!value) {
            this.summarizerPattern = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLE_ID: {
                if (value == null) {
                    this.unsetTableId();
                    break;
                }
                this.setTableId((String)value);
                break;
            }
            case BOUNDS: {
                if (value == null) {
                    this.unsetBounds();
                    break;
                }
                this.setBounds((TRowRange)value);
                break;
            }
            case SUMMARIZERS: {
                if (value == null) {
                    this.unsetSummarizers();
                    break;
                }
                this.setSummarizers((List)value);
                break;
            }
            case SUMMARIZER_PATTERN: {
                if (value == null) {
                    this.unsetSummarizerPattern();
                    break;
                }
                this.setSummarizerPattern((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_ID: {
                return this.getTableId();
            }
            case BOUNDS: {
                return this.getBounds();
            }
            case SUMMARIZERS: {
                return this.getSummarizers();
            }
            case SUMMARIZER_PATTERN: {
                return this.getSummarizerPattern();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_ID: {
                return this.isSetTableId();
            }
            case BOUNDS: {
                return this.isSetBounds();
            }
            case SUMMARIZERS: {
                return this.isSetSummarizers();
            }
            case SUMMARIZER_PATTERN: {
                return this.isSetSummarizerPattern();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TSummaryRequest) {
            return this.equals((TSummaryRequest)that);
        }
        return false;
    }

    public boolean equals(TSummaryRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tableId = this.isSetTableId();
        boolean that_present_tableId = that.isSetTableId();
        if (this_present_tableId || that_present_tableId) {
            if (!this_present_tableId || !that_present_tableId) {
                return false;
            }
            if (!this.tableId.equals(that.tableId)) {
                return false;
            }
        }
        boolean this_present_bounds = this.isSetBounds();
        boolean that_present_bounds = that.isSetBounds();
        if (this_present_bounds || that_present_bounds) {
            if (!this_present_bounds || !that_present_bounds) {
                return false;
            }
            if (!this.bounds.equals(that.bounds)) {
                return false;
            }
        }
        boolean this_present_summarizers = this.isSetSummarizers();
        boolean that_present_summarizers = that.isSetSummarizers();
        if (this_present_summarizers || that_present_summarizers) {
            if (!this_present_summarizers || !that_present_summarizers) {
                return false;
            }
            if (!this.summarizers.equals(that.summarizers)) {
                return false;
            }
        }
        boolean this_present_summarizerPattern = this.isSetSummarizerPattern();
        boolean that_present_summarizerPattern = that.isSetSummarizerPattern();
        if (this_present_summarizerPattern || that_present_summarizerPattern) {
            if (!this_present_summarizerPattern || !that_present_summarizerPattern) {
                return false;
            }
            if (!this.summarizerPattern.equals(that.summarizerPattern)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTableId() ? 131071 : 524287);
        if (this.isSetTableId()) {
            hashCode = hashCode * 8191 + this.tableId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBounds() ? 131071 : 524287);
        if (this.isSetBounds()) {
            hashCode = hashCode * 8191 + this.bounds.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSummarizers() ? 131071 : 524287);
        if (this.isSetSummarizers()) {
            hashCode = hashCode * 8191 + this.summarizers.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSummarizerPattern() ? 131071 : 524287);
        if (this.isSetSummarizerPattern()) {
            hashCode = hashCode * 8191 + this.summarizerPattern.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSummaryRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTableId(), other.isSetTableId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableId() && (lastComparison = TBaseHelper.compareTo((String)this.tableId, (String)other.tableId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBounds(), other.isSetBounds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBounds() && (lastComparison = TBaseHelper.compareTo((Comparable)this.bounds, (Comparable)other.bounds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSummarizers(), other.isSetSummarizers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSummarizers() && (lastComparison = TBaseHelper.compareTo(this.summarizers, other.summarizers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSummarizerPattern(), other.isSetSummarizerPattern());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSummarizerPattern() && (lastComparison = TBaseHelper.compareTo((String)this.summarizerPattern, (String)other.summarizerPattern)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TSummaryRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TSummaryRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSummaryRequest(");
        boolean first = true;
        sb.append("tableId:");
        if (this.tableId == null) {
            sb.append("null");
        } else {
            sb.append(this.tableId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("bounds:");
        if (this.bounds == null) {
            sb.append("null");
        } else {
            sb.append(this.bounds);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("summarizers:");
        if (this.summarizers == null) {
            sb.append("null");
        } else {
            sb.append(this.summarizers);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("summarizerPattern:");
        if (this.summarizerPattern == null) {
            sb.append("null");
        } else {
            sb.append(this.summarizerPattern);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.bounds != null) {
            this.bounds.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    private static void unusedMethod() {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_ID, new FieldMetaData("tableId", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BOUNDS, new FieldMetaData("bounds", 3, (FieldValueMetaData)new StructMetaData(12, TRowRange.class)));
        tmpMap.put(_Fields.SUMMARIZERS, new FieldMetaData("summarizers", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TSummarizerConfiguration.class))));
        tmpMap.put(_Fields.SUMMARIZER_PATTERN, new FieldMetaData("summarizerPattern", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSummaryRequest.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_ID(1, "tableId"),
        BOUNDS(2, "bounds"),
        SUMMARIZERS(3, "summarizers"),
        SUMMARIZER_PATTERN(4, "summarizerPattern");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_ID;
                }
                case 2: {
                    return BOUNDS;
                }
                case 3: {
                    return SUMMARIZERS;
                }
                case 4: {
                    return SUMMARIZER_PATTERN;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TSummaryRequestStandardSchemeFactory
    implements SchemeFactory {
        private TSummaryRequestStandardSchemeFactory() {
        }

        public TSummaryRequestStandardScheme getScheme() {
            return new TSummaryRequestStandardScheme();
        }
    }

    private static class TSummaryRequestTupleSchemeFactory
    implements SchemeFactory {
        private TSummaryRequestTupleSchemeFactory() {
        }

        public TSummaryRequestTupleScheme getScheme() {
            return new TSummaryRequestTupleScheme();
        }
    }

    private static class TSummaryRequestTupleScheme
    extends TupleScheme<TSummaryRequest> {
        private TSummaryRequestTupleScheme() {
        }

        public void write(TProtocol prot, TSummaryRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTableId()) {
                optionals.set(0);
            }
            if (struct.isSetBounds()) {
                optionals.set(1);
            }
            if (struct.isSetSummarizers()) {
                optionals.set(2);
            }
            if (struct.isSetSummarizerPattern()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetTableId()) {
                oprot.writeString(struct.tableId);
            }
            if (struct.isSetBounds()) {
                struct.bounds.write((TProtocol)oprot);
            }
            if (struct.isSetSummarizers()) {
                oprot.writeI32(struct.summarizers.size());
                for (TSummarizerConfiguration _iter126 : struct.summarizers) {
                    _iter126.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSummarizerPattern()) {
                oprot.writeString(struct.summarizerPattern);
            }
        }

        public void read(TProtocol prot, TSummaryRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.bounds = new TRowRange();
                struct.bounds.read((TProtocol)iprot);
                struct.setBoundsIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list127 = iprot.readListBegin((byte)12);
                struct.summarizers = new ArrayList<TSummarizerConfiguration>(_list127.size);
                for (int _i129 = 0; _i129 < _list127.size; ++_i129) {
                    TSummarizerConfiguration _elem128 = new TSummarizerConfiguration();
                    _elem128.read((TProtocol)iprot);
                    struct.summarizers.add(_elem128);
                }
                struct.setSummarizersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.summarizerPattern = iprot.readString();
                struct.setSummarizerPatternIsSet(true);
            }
        }
    }

    private static class TSummaryRequestStandardScheme
    extends StandardScheme<TSummaryRequest> {
        private TSummaryRequestStandardScheme() {
        }

        public void read(TProtocol iprot, TSummaryRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.tableId = iprot.readString();
                            struct.setTableIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.bounds = new TRowRange();
                            struct.bounds.read(iprot);
                            struct.setBoundsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list122 = iprot.readListBegin();
                            struct.summarizers = new ArrayList<TSummarizerConfiguration>(_list122.size);
                            for (int _i124 = 0; _i124 < _list122.size; ++_i124) {
                                TSummarizerConfiguration _elem123 = new TSummarizerConfiguration();
                                _elem123.read(iprot);
                                struct.summarizers.add(_elem123);
                            }
                            iprot.readListEnd();
                            struct.setSummarizersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.summarizerPattern = iprot.readString();
                            struct.setSummarizerPatternIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TSummaryRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableId != null) {
                oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
                oprot.writeString(struct.tableId);
                oprot.writeFieldEnd();
            }
            if (struct.bounds != null) {
                oprot.writeFieldBegin(BOUNDS_FIELD_DESC);
                struct.bounds.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.summarizers != null) {
                oprot.writeFieldBegin(SUMMARIZERS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.summarizers.size()));
                for (TSummarizerConfiguration _iter125 : struct.summarizers) {
                    _iter125.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.summarizerPattern != null) {
                oprot.writeFieldBegin(SUMMARIZER_PATTERN_FIELD_DESC);
                oprot.writeString(struct.summarizerPattern);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

