/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import com.beust.jcommander.Parameter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit is fine here because it's a utility class executed by a main()")
public class PrintBCInfo {
    SiteConfiguration siteConfig;
    Configuration conf;
    FileSystem fs;
    Path path;
    CryptoService cryptoService = NoCryptoServiceFactory.NONE;

    public void printMetaBlockInfo() throws IOException {
        FSDataInputStream fsin = this.fs.open(this.path);
        try (BCFile.Reader bcfr = new BCFile.Reader(fsin, this.fs.getFileStatus(this.path).getLen(), this.conf, this.cryptoService);){
            Set<Map.Entry<String, BCFile.MetaIndexEntry>> es = bcfr.metaIndex.index.entrySet();
            for (Map.Entry<String, BCFile.MetaIndexEntry> entry : es) {
                PrintStream out = System.out;
                out.println("Meta block     : " + entry.getKey());
                out.println("      Raw size             : " + String.format("%,d", entry.getValue().getRegion().getRawSize()) + " bytes");
                out.println("      Compressed size      : " + String.format("%,d", entry.getValue().getRegion().getCompressedSize()) + " bytes");
                out.println("      Compression type     : " + entry.getValue().getCompressionAlgorithm().getName());
                out.println();
            }
        }
    }

    public PrintBCInfo(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs("PrintInfo", args, new Object[0]);
        if (opts.file.isEmpty()) {
            System.err.println("No files were given");
            System.exit(-1);
        }
        this.siteConfig = opts.getSiteConfiguration();
        this.conf = new Configuration();
        FileSystem hadoopFs = FileSystem.get((Configuration)this.conf);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        this.path = new Path(opts.file);
        this.fs = opts.file.contains(":") ? this.path.getFileSystem(this.conf) : (hadoopFs.exists(this.path) ? hadoopFs : localFs);
    }

    public CryptoService getCryptoService() {
        return this.cryptoService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(description=" <file>")
        String file;

        Opts() {
        }
    }
}

